/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectPreEvent;
import ca.sqlpower.sqlobject.SQLObjectPreEventListener;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.SQLPowerUtils;
import com.google.common.collect.ListMultimap;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public abstract class SQLObject
extends AbstractSPObject
implements Serializable {
    private static Logger logger = Logger.getLogger(SQLObject.class);
    protected boolean populated = false;
    private AtomicBoolean populating = new AtomicBoolean(false);
    private String physicalName;
    private final Map<String, Object> clientProperties = new HashMap<String, Object>();
    private final Map<Class<? extends SQLObject>, Throwable> childrenInaccessibleReason = new HashMap<Class<? extends SQLObject>, Throwable>();
    private final transient List<SQLObjectPreEventListener> sqlObjectPreEventListeners = new ArrayList<SQLObjectPreEventListener>();

    @Accessor(isInteresting=true)
    public final String getPhysicalName() {
        if (this.physicalName != null) {
            return this.physicalName;
        }
        return this.getName();
    }

    @Mutator
    public void setPhysicalName(String argName) {
        String oldPhysicalName = this.getPhysicalName();
        String actualOldPhysicalName = this.physicalName;
        this.physicalName = argName;
        if (actualOldPhysicalName == null && argName == null || actualOldPhysicalName != null && actualOldPhysicalName.equals(argName)) {
            return;
        }
        this.firePropertyChange("physicalName", oldPhysicalName, argName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void populate() throws SQLObjectException {
        if (this.populated || !this.populating.compareAndSet(false, true)) {
            return;
        }
        DatabaseMetaDataDecorator.putHint("cacheType", (Object)DatabaseMetaDataDecorator.CacheType.EAGER_CACHE);
        this.childrenInaccessibleReason.clear();
        try {
            this.populateImpl();
        }
        catch (SQLObjectException e) {
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLObject.this.setChildrenInaccessibleReason(e, SQLObject.class, true);
                    }
                    catch (SQLObjectException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLObject.this.setChildrenInaccessibleReason(e, SQLObject.class, true);
                    }
                    catch (SQLObjectException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            });
        }
        finally {
            this.populating.set(false);
        }
    }

    protected abstract void populateImpl() throws SQLObjectException;

    @Transient
    @Accessor
    public abstract String getShortDisplayName();

    @Accessor
    public boolean isPopulated() {
        return this.populated;
    }

    @Mutator
    public void setPopulated(boolean v) {
        boolean oldPop = this.populated;
        this.populated = v;
        this.firePropertyChange("populated", oldPop, v);
    }

    @Override
    public boolean allowsChildren() {
        return super.allowsChildren();
    }

    @Override
    public boolean removeChild(SPObject child) throws ObjectDependentException, IllegalArgumentException {
        if (child instanceof SQLObject && !this.fireDbChildPreRemove(this.getChildrenWithoutPopulating(child.getClass()).indexOf(child), (SQLObject)child)) {
            return false;
        }
        if (!this.getChildrenWithoutPopulating().contains(child)) {
            return false;
        }
        return this.removeChildImpl(child);
    }

    @NonProperty
    public List<? extends SQLObject> getChildren() {
        return this.getChildren(SQLObject.class);
    }

    @Override
    @NonProperty
    public <T extends SPObject> List<T> getChildren(Class<T> type) {
        try {
            if (this.isMagicEnabled()) {
                this.populate();
            }
            return this.getChildrenWithoutPopulating(type);
        }
        catch (SQLObjectException e) {
            throw new RuntimeException("Could not populate " + this.getName(), e);
        }
    }

    @NonProperty
    public abstract List<? extends SQLObject> getChildrenWithoutPopulating();

    @NonProperty
    public <T extends SPObject> List<T> getChildrenWithoutPopulating(Class<T> type) {
        ArrayList<T> children = new ArrayList<T>();
        for (SQLObject sQLObject : this.getChildrenWithoutPopulating()) {
            if (!type.isAssignableFrom(sQLObject.getClass())) continue;
            children.add(type.cast(sQLObject));
        }
        return Collections.unmodifiableList(children);
    }

    @NonProperty
    public SQLObject getChild(int index) throws SQLObjectException {
        this.populate();
        return this.getChildrenWithoutPopulating().get(index);
    }

    @NonProperty
    public int getChildCount() throws SQLObjectException {
        this.populate();
        return this.getChildrenWithoutPopulating().size();
    }

    @NonProperty
    Set<String> getChildNames() throws SQLObjectException {
        return this.getChildNames(SQLObject.class);
    }

    @NonProperty
    <T extends SQLObject> Set<String> getChildNames(Class<T> childType) {
        HashSet<String> names = new HashSet<String>();
        for (SQLObject child : this.getChildren(childType)) {
            names.add(child.getName());
        }
        return names;
    }

    public void addChild(SQLObject newChild) throws SQLObjectException {
        this.addChild(newChild, this.getChildrenWithoutPopulating(newChild.getClass()).size());
    }

    @NonProperty
    public List<SPListener> getSPListeners() {
        return this.listeners;
    }

    @NonProperty
    public List<SQLObjectPreEventListener> getSQLObjectPreEventListeners() {
        return this.sqlObjectPreEventListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSQLObjectPreEventListener(SQLObjectPreEventListener l) {
        if (l == null) {
            throw new NullPointerException("You can't add a null listener");
        }
        List<SQLObjectPreEventListener> list = this.sqlObjectPreEventListeners;
        synchronized (list) {
            if (this.sqlObjectPreEventListeners.contains(l)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("NOT Adding duplicate pre-event listener " + l + " to SQLObject " + this));
                }
                return;
            }
            this.sqlObjectPreEventListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSQLObjectPreEventListener(SQLObjectPreEventListener l) {
        List<SQLObjectPreEventListener> list = this.sqlObjectPreEventListeners;
        synchronized (list) {
            this.sqlObjectPreEventListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fireDbChildrenPreRemove(int[] oldIndices, List<SQLObject> oldChildren) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getClass().getName() + " " + this.toString() + ": " + "firing dbChildrenPreRemove event"));
        }
        SQLObjectPreEvent e = new SQLObjectPreEvent(this, oldIndices, oldChildren.toArray(new SQLObject[oldChildren.size()]));
        int count = 0;
        List<SQLObjectPreEventListener> list = this.sqlObjectPreEventListeners;
        synchronized (list) {
            SQLObjectPreEventListener[] listeners;
            for (SQLObjectPreEventListener l : listeners = this.sqlObjectPreEventListeners.toArray(new SQLObjectPreEventListener[0])) {
                l.dbChildrenPreRemove(e);
                ++count;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notified " + count + " listeners. Veto=" + e.isVetoed()));
        }
        return !e.isVetoed();
    }

    protected boolean fireDbChildPreRemove(int oldIndex, SQLObject oldChild) {
        int[] oldIndexArray = new int[]{oldIndex};
        ArrayList<SQLObject> oldChildList = new ArrayList<SQLObject>(1);
        oldChildList.add(oldChild);
        return this.fireDbChildrenPreRemove(oldIndexArray, oldChildList);
    }

    @NonProperty
    public <T extends SQLObject> T getChildByName(String name, Class<T> childType) {
        return this.getChildByNameImpl(name, false, childType);
    }

    @NonProperty
    public <T extends SQLObject> T getChildByNameIgnoreCase(String name, Class<T> childType) {
        return this.getChildByNameImpl(name, true, childType);
    }

    @NonProperty
    private <T extends SQLObject> T getChildByNameImpl(String name, boolean ignoreCase, Class<T> childType) {
        for (SQLObject o : this.getChildren(childType)) {
            if ((!ignoreCase || !o.getName().equalsIgnoreCase(name)) && (ignoreCase || !o.getName().equals(name))) continue;
            return (T)o;
        }
        return null;
    }

    @NonProperty
    public int getIndexOfChildByName(String name) throws SQLObjectException {
        int i = 0;
        for (SQLObject sQLObject : this.getChildren()) {
            SQLObject so = sQLObject;
            if (so.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void putClientProperty(Class<?> namespace, String propName, Object property) {
        String key = namespace + "." + propName;
        Object oldValue = this.clientProperties.get(key);
        this.clientProperties.put(key, property);
        this.firePropertyChange("clientProperty." + key, oldValue, property);
    }

    @NonProperty
    public Object getClientProperty(Class<?> namespace, String propName) {
        return this.clientProperties.get(namespace + "." + propName);
    }

    @NonProperty
    public Set<String> getClientPropertyNames() {
        return this.clientProperties.keySet();
    }

    @Transient
    @Accessor
    public Throwable getChildrenInaccessibleReason(Class<? extends SQLObject> childType) {
        return this.childrenInaccessibleReason.get(childType);
    }

    @Transient
    @Accessor
    public Map<Class<? extends SQLObject>, Throwable> getChildrenInaccessibleReasons() {
        return Collections.unmodifiableMap(this.childrenInaccessibleReason);
    }

    @Transient
    @Mutator
    public void setChildrenInaccessibleReason(Throwable cause, Class<? extends SQLObject> childType, boolean rethrow) throws SQLObjectException {
        HashMap<Class<? extends SQLObject>, Throwable> oldVal = new HashMap<Class<? extends SQLObject>, Throwable>(this.childrenInaccessibleReason);
        this.childrenInaccessibleReason.put(childType, cause);
        this.firePropertyChange("childrenInaccessibleReason", oldVal, this.childrenInaccessibleReason);
        this.setPopulated(true);
        if (rethrow) {
            if (cause instanceof SQLObjectException) {
                throw (SQLObjectException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new SQLObjectException(cause);
        }
    }

    void refresh() throws SQLObjectException {
        if (!this.isPopulated()) {
            logger.debug((Object)("Not refreshing unpopulated object " + this));
            return;
        }
        if (this.isTableContainer()) {
            logger.debug((Object)("Refreshing table container " + this));
            Connection con = null;
            SQLDatabase sQLDatabase = SQLPowerUtils.getAncestor(this, SQLDatabase.class);
            try {
                SQLCatalog cat = SQLPowerUtils.getAncestor(this, SQLCatalog.class);
                SQLSchema sch = SQLPowerUtils.getAncestor(this, SQLSchema.class);
                String catName = cat == null ? null : cat.getName();
                String schName = sch == null ? null : sch.getName();
                con = sQLDatabase.getConnection();
                DatabaseMetaData dbmd = con.getMetaData();
                final List<SQLTable> newChildren = SQLTable.fetchTablesForTableContainer(dbmd, catName, schName);
                this.runInForeground(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SQLObjectUtils.refreshChildren(SQLObject.this, newChildren, SQLTable.class);
                        }
                        catch (SQLObjectException e) {
                            throw new SQLObjectRuntimeException(e);
                        }
                    }
                });
                try {
                    final ListMultimap<String, SQLColumn> newCols = SQLColumn.fetchColumnsForTable(catName, schName, null, dbmd);
                    this.runInForeground(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<SQLTable> populatedTables = new ArrayList<SQLTable>();
                            for (SQLTable table : SQLObject.this.getChildrenWithoutPopulating(SQLTable.class)) {
                                if (!table.isColumnsPopulated()) continue;
                                populatedTables.add(table);
                            }
                            for (SQLTable table : populatedTables) {
                                try {
                                    SQLObjectUtils.refreshChildren(table, newCols.get((Object)table.getName()), SQLColumn.class);
                                }
                                catch (SQLObjectException e) {
                                    throw new SQLObjectRuntimeException(e);
                                }
                            }
                        }
                    });
                }
                catch (SQLException e) {
                    throw new SQLObjectException("Refresh failed", e);
                }
                for (SQLTable t : this.getChildrenWithoutPopulating(SQLTable.class)) {
                    t.refreshIndexes();
                }
                for (SQLTable t : this.getChildrenWithoutPopulating(SQLTable.class)) {
                    t.refreshExportedKeys();
                }
                logger.debug((Object)("Table container refresh complete for " + this));
            }
            catch (SQLException e) {
                throw new SQLObjectException("Refresh failed", e);
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException ex) {
                    logger.warn((Object)"Failed to close connection! Squishing this exception:", (Throwable)ex);
                }
            }
        }
        for (SQLObject sQLObject : this.getChildrenWithoutPopulating()) {
            sQLObject.refresh();
        }
    }

    @NonProperty
    public boolean isTableContainer() throws SQLObjectException {
        if (this.getChildrenWithoutPopulating().size() > 0) {
            return this.getChildrenWithoutPopulating(SQLTable.class).size() != 0;
        }
        if (this.getClass() == SQLSchema.class) {
            return true;
        }
        Connection con = null;
        try {
            if (this.getClass() == SQLCatalog.class) {
                SQLDatabase db = (SQLDatabase)this.getParent();
                con = db.getConnection();
                if (con == null) {
                    throw new SQLObjectException("Unable to determine table container status without database connection");
                }
                DatabaseMetaData dbmd = con.getMetaData();
                boolean bl = dbmd.getSchemaTerm() == null;
                return bl;
            }
            if (this.getClass() == SQLDatabase.class) {
                SQLDatabase db = (SQLDatabase)this;
                con = db.getConnection();
                if (con == null) {
                    throw new SQLObjectException("Unable to determine table container status without database connection");
                }
                DatabaseMetaData dbmd = con.getMetaData();
                boolean bl = dbmd.getSchemaTerm() == null && dbmd.getCatalogTerm() == null;
                return bl;
            }
        }
        catch (SQLException ex) {
            throw new SQLObjectException("Failed to obtain database metadata", ex);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.warn((Object)"Failed to close connection", (Throwable)ex);
            }
        }
        return false;
    }

    public void updateToMatch(SQLObject source) throws SQLObjectException {
        throw new UnsupportedOperationException();
    }

    protected void updatePhysicalNameToMatch(String oldName, String newName) {
        if (newName != null && this.getPhysicalName() == null || this.getPhysicalName() != null && "".equals(this.getPhysicalName().trim()) || oldName != null && oldName.equals(this.getPhysicalName())) {
            this.setPhysicalName(newName);
        }
    }
}

