/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.Named;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class Symbol
extends AFn
implements IObj,
Comparable,
Named,
Serializable {
    final String ns;
    final String name;
    final int hash;
    final IPersistentMap _meta;

    public String toString() {
        if (this.ns != null) {
            return this.ns + "/" + this.name;
        }
        return this.name;
    }

    public String getNamespace() {
        return this.ns;
    }

    public String getName() {
        return this.name;
    }

    public static Symbol create(String ns2, String name2) {
        return Symbol.intern(ns2, name2);
    }

    public static Symbol create(String nsname) {
        return Symbol.intern(nsname);
    }

    public static Symbol intern(String ns2, String name2) {
        return new Symbol(ns2 == null ? null : ns2.intern(), name2.intern());
    }

    public static Symbol intern(String nsname) {
        int i = nsname.lastIndexOf(47);
        if (i == -1 || nsname.equals("/")) {
            return new Symbol(null, nsname.intern());
        }
        return new Symbol(nsname.substring(0, i).intern(), nsname.substring(i + 1).intern());
    }

    private Symbol(String ns_interned, String name_interned) {
        this.name = name_interned;
        this.ns = ns_interned;
        this.hash = Util.hashCombine(this.name.hashCode(), Util.hash(this.ns));
        this._meta = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Symbol)) {
            return false;
        }
        Symbol symbol2 = (Symbol)o;
        return this.name == symbol2.name && this.ns == symbol2.ns;
    }

    public int hashCode() {
        return this.hash;
    }

    public IObj withMeta(IPersistentMap meta2) {
        return new Symbol(meta2, this.ns, this.name);
    }

    private Symbol(IPersistentMap meta2, String ns2, String name2) {
        this.name = name2;
        this.ns = ns2;
        this._meta = meta2;
        this.hash = Util.hashCombine(name2.hashCode(), Util.hash(ns2));
    }

    public int compareTo(Object o) {
        Symbol s = (Symbol)o;
        if (this.equals(o)) {
            return 0;
        }
        if (this.ns == null && s.ns != null) {
            return -1;
        }
        if (this.ns != null) {
            if (s.ns == null) {
                return 1;
            }
            int nsc = this.ns.compareTo(s.ns);
            if (nsc != 0) {
                return nsc;
            }
        }
        return this.name.compareTo(s.name);
    }

    private Object readResolve() throws ObjectStreamException {
        return Symbol.intern(this.ns, this.name);
    }

    public Object invoke(Object obj) {
        return RT.get(obj, this);
    }

    public Object invoke(Object obj, Object notFound) {
        return RT.get(obj, this, notFound);
    }

    public IPersistentMap meta() {
        return this._meta;
    }
}

