/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.console;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.RubySourceLocator;
import org.rubypeople.rdt.internal.ui.util.StackTraceLine;

public class RubyStackTraceHyperlink
implements IHyperlink {
    private IConsole fConsole;
    private StackTraceLine fTraceLine;

    public RubyStackTraceHyperlink(IConsole iConsole, StackTraceLine stackTraceLine) {
        this.fConsole = iConsole;
        this.fTraceLine = stackTraceLine;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    private void setEditorToLine(IEditorPart iEditorPart, IEditorInput iEditorInput) throws CoreException {
        IDocumentProvider iDocumentProvider;
        block5: {
            if (!(iEditorPart instanceof ITextEditor)) {
                return;
            }
            int n = this.getLineNumber();
            if (n > 0) {
                --n;
            }
            if (n == 0) {
                return;
            }
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            iDocumentProvider = iTextEditor.getDocumentProvider();
            iDocumentProvider.connect((Object)iEditorInput);
            IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
            try {
                IRegion iRegion = iDocument.getLineInformation(n);
                iTextEditor.selectAndReveal(iRegion.getOffset(), iRegion.getLength());
            }
            catch (BadLocationException badLocationException) {
                if (!RdtDebugUiPlugin.getDefault().isDebugging()) break block5;
                System.out.println("Could not set editor to line: " + n);
            }
        }
        iDocumentProvider.disconnect((Object)iEditorInput);
    }

    public void linkActivated() {
        RubySourceLocator rubySourceLocator = null;
        ILaunch iLaunch = this.getConsole().getProcess().getLaunch();
        if (iLaunch == null) {
            return;
        }
        ISourceLocator iSourceLocator = iLaunch.getSourceLocator();
        if (!(iSourceLocator instanceof RubySourceLocator)) {
            return;
        }
        rubySourceLocator = (RubySourceLocator)iSourceLocator;
        String string = this.getFilename();
        try {
            Object object = rubySourceLocator.getSourceElement(string);
            IEditorInput iEditorInput = rubySourceLocator.getEditorInput(object);
            if (iEditorInput == null) {
                if (RdtDebugUiPlugin.getDefault().isDebugging()) {
                    System.out.println("Could not create editor input for stack trace: " + string);
                }
                return;
            }
            IEditorPart iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(iEditorInput, rubySourceLocator.getEditorId(iEditorInput, object));
            this.setEditorToLine(iEditorPart, iEditorInput);
        }
        catch (CoreException coreException) {
            RdtDebugUiPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.debug.ui", 0, "Could not open editor or set line in editor." + string, (Throwable)coreException));
        }
    }

    public int getLineNumber() {
        return this.fTraceLine.getLineNumber();
    }

    public String getFilename() {
        return this.fTraceLine.getFilename();
    }

    protected IConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws BadLocationException {
        IRegion iRegion = this.getConsole().getRegion((IHyperlink)this);
        return this.getConsole().getDocument().get(iRegion.getOffset(), iRegion.getLength());
    }
}

