/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.rubypeople.rdt.core.RubyCore;

public class RdtDebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.rubypeople.rdt.debug.core";
    private static boolean isRubyDebuggerVerbose = false;
    protected static RdtDebugCorePlugin plugin;

    public RdtDebugCorePlugin() {
        plugin = this;
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return RubyCore.getWorkspace();
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        String string = Platform.getDebugOption((String)"org.rubypeople.rdt.debug.core/rubyDebuggerVerbose");
        isRubyDebuggerVerbose = string == null ? false : string.equalsIgnoreCase("true");
    }

    public static void log(int n, String string) {
        Status status = new Status(n, PLUGIN_ID, 0, string, null);
        RdtDebugCorePlugin.log((IStatus)status);
    }

    public static void log(String string, Throwable throwable) {
        RdtDebugCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, string, throwable));
    }

    public static void log(IStatus iStatus) {
        RdtDebugCorePlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        RdtDebugCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "RdtLaunchingPlugin.internalErrorOccurred", throwable));
    }

    public static void debug(Object object) {
        if (RdtDebugCorePlugin.getDefault() != null) {
            if (RdtDebugCorePlugin.getDefault().isDebugging()) {
                System.out.println(object.toString());
            }
        } else {
            System.out.println(object.toString());
        }
    }

    public static void debug(String string, Throwable throwable) {
        if (RdtDebugCorePlugin.getDefault() != null) {
            if (RdtDebugCorePlugin.getDefault().isDebugging()) {
                System.out.println(String.valueOf(string) + ", Exception: " + throwable.getMessage());
                RdtDebugCorePlugin.log(throwable);
            }
        } else {
            System.out.println(string);
            throwable.printStackTrace();
        }
    }

    public static boolean isRubyDebuggerVerbose() {
        return isRubyDebuggerVerbose;
    }
}

