/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.text.ParseException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizard;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutWizardCheckoutAsWithProjectFilePage
extends WizardPage {
    private Label textLabel;
    private Button wizardButton;
    private Button projectButton;
    private Text projectText;
    private Button existingButton;
    private String projectName;
    private Text revisionText;
    private Button headButton;
    private Button revisionButton;
    private static final int REVISION_WIDTH_HINT = 40;

    public CheckoutWizardCheckoutAsWithProjectFilePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        CheckoutWizard wizard = (CheckoutWizard)this.getWizard();
        ISVNRemoteFolder[] remoteFolders = wizard.getRemoteFolders();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(768));
        this.textLabel = new Label(outerContainer, 0);
        GridData data = new GridData();
        data.widthHint = 300;
        this.textLabel.setLayoutData((Object)data);
        if (remoteFolders != null) {
            this.textLabel.setText(Policy.bind("CheckoutWizardCheckoutAsPage.single", remoteFolders[0].getName()));
        }
        this.wizardButton = new Button(outerContainer, 16);
        this.wizardButton.setText(Policy.bind("CheckoutWizardCheckoutAsPage.wizard"));
        this.wizardButton.setEnabled(false);
        Label notAvailableLabel = new Label(outerContainer, 0);
        notAvailableLabel.setText(Policy.bind("CheckoutWizardCheckoutAsPage.notAvailable"));
        notAvailableLabel.setEnabled(false);
        this.projectButton = new Button(outerContainer, 16);
        this.projectButton.setText(Policy.bind("CheckoutWizardCheckoutAsPage.project"));
        Composite projectGroup = new Composite(outerContainer, 0);
        GridLayout projectLayout = new GridLayout();
        projectLayout.numColumns = 2;
        projectGroup.setLayout((Layout)projectLayout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(Policy.bind("CheckoutWizardCheckoutAsPage.projectName"));
        this.projectText = new Text(projectGroup, 2048);
        data = new GridData();
        data.widthHint = 300;
        this.projectText.setLayoutData((Object)data);
        if (this.projectName == null) {
            if (remoteFolders != null) {
                this.projectText.setText(remoteFolders[0].getName());
            }
        } else {
            this.projectText.setText(this.projectName);
        }
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutWizard wizard = (CheckoutWizard)CheckoutWizardCheckoutAsWithProjectFilePage.this.getWizard();
                wizard.setProjectName(CheckoutWizardCheckoutAsWithProjectFilePage.this.projectText.getText().trim());
                CheckoutWizardCheckoutAsWithProjectFilePage.this.setPageComplete(CheckoutWizardCheckoutAsWithProjectFilePage.this.canFinish());
            }
        });
        this.existingButton = new Button(outerContainer, 16);
        this.existingButton.setText(Policy.bind("CheckoutWizardCheckoutAsPage.existing"));
        this.existingButton.setEnabled(false);
        this.existingButton.setVisible(false);
        this.projectButton.setSelection(true);
        Group revisionGroup = new Group(outerContainer, 0);
        revisionGroup.setText(Policy.bind("CheckoutWizardProjectPage.revision"));
        GridLayout revisionLayout = new GridLayout();
        revisionLayout.numColumns = 3;
        revisionGroup.setLayout((Layout)revisionLayout);
        data = new GridData(1808);
        revisionGroup.setLayoutData((Object)data);
        this.headButton = new Button((Composite)revisionGroup, 16);
        this.headButton.setText(Policy.bind("SwitchDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.headButton.setLayoutData((Object)data);
        this.revisionButton = new Button((Composite)revisionGroup, 16);
        this.revisionButton.setText(Policy.bind("SwitchDialog.revision"));
        this.headButton.setSelection(true);
        this.revisionText = new Text((Composite)revisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        this.revisionText.setEnabled(false);
        Button logButton = new Button((Composite)revisionGroup, 8);
        logButton.setText(Policy.bind("MergeDialog.showLog"));
        logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardCheckoutAsWithProjectFilePage.this.showLog();
            }
        });
        SelectionAdapter revisionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardCheckoutAsWithProjectFilePage.this.revisionText.setEnabled(CheckoutWizardCheckoutAsWithProjectFilePage.this.revisionButton.getSelection());
                if (CheckoutWizardCheckoutAsWithProjectFilePage.this.revisionButton.getSelection()) {
                    CheckoutWizardCheckoutAsWithProjectFilePage.this.revisionText.selectAll();
                    CheckoutWizardCheckoutAsWithProjectFilePage.this.revisionText.setFocus();
                }
            }
        };
        this.headButton.addSelectionListener((SelectionListener)revisionListener);
        this.revisionButton.addSelectionListener((SelectionListener)revisionListener);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardCheckoutAsWithProjectFilePage.this.projectText.setEnabled(CheckoutWizardCheckoutAsWithProjectFilePage.this.projectButton.getSelection());
                if (CheckoutWizardCheckoutAsWithProjectFilePage.this.projectButton.getSelection()) {
                    CheckoutWizardCheckoutAsWithProjectFilePage.this.projectText.selectAll();
                    CheckoutWizardCheckoutAsWithProjectFilePage.this.projectText.setFocus();
                }
                CheckoutWizardCheckoutAsWithProjectFilePage.this.setPageComplete(CheckoutWizardCheckoutAsWithProjectFilePage.this.canFinish());
            }
        };
        this.wizardButton.addSelectionListener((SelectionListener)selectionListener);
        this.projectButton.addSelectionListener((SelectionListener)selectionListener);
        this.existingButton.addSelectionListener((SelectionListener)selectionListener);
        this.setMessage(Policy.bind("CheckoutWizardCheckoutAsPage.text"));
        this.setControl((Control)outerContainer);
    }

    public void setText(String text) {
        this.textLabel.setText(text);
    }

    public void setProject(String project) {
        this.projectText.setText(project);
    }

    private boolean canFinish() {
        return !this.projectButton.getSelection() || this.projectText.getText().trim().length() > 0;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    private void showLog() {
        HistoryDialog dialog = new HistoryDialog(this.getShell(), this.getCommonParent());
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
        this.revisionButton.setSelection(true);
        this.revisionText.setEnabled(true);
        this.headButton.setSelection(false);
    }

    private ISVNRemoteResource getCommonParent() {
        ISVNRemoteFolder[] remoteFolders = ((CheckoutWizard)this.getWizard()).getRemoteFolders();
        if (remoteFolders.length == 1) {
            return remoteFolders[0];
        }
        ISVNRemoteFolder commonParent = null;
        ISVNRemoteFolder parent = remoteFolders[0];
        while (commonParent == null) {
            if ((parent = parent.getParent()) == null) break;
            int i = 1;
            while (i < remoteFolders.length) {
                if (!remoteFolders[i].getUrl().toString().startsWith(parent.getUrl().toString())) break;
                ++i;
            }
            commonParent = parent;
        }
        return commonParent;
    }

    public SVNRevision getRevision() {
        if (this.headButton.getSelection()) {
            return SVNRevision.HEAD;
        }
        SVNRevision svnRevision = null;
        try {
            svnRevision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
        }
        catch (ParseException parseException) {}
        if (svnRevision == null) {
            return SVNRevision.HEAD;
        }
        return svnRevision;
    }
}

