/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BP4102
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP4102(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document doc = entryContext.getMessageEntryDocument();
            if (doc == null) {
                throw new AssertionNotApplicableException();
            }
            Element root = doc.getDocumentElement();
            NodeList faultList = root.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            if (faultList == null || faultList.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            Element fault = (Element)faultList.item(0);
            NodeList details = fault.getElementsByTagName("detail");
            if (details != null && details.getLength() > 0) {
                NodeList list = details.item(0).getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    if (list.item(i).getNodeType() == 1 && list.item(i).getLocalName() != null) {
                        throw new AssertionPassException();
                    }
                    ++i;
                }
            }
            this.result = "notApplicable";
        }
        catch (AssertionPassException assertionPassException) {
            this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

