/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.BusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceInterfaceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.response.DispositionReport;
import org.uddi4j.transport.TransportException;

public class UnpublishAction
extends UDDIPropertiesFormAction {
    protected RegistryNode registryNode_ = this.getRegistryNode();
    protected boolean isLoggedIn_;

    public UnpublishAction(Controller controller) {
        super(controller);
    }

    protected final boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        RegistryElement regElement = (RegistryElement)this.registryNode_.getTreeElement();
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        FormTool formTool = this.getSelectedFormTool();
        if (!regElement.isLoggedIn()) {
            String publishURL = parser.getParameter("advancedPublishURL");
            String userId = parser.getParameter("advancedUserId");
            String password = parser.getParameter("advancedPassword");
            boolean inputsValid = true;
            if (publishURL != null) {
                this.propertyTable_.put("advancedPublishURL", publishURL);
            }
            if (!Validator.validateURL(publishURL)) {
                formTool.flagError("advancedPublishURL");
                inputsValid = false;
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_PUBLISH_URL"));
            }
            if (userId != null) {
                this.propertyTable_.put("advancedUserId", userId);
            }
            if (!Validator.validateString(userId)) {
                formTool.flagError("advancedUserId");
                inputsValid = false;
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_USERID"));
            }
            this.propertyTable_.put("advancedPassword", password);
            formTool.updatePropertyTable(this.propertyTable_);
            return inputsValid;
        }
        return true;
    }

    public boolean run() {
        RegistryElement registryElement = (RegistryElement)this.registryNode_.getTreeElement();
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        NodeManager navigatorManager = uddiPerspective.getNavigatorManager();
        Node selectedNode = navigatorManager.getSelectedNode();
        TreeElement selectedElement = selectedNode.getTreeElement();
        try {
            if (!registryElement.isLoggedIn()) {
                String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
                String userId = (String)this.propertyTable_.get("advancedUserId");
                String password = (String)this.propertyTable_.get("advancedPassword");
                registryElement.performLogin(publishURL, userId, password);
            }
            String selectedElementKey = selectedElement.getKey();
            String unpublishTypeMessageKey = null;
            UDDIProxy proxy = registryElement.getProxy();
            String authInfo = registryElement.getAuthInfoString();
            DispositionReport dr = null;
            if (selectedElement instanceof BusinessElement) {
                unpublishTypeMessageKey = "MSG_INFO_BUSINESS_UNPUBLISHED";
                dr = proxy.delete_business(authInfo, selectedElementKey);
            } else if (selectedElement instanceof ServiceElement) {
                unpublishTypeMessageKey = "MSG_INFO_SERVICE_UNPUBLISHED";
                dr = proxy.delete_service(authInfo, selectedElementKey);
            } else if (selectedElement instanceof ServiceInterfaceElement) {
                unpublishTypeMessageKey = "MSG_INFO_SERVICE_INTERFACE_UNPUBLISHED";
                dr = proxy.delete_tModel(authInfo, selectedElementKey);
            }
            if (!dr.success()) {
                throw new Exception(dr.toString());
            }
            selectedElement.disconnectAll();
            messageQueue.addMessage(uddiPerspective.getMessage(unpublishTypeMessageKey, selectedElement.getName()));
            return true;
        }
        catch (TransportException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "TransportException", e);
            return false;
        }
        catch (UDDIException e) {
            messageQueue.addMessage(uddiPerspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
            return false;
        }
        catch (MalformedURLException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "MalformedURLException", e);
            return false;
        }
        catch (Exception e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "Exception", e);
            return false;
        }
    }
}

