/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.extensions.internal.templates;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.templates.SQLTemplate;
import org.osgi.framework.Bundle;

public class TemplateRegistry {
    protected static final String PLUGIN_ID = ServerExtensionsPlugin.getUniqueIdentifier();
    protected static final String TEMPLATE_EXTENSION_POINT_ID = String.valueOf(PLUGIN_ID) + ".sqlTemplates";
    protected static TemplateRegistry instance = null;
    private String SEP = System.getProperty("file.separator");

    public static TemplateRegistry getInstance() {
        if (instance == null) {
            instance = new TemplateRegistry();
        }
        return instance;
    }

    public SQLTemplate getTemplate(Object obj, String vendorId) {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(TEMPLATE_EXTENSION_POINT_ID);
        IConfigurationElement[] e = ep.getConfigurationElements();
        int i = 0;
        while (i < e.length) {
            String baseDir = e[i].getAttribute("baseDir");
            String vendorDir = null;
            IConfigurationElement[] e2 = e[i].getChildren("vendorDirectory");
            int j = 0;
            while (j < e2.length) {
                if (e2[j].getAttribute("vendorId").equals(vendorId)) {
                    vendorDir = e2[j].getAttribute("vendorDir");
                    break;
                }
                ++j;
            }
            String templateFile = null;
            String title = null;
            e2 = e[i].getChildren("templateFile");
            int j2 = 0;
            while (j2 < e2.length) {
                if (this.implementsOrExtends(obj, e2[j2].getAttribute("objectClass"))) {
                    templateFile = e2[j2].getAttribute("templateFile");
                    title = e2[j2].getAttribute("title");
                    break;
                }
                ++j2;
            }
            if (vendorDir != null && templateFile != null) {
                Bundle otherBundle = Platform.getBundle((String)e[i].getDeclaringExtension().getNamespace());
                URL uri = otherBundle.getEntry(String.valueOf(baseDir) + this.SEP + vendorDir + this.SEP + templateFile);
                try {
                    File f = new File(Platform.asLocalURL((URL)uri).getPath());
                    if (f.exists()) {
                        return new SQLTemplate(obj.getClass().getName(), vendorId, f, title);
                    }
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return null;
    }

    protected boolean implementsOrExtends(Object obj, String className) {
        Class<?> cur = obj.getClass();
        while (cur != null) {
            if (cur.getName().equals(className)) {
                return true;
            }
            cur = cur.getSuperclass();
        }
        Class<?>[] interfaces = obj.getClass().getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getName().equals(className)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

