/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.core;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class Message
implements IMessage {
    private String id = null;
    private String[] params = null;
    private int severity = -1;
    private Object targetObject = null;
    private String bundleName = null;
    private String groupName = null;
    private int lineNumber = 0;
    private int length = -1;
    private int offset = -1;
    private HashMap messageAttributes;
    private String markerId = null;

    public Message() {
    }

    public Message(String aBundleName, int aSeverity, String anId) {
        this(aBundleName, aSeverity, anId, null, null);
    }

    public Message(String aBundleName, int aSeverity, String anId, String[] aParams) {
        this(aBundleName, aSeverity, anId, aParams, null);
    }

    public Message(String aBundleName, int aSeverity, String anId, String[] aParams, Object aTargetObject) {
        this.bundleName = aBundleName;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.targetObject = aTargetObject;
    }

    public Message(String aBundleName, int aSeverity, String anId, String[] aParams, Object aTargetObject, String aGroupName) {
        this.bundleName = aBundleName;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.targetObject = aTargetObject;
        this.groupName = aGroupName;
    }

    public ResourceBundle getBundle(Locale locale, ClassLoader classLoader) {
        ResourceBundle bundle = null;
        try {
            bundle = classLoader == null ? ResourceBundle.getBundle(this.getBundleName(), locale) : ResourceBundle.getBundle(this.getBundleName(), locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            bundle = this.getFrameworkBundle(locale);
        }
        return bundle;
    }

    private ResourceBundle getFrameworkBundle(Locale locale) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(this.getBundleName(), locale, this.getClass().getClassLoader());
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        return bundle;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public String[] getParams() {
        return this.params;
    }

    public int getSeverity() {
        return this.severity;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public String getText() {
        return this.getText(Locale.getDefault(), null);
    }

    public String getText(ClassLoader classLoader) {
        return this.getText(Locale.getDefault(), classLoader);
    }

    public String getText(Locale locale) {
        return this.getText(locale, null);
    }

    public String getText(Locale locale, ClassLoader classLoader) {
        String message = "";
        if (locale == null) {
            return message;
        }
        ResourceBundle bundle = this.getBundle(locale, classLoader);
        if (bundle == null) {
            return message;
        }
        try {
            message = bundle.getString(this.getId());
            if (this.getParams() != null) {
                message = MessageFormat.format(message, this.getParams());
            }
        }
        catch (MissingResourceException exc) {
            System.err.println(exc.getMessage());
            System.err.println(this.getId());
        }
        catch (NullPointerException exc) {
            System.err.println(exc.getMessage());
            System.err.println(this.getId());
        }
        return message;
    }

    public void setBundleName(String aBundleName) {
        this.bundleName = aBundleName;
    }

    public void setGroupName(String name) {
        this.groupName = name;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public void setLength(int length) {
        if (length < 0) {
            length = -1;
        }
        this.length = length;
    }

    public void setLineNo(int lineNumber) {
        this.lineNumber = lineNumber < 0 ? 0 : lineNumber;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            offset = -1;
        }
        this.offset = offset;
    }

    public void setParams(String[] newParams) {
        this.params = newParams;
    }

    public void setSeverity(int newSeverity) {
        this.severity = newSeverity;
    }

    public void setTargetObject(Object obj) {
        this.targetObject = obj;
    }

    public Object getAttribute(String attributeName) {
        if (this.messageAttributes != null) {
            return this.messageAttributes.get(attributeName);
        }
        return null;
    }

    public void setAttribute(String attributeName, Object value) {
        if (this.messageAttributes == null) {
            this.messageAttributes = new HashMap();
        }
        this.messageAttributes.put(attributeName, value);
    }

    public HashMap getAttributes() {
        return this.messageAttributes;
    }

    public String getMarkerId() {
        return this.markerId;
    }

    public void setMarkerId(String markerId) {
        this.markerId = markerId;
    }
}

