/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.wizards.other;

import java.text.MessageFormat;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionInformation;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionUIProvider;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.NewConnectionWizard;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;

public class OtherNewConnectionProvider implements IServerConnectionUIProvider,
		Listener {
	private static final RSCCoreUIWidgetFactory factory = RSCCoreUIWidgetFactory.INSTANCE;

	private static final ResourceLoader resource = ResourceLoader.INSTANCE;

	private static final String CUI_NEWCW_DATABASE_LBL_UI_ = resource
			.queryString("CUI_NEWCW_DATABASE_LBL_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_HOST_LBL_UI_ = resource
			.queryString("CUI_NEWCW_HOST_LBL_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_PORT_LBL_UI_ = resource
			.queryString("CUI_NEWCW_PORT_LBL_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_ = resource
			.queryString("CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_ = resource
			.queryString("CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_JARBROWSE_BTN_UI_ = resource
			.queryString("CUI_NEWCW_JARBROWSE_BTN_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = resource
			.queryString("CUI_NEWCW_CONNECTIONURL_LBL_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_ = resource
			.queryString("CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_DEFDBNAME_VAL_UI_ = resource
			.queryString("CUI_NEWCW_DEFDBNAME_VAL_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_VALIDATE_HOST_REQ_UI_ = resource
			.queryString("CUI_NEWCW_VALIDATE_HOST_REQ_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_VALIDATE_PORT_REQ_UI_ = resource
			.queryString("CUI_NEWCW_VALIDATE_PORT_REQ_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_VALIDATE_DRIVERCLASS_REQ_UI_ = resource
			.queryString("CUI_NEWCW_VALIDATE_DRIVERCLASS_REQ_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_VALIDATE_CLASSLOCATION_REQ_UI_ = resource
			.queryString("CUI_NEWCW_VALIDATE_CLASSLOCATION_REQ_UI_"); //$NON-NLS-1$

	private static final String CUI_NEWCW_VALIDATE_URL_REQ_UI_ = resource
			.queryString("CUI_NEWCW_VALIDATE_URL_REQ_UI_"); //$NON-NLS-1$

	private IServerConnectionInformation connectionInformation;

	private DatabaseDefinition definition;

	private Label databaseLabel;

	private Text databaseCombo;

	private Label driverLabel;

	private Text driverDisplay;

	private Label locationLabel;

	private Text locationCombo;

	private Button browseLocation;

	private Label urlLabel;

	private Text urlDisplay;

	private WizardPage parentPage;

	private Composite parentComposite;

	private void createLayout(Composite parentComposite) {
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		layout.numColumns = 3;
		layout.horizontalSpacing = 5;
		layout.verticalSpacing = 5;
		parentComposite.setLayout(layout);
	}

	public boolean determinePageCompletion() {
		return validateControl();
	}

	private void setConnectionInformation() {
		connectionInformation.setDatabaseName(databaseCombo.getText());
		connectionInformation.setURL(urlDisplay.getText());
		connectionInformation.setDriverClassName(driverDisplay.getText());
		connectionInformation.setLoadingPath(locationCombo.getText());
		if (determinePageCompletion()) {
			connectionInformation.setInformationComplete(true);
		}
	}

	private boolean validateControl() {
		if (databaseCombo.getText() == null
				|| databaseCombo.getText().equals("")) { //$NON-NLS-1$
			parentPage.setErrorMessage(MessageFormat.format(
					CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_,
					new String[] { CUI_NEWCW_DEFDBNAME_VAL_UI_ }));
			return false;
		} else if (driverDisplay != null && driverDisplay.getEnabled()
				&& driverDisplay.getText().trim().length() < 1) {
			parentPage.setErrorMessage(CUI_NEWCW_VALIDATE_DRIVERCLASS_REQ_UI_);
			return false;
		} else if (locationCombo != null
				&& locationCombo.getText().trim().length() < 1) {
			parentPage
					.setErrorMessage(CUI_NEWCW_VALIDATE_CLASSLOCATION_REQ_UI_);
			return false;
		} else if (urlDisplay != null
				&& urlDisplay.getText().trim().length() == 0) {
			parentPage.setErrorMessage(CUI_NEWCW_VALIDATE_URL_REQ_UI_);
			return false;
		}
		return true;
	}

	private void addListeners() {
		locationCombo.addListener(SWT.Modify, this);
		browseLocation.addListener(SWT.Selection, this);
		databaseCombo.addListener(SWT.Modify, this);
		driverDisplay.addListener(SWT.Modify, this);
		urlDisplay.addListener(SWT.Modify, this);
	}

	private void initialize() {
		addListeners();
		determinePageCompletion();
	}

	private void removeListeners() {
		locationCombo.removeListener(SWT.Modify, this);
		browseLocation.removeListener(SWT.Selection, this);
		databaseCombo.removeListener(SWT.Modify, this);
		driverDisplay.removeListener(SWT.Modify, this);
		urlDisplay.removeListener(SWT.Modify, this);
	}

	private Composite createServerConnectionUI(Composite parent) {
		parentComposite = factory.createComposite(parent, SWT.NULL);
		createLayout(parentComposite);

		GridData gd;

		databaseLabel = factory.createLabel(parentComposite, SWT.NONE);
		databaseLabel.setText(CUI_NEWCW_DATABASE_LBL_UI_);
		gd = new GridData();
		gd.verticalAlignment = GridData.BEGINNING;
		databaseLabel.setLayoutData(gd);

		databaseCombo = factory.createText(parentComposite, SWT.SINGLE
				| SWT.BORDER);
		gd = new GridData();
		gd.verticalAlignment = GridData.BEGINNING;
		gd.horizontalAlignment = GridData.FILL;
		gd.horizontalSpan = 2;
		databaseCombo.setLayoutData(gd);

		driverLabel = factory.createLabel(parentComposite, SWT.NONE);
		driverLabel.setText(CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_);
		gd = new GridData();
		gd.verticalAlignment = GridData.BEGINNING;
		gd.horizontalSpan = 1;
		driverLabel.setLayoutData(gd);

		driverDisplay = factory.createText(parentComposite, SWT.SINGLE
				| SWT.BORDER);
		gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.verticalAlignment = GridData.BEGINNING;
		gd.grabExcessHorizontalSpace = true;
		gd.horizontalSpan = 2;
		driverDisplay.setLayoutData(gd);

		locationLabel = factory.createLabel(parentComposite, SWT.NONE);
		locationLabel.setText(CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_);
		gd = new GridData();
		gd.verticalAlignment = GridData.BEGINNING;
		gd.horizontalSpan = 1;
		locationLabel.setLayoutData(gd);

		locationCombo = factory.createText(parentComposite, SWT.SINGLE
				| SWT.BORDER);
		gd = new GridData();
		gd.widthHint = 200;
		gd.horizontalAlignment = GridData.FILL;
		gd.grabExcessHorizontalSpace = true;
		gd.verticalAlignment = GridData.BEGINNING;
		gd.grabExcessHorizontalSpace = true;
		gd.horizontalSpan = 1;
		locationCombo.setLayoutData(gd);

		browseLocation = factory.createButton(parentComposite, SWT.PUSH);
		browseLocation.setText(CUI_NEWCW_JARBROWSE_BTN_UI_);
		gd = new GridData();
		gd.verticalAlignment = GridData.BEGINNING;
		gd.horizontalAlignment = GridData.FILL;
		gd.grabExcessHorizontalSpace = true;
		gd.horizontalSpan = 1;
		browseLocation.setLayoutData(gd);

		urlLabel = factory.createLabel(parentComposite, SWT.NONE);
		urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
		gd = new GridData();
		gd.verticalAlignment = GridData.BEGINNING;
		gd.horizontalSpan = 1;
		urlLabel.setLayoutData(gd);

		urlDisplay = factory.createText(parentComposite, SWT.SINGLE
				| SWT.BORDER);
		gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.verticalAlignment = GridData.BEGINNING;
		gd.grabExcessHorizontalSpace = true;
		gd.horizontalSpan = 2;
		urlDisplay.setLayoutData(gd);

		initialize();

		return parentComposite;
	}

	public Composite getServerConnectionUI(Composite parent) {
		if (parentComposite == null || parentComposite.isDisposed()) {
			parentComposite = createServerConnectionUI(parent);
		}
		setConnectionInformation();
		return parentComposite;
	}

	public void setServerConnectionInformation(
			IServerConnectionInformation connectionInformation) {
		this.connectionInformation = connectionInformation;
	}

	public void setDatabaseDefinition(DatabaseDefinition definition) {
		this.definition = definition;
	}

	public void setWizardPage(WizardPage parentPage) {
		this.parentPage = parentPage;
	}

	public void handleEvent(Event event) {
		Widget source = event.widget;
		if (source == databaseCombo) {	
			connectionInformation.setDatabaseName(databaseCombo.getText());
		} else if (source == this.urlDisplay) {
			connectionInformation.setURL(urlDisplay.getText());
		}else if (source == this.driverDisplay) {
			connectionInformation.setDriverClassName(driverDisplay.getText());
		} else if (source == browseLocation) {
			String file = NewConnectionWizard.getFile((Wizard) parentPage
					.getWizard(), NewConnectionWizard.fExtensions);
			if (file != null && file.length() > 0) {
				locationCombo.removeListener(SWT.Modify, this);
				locationCombo.setText(file);
				locationCombo.addListener(SWT.Modify, this);
				connectionInformation.setLoadingPath(file);
			}
		}
		setConnectionInformation();
	}

	public void loadProperties() {
		removeListeners();
		urlDisplay.setText(connectionInformation.getURL());
		driverDisplay.setText(connectionInformation.getDriverClassName());
		locationCombo.setText(connectionInformation.getLoadingPath());
		databaseCombo.setText(connectionInformation.getDatabaseName());
		addListeners();
		setConnectionInformation();
	}
}