/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.schema.helper;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

/**
 * @author ckadner
 *
 * Helper to provide convenience methods that are related to 
 * {@link com.ibm.db.models.sql.schema.Database}.
 */
public class DatabaseHelper
{
    
    /**
     * Finds a <code>Schema</code> by its name in a given <code>Database</code>.
     * If the given <code>schemaName</code> is not delimited, the
     * search is not case sensitive.  
     * 
     * @param database the <code>Database</code> to find <code>Schema</code>s in
     * @param schemaName the String name of the <code>Schema</code> to find
     * @return the <code>Schema</code> found or <code>null</code> if no 
     * 		corresponding <code>Schema</code> was found
     * @throws NullPointerException if given <code>database</code> or given
     *         <code>schemaName</code> is <code>null</code>
     */
    public static Schema findSchema(Database database, String schemaName) {
        Schema returnSchema = null;
        
        if (schemaName != null) {
            // TODO perf: optimize performance by loading only the schema needed as
            //            opposed to all of them
            for (Iterator it = database.getSchemas().iterator(); it.hasNext();)
            {
                Schema schema = (Schema) it.next();
                if (schemaName.equals(schema.getName())) {
                    returnSchema = schema;
                }
            }
        }
    
        return returnSchema;
    }
    
    
    /**
     * Finds all <code>Table</code>s with the name <code>tableName</code> in all
     * <code>Schema</code>'s of the given <code>database</code>.
     * Returns a list of <code>Table</code>s with associated <code>Schema</code>.
     * If the given <code>tableName</code> is not delimited, the
     * search is not case sensitive.  
     * 
     * @param database the <code>Database</code> to search in
     * @param tableName the String name of the <code>Table</code> to find
     * @return List of <code>Table</code>s with associated <code>Schema</code>
     * @throws NullPointerException if given <code>schema</code> or given
     *         <code>tableName</code> is <code>null</code>
     */
    public static List findTables(Database database, String tableName) {
        List returnTables = new Vector();
        
        if (tableName != null) {
            for (Iterator schemaIt = database.getSchemas().iterator(); schemaIt.hasNext();)
            {
                Schema schema = (Schema) schemaIt.next();
                
    	        for (Iterator tableIt = schema.getTables().iterator(); tableIt.hasNext();)
    	        {
    	            Table table = (Table) tableIt.next();
    	            
    	            if (tableName.equals(table.getName())) {
    	                returnTables.add(table);
    	            }
    	        }
            }
        }

        return returnTables;
    }    

}
