/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.ProductFile;
import org.eclipse.pde.internal.build.site.PDEState;

public class ProductGenerator
extends AbstractScriptGenerator {
    private static final String BUNDLE_EQUINOX_COMMON = "org.eclipse.equinox.common";
    private static final String BUNDLE_OSGI = "org.eclipse.osgi";
    private static final String BUNDLE_CORE_RUNTIME = "org.eclipse.core.runtime";
    private static final String BUNDLE_UPDATE_CONFIGURATOR = "org.eclipse.update.configurator";
    private static final String START_LEVEL_2 = "@2:start";
    private static final String START_LEVEL_3 = "@3:start";
    private static final String START = "@start";
    private String product = null;
    private ProductFile productFile = null;
    private String root = null;
    private boolean refactoredRuntime = false;
    private Properties buildProperties;

    public void generate() throws CoreException {
        this.initialize();
        if (this.productFile == null) {
            return;
        }
        if (this.productFile.getId() == null) {
            return;
        }
        String custom = this.findFile(this.productFile.getConfigIniPath(), false);
        String location = null;
        String fileList = null;
        for (Config config : ProductGenerator.getConfigInfos()) {
            location = "productRootFiles/" + config.toStringReplacingAny(".", "ANY");
            String rootLocation = String.valueOf(this.root) + location;
            File rootDir = new File(rootLocation);
            if (!rootDir.exists() && !rootDir.mkdirs() || rootDir.isFile()) continue;
            if (this.buildProperties != null) {
                fileList = this.buildProperties.getProperty("root." + config.toString("."), "");
                fileList = String.valueOf(fileList) + (fileList.length() > 0 ? String.valueOf(',') + location : location);
                this.buildProperties.put("root." + config.toString("."), fileList);
            }
            if (custom != null) {
                this.copyFile(custom, String.valueOf(rootLocation) + "/configuration/config.ini");
            } else {
                this.createConfigIni(config, rootLocation);
            }
            if (config.getOs().equals(Config.ANY)) continue;
            this.createEclipseProductFile(rootLocation);
            this.createLauncherIniFile(rootLocation, config.getOs());
        }
    }

    private void initialize() throws CoreException {
        this.loadProduct();
        PDEState state = this.getSite(false).getRegistry();
        this.refactoredRuntime = state.getResolvedBundle(BUNDLE_EQUINOX_COMMON) != null;
    }

    private void loadProduct() throws CoreException {
        if (this.product == null || this.product.startsWith("${")) {
            this.productFile = null;
            return;
        }
        String productPath = this.findFile(this.product, false);
        if (productPath == null) {
            productPath = this.product;
        }
        this.productFile = new ProductFile(productPath, null);
    }

    private void copyFile(String src, String dest) {
        block27: {
            OutputStream out;
            FileInputStream in;
            block26: {
                File source = new File(src);
                if (!source.exists()) {
                    return;
                }
                File destination = new File(dest);
                File destDir = destination.getParentFile();
                if (!destDir.exists() && !destDir.mkdirs() || destDir.isFile()) {
                    return;
                }
                in = null;
                out = null;
                try {
                    try {
                        int len;
                        in = new FileInputStream(source);
                        out = new FileOutputStream(destination);
                        byte[] buf = new byte[1024];
                        while ((len = ((InputStream)in).read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    catch (IOException iOException) {
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                break block27;
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void createConfigIni(Config config, String location) throws CoreException {
        block27: {
            OutputStreamWriter writer;
            block26: {
                String application;
                File configDir = new File(String.valueOf(location) + "/configuration");
                if (!configDir.exists() && !configDir.mkdirs() || configDir.isFile()) {
                    return;
                }
                PDEState state = this.getSite(false).getRegistry();
                StringBuffer buffer = new StringBuffer();
                buffer.append("#Product Runtime Configuration File\n");
                String splash = this.getSplashLocation(config);
                if (splash != null) {
                    buffer.append("osgi.splashPath=" + splash + '\n');
                }
                if ((application = this.productFile.getApplication()) != null) {
                    buffer.append("eclipse.application=" + application + '\n');
                }
                buffer.append("eclipse.product=" + this.productFile.getId() + '\n');
                buffer.append("osgi.bundles=");
                if (this.productFile.useFeatures() || this.productFile.containsPlugin(BUNDLE_UPDATE_CONFIGURATOR)) {
                    if (this.refactoredRuntime) {
                        buffer.append(BUNDLE_EQUINOX_COMMON);
                        buffer.append(START_LEVEL_2);
                        buffer.append(',');
                        buffer.append(BUNDLE_UPDATE_CONFIGURATOR);
                        buffer.append(START_LEVEL_3);
                        buffer.append(',');
                        buffer.append(BUNDLE_CORE_RUNTIME);
                        buffer.append(START);
                        buffer.append('\n');
                    } else {
                        buffer.append(BUNDLE_CORE_RUNTIME);
                        buffer.append(START_LEVEL_2);
                        buffer.append(',');
                        buffer.append(BUNDLE_UPDATE_CONFIGURATOR);
                        buffer.append(START_LEVEL_3);
                        buffer.append('\n');
                    }
                } else {
                    Hashtable<String, String> environment = new Hashtable<String, String>(3);
                    ((Dictionary)environment).put("osgi.os", config.getOs());
                    ((Dictionary)environment).put("osgi.ws", config.getWs());
                    ((Dictionary)environment).put("osgi.arch", config.getArch());
                    List pluginList = this.productFile.getPlugins();
                    BundleHelper helper = BundleHelper.getDefault();
                    boolean first = true;
                    for (String id : pluginList) {
                        String filter;
                        BundleDescription bundle = state.getResolvedBundle(id);
                        if (bundle == null || (filter = bundle.getPlatformFilter()) != null && !helper.createFilter(filter).match(environment) || BUNDLE_OSGI.equals(id)) continue;
                        if (first) {
                            first = false;
                        } else {
                            buffer.append(",");
                        }
                        buffer.append(id);
                        if (BUNDLE_EQUINOX_COMMON.equals(id)) {
                            buffer.append(START_LEVEL_2);
                            continue;
                        }
                        if (!BUNDLE_CORE_RUNTIME.equals(id)) continue;
                        if (this.refactoredRuntime) {
                            buffer.append(START);
                            continue;
                        }
                        buffer.append(START_LEVEL_2);
                    }
                    buffer.append('\n');
                }
                buffer.append("osgi.bundles.defaultStartLevel=4\n");
                writer = null;
                try {
                    try {
                        writer = new FileWriter(new File(configDir, "config.ini"));
                        writer.write(buffer.toString());
                    }
                    catch (IOException iOException) {
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block27;
                }
                catch (IOException iOException) {}
                break block27;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void createEclipseProductFile(String directory) throws CoreException {
        block19: {
            FileOutputStream stream;
            block18: {
                BundleDescription bundle;
                File dir = new File(directory);
                if (!dir.exists() && !dir.mkdirs() || dir.isFile()) {
                    return;
                }
                Properties properties = new Properties();
                if (this.productFile.getProductName() != null) {
                    properties.put("name", this.productFile.getProductName());
                }
                if (this.productFile.getId() != null) {
                    properties.put("id", this.productFile.getId());
                }
                if ((bundle = this.getSite(false).getRegistry().getResolvedBundle(this.getBrandingPlugin())) != null) {
                    properties.put("version", bundle.getVersion().toString());
                }
                stream = null;
                try {
                    try {
                        File file = new File(dir, ".eclipseproduct");
                        stream = new FileOutputStream(file);
                        properties.store(stream, "Eclipse Product File");
                        stream.flush();
                    }
                    catch (IOException iOException) {
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                break block19;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getBrandingPlugin() {
        String id = this.productFile.getId();
        if (id == null) {
            return null;
        }
        int dot = id.lastIndexOf(46);
        return dot != -1 ? id.substring(0, dot) : null;
    }

    private String getSplashLocation(Config config) throws CoreException {
        String plugin = this.productFile.getSplashLocation();
        if (plugin == null) {
            plugin = this.getBrandingPlugin();
        }
        if (plugin == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("platform:/base/plugins/");
        buffer.append(plugin);
        Hashtable<String, String> environment = new Hashtable<String, String>(4);
        ((Dictionary)environment).put("osgi.os", config.getOs());
        ((Dictionary)environment).put("osgi.ws", config.getWs());
        ((Dictionary)environment).put("osgi.arch", config.getArch());
        PDEState state = this.getSite(false).getRegistry();
        BundleHelper helper = BundleHelper.getDefault();
        BundleDescription bundle = state.getResolvedBundle(plugin);
        if (bundle != null) {
            BundleDescription[] fragments = bundle.getFragments();
            int i = 0;
            while (i < fragments.length) {
                String fragmentId;
                String filter = fragments[i].getPlatformFilter();
                if ((filter == null || helper.createFilter(filter).match(environment)) && this.productFile.containsPlugin(fragmentId = fragments[i].getSymbolicName())) {
                    buffer.append(",platform:/base/plugins/");
                    buffer.append(fragmentId);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    private void createLauncherIniFile(String directory, String os) {
        File dir;
        String launcher = this.getLauncherName();
        if (os.equals("macosx")) {
            directory = String.valueOf(directory) + "/" + launcher + ".app/Contents/MacOS";
        }
        if (!(dir = new File(directory)).exists() && !dir.mkdirs() || dir.isFile()) {
            return;
        }
        String programArgs = this.productFile.getProgramArguments(os);
        String vmArgs = this.productFile.getVMArguments(os);
        if (!(programArgs != null && programArgs.length() != 0 || vmArgs != null && vmArgs.length() != 0)) {
            return;
        }
        String lineDelimiter = "win32".equals(os) ? "\r\n" : "\n";
        PrintWriter writer = null;
        try {
            try {
                StringTokenizer tokenizer;
                writer = new PrintWriter(new FileWriter(new File(dir, String.valueOf(launcher) + ".ini")));
                if (programArgs != null && programArgs.length() > 0) {
                    tokenizer = new StringTokenizer(programArgs);
                    while (tokenizer.hasMoreTokens()) {
                        writer.print(tokenizer.nextToken());
                        writer.print(lineDelimiter);
                    }
                }
                if (vmArgs != null && vmArgs.length() > 0) {
                    writer.print("-vmargs");
                    writer.print(lineDelimiter);
                    tokenizer = new StringTokenizer(vmArgs);
                    while (tokenizer.hasMoreTokens()) {
                        writer.print(tokenizer.nextToken());
                        writer.print(lineDelimiter);
                    }
                }
            }
            catch (IOException iOException) {}
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getLauncherName() {
        String name = this.productFile.getLauncherName();
        if (name != null && name.length() > 0) {
            if ((name = name.trim()).endsWith(".exe")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
        return "eclipse";
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setBuildProperties(Properties buildProperties) {
        this.buildProperties = buildProperties;
    }
}

