/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.util.List;
import junit.framework.JUnit4TestAdapterCache;
import junit.framework.Test;
import junit.framework.TestResult;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4TestAdapter
implements Test {
    private final Class<?> fNewTestClass;
    private Runner fRunner;
    private JUnit4TestAdapterCache fCache;

    public JUnit4TestAdapter(Class<?> newTestClass) {
        this(newTestClass, JUnit4TestAdapterCache.getDefault());
    }

    public JUnit4TestAdapter(Class<?> newTestClass, JUnit4TestAdapterCache cache) {
        this.fCache = cache;
        this.fNewTestClass = newTestClass;
        this.fRunner = Request.aClass(newTestClass).getRunner();
    }

    @Override
    public int countTestCases() {
        return this.fRunner.testCount();
    }

    @Override
    public void run(TestResult result) {
        this.fRunner.run(this.fCache.getNotifier(result, this));
    }

    public List<Test> getTests() {
        return this.fCache.asTestList(this.getDescription());
    }

    public Class getTestClass() {
        return this.fNewTestClass;
    }

    public Description getDescription() {
        return this.fRunner.getDescription();
    }

    public String toString() {
        return this.fNewTestClass.getName();
    }
}

