/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import java.util.StringTokenizer;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceConsole;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.console.IConsoleView;

public class FormatStackTraceActionDelegate
implements IViewActionDelegate {
    private IConsoleView fConsoleView;
    private JavaStackTraceConsole fConsole;

    public FormatStackTraceActionDelegate() {
    }

    public FormatStackTraceActionDelegate(JavaStackTraceConsole console) {
        this.fConsole = console;
    }

    public void init(IViewPart view) {
        this.fConsoleView = (IConsoleView)view;
    }

    public void run(IAction action) {
        IDocument document;
        String orig;
        if (this.fConsoleView != null) {
            this.fConsole = (JavaStackTraceConsole)this.fConsoleView.getConsole();
        }
        if ((orig = (document = this.fConsole.getDocument()).get()) != null && orig.length() > 0) {
            document.set("");
            document.set(this.format(orig));
        }
    }

    private String format(String trace) {
        StringTokenizer tokenizer = new StringTokenizer(trace, " \t\n\r\f", true);
        StringBuffer formattedTrace = new StringBuffer();
        boolean insideAt = false;
        boolean newLine = true;
        int pendingSpaces = 0;
        boolean antTrace = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 0) continue;
            char c = token.charAt(0);
            switch (c) {
                case ' ': {
                    if (newLine) {
                        ++pendingSpaces;
                        break;
                    }
                    pendingSpaces = 1;
                    break;
                }
                case '\t': {
                    if (newLine) {
                        pendingSpaces += 4;
                        break;
                    }
                    pendingSpaces = 1;
                    break;
                }
                case '\n': 
                case '\f': 
                case '\r': {
                    if (insideAt) {
                        pendingSpaces = 1;
                        break;
                    }
                    pendingSpaces = 0;
                    newLine = true;
                    break;
                }
                default: {
                    if (newLine || antTrace) {
                        if (c == '\"') {
                            formattedTrace.append("\n\n");
                        } else {
                            if ("-".equals(token)) {
                                formattedTrace.append("\n");
                                formattedTrace.append("    ");
                                formattedTrace.append(token);
                                pendingSpaces = 0;
                                break;
                            }
                            if ("at".equals(token)) {
                                if (!antTrace) {
                                    formattedTrace.append("\n");
                                    formattedTrace.append("    ");
                                } else {
                                    formattedTrace.append(' ');
                                }
                                insideAt = true;
                                formattedTrace.append(token);
                                pendingSpaces = 0;
                                break;
                            }
                            if (c == '[') {
                                if (antTrace) {
                                    formattedTrace.append("\n");
                                }
                                formattedTrace.append(token);
                                pendingSpaces = 0;
                                newLine = false;
                                antTrace = true;
                                break;
                            }
                        }
                        newLine = false;
                    }
                    if (pendingSpaces > 0) {
                        int i = 0;
                        while (i < pendingSpaces) {
                            formattedTrace.append(' ');
                            ++i;
                        }
                        pendingSpaces = 0;
                    }
                    formattedTrace.append(token);
                    insideAt = false;
                }
            }
        }
        return formattedTrace.toString();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

