/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.RefreshChangeListener;
import org.eclipse.team.internal.ui.synchronize.RefreshParticipantJob;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;

public class RefreshSubscriberParticipantJob
extends RefreshParticipantJob {
    private final IResource[] resources;

    public RefreshSubscriberParticipantJob(SubscriberParticipant participant, String jobName, String taskName, IResource[] resources, IRefreshSubscriberListener listener) {
        super(participant, jobName, taskName, listener);
        this.resources = resources;
    }

    protected Subscriber getSubscriber() {
        return ((SubscriberParticipant)this.getParticipant()).getSubscriber();
    }

    private SubscriberSyncInfoCollector getCollector() {
        return ((SubscriberParticipant)this.getParticipant()).getSubscriberSyncInfoCollector();
    }

    protected int getChangeCount() {
        int numChanges = 0;
        SubscriberSyncInfoCollector collector = this.getCollector();
        if (collector != null) {
            SyncInfoTree set = collector.getSyncInfoSet();
            int i = 0;
            while (i < this.resources.length) {
                IResource resource = this.resources[i];
                SyncInfo[] infos = set.getSyncInfos(resource, 2);
                if (infos != null && infos.length > 0) {
                    numChanges += infos.length;
                }
                ++i;
            }
        }
        return numChanges;
    }

    protected RefreshParticipantJob.IChangeDescription createChangeDescription() {
        return new RefreshChangeListener(this.resources, this.getCollector());
    }

    protected void handleProgressGroupSet(IProgressMonitor group, int ticks) {
        this.getCollector().setProgressGroup(group, ticks);
    }

    public boolean shouldRun() {
        return this.getSubscriber() != null && this.getCollector().getSyncInfoSet() != null;
    }

    public boolean belongsTo(Object family) {
        if (family instanceof RefreshSubscriberParticipantJob) {
            return ((RefreshSubscriberParticipantJob)((Object)family)).getSubscriber() == this.getSubscriber();
        }
        return super.belongsTo(family);
    }

    protected void doRefresh(RefreshParticipantJob.IChangeDescription changeListener, IProgressMonitor monitor) throws TeamException {
        Subscriber subscriber = this.getSubscriber();
        if (subscriber != null) {
            try {
                subscriber.addListener((ISubscriberChangeListener)((RefreshChangeListener)changeListener));
                subscriber.refresh(this.resources, 2, monitor);
                this.getCollector().waitForCollector(monitor);
            }
            finally {
                subscriber.removeListener((ISubscriberChangeListener)((RefreshChangeListener)changeListener));
            }
        }
    }
}

