/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.net.ssl.AbstractSessionContext;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.provider.AbstractHandshake;
import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.Certificate;
import gnu.javax.net.ssl.provider.CertificateBuilder;
import gnu.javax.net.ssl.provider.CertificateRequest;
import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.CertificateVerify;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientCertificateTypeList;
import gnu.javax.net.ssl.provider.ClientDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ClientDiffieHellmanPublic;
import gnu.javax.net.ssl.provider.ClientHelloBuilder;
import gnu.javax.net.ssl.provider.ClientKeyExchangeBuilder;
import gnu.javax.net.ssl.provider.ClientPSKParameters;
import gnu.javax.net.ssl.provider.ClientRSA_PSKParameters;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.DelegatedTask;
import gnu.javax.net.ssl.provider.EncryptedPreMasterSecret;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.ExtensionList;
import gnu.javax.net.ssl.provider.Finished;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.InputSecurityParameters;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.MaxFragmentLength;
import gnu.javax.net.ssl.provider.OutputSecurityParameters;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.ServerDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ServerDHParams;
import gnu.javax.net.ssl.provider.ServerHello;
import gnu.javax.net.ssl.provider.ServerKeyExchange;
import gnu.javax.net.ssl.provider.ServerNameList;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import gnu.javax.net.ssl.provider.TruncatedHMAC;
import gnu.javax.net.ssl.provider.Util;
import gnu.javax.net.ssl.provider.X500PrincipalList;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientHandshake
extends AbstractHandshake {
    private State state = State.WRITE_CLIENT_HELLO;
    private ByteBuffer outBuffer;
    private boolean continuedSession = false;
    private SessionImpl continued;
    private KeyPair dhPair;
    private String keyAlias;
    private PrivateKey privateKey;
    private MaxFragmentLength maxFragmentLengthSent;
    private boolean truncatedHMacSent;
    private ProtocolVersion sentVersion;
    private AbstractHandshake.CertVerifier certVerifier;
    private ParamsVerifier paramsVerifier;
    private DelegatedTask keyExchange;
    private CertLoader certLoader;
    private GenCertVerify genCertVerify;

    public ClientHandshake(SSLEngineImpl engine) throws NoSuchAlgorithmException {
        super(engine);
    }

    @Override
    protected SSLEngineResult.HandshakeStatus implHandleInput() throws SSLException {
        if (this.state == State.DONE) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        if (this.state.isWriteState() || this.outBuffer != null && this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        ByteBuffer buffer = this.handshakeBuffer.duplicate();
        buffer.flip();
        buffer.position(this.handshakeOffset);
        Handshake handshake = new Handshake(buffer.slice(), this.engine.session().suite, this.engine.session().version);
        logger.logv(Component.SSL_HANDSHAKE, "processing in state {0}:\n{1}", new Object[]{this.state, handshake});
        switch (this.state) {
            case READ_SERVER_HELLO: {
                if (handshake.type() != Handshake.Type.SERVER_HELLO) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                ServerHello hello = (ServerHello)handshake.body();
                this.serverRandom = hello.random().copy();
                this.engine.session().suite = hello.cipherSuite();
                this.engine.session().version = hello.version();
                this.compression = hello.compressionMethod();
                Session.ID serverId = new Session.ID(hello.sessionId());
                if (this.continued != null && this.continued.id().equals(serverId)) {
                    this.continuedSession = true;
                    this.engine.setSession(this.continued);
                } else if (this.engine.getEnableSessionCreation()) {
                    ((AbstractSessionContext)this.engine.contextImpl.engineGetClientSessionContext()).put(this.engine.session());
                }
                ExtensionList extensions = hello.extensions();
                if (extensions != null) {
                    for (Extension extension : extensions) {
                        Extension.Type type = extension.type();
                        if (type == null) continue;
                        switch (type) {
                            case MAX_FRAGMENT_LENGTH: {
                                MaxFragmentLength mfl = (MaxFragmentLength)extension.value();
                                if (this.maxFragmentLengthSent != mfl) break;
                                this.engine.session().setApplicationBufferSize(mfl.maxLength());
                                break;
                            }
                            case TRUNCATED_HMAC: {
                                if (!this.truncatedHMacSent) break;
                                this.engine.session().setTruncatedMac(true);
                            }
                        }
                    }
                }
                KeyExchangeAlgorithm kex = this.engine.session().suite.keyExchangeAlgorithm();
                if (this.continuedSession) {
                    byte[][] keys = this.generateKeys(this.clientRandom, this.serverRandom, this.engine.session());
                    this.setupSecurityParameters(keys, true, this.engine, this.compression);
                    this.state = State.READ_FINISHED;
                    break;
                }
                if (kex == KeyExchangeAlgorithm.RSA || kex == KeyExchangeAlgorithm.DH_DSS || kex == KeyExchangeAlgorithm.DH_RSA || kex == KeyExchangeAlgorithm.DHE_DSS || kex == KeyExchangeAlgorithm.DHE_RSA || kex == KeyExchangeAlgorithm.RSA_PSK) {
                    this.state = State.READ_CERTIFICATE;
                    break;
                }
                if (kex == KeyExchangeAlgorithm.DH_anon || kex == KeyExchangeAlgorithm.PSK || kex == KeyExchangeAlgorithm.DHE_PSK) {
                    this.state = State.READ_SERVER_KEY_EXCHANGE;
                    break;
                }
                this.state = State.READ_CERTIFICATE_REQUEST;
                break;
            }
            case READ_CERTIFICATE: {
                if (handshake.type() != Handshake.Type.CERTIFICATE) {
                    if (this.engine.session().suite.signatureAlgorithm() != SignatureAlgorithm.ANONYMOUS) {
                        throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                    }
                    this.state = State.READ_SERVER_KEY_EXCHANGE;
                }
                Certificate cert = (Certificate)handshake.body();
                java.security.cert.Certificate[] chain = null;
                try {
                    chain = cert.certificates().toArray(new X509Certificate[0]);
                }
                catch (CertificateException ce) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.BAD_CERTIFICATE), (Throwable)ce);
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNSUPPORTED_CERTIFICATE), (Throwable)nsae);
                }
                this.engine.session().setPeerCertificates(chain);
                this.certVerifier = new AbstractHandshake.CertVerifier(true, (X509Certificate[])chain);
                this.tasks.add(this.certVerifier);
                KeyExchangeAlgorithm kea = this.engine.session().suite.keyExchangeAlgorithm();
                if (kea == KeyExchangeAlgorithm.RSA || kea == KeyExchangeAlgorithm.RSA_PSK) {
                    this.keyExchange = new RSAGen(kea == KeyExchangeAlgorithm.RSA);
                    this.tasks.add(this.keyExchange);
                    if (kea == KeyExchangeAlgorithm.RSA) {
                        this.state = State.READ_CERTIFICATE_REQUEST;
                        break;
                    }
                    this.state = State.READ_SERVER_KEY_EXCHANGE;
                    break;
                }
                this.state = State.READ_SERVER_KEY_EXCHANGE;
                break;
            }
            case READ_SERVER_KEY_EXCHANGE: {
                ServerDHParams dhParams;
                CipherSuite s = this.engine.session().suite;
                KeyExchangeAlgorithm kexalg = s.keyExchangeAlgorithm();
                if (kexalg != KeyExchangeAlgorithm.DHE_DSS && kexalg != KeyExchangeAlgorithm.DHE_RSA && kexalg != KeyExchangeAlgorithm.DH_anon && kexalg != KeyExchangeAlgorithm.DHE_PSK && kexalg != KeyExchangeAlgorithm.PSK && kexalg != KeyExchangeAlgorithm.RSA_PSK) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                if (handshake.type() != Handshake.Type.SERVER_KEY_EXCHANGE) {
                    if (kexalg != KeyExchangeAlgorithm.RSA_PSK && kexalg != KeyExchangeAlgorithm.PSK) {
                        throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                    }
                    this.state = State.READ_CERTIFICATE_REQUEST;
                    return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                }
                ServerKeyExchange skex = (ServerKeyExchange)handshake.body();
                ByteBuffer paramsBuffer = null;
                if (kexalg == KeyExchangeAlgorithm.DHE_DSS || kexalg == KeyExchangeAlgorithm.DHE_RSA || kexalg == KeyExchangeAlgorithm.DH_anon) {
                    dhParams = (ServerDHParams)skex.params();
                    ByteBuffer b = dhParams.buffer();
                    paramsBuffer = ByteBuffer.allocate(b.remaining());
                    paramsBuffer.put(b);
                }
                if (s.signatureAlgorithm() != SignatureAlgorithm.ANONYMOUS) {
                    byte[] signature = skex.signature().signature();
                    this.paramsVerifier = new ParamsVerifier(paramsBuffer, signature);
                    this.tasks.add(this.paramsVerifier);
                }
                if (kexalg == KeyExchangeAlgorithm.DHE_DSS || kexalg == KeyExchangeAlgorithm.DHE_RSA || kexalg == KeyExchangeAlgorithm.DH_anon) {
                    dhParams = (ServerDHParams)skex.params();
                    GnuDHPublicKey serverKey = new GnuDHPublicKey(null, dhParams.p(), dhParams.g(), dhParams.y());
                    DHParameterSpec params = new DHParameterSpec(dhParams.p(), dhParams.g());
                    this.keyExchange = new ClientDHGen(serverKey, params, true);
                    this.tasks.add(this.keyExchange);
                }
                if (kexalg == KeyExchangeAlgorithm.DHE_PSK) {
                    ServerDHE_PSKParameters pskParams = (ServerDHE_PSKParameters)skex.params();
                    ServerDHParams dhParams2 = pskParams.params();
                    GnuDHPublicKey serverKey = new GnuDHPublicKey(null, dhParams2.p(), dhParams2.g(), dhParams2.y());
                    DHParameterSpec params = new DHParameterSpec(dhParams2.p(), dhParams2.g());
                    this.keyExchange = new ClientDHGen(serverKey, params, false);
                    this.tasks.add(this.keyExchange);
                }
                this.state = State.READ_CERTIFICATE_REQUEST;
                break;
            }
            case READ_CERTIFICATE_REQUEST: {
                if (handshake.type() != Handshake.Type.CERTIFICATE_REQUEST) {
                    this.state = State.READ_SERVER_HELLO_DONE;
                    return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                }
                CertificateRequest req = (CertificateRequest)handshake.body();
                ClientCertificateTypeList types = req.types();
                LinkedList<String> typeList = new LinkedList<String>();
                for (CertificateRequest.ClientCertificateType t : types) {
                    typeList.add(t.name());
                }
                X500PrincipalList issuers = req.authorities();
                LinkedList<X500Principal> issuerList = new LinkedList<X500Principal>();
                for (X500Principal p : issuers) {
                    issuerList.add(p);
                }
                this.certLoader = new CertLoader(typeList, issuerList);
                this.tasks.add(this.certLoader);
                break;
            }
            case READ_SERVER_HELLO_DONE: {
                if (handshake.type() != Handshake.Type.SERVER_HELLO_DONE) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                this.state = State.WRITE_CERTIFICATE;
                break;
            }
            case READ_FINISHED: {
                if (handshake.type() != Handshake.Type.FINISHED) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                Finished serverFinished = (Finished)handshake.body();
                MessageDigest md5copy = null;
                MessageDigest shacopy = null;
                try {
                    md5copy = (MessageDigest)this.md5.clone();
                    shacopy = (MessageDigest)this.sha.clone();
                }
                catch (CloneNotSupportedException cnse) {
                    throw new SSLException(cnse);
                }
                Finished clientFinished = new Finished(this.generateFinished(md5copy, shacopy, false, this.engine.session()), this.engine.session().version);
                logger.logv(Component.SSL_HANDSHAKE, "clientFinished: {0}", clientFinished);
                if (this.engine.session().version == ProtocolVersion.SSL_3) {
                    if (!Arrays.equals(clientFinished.md5Hash(), serverFinished.md5Hash()) || !Arrays.equals(clientFinished.shaHash(), serverFinished.shaHash())) {
                        this.engine.session().invalidate();
                        throw new SSLException("session verify failed");
                    }
                } else if (!Arrays.equals(clientFinished.verifyData(), serverFinished.verifyData())) {
                    this.engine.session().invalidate();
                    throw new SSLException("session verify failed");
                }
                if (this.continuedSession) {
                    this.engine.changeCipherSpec();
                    this.state = State.WRITE_FINISHED;
                    break;
                }
                this.state = State.DONE;
                break;
            }
            default: {
                throw new IllegalStateException("invalid state: " + (Object)((Object)this.state));
            }
        }
        this.handshakeOffset += handshake.length() + 4;
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.state.isWriteState() || this.outBuffer != null && this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected SSLEngineResult.HandshakeStatus implHandleOutput(ByteBuffer fragment) throws SSLException {
        ClientHandshake.logger.logv(Component.SSL_HANDSHAKE, "output to {0}; state:{1}; outBuffer:{2}", new Object[]{fragment, this.state, this.outBuffer});
        if (this.outBuffer != null && this.outBuffer.hasRemaining()) {
            l = Math.min(fragment.remaining(), this.outBuffer.remaining());
            fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
            this.outBuffer.position(this.outBuffer.position() + l);
        }
        if (fragment.hasRemaining()) ** GOTO lbl197
        if (this.state.isWriteState() || this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
lbl-1000:
        // 1 sources

        {
            ClientHandshake.logger.logv(Component.SSL_HANDSHAKE, "loop state={0}", new Object[]{this.state});
            switch (ClientHandshake.$SWITCH_TABLE$gnu$javax$net$ssl$provider$ClientHandshake$State()[this.state.ordinal()]) {
                case 1: {
                    hello = new ClientHelloBuilder();
                    ctx = (AbstractSessionContext)this.engine.contextImpl.engineGetClientSessionContext();
                    this.continued = (SessionImpl)ctx.getSession(this.engine.getPeerHost(), this.engine.getPeerPort());
                    this.engine.session().setId(new Session.ID(new byte[0]));
                    sid = this.engine.session().id();
                    if (this.continued != null) {
                        sid = this.continued.id();
                    }
                    hello.setSessionId(sid.id());
                    this.sentVersion = this.chooseVersion();
                    hello.setVersion(this.sentVersion);
                    hello.setCipherSuites(this.getSuites());
                    hello.setCompressionMethods(this.getCompressionMethods());
                    r = hello.random();
                    r.setGmtUnixTime(Util.unixTime());
                    nonce = new byte[28];
                    this.engine.session().random().nextBytes(nonce);
                    r.setRandomBytes(nonce);
                    this.clientRandom = r.copy();
                    if (this.enableExtensions()) {
                        extensions = new LinkedList<Extension>();
                        fraglen = this.maxFragmentLength();
                        if (fraglen != null) {
                            extensions.add(new Extension(Extension.Type.MAX_FRAGMENT_LENGTH, fraglen));
                            this.maxFragmentLengthSent = fraglen;
                        }
                        if ((host = this.engine.getPeerHost()) != null) {
                            name = new ServerNameList.ServerName(ServerNameList.NameType.HOST_NAME, host);
                            names = new ServerNameList(Collections.singletonList(name));
                            extensions.add(new Extension(Extension.Type.SERVER_NAME, names));
                        }
                        if (this.truncatedHMac()) {
                            extensions.add(new Extension(Extension.Type.TRUNCATED_HMAC, new TruncatedHMAC()));
                            this.truncatedHMacSent = true;
                        }
                        elist = new ExtensionList(extensions);
                        hello.setExtensions(elist.buffer());
                    } else {
                        hello.setDisableExtensions(true);
                    }
                    ClientHandshake.logger.logv(Component.SSL_HANDSHAKE, "{0}", new Object[]{hello});
                    fragment.putInt(Handshake.Type.CLIENT_HELLO.getValue() << 24 | hello.length() & 0xFFFFFF);
                    this.outBuffer = hello.buffer();
                    l = Math.min(fragment.remaining(), this.outBuffer.remaining());
                    fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
                    this.outBuffer.position(this.outBuffer.position() + l);
                    this.state = State.READ_SERVER_HELLO;
                    break;
                }
                case 7: {
                    chain = this.engine.session().getLocalCertificates();
                    if (chain != null) {
                        cert = new CertificateBuilder(CertificateType.X509);
                        try {
                            cert.setCertificates(Arrays.asList(chain));
                        }
                        catch (CertificateException ce) {
                            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR), (Throwable)ce);
                        }
                        this.outBuffer = cert.buffer();
                        fragment.putInt(Handshake.Type.CERTIFICATE.getValue() << 24 | cert.length() & 0xFFFFFF);
                        l = Math.min(fragment.remaining(), this.outBuffer.remaining());
                        fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
                        this.outBuffer.position(this.outBuffer.position() + l);
                    }
                    this.state = State.WRITE_CLIENT_KEY_EXCHANGE;
                    break;
                }
                case 8: {
                    kea = this.engine.session().suite.keyExchangeAlgorithm();
                    ckex = new ClientKeyExchangeBuilder(this.engine.session().suite, this.engine.session().version);
                    if (kea == KeyExchangeAlgorithm.DHE_DSS || kea == KeyExchangeAlgorithm.DHE_RSA || kea == KeyExchangeAlgorithm.DH_anon || kea == KeyExchangeAlgorithm.DH_DSS || kea == KeyExchangeAlgorithm.DH_RSA) {
                        if (!ClientHandshake.$assertionsDisabled && this.dhPair == null) {
                            throw new AssertionError();
                        }
                        pubkey = (DHPublicKey)this.dhPair.getPublic();
                        pub = new ClientDiffieHellmanPublic(pubkey.getY());
                        ckex.setExchangeKeys(pub.buffer());
                    }
                    if (kea == KeyExchangeAlgorithm.RSA || kea == KeyExchangeAlgorithm.RSA_PSK) {
                        if (!ClientHandshake.$assertionsDisabled && !(this.keyExchange instanceof RSAGen)) {
                            throw new AssertionError();
                        }
                        if (!ClientHandshake.$assertionsDisabled && !this.keyExchange.hasRun()) {
                            throw new AssertionError();
                        }
                        if (this.keyExchange.thrown() != null) {
                            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE), this.keyExchange.thrown());
                        }
                        epms = new EncryptedPreMasterSecret(((RSAGen)this.keyExchange).encryptedSecret(), this.engine.session().version);
                        if (kea == KeyExchangeAlgorithm.RSA) {
                            ckex.setExchangeKeys(epms.buffer());
                        } else {
                            identity = this.getPSKIdentity();
                            if (identity == null) {
                                throw new SSLException("no pre-shared-key identity; set the security property \"jessie.client.psk.identity\"");
                            }
                            params = new ClientRSA_PSKParameters(identity, epms.buffer());
                            ckex.setExchangeKeys(params.buffer());
                            this.generatePSKSecret(identity, this.preMasterSecret, true);
                        }
                    }
                    if (kea == KeyExchangeAlgorithm.DHE_PSK) {
                        if (!ClientHandshake.$assertionsDisabled && !(this.keyExchange instanceof ClientDHGen)) {
                            throw new AssertionError();
                        }
                        if (!ClientHandshake.$assertionsDisabled && this.dhPair == null) {
                            throw new AssertionError();
                        }
                        identity = this.getPSKIdentity();
                        if (identity == null) {
                            throw new SSLException("no pre-shared key identity; set the security property \"jessie.client.psk.identity\"");
                        }
                        pubkey = (DHPublicKey)this.dhPair.getPublic();
                        params = new ClientDHE_PSKParameters(identity, new ClientDiffieHellmanPublic(pubkey.getY()));
                        ckex.setExchangeKeys(params.buffer());
                        this.generatePSKSecret(identity, this.preMasterSecret, true);
                    }
                    if (kea == KeyExchangeAlgorithm.PSK) {
                        identity = this.getPSKIdentity();
                        if (identity == null) {
                            throw new SSLException("no pre-shared key identity; set the security property \"jessie.client.psk.identity\"");
                        }
                        this.generatePSKSecret(identity, null, true);
                        params = new ClientPSKParameters(identity);
                        ckex.setExchangeKeys(params.buffer());
                    }
                    if (kea == KeyExchangeAlgorithm.NONE) {
                        inflater = null;
                        deflater = null;
                        if (this.compression == CompressionMethod.ZLIB) {
                            inflater = new Inflater();
                            deflater = new Deflater();
                        }
                        this.inParams = new InputSecurityParameters(null, null, inflater, this.engine.session(), this.engine.session().suite);
                        this.outParams = new OutputSecurityParameters(null, null, deflater, this.engine.session(), this.engine.session().suite);
                        this.engine.session().privateData.masterSecret = new byte[0];
                    }
                    ClientHandshake.logger.logv(Component.SSL_HANDSHAKE, "{0}", new Object[]{ckex});
                    this.outBuffer = ckex.buffer();
                    ClientHandshake.logger.logv(Component.SSL_HANDSHAKE, "client kex buffer {0}", new Object[]{this.outBuffer});
                    fragment.putInt(Handshake.Type.CLIENT_KEY_EXCHANGE.getValue() << 24 | ckex.length() & 0xFFFFFF);
                    l = Math.min(fragment.remaining(), this.outBuffer.remaining());
                    fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
                    this.outBuffer.position(this.outBuffer.position() + l);
                    if (this.privateKey != null) {
                        this.genCertVerify = new GenCertVerify(this.md5, this.sha);
                        this.tasks.add(this.genCertVerify);
                        this.state = State.WRITE_CERTIFICATE_VERIFY;
                        break block11;
                    }
                    this.engine.changeCipherSpec();
                    this.state = State.WRITE_FINISHED;
                    break block11;
                }
                case 9: {
                    if (!ClientHandshake.$assertionsDisabled && this.genCertVerify == null) {
                        throw new AssertionError();
                    }
                    if (!ClientHandshake.$assertionsDisabled && !this.genCertVerify.hasRun()) {
                        throw new AssertionError();
                    }
                    verify = new CertificateVerify(this.genCertVerify.signed(), this.engine.session().suite.signatureAlgorithm());
                    this.outBuffer = verify.buffer();
                    fragment.putInt(Handshake.Type.CERTIFICATE_VERIFY.getValue() << 24 | verify.length() & 0xFFFFFF);
                    l = Math.min(fragment.remaining(), this.outBuffer.remaining());
                    fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
                    this.outBuffer.position(this.outBuffer.position() + l);
                    this.engine.changeCipherSpec();
                    this.state = State.WRITE_FINISHED;
                    break block11;
                }
                case 10: {
                    md5copy = null;
                    shacopy = null;
                    try {
                        md5copy = (MessageDigest)this.md5.clone();
                        shacopy = (MessageDigest)this.sha.clone();
                    }
                    catch (CloneNotSupportedException cnse) {
                        throw new SSLException(cnse);
                    }
                    this.outBuffer = this.generateFinished(md5copy, shacopy, true, this.engine.session());
                    fragment.putInt(Handshake.Type.FINISHED.getValue() << 24 | this.outBuffer.remaining() & 0xFFFFFF);
                    l = Math.min(this.outBuffer.remaining(), fragment.remaining());
                    fragment.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + l));
                    this.outBuffer.position(this.outBuffer.position() + l);
                    if (this.continuedSession) {
                        this.state = State.DONE;
                        break;
                    }
                    this.state = State.READ_FINISHED;
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid state: " + (Object)this.state);
                }
            }
lbl197:
            // 5 sources

            ** while (fragment.remaining() >= 4 && this.state.isWriteState())
        }
lbl198:
        // 4 sources

        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.state.isWriteState() || this.outBuffer != null && this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    @Override
    SSLEngineResult.HandshakeStatus status() {
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.state.isWriteState()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    @Override
    void checkKeyExchange() throws SSLException {
    }

    @Override
    void handleV2Hello(ByteBuffer hello) throws SSLException {
        throw new SSLException("this should be impossible");
    }

    private ProtocolVersion chooseVersion() throws SSLException {
        ProtocolVersion version = null;
        String[] stringArray = this.engine.getEnabledProtocols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ver = stringArray[n2];
            try {
                ProtocolVersion v = ProtocolVersion.forName(ver);
                if (version == null || version.compareTo(v) < 0) {
                    version = v;
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        if (version == null) {
            throw new SSLException("no suitable enabled versions");
        }
        return version;
    }

    private List<CipherSuite> getSuites() throws SSLException {
        LinkedList<CipherSuite> suites = new LinkedList<CipherSuite>();
        String[] stringArray = this.engine.getEnabledCipherSuites();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            CipherSuite suite = CipherSuite.forName(s);
            if (suite != null) {
                suites.add(suite);
            }
            ++n2;
        }
        if (suites.isEmpty()) {
            throw new SSLException("no cipher suites enabled");
        }
        return suites;
    }

    private List<CompressionMethod> getCompressionMethods() {
        LinkedList<CompressionMethod> methods = new LinkedList<CompressionMethod>();
        GetSecurityPropertyAction gspa = new GetSecurityPropertyAction("jessie.enable.compression");
        if (Boolean.valueOf(AccessController.doPrivileged(gspa)).booleanValue()) {
            methods.add(CompressionMethod.ZLIB);
        }
        methods.add(CompressionMethod.NULL);
        return methods;
    }

    private boolean enableExtensions() {
        GetSecurityPropertyAction action = new GetSecurityPropertyAction("jessie.client.enable.extensions");
        return Boolean.valueOf(AccessController.doPrivileged(action));
    }

    private MaxFragmentLength maxFragmentLength() {
        GetSecurityPropertyAction action = new GetSecurityPropertyAction("jessie.client.maxFragmentLength");
        String s = AccessController.doPrivileged(action);
        if (s != null) {
            try {
                int len = Integer.parseInt(s);
                switch (len) {
                    case 9: 
                    case 512: {
                        return MaxFragmentLength.LEN_2_9;
                    }
                    case 10: 
                    case 1024: {
                        return MaxFragmentLength.LEN_2_10;
                    }
                    case 11: 
                    case 2048: {
                        return MaxFragmentLength.LEN_2_11;
                    }
                    case 12: 
                    case 4096: {
                        return MaxFragmentLength.LEN_2_12;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    private boolean truncatedHMac() {
        GetSecurityPropertyAction action = new GetSecurityPropertyAction("jessie.client.truncatedHMac");
        return Boolean.valueOf(AccessController.doPrivileged(action));
    }

    private String getPSKIdentity() {
        GetSecurityPropertyAction action = new GetSecurityPropertyAction("jessie.client.psk.identity");
        return AccessController.doPrivileged(action);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CertLoader
    extends DelegatedTask {
        private final List<String> keyTypes;
        private final List<X500Principal> issuers;

        CertLoader(List<String> keyTypes, List<X500Principal> issuers) {
            this.keyTypes = keyTypes;
            this.issuers = issuers;
        }

        @Override
        public void implRun() {
            X509ExtendedKeyManager km = ClientHandshake.this.engine.contextImpl.keyManager;
            if (km == null) {
                return;
            }
            ClientHandshake.this.keyAlias = km.chooseEngineClientAlias(this.keyTypes.toArray(new String[this.keyTypes.size()]), this.issuers.toArray(new X500Principal[this.issuers.size()]), ClientHandshake.this.engine);
            ClientHandshake.this.engine.session().setLocalCertificates(km.getCertificateChain(ClientHandshake.this.keyAlias));
            ClientHandshake.this.privateKey = km.getPrivateKey(ClientHandshake.this.keyAlias);
        }
    }

    class ClientDHGen
    extends DelegatedTask {
        private final DHPublicKey serverKey;
        private final DHParameterSpec params;
        private final boolean full;

        ClientDHGen(DHPublicKey serverKey, DHParameterSpec params, boolean full) {
            this.serverKey = serverKey;
            this.params = params;
            this.full = full;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void implRun() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, SSLException {
            logger.log(Component.SSL_DELEGATED_TASK, "running client DH phase");
            if (ClientHandshake.this.paramsVerifier != null) {
                ParamsVerifier paramsVerifier = ClientHandshake.this.paramsVerifier;
                synchronized (paramsVerifier) {
                    try {
                        while (!ClientHandshake.this.paramsVerifier.hasRun()) {
                            ClientHandshake.this.paramsVerifier.wait(500L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            KeyPairGenerator gen = KeyPairGenerator.getInstance("DH");
            gen.initialize(this.params, ClientHandshake.this.engine.session().random());
            ClientHandshake.this.dhPair = gen.generateKeyPair();
            logger.logv(Component.SSL_KEY_EXCHANGE, "client keys public:{0} private:{1}", ClientHandshake.this.dhPair.getPublic(), ClientHandshake.this.dhPair.getPrivate());
            ClientHandshake.this.initDiffieHellman((DHPrivateKey)ClientHandshake.this.dhPair.getPrivate(), ClientHandshake.this.engine.session().random());
            AbstractHandshake.DHPhase phase = new AbstractHandshake.DHPhase(this.serverKey, this.full);
            phase.run();
            if (phase.thrown() != null) {
                throw new SSLException(phase.thrown());
            }
        }

        DHPublicKey serverKey() {
            return this.serverKey;
        }
    }

    class GenCertVerify
    extends DelegatedTask {
        private final MessageDigest md5;
        private final MessageDigest sha;
        private byte[] signed;

        GenCertVerify(MessageDigest md5, MessageDigest sha) {
            try {
                this.md5 = (MessageDigest)md5.clone();
                this.sha = (MessageDigest)sha.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new Error(cnse);
            }
        }

        public void implRun() throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            byte[] toSign = ClientHandshake.this.engine.session().version == ProtocolVersion.SSL_3 ? ClientHandshake.this.genV3CertificateVerify(this.md5, this.sha, ClientHandshake.this.engine.session()) : (ClientHandshake.this.engine.session().suite.signatureAlgorithm() == SignatureAlgorithm.RSA ? Util.concat(this.md5.digest(), this.sha.digest()) : this.sha.digest());
            Signature sig = Signature.getInstance(ClientHandshake.this.engine.session().suite.signatureAlgorithm().name());
            sig.initSign(ClientHandshake.this.privateKey);
            sig.update(toSign);
            this.signed = sig.sign();
        }

        byte[] signed() {
            return this.signed;
        }
    }

    class ParamsVerifier
    extends DelegatedTask {
        private final ByteBuffer paramsBuffer;
        private final byte[] signature;
        private boolean verified;

        ParamsVerifier(ByteBuffer paramsBuffer, byte[] signature) {
            this.paramsBuffer = paramsBuffer;
            this.signature = signature;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void implRun() throws InvalidKeyException, NoSuchAlgorithmException, SSLPeerUnverifiedException, SignatureException {
            Signature s = Signature.getInstance(ClientHandshake.this.engine.session().suite.signatureAlgorithm().algorithm());
            s.initVerify(ClientHandshake.this.engine.session().getPeerCertificates()[0]);
            s.update(this.paramsBuffer);
            this.verified = s.verify(this.signature);
            ParamsVerifier paramsVerifier = this;
            synchronized (paramsVerifier) {
                this.notifyAll();
            }
        }

        boolean verified() {
            return this.verified;
        }
    }

    class RSAGen
    extends DelegatedTask {
        private byte[] encryptedPreMasterSecret;
        private final boolean full;

        RSAGen() {
            this(true);
        }

        RSAGen(boolean full) {
            this.full = full;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void implRun() throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, SSLException {
            boolean[] keyUsage;
            if (ClientHandshake.this.certVerifier != null) {
                AbstractHandshake.CertVerifier certVerifier = ClientHandshake.this.certVerifier;
                synchronized (certVerifier) {
                    try {
                        while (!ClientHandshake.this.certVerifier.hasRun()) {
                            ClientHandshake.this.certVerifier.wait(500L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ClientHandshake.this.preMasterSecret = new byte[48];
            ClientHandshake.this.engine.session().random().nextBytes(ClientHandshake.this.preMasterSecret);
            ClientHandshake.this.preMasterSecret[0] = (byte)ClientHandshake.this.sentVersion.major();
            ClientHandshake.this.preMasterSecret[1] = (byte)ClientHandshake.this.sentVersion.minor();
            Cipher rsa = Cipher.getInstance("RSA");
            java.security.cert.Certificate cert = ClientHandshake.this.engine.session().getPeerCertificates()[0];
            if (cert instanceof X509Certificate && (keyUsage = ((X509Certificate)cert).getKeyUsage()) != null && !keyUsage[2]) {
                throw new InvalidKeyException("certificate's keyUsage does not permit keyEncipherment");
            }
            rsa.init(1, cert.getPublicKey());
            this.encryptedPreMasterSecret = rsa.doFinal(ClientHandshake.this.preMasterSecret);
            if (this.full) {
                ClientHandshake.this.generateMasterSecret(ClientHandshake.this.clientRandom, ClientHandshake.this.serverRandom, ClientHandshake.this.engine.session());
                byte[][] keys = ClientHandshake.this.generateKeys(ClientHandshake.this.clientRandom, ClientHandshake.this.serverRandom, ClientHandshake.this.engine.session());
                ClientHandshake.this.setupSecurityParameters(keys, true, ClientHandshake.this.engine, ClientHandshake.this.compression);
            }
        }

        byte[] encryptedSecret() {
            return this.encryptedPreMasterSecret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        WRITE_CLIENT_HELLO(false, true),
        READ_SERVER_HELLO(true, false),
        READ_CERTIFICATE(true, false),
        READ_SERVER_KEY_EXCHANGE(true, false),
        READ_CERTIFICATE_REQUEST(true, false),
        READ_SERVER_HELLO_DONE(true, false),
        WRITE_CERTIFICATE(false, true),
        WRITE_CLIENT_KEY_EXCHANGE(false, true),
        WRITE_CERTIFICATE_VERIFY(false, true),
        WRITE_FINISHED(false, true),
        READ_FINISHED(true, false),
        DONE(false, false);

        private final boolean isWriteState;
        private final boolean isReadState;

        private State(boolean isReadState, boolean isWriteState) {
            this.isReadState = isReadState;
            this.isWriteState = isWriteState;
        }

        boolean isReadState() {
            return this.isReadState;
        }

        boolean isWriteState() {
            return this.isWriteState;
        }
    }
}

