/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboBoxUI
extends ComboBoxUI {
    protected JButton arrowButton;
    protected JComboBox comboBox;
    protected Component editor;
    protected FocusListener focusListener;
    protected boolean hasFocus;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    protected JList listBox;
    protected ListDataListener listDataListener;
    protected ComboPopup popup;
    protected KeyListener popupKeyListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    Dimension displaySize = new Dimension();
    protected CellRendererPane currentValuePane = new CellRendererPane();
    protected Dimension cachedMinimumSize = new Dimension();
    protected boolean isMinimumSizeDirty = true;
    private static final ListCellRenderer DEFAULT_RENDERER = new DefaultListCellRenderer();

    public static ComponentUI createUI(JComponent c) {
        return new BasicComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JComboBox) {
            ComboBoxEditor currentEditor;
            this.isMinimumSizeDirty = true;
            this.comboBox = (JComboBox)c;
            this.installDefaults();
            this.popup = this.createPopup();
            this.listBox = this.popup.getList();
            ListCellRenderer renderer = this.comboBox.getRenderer();
            if (renderer == null || renderer instanceof UIResource) {
                this.comboBox.setRenderer(this.createRenderer());
            }
            if ((currentEditor = this.comboBox.getEditor()) == null || currentEditor instanceof UIResource) {
                currentEditor = this.createEditor();
                this.comboBox.setEditor(currentEditor);
            }
            this.installComponents();
            this.installListeners();
            this.comboBox.setLayout(this.createLayoutManager());
            this.comboBox.setFocusable(true);
            this.installKeyboardActions();
            this.comboBox.putClientProperty("noCancelPopup", Boolean.TRUE);
        }
    }

    public void uninstallUI(JComponent c) {
        this.setPopupVisible(this.comboBox, false);
        this.popup.uninstallingUI();
        this.uninstallKeyboardActions();
        this.comboBox.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.comboBox = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.installBorder(this.comboBox, "ComboBox.border");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.focusListener = this.createFocusListener();
        this.comboBox.addFocusListener(this.focusListener);
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.keyListener = this.createKeyListener();
        this.comboBox.addKeyListener(this.keyListener);
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
        this.popupMouseListener = this.popup.getMouseListener();
        this.comboBox.addMouseListener(this.popupMouseListener);
        this.popupMouseMotionListener = this.popup.getMouseMotionListener();
        this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        this.popupKeyListener = this.popup.getKeyListener();
        this.comboBox.addKeyListener(this.popupKeyListener);
    }

    protected void uninstallDefaults() {
        if (this.comboBox.getFont() instanceof UIResource) {
            this.comboBox.setFont(null);
        }
        if (this.comboBox.getForeground() instanceof UIResource) {
            this.comboBox.setForeground(null);
        }
        if (this.comboBox.getBackground() instanceof UIResource) {
            this.comboBox.setBackground(null);
        }
        LookAndFeel.uninstallBorder(this.comboBox);
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.comboBox.removeFocusListener(this.focusListener);
        this.listBox.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.comboBox.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.comboBox.removeKeyListener(this.keyListener);
        this.keyListener = null;
        this.comboBox.getModel().removeListDataListener(this.listDataListener);
        this.listDataListener = null;
        if (this.popupMouseListener != null) {
            this.comboBox.removeMouseListener(this.popupMouseListener);
        }
        this.popupMouseListener = null;
        if (this.popupMouseMotionListener != null) {
            this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        }
        this.popupMouseMotionListener = null;
        if (this.popupKeyListener != null) {
            this.comboBox.removeKeyListener(this.popupKeyListener);
        }
        this.popupKeyListener = null;
    }

    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected ItemListener createItemListener() {
        return new ItemHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource();
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource();
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        this.comboBox.add(this.arrowButton);
        if (this.arrowButton != null) {
            this.configureArrowButton();
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void uninstallComponents() {
        if (this.arrowButton != null) {
            this.unconfigureArrowButton();
        }
        if (this.editor != null) {
            this.unconfigureEditor();
        }
        this.comboBox.removeAll();
        this.arrowButton = null;
    }

    public void addEditor() {
        this.removeEditor();
        this.editor = this.comboBox.getEditor().getEditorComponent();
        if (this.editor != null) {
            this.configureEditor();
            this.comboBox.add(this.editor);
        }
    }

    public void removeEditor() {
        if (this.editor != null) {
            this.unconfigureEditor();
            this.comboBox.remove(this.editor);
        }
    }

    protected void configureEditor() {
        this.editor.setFont(this.comboBox.getFont());
        if (this.popupKeyListener != null) {
            this.editor.addKeyListener(this.popupKeyListener);
        }
        if (this.keyListener != null) {
            this.editor.addKeyListener(this.keyListener);
        }
        this.comboBox.configureEditor(this.comboBox.getEditor(), this.comboBox.getSelectedItem());
    }

    protected void unconfigureEditor() {
        if (this.popupKeyListener != null) {
            this.editor.removeKeyListener(this.popupKeyListener);
        }
        if (this.keyListener != null) {
            this.editor.removeKeyListener(this.keyListener);
        }
    }

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setEnabled(this.comboBox.isEnabled());
            this.arrowButton.setFocusable(false);
            this.arrowButton.addMouseListener(this.popup.getMouseListener());
            this.arrowButton.addMouseMotionListener(this.popup.getMouseMotionListener());
            this.arrowButton.putClientProperty("noCancelPopup", Boolean.TRUE);
        }
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            if (this.popupMouseListener != null) {
                this.arrowButton.removeMouseListener(this.popupMouseListener);
            }
            if (this.popupMouseMotionListener != null) {
                this.arrowButton.removeMouseMotionListener(this.popupMouseMotionListener);
            }
        }
    }

    protected JButton createArrowButton() {
        return new BasicArrowButton(5);
    }

    public boolean isPopupVisible(JComboBox c) {
        return this.popup.isVisible();
    }

    public void setPopupVisible(JComboBox c, boolean v) {
        if (v) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    public boolean isFocusTraversable(JComboBox c) {
        return !this.comboBox.isEditable();
    }

    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rect = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(g, rect, this.hasFocus);
            this.paintCurrentValue(g, rect, this.hasFocus);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (this.isMinimumSizeDirty) {
            Insets i = this.getInsets();
            Dimension d = this.getDisplaySize();
            d.width += i.left + i.right + d.height;
            this.cachedMinimumSize = new Dimension(d.width, d.height + i.top + i.bottom);
            this.isMinimumSizeDirty = false;
        }
        return new Dimension(this.cachedMinimumSize);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public int getAccessibleChildrenCount(JComponent c) {
        int count = 1;
        if (this.comboBox.isEditable()) {
            count = 2;
        }
        return count;
    }

    public Accessible getAccessibleChild(JComponent c, int i) {
        Accessible child = null;
        switch (i) {
            case 0: {
                if (!(this.popup instanceof Accessible)) break;
                AccessibleContext ctx = ((Accessible)((Object)this.popup)).getAccessibleContext();
                ctx.setAccessibleParent(this.comboBox);
                child = (Accessible)((Object)this.popup);
                break;
            }
            case 1: {
                if (!this.comboBox.isEditable() || !(this.editor instanceof Accessible)) break;
                AccessibleContext ctx = ((Accessible)((Object)this.editor)).getAccessibleContext();
                ctx.setAccessibleParent(this.comboBox);
                child = (Accessible)((Object)this.editor);
            }
        }
        return child;
    }

    protected boolean isNavigationKey(int keyCode) {
        return keyCode == 38 || keyCode == 40 || keyCode == 37 || keyCode == 39 || keyCode == 10 || keyCode == 27 || keyCode == 9;
    }

    protected void selectNextPossibleValue() {
        int index = this.comboBox.getSelectedIndex();
        if (index != this.comboBox.getItemCount() - 1) {
            this.comboBox.setSelectedIndex(index + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        int index = this.comboBox.getSelectedIndex();
        if (index > 0) {
            this.comboBox.setSelectedIndex(index - 1);
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible(this.comboBox, !this.isPopupVisible(this.comboBox));
    }

    protected Rectangle rectangleForCurrentValue() {
        int w = this.comboBox.getWidth();
        int h = this.comboBox.getHeight();
        Insets i = this.comboBox.getInsets();
        int arrowSize = h - (i.top + i.bottom);
        if (this.arrowButton != null) {
            arrowSize = this.arrowButton.getWidth();
        }
        return new Rectangle(i.left, i.top, w - (i.left + i.right + arrowSize), h - (i.top + i.left));
    }

    protected Insets getInsets() {
        return this.comboBox.getInsets();
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        ListCellRenderer renderer = this.comboBox.getRenderer();
        if (this.comboBox.getSelectedIndex() != -1) {
            Component comp;
            if (hasFocus && !this.isPopupVisible(this.comboBox)) {
                comp = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
            } else {
                comp = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
                Color bg = UIManager.getColor("ComboBox.disabledForeground");
                comp.setBackground(bg);
            }
            comp.setFont(this.comboBox.getFont());
            if (hasFocus && !this.isPopupVisible(this.comboBox)) {
                comp.setForeground(this.listBox.getSelectionForeground());
                comp.setBackground(this.listBox.getSelectionBackground());
            } else if (this.comboBox.isEnabled()) {
                comp.setForeground(this.comboBox.getForeground());
                comp.setBackground(this.comboBox.getBackground());
            } else {
                Color fg = UIManager.getColor("ComboBox.disabledForeground");
                comp.setForeground(fg);
                Color bg = UIManager.getColor("ComboBox.disabledBackground");
                comp.setBackground(bg);
            }
            this.currentValuePane.paintComponent(g, comp, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        Color saved = g.getColor();
        if (this.comboBox.isEnabled()) {
            g.setColor(UIManager.getColor("UIManager.background"));
        } else {
            g.setColor(UIManager.getColor("UIManager.disabledBackground"));
        }
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.setColor(saved);
    }

    protected Dimension getDefaultSize() {
        Component comp = DEFAULT_RENDERER.getListCellRendererComponent(this.listBox, " ", -1, false, false);
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    protected Dimension getDisplaySize() {
        Object prototype;
        Dimension dim = new Dimension();
        ListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = DEFAULT_RENDERER;
        }
        if ((prototype = this.comboBox.getPrototypeDisplayValue()) != null) {
            Component comp = renderer.getListCellRendererComponent(this.listBox, prototype, -1, false, false);
            this.currentValuePane.add(comp);
            comp.setFont(this.comboBox.getFont());
            Dimension renderSize = comp.getPreferredSize();
            this.currentValuePane.remove(comp);
            dim.height = renderSize.height;
            dim.width = renderSize.width;
        } else {
            ComboBoxModel model = this.comboBox.getModel();
            int size = model.getSize();
            if (size > 0) {
                int i = 0;
                while (i < size) {
                    Component comp = renderer.getListCellRendererComponent(this.listBox, model.getElementAt(i), -1, false, false);
                    this.currentValuePane.add(comp);
                    comp.setFont(this.comboBox.getFont());
                    Dimension renderSize = comp.getPreferredSize();
                    this.currentValuePane.remove(comp);
                    dim.width = Math.max(dim.width, renderSize.width);
                    dim.height = Math.max(dim.height, renderSize.height);
                    ++i;
                }
            } else {
                dim = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    dim.width = 100;
                }
            }
        }
        if (this.comboBox.isEditable()) {
            Dimension editSize = this.editor.getPreferredSize();
            dim.width = Math.max(dim.width, editSize.width);
            dim.height = Math.max(dim.height, editSize.height);
        }
        this.displaySize.setSize(dim.width, dim.height);
        return dim;
    }

    protected void installKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, (InputMap)UIManager.get("ComboBox.ancestorInputMap"));
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, null);
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            Insets i = BasicComboBoxUI.this.getInsets();
            int arrowSize = BasicComboBoxUI.this.comboBox.getHeight() - (i.top + i.bottom);
            if (BasicComboBoxUI.this.arrowButton != null) {
                BasicComboBoxUI.this.arrowButton.setBounds(BasicComboBoxUI.this.comboBox.getWidth() - (i.right + arrowSize), i.top, arrowSize, arrowSize);
            }
            if (BasicComboBoxUI.this.editor != null) {
                BasicComboBoxUI.this.editor.setBounds(BasicComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            BasicComboBoxUI.this.hasFocus = true;
            BasicComboBoxUI.this.comboBox.repaint();
        }

        public void focusLost(FocusEvent e) {
            BasicComboBoxUI.this.hasFocus = false;
            if (!e.isTemporary() && BasicComboBoxUI.this.comboBox.isLightWeightPopupEnabled()) {
                BasicComboBoxUI.this.setPopupVisible(BasicComboBoxUI.this.comboBox, false);
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }
    }

    public class ItemHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            ComboBoxModel model = BasicComboBoxUI.this.comboBox.getModel();
            Object v = model.getSelectedItem();
            if (BasicComboBoxUI.this.editor != null) {
                BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), v);
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (BasicComboBoxUI.this.comboBox.getModel().getSize() != 0 && BasicComboBoxUI.this.comboBox.isEnabled()) {
                if (!BasicComboBoxUI.this.isNavigationKey(e.getKeyCode())) {
                    if (!BasicComboBoxUI.this.comboBox.isEditable() && BasicComboBoxUI.this.comboBox.selectWithKeyChar(e.getKeyChar())) {
                        e.consume();
                    }
                } else if (e.getKeyCode() == 38 && BasicComboBoxUI.this.comboBox.isPopupVisible()) {
                    BasicComboBoxUI.this.selectPreviousPossibleValue();
                } else if (e.getKeyCode() == 40) {
                    if (BasicComboBoxUI.this.comboBox.isPopupVisible()) {
                        BasicComboBoxUI.this.selectNextPossibleValue();
                    } else {
                        BasicComboBoxUI.this.comboBox.showPopup();
                    }
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                    BasicComboBoxUI.this.popup.hide();
                }
            }
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() != -1 || e.getIndex1() != -1) {
                BasicComboBoxUI.this.isMinimumSizeDirty = true;
                BasicComboBoxUI.this.comboBox.revalidate();
            }
            if (BasicComboBoxUI.this.editor != null) {
                BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), BasicComboBoxUI.this.comboBox.getSelectedItem());
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }

        public void intervalAdded(ListDataEvent e) {
            int start = e.getIndex0();
            int end = e.getIndex1();
            if (start == 0 && BasicComboBoxUI.this.comboBox.getItemCount() - (end - start + 1) == 0) {
                this.contentsChanged(e);
            } else if (start != -1 || end != -1) {
                ListCellRenderer renderer = BasicComboBoxUI.this.comboBox.getRenderer();
                ComboBoxModel model = BasicComboBoxUI.this.comboBox.getModel();
                int w = BasicComboBoxUI.this.displaySize.width;
                int h = BasicComboBoxUI.this.displaySize.height;
                int i = start;
                while (i <= end) {
                    Component comp = renderer.getListCellRendererComponent(BasicComboBoxUI.this.listBox, model.getElementAt(i), -1, false, false);
                    BasicComboBoxUI.this.currentValuePane.add(comp);
                    comp.setFont(BasicComboBoxUI.this.comboBox.getFont());
                    Dimension dim = comp.getPreferredSize();
                    w = Math.max(w, dim.width);
                    h = Math.max(h, dim.height);
                    BasicComboBoxUI.this.currentValuePane.remove(comp);
                    ++i;
                }
                if (BasicComboBoxUI.this.displaySize.width < w || BasicComboBoxUI.this.displaySize.height < h) {
                    if (BasicComboBoxUI.this.displaySize.width < w) {
                        BasicComboBoxUI.this.displaySize.width = w;
                    }
                    if (BasicComboBoxUI.this.displaySize.height < h) {
                        BasicComboBoxUI.this.displaySize.height = h;
                    }
                    BasicComboBoxUI.this.comboBox.revalidate();
                    if (BasicComboBoxUI.this.editor != null) {
                        BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), BasicComboBoxUI.this.comboBox.getSelectedItem());
                    }
                }
            }
        }

        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            if (propName.equals("enabled")) {
                boolean enabled = BasicComboBoxUI.this.comboBox.isEnabled();
                if (BasicComboBoxUI.this.editor != null) {
                    BasicComboBoxUI.this.editor.setEnabled(enabled);
                }
                if (BasicComboBoxUI.this.arrowButton != null) {
                    BasicComboBoxUI.this.arrowButton.setEnabled(enabled);
                }
                BasicComboBoxUI.this.comboBox.repaint();
            } else if (propName.equals("editor") && BasicComboBoxUI.this.comboBox.isEditable()) {
                BasicComboBoxUI.this.addEditor();
                BasicComboBoxUI.this.comboBox.revalidate();
            } else if (e.getPropertyName().equals("editable")) {
                if (BasicComboBoxUI.this.comboBox.isEditable()) {
                    BasicComboBoxUI.this.addEditor();
                } else {
                    BasicComboBoxUI.this.removeEditor();
                }
                BasicComboBoxUI.this.comboBox.revalidate();
            } else if (propName.equals("model")) {
                ComboBoxModel newModel;
                ComboBoxModel oldModel = (ComboBoxModel)e.getOldValue();
                if (oldModel != null && BasicComboBoxUI.this.listDataListener != null) {
                    oldModel.removeListDataListener(BasicComboBoxUI.this.listDataListener);
                }
                if ((newModel = (ComboBoxModel)e.getNewValue()) != null && BasicComboBoxUI.this.listDataListener != null) {
                    BasicComboBoxUI.this.comboBox.getModel().addListDataListener(BasicComboBoxUI.this.listDataListener);
                }
                if (BasicComboBoxUI.this.editor != null) {
                    BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), BasicComboBoxUI.this.comboBox.getSelectedItem());
                }
                BasicComboBoxUI.this.isMinimumSizeDirty = true;
                BasicComboBoxUI.this.comboBox.revalidate();
                BasicComboBoxUI.this.comboBox.repaint();
            } else if (propName.equals("font")) {
                Font font = (Font)e.getNewValue();
                if (BasicComboBoxUI.this.editor != null) {
                    BasicComboBoxUI.this.editor.setFont(font);
                }
                BasicComboBoxUI.this.listBox.setFont(font);
                BasicComboBoxUI.this.isMinimumSizeDirty = true;
                BasicComboBoxUI.this.comboBox.revalidate();
            } else if (propName.equals("prototypeDisplayValue")) {
                BasicComboBoxUI.this.isMinimumSizeDirty = true;
                BasicComboBoxUI.this.comboBox.revalidate();
            } else if (propName.equals("renderer")) {
                BasicComboBoxUI.this.isMinimumSizeDirty = true;
                BasicComboBoxUI.this.comboBox.revalidate();
            }
        }
    }
}

