/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxIcon;

public class MetalComboBoxUI
extends BasicComboBoxUI {
    public static ComponentUI createUI(JComponent component) {
        return new MetalComboBoxUI();
    }

    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return super.createPopup();
    }

    protected JButton createArrowButton() {
        MetalComboBoxButton button = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), this.currentValuePane, this.listBox);
        button.setMargin(new Insets(0, 1, 1, 3));
        return button;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    public void paint(Graphics g, JComponent c) {
    }

    protected void editablePropertyChanged(PropertyChangeEvent e) {
        if (this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton b = (MetalComboBoxButton)this.arrowButton;
            b.setIconOnly(this.comboBox.isEditable());
            b.setFocusable(!this.comboBox.isEditable() && this.comboBox.isEnabled());
            this.comboBox.repaint();
        }
    }

    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    protected void removeListeners() {
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton b = (MetalComboBoxButton)this.arrowButton;
            d = this.getDisplaySize();
            Insets arrowInsets = b.getInsets();
            Insets comboInsets = this.comboBox.getInsets();
            Icon icon = b.getComboIcon();
            d.width += comboInsets.left + comboInsets.right;
            d.width += arrowInsets.left + arrowInsets.right;
            d.width += arrowInsets.right + icon.getIconWidth();
            d.height += comboInsets.top + comboInsets.bottom;
            d.height += arrowInsets.top + arrowInsets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            d = super.getMinimumSize(c);
            Insets arrowMargin = this.arrowButton.getMargin();
            d.height += arrowMargin.top + arrowMargin.bottom;
            d.width += arrowMargin.left + arrowMargin.right;
        } else {
            d = super.getMinimumSize(c);
        }
        this.cachedMinimumSize.setSize(d.width, d.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public void configureEditor() {
        super.configureEditor();
        if (this.popupKeyListener != null) {
            this.editor.removeKeyListener(this.popupKeyListener);
        }
        if (this.focusListener != null) {
            this.editor.addFocusListener(this.focusListener);
        }
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.focusListener != null) {
            this.editor.removeFocusListener(this.focusListener);
        }
    }

    public void layoutComboBox(Container parent, MetalComboBoxLayoutManager manager) {
        if (this.comboBox.isEditable()) {
            manager.superLayout(parent);
        } else if (this.arrowButton != null) {
            Insets comboInsets = this.comboBox.getInsets();
            int width = this.comboBox.getWidth();
            int height = this.comboBox.getHeight();
            this.arrowButton.setBounds(comboInsets.left, comboInsets.top, width - (comboInsets.left + comboInsets.right), height - (comboInsets.top + comboInsets.bottom));
        }
    }

    public class MetalComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public MetalComboBoxLayoutManager() {
            super(MetalComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            MetalComboBoxUI.this.layoutComboBox(parent, this);
        }

        public void superLayout(Container parent) {
            super.layoutContainer(parent);
        }
    }

    public class MetalComboPopup
    extends BasicComboPopup {
        public MetalComboPopup(JComboBox cBox) {
            super(cBox);
        }

        public void delegateFocus(MouseEvent e) {
            super.delegateFocus(e);
        }
    }

    public class MetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public MetalPropertyChangeListener() {
            super(MetalComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String name = e.getPropertyName();
            if (name.equals("editable")) {
                MetalComboBoxUI.this.editablePropertyChanged(e);
            } else if (name.equals("enabled")) {
                if (MetalComboBoxUI.this.arrowButton instanceof MetalComboBoxButton) {
                    MetalComboBoxUI.this.arrowButton.setFocusable(!MetalComboBoxUI.this.comboBox.isEditable() && MetalComboBoxUI.this.comboBox.isEnabled());
                    MetalComboBoxUI.this.comboBox.repaint();
                }
            } else if (name.equals("background")) {
                Color c = (Color)e.getNewValue();
                MetalComboBoxUI.this.arrowButton.setBackground(c);
                MetalComboBoxUI.this.listBox.setBackground(c);
            } else if (name.equals("foreground")) {
                Color c = (Color)e.getNewValue();
                MetalComboBoxUI.this.arrowButton.setForeground(c);
                MetalComboBoxUI.this.listBox.setForeground(c);
            }
        }
    }
}

