#!/bin/sh
echo 'name: HTTP
version: 4000.1.2
id: HTTP-4000.1.2-8d671d555f11f8c1ba7fcb19c2159447

license: BSD3
copyright: Copyright (c) 2002, Warrick Gray
           Copyright (c) 2002-2005, Ian Lynagh
           Copyright (c) 2003-2006, Bjorn Bringert
           Copyright (c) 2004, Andre Furtado
           Copyright (c) 2004, Ganesh Sittampalam
           Copyright (c) 2004-2005, Dominic Steinitz
           Copyright 2007 Robin Bate Boerop
           Copyright 2008- Sigbjorn Finne
maintainer: Ganesh Sittampalam <ganesh@earth.li>
stability:
homepage: http://projects.haskell.org/http/
package-url:
description: The HTTP package supports client-side web programming in Haskell. It lets you set up
             HTTP connections, transmitting requests and processing the responses coming back, all
             from within the comforts of Haskell. It'\''s dependent on the network package to operate,
             but other than that, the implementation is all written in Haskell.
             .
             A basic API for issuing single HTTP requests + receiving responses is provided. On top
             of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
             it taking care of handling the management of persistent connections, proxies,
             state (cookies) and authentication credentials required to handle multi-step
             interactions with a web server.
             .
             The representation of the bytes flowing across is extensible via the use of a type class,
             letting you pick the representation of requests and responses that best fits your use.
             Some pre-packaged, common instances are provided for you (@ByteString@, @String@.)
             .
             Here'\''s an example use:
             .
             >
             >    do
             >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
             >              -- fetch document and return it (as a '\''String'\''.)
             >      fmap (take 100) (getResponseBody rsp)
             >
             >    do
             >      rsp <- Network.Browser.browse $ do
             >               setAllowRedirects True -- handle HTTP redirects
             >               request $ getRequest "http://google.com/"
             >      fmap (take 100) (getResponseBody rsp)
             >
             .
             Git repository available at <git://github.com/haskell/HTTP.git>
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
pkgpath: net/hs-HTTP
exposed: True
exposed-modules: Network.BufferType Network.Stream
                 Network.StreamDebugger Network.StreamSocket Network.TCP
                 Network.HTTP Network.HTTP.Headers Network.HTTP.Base
                 Network.HTTP.Stream Network.HTTP.Auth Network.HTTP.Cookie
                 Network.HTTP.Proxy Network.HTTP.HandleStream Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5
                Network.HTTP.MD5Aux Network.HTTP.Utils
import-dirs: /usr/local/lib/ghc/HTTP-4000.1.2
library-dirs: /usr/local/lib/ghc/HTTP-4000.1.2
hs-libraries: HSHTTP-4000.1.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.2-f538acad67d0b6696484da310d5949cf
         base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         bytestring-0.9.1.10-4e62762ee9b2a5d0cc5bc2fbaaeefd53
         mtl-2.0.1.0-3e464329054b7660133198d73c31aca5
         network-2.3.0.5-8b6868c0e6dbf6adced217440d46f03d
         old-time-1.0.0.6-249d424df19da9487f0cb7da3ccb0868
         parsec-3.1.1-bf92fff0e29c344f3b78cfddb556a5b9
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-HTTP-4000.1.2/html/HTTP.haddock
haddock-html: /usr/local/share/doc/hs-HTTP-4000.1.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
