#!/bin/sh
echo 'name: ListLike
version: 1.0.1
id: ListLike-1.0.1-b010b5418f8dec91ea5529e5d8204919

license: LGPL
copyright: Copyright (c) 2007-2008 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://software.complete.org/listlike
package-url:
description: Generic support for list-like structures in Haskell.
             .
             The ListLike module provides a common interface to the various Haskell
             types that are list-like.  Predefined interfaces include standard
             Haskell lists, Arrays, ByteStrings, and lazy ByteStrings.  Custom
             types can easily be made ListLike instances as well.
             .
             ListLike also provides for String-like types, such as String and
             ByteString, for types that support input and output, and for types that can handle
             infinite lists.
category: Generics
author: John Goerzen
pkgpath: devel/hs-ListLike
exposed: True
exposed-modules: Data.ListLike Data.ListLike.Base
                 Data.ListLike.FoldableLL Data.ListLike.IO Data.ListLike.Instances
                 Data.ListLike.String Data.ListLike.Utils
hidden-modules:
import-dirs: /usr/local/lib/ghc/ListLike-1.0.1
library-dirs: /usr/local/lib/ghc/ListLike-1.0.1
hs-libraries: HSListLike-1.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.2-f538acad67d0b6696484da310d5949cf
         base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         bytestring-0.9.1.10-4e62762ee9b2a5d0cc5bc2fbaaeefd53
         containers-0.4.0.0-f1307d32d8f4b51a1487c01f0997b6d9
         haskell98-1.1.0.1-3ce559675b118e85a39def472ca9857c
         mtl-2.0.1.0-3e464329054b7660133198d73c31aca5
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-ListLike-1.0.1/html/ListLike.haddock
haddock-html: /usr/local/share/doc/hs-ListLike-1.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
