#!/bin/sh
echo 'name: cmdargs
version: 0.7
id: cmdargs-0.7-bf89e827219e4db12b31282fe56b21f0

license: BSD3
copyright: Neil Mitchell 2009-2011
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability: Beta
homepage: http://community.haskell.org/~ndm/cmdargs/
package-url:
description: This library provides an easy way to define command line parsers. Most users
             will want to use the "System.Console.CmdArgs.Implicit" module, whose
             documentation contains an example.
             .
             * "System.Console.CmdArgs.Explicit" provides a way to write command line
             parsers for both single mode programs (most programs) and multiple
             mode programs (e.g. darcs or cabal). Parsers are defined by constructing
             a data structure.
             .
             * "System.Console.CmdArgs.Implicit" provides a way to concisely define
             command line parsers, up to three times shorter than getopt. These parsers
             are translated into the Explicit data type.
             .
             * "System.Console.CmdArgs.GetOpt" provides a wrapper allowing compatiblity
             with existing getopt parsers, mapping to the Explicit data type.
             .
             For a general reference on what command line flags are commonly used,
             see <http://www.faqs.org/docs/artu/ch10s05.html>.
category: Console
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: devel/hs-cmdargs
exposed: True
exposed-modules: System.Console.CmdArgs
                 System.Console.CmdArgs.Annotate System.Console.CmdArgs.Default
                 System.Console.CmdArgs.Explicit System.Console.CmdArgs.GetOpt
                 System.Console.CmdArgs.Implicit System.Console.CmdArgs.Text
                 System.Console.CmdArgs.Verbosity
hidden-modules: Data.Generics.Any Data.Generics.Any.Prelude
                System.Console.CmdArgs.Explicit.Help
                System.Console.CmdArgs.Explicit.Process
                System.Console.CmdArgs.Explicit.Type
                System.Console.CmdArgs.Implicit.Ann
                System.Console.CmdArgs.Implicit.Global
                System.Console.CmdArgs.Implicit.Local
                System.Console.CmdArgs.Implicit.Reader
                System.Console.CmdArgs.Implicit.Reform
                System.Console.CmdArgs.Implicit.Type
                System.Console.CmdArgs.Implicit.UI
import-dirs: /usr/local/lib/ghc/cmdargs-0.7
library-dirs: /usr/local/lib/ghc/cmdargs-0.7
hs-libraries: HScmdargs-0.7
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         transformers-0.2.2.0-89265f646be3aed4f502cfc5eccd7c93
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cmdargs-0.7/html/cmdargs.haddock
haddock-html: /usr/local/share/doc/hs-cmdargs-0.7/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
