#!/bin/sh
echo 'name: convertible
version: 1.0.11.0
id: convertible-1.0.11.0-d277dbd888af1ee72a2d31dbb24b72a2

license: BSD3
copyright: Copyright (c) 2009-2011 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen
pkgpath: devel/hs-convertible
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Text
                 Data.Convertible.Instances.Time
hidden-modules:
import-dirs: /usr/local/lib/ghc/convertible-1.0.11.0
library-dirs: /usr/local/lib/ghc/convertible-1.0.11.0
hs-libraries: HSconvertible-1.0.11.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         bytestring-0.9.1.10-4e62762ee9b2a5d0cc5bc2fbaaeefd53
         containers-0.4.0.0-f1307d32d8f4b51a1487c01f0997b6d9
         mtl-2.0.1.0-3e464329054b7660133198d73c31aca5
         old-locale-1.0.0.2-25ff1e5e0486bb3cf2cb85cb7daf8f22
         old-time-1.0.0.6-249d424df19da9487f0cb7da3ccb0868
         text-0.11.1.5-a9f0a532672121c1439a824b6891e297
         time-1.2.0.3-ad46a3ade48e0011608895f44cc02a52
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.0.11.0/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.0.11.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
