/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.webdav.lib.WebdavState;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class UnlockMethod
extends XMLResponseMethodBase {
    public static final int NO_TRANSACTION = -1;
    public static final int ABORT_TRANSACTION = 0;
    public static final int COMMIT_TRANSACTION = 1;
    private String lockToken = null;
    private int transactionStatus = -1;

    public UnlockMethod(String path, String txHandle, int transactionStatus) {
        this(path);
        this.setLockToken(txHandle);
        this.setTransactionStatus(transactionStatus);
    }

    public UnlockMethod() {
    }

    public UnlockMethod(String path) {
        super(path);
    }

    public UnlockMethod(String path, String lockToken) {
        this(path);
        this.setLockToken(lockToken);
    }

    public void setLockToken(String lockToken) {
        this.checkNotUsed();
        this.lockToken = lockToken;
    }

    public int getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(int transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public String getName() {
        return "UNLOCK";
    }

    public void recycle() {
        this.transactionStatus = -1;
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Lock-Token")) {
            this.setLockToken(headerValue);
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        super.setRequestHeader("Lock-Token", "<" + this.lockToken + ">");
    }

    protected String generateRequestBody() {
        if (this.getTransactionStatus() == -1) {
            return "";
        }
        return "<D:transactioninfo xmlns:D='DAV:'>\n  <D:transactionstatus>" + (this.getTransactionStatus() == 0 ? "<D:abort/>" : "<D:commit/>") + "</D:transactionstatus>\n</D:transactioninfo>";
    }

    protected void processResponseBody(HttpState state, HttpConnection conn) {
        if (this.getStatusLine().getStatusCode() == 204 && state instanceof WebdavState) {
            ((WebdavState)state).removeLock(this.getPath(), this.lockToken);
        }
    }
}

