/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.bsd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerBase;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.DebuggerUtilities;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.ReadResult;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.bsd.BsdAddress;
import sun.jvm.hotspot.debugger.bsd.BsdCDebugger;
import sun.jvm.hotspot.debugger.bsd.BsdDebugger;
import sun.jvm.hotspot.debugger.bsd.BsdOopHandle;
import sun.jvm.hotspot.debugger.bsd.BsdThread;
import sun.jvm.hotspot.debugger.bsd.SharedObject;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.utilities.PlatformInfo;

public class BsdDebuggerLocal
extends DebuggerBase
implements BsdDebugger {
    private boolean useGCC32ABI;
    private boolean attached;
    private long p_ps_prochandle;
    private boolean isCore;
    private BsdCDebugger cdbg;
    private List threadList;
    private List loadObjectList;
    private BsdDebuggerLocalWorkerThread workerThread = null;

    private ClosestSymbol createClosestSymbol(String name, long offset) {
        return new ClosestSymbol(name, offset);
    }

    private LoadObject createLoadObject(String fileName, long textsize, long base) {
        File f = new File(fileName);
        Address baseAddr = this.newAddress(base);
        return new SharedObject(this, fileName, f.length(), baseAddr);
    }

    private static native void init0() throws DebuggerException;

    private native void attach0(int var1) throws DebuggerException;

    private native void attach0(String var1, String var2) throws DebuggerException;

    private native void detach0() throws DebuggerException;

    private native long lookupByName0(String var1, String var2) throws DebuggerException;

    private native ClosestSymbol lookupByAddress0(long var1) throws DebuggerException;

    private native long[] getThreadIntegerRegisterSet0(int var1) throws DebuggerException;

    private native byte[] readBytesFromProcess0(long var1, long var3) throws DebuggerException;

    public static native int getAddressSize();

    public BsdDebuggerLocal(MachineDescription machDesc, boolean useCache) throws DebuggerException {
        this.machDesc = machDesc;
        this.utils = new DebuggerUtilities(machDesc.getAddressSize(), machDesc.isBigEndian()){

            @Override
            public void checkAlignment(long address, long alignment) {
                if (address % alignment != 0L && (alignment != 8L || address % 4L != 0L)) {
                    throw new UnalignedAddressException("Trying to read at address: " + this.addressValueToString(address) + " with alignment: " + alignment, address);
                }
            }
        };
        if (useCache) {
            if (this.getCPU().equals("ia64")) {
                this.initCache(16384L, this.parseCacheNumPagesProperty(1024));
            } else {
                this.initCache(4096L, this.parseCacheNumPagesProperty(4096));
            }
        }
        this.workerThread = new BsdDebuggerLocalWorkerThread(this);
        this.workerThread.start();
    }

    @Override
    public boolean hasProcessList() throws DebuggerException {
        return false;
    }

    @Override
    public List getProcessList() throws DebuggerException {
        throw new DebuggerException("getProcessList not implemented yet");
    }

    private void checkAttached() throws DebuggerException {
        if (this.attached) {
            if (this.isCore) {
                throw new DebuggerException("attached to a core dump already");
            }
            throw new DebuggerException("attached to a process already");
        }
    }

    private void requireAttach() {
        if (!this.attached) {
            throw new RuntimeException("not attached to a process or a core!");
        }
    }

    private void findABIVersion() throws DebuggerException {
        this.useGCC32ABI = this.lookupByName0("libjvm.so", "__vt_10JavaThread") == 0L && this.lookupByName0("libjvm_g.so", "__vt_10JavaThread") == 0L;
    }

    @Override
    public synchronized void attach(int processID) throws DebuggerException {
        this.checkAttached();
        this.threadList = new ArrayList();
        this.loadObjectList = new ArrayList();
        class AttachTask
        implements WorkerThreadTask {
            int pid;

            AttachTask() {
            }

            @Override
            public void doit(BsdDebuggerLocal debugger) {
                debugger.attach0(this.pid);
                debugger.attached = true;
                debugger.isCore = false;
                BsdDebuggerLocal.this.findABIVersion();
            }
        }
        AttachTask task = new AttachTask();
        task.pid = processID;
        this.workerThread.execute(task);
    }

    @Override
    public synchronized void attach(String execName, String coreName) {
        this.checkAttached();
        this.threadList = new ArrayList();
        this.loadObjectList = new ArrayList();
        this.attach0(execName, coreName);
        this.attached = true;
        this.isCore = true;
        this.findABIVersion();
    }

    @Override
    public synchronized boolean detach() {
        if (!this.attached) {
            return false;
        }
        this.threadList = null;
        this.loadObjectList = null;
        if (this.isCore) {
            this.detach0();
            this.attached = false;
            return true;
        }
        class DetachTask
        implements WorkerThreadTask {
            boolean result = false;

            DetachTask() {
            }

            @Override
            public void doit(BsdDebuggerLocal debugger) {
                debugger.detach0();
                debugger.attached = false;
                this.result = true;
            }
        }
        DetachTask task = new DetachTask();
        this.workerThread.execute(task);
        return task.result;
    }

    @Override
    public Address parseAddress(String addressString) throws NumberFormatException {
        long addr = this.utils.scanAddress(addressString);
        if (addr == 0L) {
            return null;
        }
        return new BsdAddress(this, addr);
    }

    @Override
    public String getOS() {
        return PlatformInfo.getOS();
    }

    @Override
    public String getCPU() {
        return PlatformInfo.getCPU();
    }

    @Override
    public boolean hasConsole() throws DebuggerException {
        return false;
    }

    @Override
    public String consoleExecuteCommand(String cmd) throws DebuggerException {
        throw new DebuggerException("No debugger console available on Bsd");
    }

    @Override
    public String getConsolePrompt() throws DebuggerException {
        return null;
    }

    private long handleGCC32ABI(long addr, String symbol) throws DebuggerException {
        if (this.useGCC32ABI && symbol.startsWith("_ZTV")) {
            return addr + 2L * this.machDesc.getAddressSize();
        }
        return addr;
    }

    @Override
    public synchronized Address lookup(String objectName, String symbol) {
        this.requireAttach();
        if (!this.attached) {
            return null;
        }
        if (this.isCore) {
            long addr = this.lookupByName0(objectName, symbol);
            return addr == 0L ? null : new BsdAddress(this, this.handleGCC32ABI(addr, symbol));
        }
        class LookupByNameTask
        implements WorkerThreadTask {
            String objectName;
            String symbol;
            Address result;

            LookupByNameTask() {
            }

            @Override
            public void doit(BsdDebuggerLocal debugger) {
                long addr = debugger.lookupByName0(this.objectName, this.symbol);
                this.result = addr == 0L ? null : new BsdAddress(debugger, BsdDebuggerLocal.this.handleGCC32ABI(addr, this.symbol));
            }
        }
        LookupByNameTask task = new LookupByNameTask();
        task.objectName = objectName;
        task.symbol = symbol;
        this.workerThread.execute(task);
        return task.result;
    }

    @Override
    public synchronized OopHandle lookupOop(String objectName, String symbol) {
        Address addr = this.lookup(objectName, symbol);
        if (addr == null) {
            return null;
        }
        return addr.addOffsetToAsOopHandle(0L);
    }

    @Override
    public MachineDescription getMachineDescription() {
        return this.machDesc;
    }

    @Override
    public ThreadProxy getThreadForIdentifierAddress(Address addr) {
        return new BsdThread((BsdDebugger)this, addr);
    }

    @Override
    public ThreadProxy getThreadForThreadId(long id) {
        return new BsdThread((BsdDebugger)this, id);
    }

    @Override
    public String addressValueToString(long address) {
        return this.utils.addressValueToString(address);
    }

    @Override
    public BsdAddress readAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new BsdAddress(this, value);
    }

    @Override
    public BsdAddress readCompOopAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readCompOopAddressValue(address);
        return value == 0L ? null : new BsdAddress(this, value);
    }

    @Override
    public BsdOopHandle readOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new BsdOopHandle(this, value);
    }

    @Override
    public BsdOopHandle readCompOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readCompOopAddressValue(address);
        return value == 0L ? null : new BsdOopHandle(this, value);
    }

    @Override
    public synchronized long[] getThreadIntegerRegisterSet(int lwp_id) throws DebuggerException {
        this.requireAttach();
        if (this.isCore) {
            return this.getThreadIntegerRegisterSet0(lwp_id);
        }
        class GetThreadIntegerRegisterSetTask
        implements WorkerThreadTask {
            int lwp_id;
            long[] result;

            GetThreadIntegerRegisterSetTask() {
            }

            @Override
            public void doit(BsdDebuggerLocal debugger) {
                this.result = debugger.getThreadIntegerRegisterSet0(this.lwp_id);
            }
        }
        GetThreadIntegerRegisterSetTask task = new GetThreadIntegerRegisterSetTask();
        task.lwp_id = lwp_id;
        this.workerThread.execute(task);
        return task.result;
    }

    @Override
    public long readCInteger(long address, long numBytes, boolean isUnsigned) throws UnmappedAddressException, UnalignedAddressException {
        if (numBytes == 8L) {
            this.utils.checkAlignment(address, 4L);
        } else {
            this.utils.checkAlignment(address, numBytes);
        }
        byte[] data = this.readBytes(address, numBytes);
        return this.utils.dataToCInteger(data, isUnsigned);
    }

    @Override
    public long readJLong(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.utils.checkAlignment(address, this.jintSize);
        byte[] data = this.readBytes(address, this.jlongSize);
        return this.utils.dataToJLong(data, this.jlongSize);
    }

    @Override
    public long getAddressValue(Address addr) {
        if (addr == null) {
            return 0L;
        }
        return ((BsdAddress)addr).getValue();
    }

    @Override
    public Address newAddress(long value) {
        if (value == 0L) {
            return null;
        }
        return new BsdAddress(this, value);
    }

    @Override
    public List getThreadList() {
        this.requireAttach();
        return this.threadList;
    }

    @Override
    public List getLoadObjectList() {
        this.requireAttach();
        return this.loadObjectList;
    }

    @Override
    public synchronized ClosestSymbol lookup(long addr) {
        this.requireAttach();
        if (this.isCore) {
            return this.lookupByAddress0(addr);
        }
        class LookupByAddressTask
        implements WorkerThreadTask {
            long addr;
            ClosestSymbol result;

            LookupByAddressTask() {
            }

            @Override
            public void doit(BsdDebuggerLocal debugger) {
                this.result = debugger.lookupByAddress0(this.addr);
            }
        }
        LookupByAddressTask task = new LookupByAddressTask();
        task.addr = addr;
        this.workerThread.execute(task);
        return task.result;
    }

    @Override
    public CDebugger getCDebugger() {
        if (this.cdbg == null) {
            String cpu = this.getCPU();
            if (cpu.equals("ia64")) {
                return null;
            }
            this.cdbg = new BsdCDebugger(this);
        }
        return this.cdbg;
    }

    @Override
    public synchronized ReadResult readBytesFromProcess(long address, long numBytes) throws UnmappedAddressException, DebuggerException {
        this.requireAttach();
        if (this.isCore) {
            byte[] res = this.readBytesFromProcess0(address, numBytes);
            return res != null ? new ReadResult(res) : new ReadResult(address);
        }
        class ReadBytesFromProcessTask
        implements WorkerThreadTask {
            long address;
            long numBytes;
            ReadResult result;

            ReadBytesFromProcessTask() {
            }

            @Override
            public void doit(BsdDebuggerLocal debugger) {
                byte[] res = debugger.readBytesFromProcess0(this.address, this.numBytes);
                this.result = res != null ? new ReadResult(res) : new ReadResult(this.address);
            }
        }
        ReadBytesFromProcessTask task = new ReadBytesFromProcessTask();
        task.address = address;
        task.numBytes = numBytes;
        this.workerThread.execute(task);
        return task.result;
    }

    @Override
    public void writeBytesToProcess(long address, long numBytes, byte[] data) throws UnmappedAddressException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    static {
        System.loadLibrary("saproc");
        BsdDebuggerLocal.init0();
    }

    class BsdDebuggerLocalWorkerThread
    extends Thread {
        BsdDebuggerLocal debugger;
        WorkerThreadTask task;
        DebuggerException lastException;

        public BsdDebuggerLocalWorkerThread(BsdDebuggerLocal debugger) {
            this.debugger = debugger;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            BsdDebuggerLocalWorkerThread bsdDebuggerLocalWorkerThread = BsdDebuggerLocal.this.workerThread;
            synchronized (bsdDebuggerLocalWorkerThread) {
                while (true) {
                    if (this.task != null) {
                        this.lastException = null;
                        try {
                            this.task.doit(this.debugger);
                        }
                        catch (DebuggerException exp) {
                            this.lastException = exp;
                        }
                        this.task = null;
                        BsdDebuggerLocal.this.workerThread.notifyAll();
                    }
                    try {
                        BsdDebuggerLocal.this.workerThread.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WorkerThreadTask execute(WorkerThreadTask task) throws DebuggerException {
            BsdDebuggerLocalWorkerThread bsdDebuggerLocalWorkerThread = BsdDebuggerLocal.this.workerThread;
            synchronized (bsdDebuggerLocalWorkerThread) {
                this.task = task;
                BsdDebuggerLocal.this.workerThread.notifyAll();
                while (this.task != null) {
                    try {
                        BsdDebuggerLocal.this.workerThread.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.lastException != null) {
                    throw new DebuggerException(this.lastException);
                }
                return task;
            }
        }
    }

    static interface WorkerThreadTask {
        public void doit(BsdDebuggerLocal var1) throws DebuggerException;
    }
}

