/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class MethodData
extends Oop {
    private static long baseOffset;
    private static CIntField size;
    private static OopField method;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("methodDataOopDesc");
        baseOffset = type.getSize();
        size = new CIntField(type.getCIntegerField("_size"), 0L);
        method = new OopField(type.getOopField("_method"), 0L);
    }

    MethodData(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    @Override
    public boolean isMethodData() {
        return true;
    }

    @Override
    public long getObjectSize() {
        return MethodData.alignObjectSize(size.getValue(this));
    }

    public Method getMethod() {
        return (Method)method.getValue(this);
    }

    @Override
    public void printValueOn(PrintStream tty) {
        Method m = this.getMethod();
        tty.print("MethodData for " + m.getName().asString() + m.getSignature().asString());
    }

    @Override
    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doOop(method, true);
            visitor.doCInt(size, true);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                MethodData.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

