/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.jvm.hotspot.oops.AccessFlags;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FieldType;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaKlass;
import sun.jvm.hotspot.utilities.soql.JSList;
import sun.jvm.hotspot.utilities.soql.JSMap;

public class JSJavaInstanceKlass
extends JSJavaKlass {
    private static final int FIELD_SOURCE_FILE = 1;
    private static final int FIELD_INTERFACES = 2;
    private static final int FIELD_FIELDS = 3;
    private static final int FIELD_METHODS = 4;
    private static final int FIELD_IS_PRIVATE = 5;
    private static final int FIELD_IS_PUBLIC = 6;
    private static final int FIELD_IS_PROTECTED = 7;
    private static final int FIELD_IS_PACKAGE_PRIVATE = 8;
    private static final int FIELD_IS_STATIC = 9;
    private static final int FIELD_IS_FINAL = 10;
    private static final int FIELD_IS_ABSTRACT = 11;
    private static final int FIELD_IS_STRICT = 12;
    private static final int FIELD_IS_SYNTHETIC = 13;
    private static final int FIELD_IS_INTERFACE = 14;
    private static final int FIELD_CLASS_LOADER = 15;
    private static final int FIELD_PROTECTION_DOMAIN = 16;
    private static final int FIELD_SIGNERS = 17;
    private static final int FIELD_STATICS = 18;
    private static final int FIELD_UNDEFINED = -1;
    private static Map fields = new HashMap();
    private Map instanceFields = new HashMap();
    private Map staticFields = new HashMap();
    private String[] instanceFieldNames;
    private String[] staticFieldNames;
    private AccessFlags accFlags;

    public JSJavaInstanceKlass(InstanceKlass kls, JSJavaFactory fac) {
        super(kls, fac);
    }

    public final InstanceKlass getInstanceKlass() {
        return (InstanceKlass)this.getKlass();
    }

    @Override
    public Object getMetaClassFieldValue(String name) {
        int fieldID = JSJavaInstanceKlass.getFieldID(name);
        InstanceKlass ik = this.getInstanceKlass();
        switch (fieldID) {
            case 1: {
                Symbol sourceFile = ik.getSourceFileName();
                return sourceFile != null ? sourceFile.asString() : "<unknown>";
            }
            case 2: {
                return this.getInterfaces();
            }
            case 3: {
                return this.factory.newJSList(ik.getImmediateFields());
            }
            case 4: {
                return this.factory.newJSList(ik.getImmediateMethods());
            }
            case 5: {
                return this.getAccessFlags().isPrivate();
            }
            case 6: {
                return this.getAccessFlags().isPublic();
            }
            case 7: {
                return this.getAccessFlags().isProtected();
            }
            case 8: {
                AccessFlags acc = this.getAccessFlags();
                return !acc.isPrivate() && !acc.isPublic() && !acc.isProtected();
            }
            case 9: {
                return this.getAccessFlags().isStatic();
            }
            case 10: {
                return this.getAccessFlags().isFinal();
            }
            case 11: {
                return this.getAccessFlags().isAbstract();
            }
            case 12: {
                return this.getAccessFlags().isStrict();
            }
            case 13: {
                return this.getAccessFlags().isSynthetic();
            }
            case 14: {
                return ik.isInterface();
            }
            case 15: {
                return this.factory.newJSJavaObject(ik.getClassLoader());
            }
            case 16: {
                return this.factory.newJSJavaObject(ik.getProtectionDomain());
            }
            case 17: {
                return this.factory.newJSJavaObject(ik.getSigners());
            }
            case 18: {
                return this.getStatics();
            }
        }
        return super.getMetaClassFieldValue(name);
    }

    @Override
    public boolean hasMetaClassField(String name) {
        if (JSJavaInstanceKlass.getFieldID(name) != -1) {
            return true;
        }
        return super.hasMetaClassField(name);
    }

    @Override
    public String getName() {
        return this.getInstanceKlass().getName().asString().replace('/', '.');
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public String[] getMetaClassFieldNames() {
        String[] superFields = super.getMetaClassFieldNames();
        Set k = fields.keySet();
        String[] res = new String[k.size() + superFields.length];
        System.arraycopy(superFields, 0, res, 0, superFields.length);
        int i = superFields.length;
        Iterator itr = k.iterator();
        while (itr.hasNext()) {
            res[i] = (String)itr.next();
            ++i;
        }
        return res;
    }

    public Object getInstanceFieldValue(String name, Instance instance) throws NoSuchFieldException {
        Field fld = this.findInstanceField(name);
        if (fld != null) {
            return this.getFieldValue(fld, name, instance);
        }
        throw new NoSuchFieldException(name + " is not field of " + this.getInstanceKlass().getName().asString().replace('/', '.'));
    }

    public Object getStaticFieldValue(String name) throws NoSuchFieldException {
        Field fld = this.findStaticField(name);
        if (fld != null) {
            return this.getFieldValue(fld, name, this.getInstanceKlass());
        }
        throw new NoSuchFieldException(name + " is not field of " + this.getInstanceKlass().getName().asString().replace('/', '.'));
    }

    public String[] getInstanceFieldNames() {
        if (this.instanceFieldNames == null) {
            for (InstanceKlass current = this.getInstanceKlass(); current != null; current = (InstanceKlass)current.getSuper()) {
                List tmp = current.getImmediateFields();
                for (Field fld : tmp) {
                    String name;
                    if (fld.isStatic() || this.instanceFields.get(name = fld.getID().getName()) != null) continue;
                    this.instanceFields.put(name, fld);
                }
            }
            Set s = this.instanceFields.keySet();
            this.instanceFieldNames = new String[s.size()];
            int i = 0;
            Iterator itr = s.iterator();
            while (itr.hasNext()) {
                this.instanceFieldNames[i] = (String)itr.next();
                ++i;
            }
        }
        return this.instanceFieldNames;
    }

    public boolean hasInstanceField(String name) {
        Field fld = this.findInstanceField(name);
        return fld != null;
    }

    public String[] getStaticFieldNames() {
        if (this.staticFieldNames == null) {
            InstanceKlass current = this.getInstanceKlass();
            List tmp = current.getImmediateFields();
            for (Field fld : tmp) {
                if (!fld.isStatic()) continue;
                this.staticFields.put(fld.getID().getName(), fld);
            }
            Set s = this.staticFields.keySet();
            this.staticFieldNames = new String[s.size()];
            int i = 0;
            Iterator itr = s.iterator();
            while (itr.hasNext()) {
                this.staticFieldNames[i] = (String)itr.next();
                ++i;
            }
        }
        return this.staticFieldNames;
    }

    public boolean hasStaticField(String name) {
        Field fld = this.findStaticField(name);
        return fld != null;
    }

    private static void addField(String name, int fieldId) {
        fields.put(name, new Integer(fieldId));
    }

    private static int getFieldID(String name) {
        Integer res = (Integer)fields.get(name);
        return res != null ? res : -1;
    }

    private AccessFlags getAccessFlags() {
        if (this.accFlags == null) {
            this.accFlags = new AccessFlags(this.getInstanceKlass().computeModifierFlags());
        }
        return this.accFlags;
    }

    private Object getFieldValue(Field fld, String name, Oop oop) {
        FieldType fd = fld.getFieldType();
        if (fd.isObject() || fd.isArray()) {
            return this.factory.newJSJavaObject(((OopField)fld).getValue(oop));
        }
        if (fd.isByte()) {
            return new Byte(((ByteField)fld).getValue(oop));
        }
        if (fd.isChar()) {
            return new String(new char[]{((CharField)fld).getValue(oop)});
        }
        if (fd.isDouble()) {
            return new Double(((DoubleField)fld).getValue(oop));
        }
        if (fd.isFloat()) {
            return new Float(((FloatField)fld).getValue(oop));
        }
        if (fd.isInt()) {
            return new Integer(((IntField)fld).getValue(oop));
        }
        if (fd.isLong()) {
            return new Long(((LongField)fld).getValue(oop));
        }
        if (fd.isShort()) {
            return new Short(((ShortField)fld).getValue(oop));
        }
        if (fd.isBoolean()) {
            return ((BooleanField)fld).getValue(oop);
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(false, "invalid field type for " + name);
        }
        return null;
    }

    private Field findInstanceField(String name) {
        Field fld2 = (Field)this.instanceFields.get(name);
        if (fld2 != null) {
            return fld2;
        }
        for (InstanceKlass current = this.getInstanceKlass(); current != null; current = (InstanceKlass)current.getSuper()) {
            List tmp = current.getImmediateFields();
            for (Field fld2 : tmp) {
                if (!fld2.getID().getName().equals(name) || fld2.isStatic()) continue;
                this.instanceFields.put(name, fld2);
                return fld2;
            }
        }
        return null;
    }

    private Field findStaticField(String name) {
        Field fld2 = (Field)this.staticFields.get(name);
        if (fld2 != null) {
            return fld2;
        }
        InstanceKlass current = this.getInstanceKlass();
        List tmp = current.getImmediateFields();
        for (Field fld2 : tmp) {
            if (!fld2.getID().getName().equals(name) || !fld2.isStatic()) continue;
            this.staticFields.put(name, fld2);
            return fld2;
        }
        return null;
    }

    private JSList getInterfaces() {
        InstanceKlass ik = this.getInstanceKlass();
        List intfs = ik.getDirectImplementedInterfaces();
        ArrayList<Instance> res = new ArrayList<Instance>(0);
        for (Klass k : intfs) {
            res.add(k.getJavaMirror());
        }
        return this.factory.newJSList(res);
    }

    private JSMap getStatics() {
        String[] names = this.getStaticFieldNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < names.length; ++i) {
            try {
                map.put(names[i], this.getStaticFieldValue(names[i]));
                continue;
            }
            catch (NoSuchFieldException exp) {
                // empty catch block
            }
        }
        return this.factory.newJSMap(map);
    }

    static {
        JSJavaInstanceKlass.addField("sourceFile", 1);
        JSJavaInstanceKlass.addField("interfaces", 2);
        JSJavaInstanceKlass.addField("fields", 3);
        JSJavaInstanceKlass.addField("methods", 4);
        JSJavaInstanceKlass.addField("isPrivate", 5);
        JSJavaInstanceKlass.addField("isPublic", 6);
        JSJavaInstanceKlass.addField("isProtected", 7);
        JSJavaInstanceKlass.addField("isPackagePrivate", 8);
        JSJavaInstanceKlass.addField("isStatic", 9);
        JSJavaInstanceKlass.addField("isFinal", 10);
        JSJavaInstanceKlass.addField("isAbstract", 11);
        JSJavaInstanceKlass.addField("isStrict", 12);
        JSJavaInstanceKlass.addField("isSynthetic", 13);
        JSJavaInstanceKlass.addField("isInterface", 14);
        JSJavaInstanceKlass.addField("classLoader", 15);
        JSJavaInstanceKlass.addField("protectionDomain", 16);
        JSJavaInstanceKlass.addField("signers", 17);
        JSJavaInstanceKlass.addField("statics", 18);
    }
}

