/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.Util;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.NotCompliantMBeanException;

class MBeanAnalyzer<M> {
    private Map<String, List<M>> opMap = Util.newInsertionOrderMap();
    private Map<String, AttrMethods<M>> attrMap = Util.newInsertionOrderMap();

    void visit(MBeanVisitor<M> mBeanVisitor) {
        for (Map.Entry<String, AttrMethods<M>> entry : this.attrMap.entrySet()) {
            String string = entry.getKey();
            AttrMethods<Object> attrMethods = entry.getValue();
            mBeanVisitor.visitAttribute(string, (AttrMethods<AttrMethods<M>>)attrMethods.getter, (AttrMethods<AttrMethods<M>>)attrMethods.setter);
        }
        for (Map.Entry<String, Object> entry : this.opMap.entrySet()) {
            for (AttrMethods<Object> attrMethods : (List)entry.getValue()) {
                mBeanVisitor.visitOperation(entry.getKey(), attrMethods);
            }
        }
    }

    static <M> MBeanAnalyzer<M> analyzer(Class<?> clazz, MBeanIntrospector<M> mBeanIntrospector) throws NotCompliantMBeanException {
        return new MBeanAnalyzer<M>(clazz, mBeanIntrospector);
    }

    private MBeanAnalyzer(Class<?> clazz, MBeanIntrospector<M> mBeanIntrospector) throws NotCompliantMBeanException {
        if (!clazz.isInterface()) {
            throw new NotCompliantMBeanException("Not an interface: " + clazz.getName());
        }
        try {
            this.initMaps(clazz, mBeanIntrospector);
        }
        catch (Exception exception) {
            throw Introspector.throwException(clazz, exception);
        }
    }

    private void initMaps(Class<?> clazz, MBeanIntrospector<M> mBeanIntrospector) throws Exception {
        Object object;
        List<Method> list = mBeanIntrospector.getMethods(clazz);
        List<Method> list2 = MBeanAnalyzer.eliminateCovariantMethods(list);
        for (Method object2 : list2) {
            Object object3;
            object = object2.getName();
            int n = object2.getParameterTypes().length;
            Object m = mBeanIntrospector.mFrom(object2);
            String string = "";
            if (((String)object).startsWith("get")) {
                string = ((String)object).substring(3);
            } else if (((String)object).startsWith("is") && object2.getReturnType() == Boolean.TYPE) {
                string = ((String)object).substring(2);
            }
            if (string.length() != 0 && n == 0 && object2.getReturnType() != Void.TYPE) {
                object3 = this.attrMap.get(string);
                if (object3 == null) {
                    object3 = new AttrMethods();
                } else if (((AttrMethods)object3).getter != null) {
                    String string2 = "Attribute " + string + " has more than one getter";
                    throw new NotCompliantMBeanException(string2);
                }
                ((AttrMethods)object3).getter = m;
                this.attrMap.put(string, (AttrMethods<M>)object3);
                continue;
            }
            if (((String)object).startsWith("set") && ((String)object).length() > 3 && n == 1 && object2.getReturnType() == Void.TYPE) {
                string = ((String)object).substring(3);
                object3 = this.attrMap.get(string);
                if (object3 == null) {
                    object3 = new AttrMethods();
                } else if (((AttrMethods)object3).setter != null) {
                    String string3 = "Attribute " + string + " has more than one setter";
                    throw new NotCompliantMBeanException(string3);
                }
                ((AttrMethods)object3).setter = m;
                this.attrMap.put(string, (AttrMethods<M>)object3);
                continue;
            }
            object3 = this.opMap.get(object);
            if (object3 == null) {
                object3 = Util.newList();
            }
            object3.add(m);
            this.opMap.put((String)object, (List<M>)object3);
        }
        for (Map.Entry entry : this.attrMap.entrySet()) {
            object = (AttrMethods)entry.getValue();
            if (mBeanIntrospector.consistent(((AttrMethods)object).getter, ((AttrMethods)object).setter)) continue;
            String string = "Getter and setter for " + (String)entry.getKey() + " have inconsistent types";
            throw new NotCompliantMBeanException(string);
        }
    }

    static List<Method> eliminateCovariantMethods(List<Method> list) {
        int n = list.size();
        Method[] methodArray = list.toArray(new Method[n]);
        Arrays.sort(methodArray, MethodOrder.instance);
        Set<Method> set = Util.newSet();
        for (int i = 1; i < n; ++i) {
            Method method = methodArray[i - 1];
            Method method2 = methodArray[i];
            if (!method.getName().equals(method2.getName()) || !Arrays.equals(method.getParameterTypes(), method2.getParameterTypes()) || set.add(method)) continue;
            throw new RuntimeException("Internal error: duplicate Method");
        }
        List<Method> list2 = Util.newList(list);
        list2.removeAll(set);
        return list2;
    }

    private static class MethodOrder
    implements Comparator<Method> {
        public static final MethodOrder instance = new MethodOrder();

        private MethodOrder() {
        }

        @Override
        public int compare(Method method, Method method2) {
            Class<?> clazz;
            Object[] objectArray;
            int n = method.getName().compareTo(method2.getName());
            if (n != 0) {
                return n;
            }
            Object[] objectArray2 = method.getParameterTypes();
            if (objectArray2.length != (objectArray = method2.getParameterTypes()).length) {
                return objectArray2.length - objectArray.length;
            }
            if (!Arrays.equals(objectArray2, objectArray)) {
                return Arrays.toString(objectArray2).compareTo(Arrays.toString(objectArray));
            }
            Class<?> clazz2 = method.getReturnType();
            if (clazz2 == (clazz = method2.getReturnType())) {
                return 0;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return -1;
            }
            return 1;
        }
    }

    private static class AttrMethods<M> {
        M getter;
        M setter;

        private AttrMethods() {
        }
    }

    static interface MBeanVisitor<M> {
        public void visitAttribute(String var1, M var2, M var3);

        public void visitOperation(String var1, M var2);
    }
}

