/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataNode;
import org.h2.index.PageScanCursor;
import org.h2.index.PageScanIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.util.IntArray;

class PageDataLeaf
extends PageData {
    private static final int KEY_OFFSET_PAIR_LENGTH = 6;
    private static final int KEY_OFFSET_PAIR_START = 11;
    private static final int OVERFLOW_DATA_START_MORE = 9;
    private static final int OVERFLOW_DATA_START_LAST = 7;
    int[] offsets;
    Row[] rows;
    int firstOverflowPageId;
    int[] overflowPageIds;
    int start = 11;

    PageDataLeaf(PageScanIndex pageScanIndex, int n, int n2, DataPage dataPage) {
        super(pageScanIndex, n, n2, dataPage);
    }

    void read() throws SQLException {
        this.data.setPos(4);
        int n = this.data.readByte();
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.keys = new int[this.entryCount];
        this.rows = new Row[this.entryCount];
        if (n == 1) {
            this.firstOverflowPageId = this.data.readInt();
        }
        for (int i = 0; i < this.entryCount; ++i) {
            this.keys[i] = this.data.readInt();
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
    }

    int addRow(Row row) throws SQLException {
        int n;
        int n2;
        int n3 = row.getByteCount(this.data);
        int n4 = this.index.getPageStore().getPageSize();
        int n5 = n2 = this.entryCount == 0 ? n4 : this.offsets[this.entryCount - 1];
        if (this.entryCount > 0 && n2 - n3 < this.start + 6) {
            return this.entryCount / 2 + 1;
        }
        int n6 = n2 - n3;
        int[] nArray = new int[this.entryCount + 1];
        int[] nArray2 = new int[this.entryCount + 1];
        Row[] rowArray = new Row[this.entryCount + 1];
        if (this.entryCount == 0) {
            n = 0;
        } else {
            n = this.find(row.getPos());
            System.arraycopy(this.offsets, 0, nArray, 0, n);
            System.arraycopy(this.keys, 0, nArray2, 0, n);
            System.arraycopy(this.rows, 0, rowArray, 0, n);
            if (n < this.entryCount) {
                System.arraycopy(this.offsets, n, nArray, n + 1, this.entryCount - n);
                System.arraycopy(this.keys, n, nArray2, n + 1, this.entryCount - n);
                System.arraycopy(this.rows, n, rowArray, n + 1, this.entryCount - n);
            }
        }
        ++this.entryCount;
        this.start += 6;
        nArray[n] = n6;
        nArray2[n] = row.getPos();
        rowArray[n] = row;
        this.offsets = nArray;
        this.keys = nArray2;
        this.rows = rowArray;
        if (n6 < this.start) {
            if (this.entryCount > 1) {
                Message.throwInternalError();
            }
            this.start += 4;
            int n7 = n3 - (n4 - this.start);
            this.offsets[n] = n6 = this.start;
            IntArray intArray = new IntArray();
            do {
                int n8 = this.index.getPageStore().allocatePage();
                intArray.add(n8);
                if ((n7 -= n4 - 7) <= 0) continue;
                n7 += 2;
            } while (n7 > 0);
            this.overflowPageIds = new int[intArray.size()];
            intArray.toArray(this.overflowPageIds);
            this.firstOverflowPageId = this.overflowPageIds[0];
        }
        this.index.getPageStore().updateRecord(this, this.data);
        return 0;
    }

    private void removeRow(int n) throws SQLException {
        --this.entryCount;
        if (this.entryCount <= 0) {
            Message.throwInternalError();
        }
        int[] nArray = new int[this.entryCount];
        int[] nArray2 = new int[this.entryCount];
        Row[] rowArray = new Row[this.entryCount];
        System.arraycopy(this.offsets, 0, nArray, 0, n);
        System.arraycopy(this.keys, 0, nArray2, 0, n);
        System.arraycopy(this.rows, 0, rowArray, 0, n);
        System.arraycopy(this.offsets, n + 1, nArray, n, this.entryCount - n);
        System.arraycopy(this.keys, n + 1, nArray2, n, this.entryCount - n);
        System.arraycopy(this.rows, n + 1, rowArray, n, this.entryCount - n);
        this.start -= 6;
        this.offsets = nArray;
        this.keys = nArray2;
        this.rows = rowArray;
    }

    Cursor find() {
        return new PageScanCursor(this, 0);
    }

    Row getRowAt(int n) throws SQLException {
        Row row = this.rows[n];
        if (row == null) {
            if (this.firstOverflowPageId != 0) {
                PageStore pageStore = this.index.getPageStore();
                int n2 = pageStore.getPageSize();
                this.data.setPos(n2);
                int n3 = this.firstOverflowPageId;
                while (true) {
                    int n4;
                    DataPage dataPage = pageStore.readPage(n3);
                    dataPage.setPos(4);
                    int n5 = dataPage.readByte();
                    if (n5 == 19) {
                        n4 = dataPage.readShortInt();
                        this.data.write(dataPage.getBytes(), 7, n4);
                        break;
                    }
                    n3 = dataPage.readInt();
                    n4 = n2 - 9;
                    this.data.write(dataPage.getBytes(), 9, n4);
                }
            }
            this.data.setPos(this.offsets[n]);
            row = this.index.readRow(this.data);
            row.setPos(this.keys[n]);
            this.rows[n] = row;
        }
        return row;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    PageData split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageDataLeaf pageDataLeaf = new PageDataLeaf(this.index, n2, this.parentPageId, this.index.getPageStore().createDataPage());
        int n3 = n;
        while (n3 < this.entryCount) {
            pageDataLeaf.addRow(this.getRowAt(n));
            this.removeRow(n);
        }
        return pageDataLeaf;
    }

    int getLastKey() throws SQLException {
        if (this.entryCount == 0) {
            return 0;
        }
        return this.getRowAt(this.entryCount - 1).getPos();
    }

    public PageDataLeaf getNextPage() throws SQLException {
        if (this.parentPageId == 0) {
            return null;
        }
        PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId);
        return pageDataNode.getNextPage(this.keys[this.entryCount - 1]);
    }

    PageDataLeaf getFirstLeaf() {
        return this;
    }

    protected void remapChildren() throws SQLException {
        if (this.firstOverflowPageId == 0) {
            return;
        }
    }

    boolean remove(int n) throws SQLException {
        int n2 = this.find(n);
        if (this.keys[n2] != n) {
            throw Message.getSQLException(90112, this.index.getSQL() + ": " + n);
        }
        if (this.entryCount == 1) {
            return true;
        }
        this.removeRow(n2);
        this.index.getPageStore().updateRecord(this, this.data);
        return false;
    }

    Row getRow(Session session, int n) throws SQLException {
        int n2 = this.find(n);
        return this.getRowAt(n2);
    }

    int getRowCount() throws SQLException {
        return this.entryCount;
    }

    void setRowCountStored(int n) throws SQLException {
    }

    public int getByteCount(DataPage dataPage) throws SQLException {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        int n;
        int n2;
        for (n2 = 0; n2 < this.entryCount; ++n2) {
            this.getRowAt(n2);
        }
        this.data.reset();
        this.data.writeInt(this.parentPageId);
        n2 = this.firstOverflowPageId == 0 ? 17 : 1;
        this.data.writeByte((byte)n2);
        this.data.writeShortInt(this.entryCount);
        if (this.firstOverflowPageId != 0) {
            this.data.writeInt(this.firstOverflowPageId);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeInt(this.keys[n]);
            this.data.writeShortInt(this.offsets[n]);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.data.setPos(this.offsets[n]);
            this.rows[n].write(this.data);
        }
        PageStore pageStore = this.index.getPageStore();
        int n3 = pageStore.getPageSize();
        pageStore.writePage(this.getPos(), this.data);
        if (this.data.length() > n3 && this.overflowPageIds != null) {
            if (this.firstOverflowPageId == 0) {
                Message.throwInternalError();
            }
            DataPage dataPage2 = pageStore.createDataPage();
            int n4 = this.getPos();
            int n5 = n3;
            int n6 = this.data.length() - n3;
            for (int i = 0; i < this.overflowPageIds.length; ++i) {
                int n7;
                dataPage2.reset();
                dataPage2.writeInt(n4);
                if (n6 > n3 - 7) {
                    dataPage2.writeByte((byte)3);
                    dataPage2.writeInt(this.overflowPageIds[i + 1]);
                    n7 = n3 - dataPage2.length();
                } else {
                    dataPage2.writeByte((byte)19);
                    n7 = n6;
                    dataPage2.writeShortInt(n6);
                }
                dataPage2.write(this.data.getBytes(), n5, n7);
                n6 -= n7;
                n5 += n7;
                int n8 = this.overflowPageIds[i];
                pageStore.writePage(n8, dataPage2);
                n4 = n8;
            }
        }
    }
}

