/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.store.Record;
import org.h2.util.Cache;
import org.h2.util.Cache2Q;
import org.h2.util.CacheLRU;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.FileUtils;
import org.h2.util.ObjectArray;

public class PageStore
implements CacheWriter {
    private static final int PAGE_SIZE_MIN = 512;
    private static final int PAGE_SIZE_MAX = 32768;
    private static final int PAGE_SIZE_DEFAULT = 1024;
    private static final int INCREMENT_PAGES = 128;
    private static final int READ_VERSION = 0;
    private static final int WRITE_VERSION = 0;
    private Database database;
    private final Trace trace;
    private String fileName;
    private FileStore file;
    private String accessMode;
    private int cacheSize;
    private Cache cache;
    private int pageSize;
    private int pageSizeShift;
    private int systemRootPageId;
    private int freeListRootPageId;
    private int logRootPageId;
    private long fileLength;
    private int pageCount;
    private int lastUsedPage;
    private int freePageCount;
    private PageLog log;
    private boolean isNew;

    public PageStore(Database database, String string, String string2, int n) {
        this.database = database;
        this.trace = database.getTrace("pageStore");
        this.fileName = string;
        this.accessMode = string2;
        this.cacheSize = n;
        String string3 = database.getCacheType();
        this.cache = "TQ".equals(string3) ? new Cache2Q(this, this.cacheSize) : new CacheLRU(this, this.cacheSize);
    }

    public int copyDirect(int n, OutputStream outputStream) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            byte[] byArray = new byte[this.pageSize];
            try {
                if (n >= this.pageCount) {
                    return -1;
                }
                this.file.seek(n * this.pageSize);
                this.file.readFullyDirect(byArray, 0, this.pageSize);
                outputStream.write(byArray, 0, this.pageSize);
                return n + 1;
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, this.fileName);
            }
        }
    }

    public void open() throws SQLException {
        try {
            if (FileUtils.exists(this.fileName)) {
                this.file = this.database.openFile(this.fileName, this.accessMode, true);
                this.readHeader();
                this.fileLength = this.file.length();
                this.pageCount = (int)(this.fileLength / (long)this.pageSize);
                this.log = new PageLog(this, this.logRootPageId);
                this.lastUsedPage = this.pageCount - 1;
                while (true) {
                    DataPage dataPage = this.readPage(this.lastUsedPage);
                    dataPage.readInt();
                    int n = dataPage.readByte();
                    if (n == 0) {
                        --this.lastUsedPage;
                        continue;
                    }
                    break;
                }
            } else {
                this.isNew = true;
                this.setPageSize(1024);
                this.file = this.database.openFile(this.fileName, this.accessMode, false);
                this.systemRootPageId = 1;
                this.freeListRootPageId = 2;
                PageFreeList pageFreeList = new PageFreeList(this, this.freeListRootPageId, 0);
                this.updateRecord(pageFreeList, null);
                this.logRootPageId = 3;
                this.lastUsedPage = 3;
                this.pageCount = 3;
                this.increaseFileSize(128 - this.pageCount);
                this.writeHeader();
                this.log = new PageLog(this, this.logRootPageId);
            }
            this.log.openForWriting();
        }
        catch (SQLException sQLException) {
            this.close();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() throws SQLException {
        this.trace.debug("checkpoint");
        if (this.log == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            this.database.checkPowerOff();
            ObjectArray objectArray = this.cache.getAllChanged();
            CacheObject.sort(objectArray);
            for (int i = 0; i < objectArray.size(); ++i) {
                Record record = (Record)objectArray.get(i);
                this.writeBack(record);
            }
            this.log.reopen();
        }
        this.pageCount = this.lastUsedPage + 1;
        this.file.setLength(this.pageSize * this.pageCount);
    }

    private void readHeader() throws SQLException {
        long l = this.file.length();
        if (l < 512L) {
            throw Message.getSQLException(90030, this.fileName);
        }
        this.database.notifyFileSize(l);
        this.file.seek(48L);
        DataPage dataPage = DataPage.create((DataHandler)this.database, new byte[464]);
        this.file.readFully(dataPage.getBytes(), 0, 464);
        this.setPageSize(dataPage.readInt());
        int n = dataPage.readByte();
        int n2 = dataPage.readByte();
        if (n2 != 0) {
            throw Message.getSQLException(90048, this.fileName);
        }
        if (n != 0) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, "close");
            }
            this.accessMode = "r";
            this.file = this.database.openFile(this.fileName, this.accessMode, true);
        }
        this.systemRootPageId = dataPage.readInt();
        this.freeListRootPageId = dataPage.readInt();
        this.logRootPageId = dataPage.readInt();
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setPageSize(int n) throws SQLException {
        if (n < 512 || n > 32768) {
            throw Message.getSQLException(90030, this.fileName);
        }
        boolean bl = false;
        int n2 = 0;
        for (int i = 1; i <= n; i += i) {
            if (n == i) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw Message.getSQLException(90030, this.fileName);
        }
        this.pageSize = n;
        this.pageSizeShift = n2;
    }

    private void writeHeader() throws SQLException {
        DataPage dataPage = DataPage.create((DataHandler)this.database, new byte[this.pageSize - 48]);
        dataPage.writeInt(this.pageSize);
        dataPage.writeByte((byte)0);
        dataPage.writeByte((byte)0);
        dataPage.writeInt(this.systemRootPageId);
        dataPage.writeInt(this.freeListRootPageId);
        dataPage.writeInt(this.logRootPageId);
        this.file.seek(48L);
        this.file.write(dataPage.getBytes(), 0, this.pageSize - 48);
    }

    public void close() throws SQLException {
        try {
            this.trace.debug("close");
            if (this.file != null) {
                this.file.close();
            }
            this.file = null;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "close");
        }
    }

    public void flushLog() throws SQLException {
    }

    public Trace getTrace() {
        return this.trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBack(CacheObject cacheObject) throws SQLException {
        Database database = this.database;
        synchronized (database) {
            Record record = (Record)cacheObject;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("writeBack " + record.getPos() + ":" + record);
            }
            record.write(null);
            record.setChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(Record record, DataPage dataPage) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("updateRecord " + record.getPos() + " " + record.toString());
        }
        Database database = this.database;
        synchronized (database) {
            record.setChanged(true);
            int n = record.getPos();
            this.cache.update(n, record);
            if (dataPage != null) {
                this.log.addUndo(record.getPos(), dataPage);
            }
        }
    }

    public int allocatePage() throws SQLException {
        return this.allocatePage(false);
    }

    public int allocatePage(boolean bl) throws SQLException {
        if (this.freePageCount > 0 && !bl) {
            PageFreeList pageFreeList;
            if (this.freeListRootPageId == 0) {
                Message.throwInternalError();
            }
            if ((pageFreeList = (PageFreeList)this.cache.find(this.freeListRootPageId)) == null) {
                pageFreeList = new PageFreeList(this, this.freeListRootPageId, 0);
                pageFreeList.read();
            }
            int n = pageFreeList.allocate();
            --this.freePageCount;
            return n;
        }
        if (this.lastUsedPage >= this.pageCount) {
            this.increaseFileSize(128);
        }
        return ++this.lastUsedPage;
    }

    private void increaseFileSize(int n) throws SQLException {
        this.pageCount += n;
        long l = this.pageCount * this.pageSize;
        this.file.setLength(l);
        this.fileLength = l;
    }

    public void freePage(int n) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("freePage " + n);
        }
        ++this.freePageCount;
        this.cache.remove(n);
        PageFreeList pageFreeList = (PageFreeList)this.cache.find(this.freeListRootPageId);
        if (pageFreeList == null) {
            pageFreeList = new PageFreeList(this, this.freeListRootPageId, 0);
            pageFreeList.read();
        }
        pageFreeList.free(n);
    }

    public DataPage createDataPage() {
        return DataPage.create((DataHandler)this.database, new byte[this.pageSize]);
    }

    public Record getRecord(int n) {
        CacheObject cacheObject = this.cache.find(n);
        return (Record)cacheObject;
    }

    public DataPage readPage(int n) throws SQLException {
        DataPage dataPage = this.createDataPage();
        this.readPage(n, dataPage);
        return dataPage;
    }

    public void readPage(int n, DataPage dataPage) throws SQLException {
        if (n >= this.pageCount) {
            throw Message.getSQLException(90030, n + " of " + this.pageCount);
        }
        this.file.seek(n << this.pageSizeShift);
        this.file.readFully(dataPage.getBytes(), 0, this.pageSize);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void writePage(int n, DataPage dataPage) throws SQLException {
        this.file.seek(n << this.pageSizeShift);
        this.file.write(dataPage.getBytes(), 0, this.pageSize);
    }

    public void removeRecord(int n) {
        this.cache.remove(n);
    }

    void setFreeListRootPage(int n, boolean bl, int n2) throws SQLException {
        this.freeListRootPageId = n;
        if (!bl) {
            PageFreeList pageFreeList = new PageFreeList(this, n, n2);
            this.updateRecord(pageFreeList, null);
        }
    }

    public int getSystemRootPageId() {
        return this.systemRootPageId;
    }

    public PageLog getLog() {
        return this.log;
    }

    Database getDatabase() {
        return this.database;
    }
}

