# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2008-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Guido Amoruso <guidonte@fluendo.com>

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, build_po


packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)


setup(name='elisa-plugin-rss',
    version='0.7',
    description='RSS 2.0 reader',
    long_description='Browse and play RSS stories.',
    license='GPLv3',
    author='Moovida Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    install_requires=['elisa-plugin-base', 'elisa-plugin-poblesec'],
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    cmdclass=cmdclass,
    controller_mappings=[('/poblesec/rss_reader',
                          'elisa.plugins.rss.controller:RssReaderListSwitcherController'),
                         ],
)
