/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant.taskdefs;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.tools.ant.BuildException;
import org.apache.webdav.ant.CollectionScanner;
import org.apache.webdav.ant.Utils;
import org.apache.webdav.ant.WebdavFileSet;
import org.apache.webdav.ant.taskdefs.WebdavMatchingTask;
import org.apache.webdav.lib.methods.DeleteMethod;

public class Delete
extends WebdavMatchingTask {
    private String locktoken = null;
    private int count = 0;

    public void execute() throws BuildException {
        try {
            if (!this.getFileSets().hasNext()) {
                this.log("Deleting: " + this.getUrl(), 2);
                this.delete(this.getUrl(), this.getUrl().getURI());
            } else {
                this.log("Deleting at: " + this.getUrl(), this.ifVerbose());
                if (!this.getUrl().getPath().endsWith("/")) {
                    this.getUrl().setPath(this.getUrl().getPath() + "/");
                }
                Iterator i = this.getFileSets();
                while (i.hasNext()) {
                    this.deleteFileset((WebdavFileSet)i.next());
                }
                this.log("Deleted " + this.count + (this.count == 1 ? " resource" : " resources") + " from " + this.getUrl(), this.count > 0 ? 2 : this.ifVerbose());
            }
        }
        catch (IOException e) {
            throw Utils.makeBuildException("Can't delete!", e);
        }
    }

    private void delete(HttpURL url, String logName) throws IOException, HttpException {
        this.validate();
        this.log("Deleting " + logName, this.ifVerbose());
        DeleteMethod delete = new DeleteMethod(url.getURI());
        delete.setFollowRedirects(true);
        if (this.locktoken != null) {
            Utils.generateIfHeader((HttpMethod)delete, this.locktoken);
        }
        int status = this.getHttpClient().executeMethod((HttpMethod)delete);
        switch (status) {
            case 200: 
            case 204: 
            case 404: {
                ++this.count;
                break;
            }
            default: {
                HttpException ex = new HttpException();
                ex.setReasonCode(status);
                throw ex;
            }
        }
    }

    private void deleteFileset(WebdavFileSet fileSet) throws IOException, HttpException {
        CollectionScanner scanner = fileSet.getCollectionScanner(this.getProject(), this.getHttpClient(), this.getUrl());
        HttpURL baseUrl = scanner.getBaseURL();
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            HttpURL url = Utils.createHttpURL(baseUrl, files[i]);
            this.delete(url, files[i]);
        }
        String[] colls = scanner.getIncludedDirectories();
        for (int i = 0; i < colls.length; ++i) {
            HttpURL url = Utils.createHttpURL(baseUrl, colls[i]);
            this.delete(url, colls[i]);
        }
    }

    public void setLocktoken(String token) {
        this.locktoken = token;
        if (!this.locktoken.startsWith("opaquelocktoken:")) {
            throw new BuildException("Invalid locktoken: " + token);
        }
    }
}

