/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.XMLParseException;

public class XMLEntityResolver
implements IXMLEntityResolver {
    private Hashtable entities = new Hashtable();

    public XMLEntityResolver() {
        this.entities.put("amp", "&#38;#38;");
        this.entities.put("quot", "&#38;#34;");
        this.entities.put("apos", "&#38;#39;");
        this.entities.put("lt", "&#38;#60;");
        this.entities.put("gt", "&#38;#62;");
    }

    protected void finalize() throws Throwable {
        this.entities.clear();
        this.entities = null;
        super.finalize();
    }

    public void addInternalEntity(String name, String value) {
        if (!this.entities.containsKey(name)) {
            this.entities.put(name, value);
        }
    }

    public void addExternalEntity(String name, String publicID, String systemID) {
        if (!this.entities.containsKey(name)) {
            this.entities.put(name, new String[]{publicID, systemID});
        }
    }

    public Reader getEntity(IXMLReader xmlReader, String name) throws XMLParseException {
        Object obj = this.entities.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return new StringReader((String)obj);
        }
        String[] id = (String[])obj;
        return this.openExternalEntity(xmlReader, id[0], id[1]);
    }

    protected Reader openExternalEntity(IXMLReader xmlReader, String publicID, String systemID) throws XMLParseException {
        try {
            return xmlReader.openStream(publicID, systemID);
        }
        catch (Exception e) {
            throw new XMLParseException(xmlReader.getSystemID(), xmlReader.getLineNr(), "Could not open external entity at system ID: " + systemID);
        }
    }
}

