/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.api.SamplingData;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReader;
import org.netbeans.modules.dlight.procfs.reader.impl.DataModel;
import org.netbeans.modules.dlight.procfs.reader.impl.DataReader;
import org.netbeans.modules.dlight.procfs.reader.impl.MSAInfoImpl;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessStatusProvider;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessUsageProvider;
import org.netbeans.modules.dlight.procfs.reader.impl.ReusableByteBuffer;
import org.netbeans.modules.dlight.procfs.reader.impl.ThreadsInfoProvider;

public abstract class ProcReaderImpl
implements ProcReader,
ProcessStatusProvider,
ProcessUsageProvider,
ThreadsInfoProvider {
    private static final int MAXFILELENGTH = 512;
    private final HashMap<Integer, MSAInfoImpl> prevMSAData = new HashMap();
    private final HashMap<Integer, Long> prevTSData = new HashMap();
    private final ReusableByteBuffer buffer = new ReusableByteBuffer(512, 10);
    protected final ByteOrder byteOrder;
    protected final DataModel dataModel;

    public ProcReaderImpl(ByteOrder byteOrder, DataModel dataModel) {
        this.byteOrder = byteOrder;
        this.dataModel = dataModel;
    }

    @Override
    public abstract PStatus getProcessStatus();

    @Override
    public abstract PUsage getProcessUsage() throws IOException;

    @Override
    public abstract List<LWPUsage> getThreadsInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PStatus getProcessStatus(InputStream is) throws IOException {
        DataReader reader = null;
        try {
            reader = this.newReader(is);
            reader.seek(4);
            int nlwp = reader._int();
            reader.seek(8);
            int pid = reader._int();
            reader.seek(268);
            int nzomb = reader._int();
            final PStatus.ThreadsInfo ti = new PStatus.ThreadsInfo(nlwp, nzomb){};
            final PStatus.PIDInfo pi = new PStatus.PIDInfo(pid){};
            PStatus pStatus = new PStatus(){

                @Override
                public PStatus.ThreadsInfo getThreadInfo() {
                    return ti;
                }

                @Override
                public PStatus.PIDInfo getPIDInfo() {
                    return pi;
                }
            };
            return pStatus;
        }
        finally {
            if (reader != null) {
                reader.releaseBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LWPUsage getProcessUsage(InputStream is) throws IOException {
        DataReader reader = null;
        try {
            reader = this.newReader(is, 256);
            reader.seek(0);
            int lwpid = reader._int();
            int count = reader._int();
            long timestamp = reader._time();
            long create = reader._time();
            long term = reader._time();
            long rtime = reader._time();
            final PUsage.UsageInfo ui = new PUsage.UsageInfo(lwpid, count, timestamp, create, term, rtime){};
            MSAInfoImpl prevMSAInfo = this.prevMSAData.containsKey(lwpid) ? this.prevMSAData.get(lwpid) : MSAInfoImpl.nullInfo;
            long ts = this.prevTSData.containsKey(lwpid) ? this.prevTSData.get(lwpid) : create;
            long sample = timestamp - ts;
            this.prevTSData.put(lwpid, timestamp);
            final SamplingData sd = new SamplingData(ts, sample);
            long utime = reader._time();
            long stime = reader._time();
            long ttime = reader._time();
            long tftime = reader._time();
            long dftime = reader._time();
            long kftime = reader._time();
            long ltime = reader._time();
            long slptime = reader._time();
            long wtime = reader._time();
            long stoptime = reader._time();
            final MSAInfoImpl mi = new MSAInfoImpl(prevMSAInfo, utime, stime, ttime, tftime, dftime, kftime, ltime, slptime, wtime, stoptime);
            this.prevMSAData.put(lwpid, mi);
            LWPUsage lWPUsage = new LWPUsage(){

                @Override
                public SamplingData getSamplingData() {
                    return sd;
                }

                @Override
                public PUsage.UsageInfo getUsageInfo() {
                    return ui;
                }

                @Override
                public PUsage.MSAInfo getMSAInfo() {
                    return mi;
                }
            };
            return lWPUsage;
        }
        finally {
            if (reader != null) {
                reader.releaseBuffer();
            }
        }
    }

    protected List<LWPUsage> getThreadsInfo(InputStream is) throws IOException {
        return null;
    }

    private DataReader newReader(InputStream is) throws IOException {
        return this.newReader(is, 512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataReader newReader(InputStream is, int limit) throws IOException {
        limit = Math.min(limit, 512);
        int offset = 0;
        try {
            offset = this.buffer.getAndLockOffset();
            int read = 0;
            for (int read_total = 0; read >= 0 && read_total < limit; read_total += read) {
                read = is.read(this.buffer.buffer, offset + read_total, limit - read_total);
            }
        }
        finally {
            is.close();
        }
        return new DataReader(this.buffer, offset, this.byteOrder);
    }
}

