/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.LoginHandleImpl;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.dashboard.CategoryNode;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.EmptyNode;
import org.netbeans.modules.kenai.ui.dashboard.ErrorNode;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.dashboard.MyProjectNode;
import org.netbeans.modules.kenai.ui.dashboard.ProjectNode;
import org.netbeans.modules.kenai.ui.dashboard.UserNode;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.LoginHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeList;
import org.netbeans.modules.kenai.ui.treelist.TreeListModel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public final class DashboardImpl
extends Dashboard {
    public static final String PREF_ALL_PROJECTS = "allProjects";
    public static final String PREF_COUNT = "count";
    public static final String PREF_ID = "id";
    private LoginHandle login;
    private final TreeListModel model = new TreeListModel();
    private static final ListModel EMPTY_MODEL = new AbstractListModel(){

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            return null;
        }
    };
    private RequestProcessor requestProcessor = new RequestProcessor("Kenai Dashboard");
    private final TreeList treeList = new TreeList(this.model);
    private final ArrayList<ProjectHandle> memberProjects = new ArrayList(50);
    private final ArrayList<ProjectHandle> openProjects = new ArrayList(50);
    public final JScrollPane dashboardComponent;
    private final PropertyChangeListener userListener;
    private boolean opened = false;
    private boolean memberProjectsLoaded = false;
    private boolean otherProjectsLoaded = false;
    private static final long TIMEOUT_INTERVAL_MILLIS = TreeListNode.TIMEOUT_INTERVAL_MILLIS;
    private OtherProjectsLoader otherProjectsLoader;
    private MemberProjectsLoader memberProjectsLoader;
    private final UserNode userNode;
    private final ErrorNode memberProjectsError;
    private final ErrorNode otherProjectsError;
    private final CategoryNode openProjectsNode;
    private final CategoryNode myProjectsNode;
    private final EmptyNode noOpenProjects = new EmptyNode(this, NbBundle.getMessage(DashboardImpl.class, (String)"NO_PROJECTS_OPEN"), NbBundle.getMessage(DashboardImpl.class, (String)"LBL_OpeningProjects"));
    private final EmptyNode noMyProjects = new EmptyNode(this, NbBundle.getMessage(DashboardImpl.class, (String)"NO_MY_PROJECTS"), NbBundle.getMessage(DashboardImpl.class, (String)"LBL_OpeningMyProjects"));
    private final Object LOCK = new Object();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private Kenai kenai = Utilities.getPreferredKenai();
    private PropertyChangeListener kenaiListener;

    private DashboardImpl() {
        this.dashboardComponent = new JScrollPane(){

            @Override
            public void requestFocus() {
                Component view = this.getViewport().getView();
                if (view != null) {
                    view.requestFocus();
                } else {
                    super.requestFocus();
                }
            }

            @Override
            public boolean requestFocusInWindow() {
                Component view = this.getViewport().getView();
                return view != null ? view.requestFocusInWindow() : super.requestFocusInWindow();
            }
        };
        this.dashboardComponent.setBorder(BorderFactory.createEmptyBorder());
        this.dashboardComponent.setBackground(ColorManager.getDefault().getDefaultBackground());
        this.dashboardComponent.getViewport().setBackground(ColorManager.getDefault().getDefaultBackground());
        this.userListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("memberProjects".equals(evt.getPropertyName())) {
                    DashboardImpl.this.refreshMemberProjects(true);
                }
            }
        };
        this.userNode = new UserNode(this);
        this.model.addRoot(-1, this.userNode);
        this.openProjectsNode = new CategoryNode(this, NbBundle.getMessage(CategoryNode.class, (String)"LBL_OpenProjects"), null);
        this.model.addRoot(-1, this.openProjectsNode);
        this.model.addRoot(-1, this.noOpenProjects);
        this.myProjectsNode = new CategoryNode(this, NbBundle.getMessage(CategoryNode.class, (String)"LBL_MyProjects"), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/bookmark.png", (boolean)true));
        if (this.login != null) {
            if (!this.model.getRootNodes().contains(this.myProjectsNode)) {
                this.model.addRoot(-1, this.myProjectsNode);
            }
            if (!this.model.getRootNodes().contains(this.noMyProjects)) {
                this.model.addRoot(-1, this.noMyProjects);
            }
        }
        this.memberProjectsError = new ErrorNode(NbBundle.getMessage(DashboardImpl.class, (String)"ERR_OpenMemberProjects"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardImpl.this.clearError(DashboardImpl.this.memberProjectsError);
                DashboardImpl.this.refreshMemberProjects(true);
            }
        });
        this.otherProjectsError = new ErrorNode(NbBundle.getMessage(DashboardImpl.class, (String)"ERR_OpenProjects"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DashboardImpl.this.clearError(DashboardImpl.this.otherProjectsError);
                DashboardImpl.this.refreshProjects();
            }
        });
        AccessibleContext accessibleContext = this.treeList.getAccessibleContext();
        String a11y = NbBundle.getMessage(DashboardImpl.class, (String)"A11Y_TeamProjects");
        accessibleContext.setAccessibleName(a11y);
        accessibleContext.setAccessibleDescription(a11y);
        this.setKenai(this.kenai);
    }

    @Override
    public Kenai getKenai() {
        return this.kenai;
    }

    public static DashboardImpl getInstance() {
        return Holder.theInstance;
    }

    @Override
    public ProjectHandle[] getOpenProjects() {
        TreeSet<ProjectHandle> s = new TreeSet<ProjectHandle>();
        s.addAll(this.openProjects);
        s.addAll(this.memberProjects);
        return s.toArray(new ProjectHandle[s.size()]);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isMemberProject(ProjectHandle m) {
        return this.memberProjects.contains(m);
    }

    public void setKenai(Kenai kenai) {
        PasswordAuthentication newValue;
        this.kenai = kenai;
        PasswordAuthentication passwordAuthentication = newValue = kenai != null ? kenai.getPasswordAuthentication() : null;
        if (newValue == null) {
            this.setUser(null);
        } else {
            this.setUser(new LoginHandleImpl(newValue.getUserName()));
        }
        this.refreshNonMemberProjects();
        if (kenai == null) {
            return;
        }
        this.kenaiListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if ("login".equals(pce.getPropertyName())) {
                    PasswordAuthentication newValue = (PasswordAuthentication)pce.getNewValue();
                    if (newValue == null) {
                        DashboardImpl.this.setUser(null);
                    } else {
                        DashboardImpl.this.setUser(new LoginHandleImpl(newValue.getUserName()));
                    }
                    DashboardImpl.this.loggingFinished();
                } else if ("login_started".equals(pce.getPropertyName())) {
                    DashboardImpl.this.loggingStarted();
                } else if ("login_failed".equals(pce.getPropertyName())) {
                    DashboardImpl.this.loggingFinished();
                } else if ("xmpp_login_started".equals(pce.getPropertyName())) {
                    DashboardImpl.this.xmppStarted();
                } else if ("xmpp_login".equals(pce.getPropertyName())) {
                    DashboardImpl.this.xmppFinsihed();
                } else if ("xmpp_login_failed".equals(pce.getPropertyName())) {
                    DashboardImpl.this.xmppFinsihed();
                }
            }
        };
        kenai.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.kenaiListener, (Object)kenai));
        KenaiConnection.getDefault(kenai).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("xmpp_started".equals(evt.getPropertyName())) {
                    DashboardImpl.this.xmppStarted();
                } else if ("xmpp_finished".equals(evt.getPropertyName())) {
                    DashboardImpl.this.xmppFinsihed();
                }
            }
        });
        PasswordAuthentication pa = kenai.getPasswordAuthentication();
        this.login = pa == null ? null : new LoginHandleImpl(pa.getUserName());
        this.userNode.set(this.login, false);
    }

    public void selectAndExpand(KenaiProject project) {
        for (TreeListNode n : this.model.getRootNodes()) {
            if (!(n instanceof ProjectNode) || !((ProjectNode)n).getProject().getId().equals(project.getName())) continue;
            this.treeList.setSelectedValue(n, true);
            n.setExpanded(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUser(LoginHandle login) {
        Object object = this.LOCK;
        synchronized (object) {
            if (null != this.login) {
                this.login.removePropertyChangeListener(this.userListener);
            }
            this.login = login;
            if (login == null) {
                Iterator<ProjectHandle> ph = this.openProjects.iterator();
                while (ph.hasNext()) {
                    ProjectHandle next = ph.next();
                    if (!next.isPrivate()) continue;
                    this.removeProjectsFromModel(Collections.singletonList(next));
                    ph.remove();
                }
                this.removeMemberProjectsFromModel(this.memberProjects);
                this.memberProjects.clear();
                this.model.removeRoot(this.myProjectsNode);
                this.model.removeRoot(this.noMyProjects);
            } else {
                if (!this.model.getRootNodes().contains(this.myProjectsNode)) {
                    this.model.addRoot(-1, this.myProjectsNode);
                }
                if (!this.model.getRootNodes().contains(this.noMyProjects)) {
                    this.model.addRoot(-1, this.noMyProjects);
                }
            }
            this.memberProjectsLoaded = false;
            this.userNode.set(login, !this.openProjects.isEmpty());
            if (this.isOpened()) {
                if (null != login) {
                    this.startLoadingMemberProjects(false);
                }
                this.switchContent();
            }
            if (null != this.login) {
                this.login.addPropertyChangeListener(this.userListener);
            }
        }
    }

    @Override
    public void addProject(final ProjectHandle project, final boolean isMemberProject, final boolean select) {
        if (project.getKenaiProject().getKenai() != this.kenai) {
            KenaiTopComponent.findInstance().setSelectedKenai(project.getKenaiProject().getKenai());
        }
        this.requestProcessor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = DashboardImpl.this.LOCK;
                synchronized (object) {
                    Runnable selectAndExpand = new Runnable(){

                        @Override
                        public void run() {
                            DashboardImpl.this.selectAndExpand(((ProjectHandleImpl)project).getKenaiProject());
                        }
                    };
                    if (DashboardImpl.this.openProjects.contains(project)) {
                        if (select) {
                            SwingUtilities.invokeLater(selectAndExpand);
                        }
                        return;
                    }
                    if (isMemberProject && DashboardImpl.this.memberProjectsLoaded && !DashboardImpl.this.memberProjects.contains(project)) {
                        DashboardImpl.this.memberProjects.add(project);
                        DashboardImpl.this.setMemberProjects(new ArrayList(DashboardImpl.this.memberProjects));
                    }
                    DashboardImpl.this.openProjects.add(project);
                    DashboardImpl.this.storeAllProjects();
                    DashboardImpl.this.setOtherProjects(new ArrayList(DashboardImpl.this.openProjects));
                    DashboardImpl.this.userNode.set(DashboardImpl.this.login, !DashboardImpl.this.openProjects.isEmpty());
                    DashboardImpl.this.switchMemberProjects();
                    if (DashboardImpl.this.isOpened()) {
                        DashboardImpl.this.switchContent();
                        if (select) {
                            SwingUtilities.invokeLater(selectAndExpand);
                        }
                    }
                }
                DashboardImpl.this.changeSupport.firePropertyChange("openedProjects", null, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProject(ProjectHandle project) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.openProjects.contains(project)) {
                return;
            }
            this.openProjects.remove(project);
            this.storeAllProjects();
            ArrayList<ProjectHandle> tmp = new ArrayList<ProjectHandle>(1);
            tmp.add(project);
            this.removeProjectsFromModel(tmp);
            if (this.isOpened()) {
                this.switchContent();
            }
        }
        project.firePropertyChange("close", null, null);
        this.changeSupport.firePropertyChange("openedProjects", null, null);
    }

    Action createLoginAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtils.showLogin(DashboardImpl.this.kenai);
            }
        };
    }

    private Action createWhatIsKenaiAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(NbBundle.getMessage(DashboardImpl.class, (String)"URL_KenaiOverview")));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
    }

    boolean isOpened() {
        return this.opened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshProjects() {
        this.myProjectLoadingStarted();
        this.projectLoadingStarted();
        this.changeSupport.firePropertyChange("refreshRequest", null, null);
        Object object = this.LOCK;
        synchronized (object) {
            this.removeMemberProjectsFromModel(this.memberProjects);
            this.memberProjects.clear();
            this.memberProjectsLoaded = false;
            this.removeProjectsFromModel(this.openProjects);
            this.openProjects.clear();
            this.otherProjectsLoaded = false;
            if (this.isOpened()) {
                this.startLoadingAllProjects(true);
                this.startLoadingMemberProjects(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNonMemberProjects() {
        Object object = this.LOCK;
        synchronized (object) {
            this.removeProjectsFromModel(this.openProjects);
            this.openProjects.clear();
            this.otherProjectsLoaded = false;
            if (this.isOpened()) {
                this.startLoadingAllProjects(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMemberProjects(boolean force) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!force) {
                this.removeMemberProjectsFromModel(this.memberProjects);
            }
            this.memberProjects.clear();
            this.memberProjectsLoaded = false;
            if (this.isOpened()) {
                this.startLoadingMemberProjects(force);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.LOCK;
        synchronized (object) {
            this.treeList.setModel(EMPTY_MODEL);
            this.model.clear();
            this.opened = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent getComponent() {
        Object object = this.LOCK;
        synchronized (object) {
            this.opened = true;
            this.requestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    UIUtils.waitStartupFinished();
                    DashboardImpl.this.myProjectLoadingStarted();
                    DashboardImpl.this.projectLoadingStarted();
                    if (null != DashboardImpl.this.login && !DashboardImpl.this.memberProjectsLoaded) {
                        DashboardImpl.this.startLoadingMemberProjects(false);
                    }
                    if (!DashboardImpl.this.otherProjectsLoaded) {
                        DashboardImpl.this.startLoadingAllProjects(false);
                    }
                }
            });
            this.switchContent();
        }
        return this.dashboardComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillModel() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.model.getRootNodes().contains(this.userNode)) {
                this.model.addRoot(0, this.userNode);
                this.model.addRoot(1, this.openProjectsNode);
                if (this.login != null && !this.model.getRootNodes().contains(this.myProjectsNode)) {
                    this.model.addRoot(-1, this.myProjectsNode);
                }
            }
            if (this.login != null ? this.model.getSize() > 3 : this.model.getSize() > 2) {
                return;
            }
            this.addProjectsToModel(-1, this.openProjects);
            this.addMemberProjectsToModel(-1, this.memberProjects);
        }
    }

    private void switchContent() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean isTreeListShowing;
                boolean isEmpty = true;
                Object object = DashboardImpl.this.LOCK;
                synchronized (object) {
                    isEmpty = null == DashboardImpl.this.login && DashboardImpl.this.openProjects.isEmpty();
                }
                boolean bl = isTreeListShowing = DashboardImpl.this.dashboardComponent.getViewport().getView() == DashboardImpl.this.treeList;
                if (isEmpty) {
                    if (isTreeListShowing || DashboardImpl.this.dashboardComponent.getViewport().getView() == null) {
                        DashboardImpl.this.dashboardComponent.setViewportView(DashboardImpl.this.createEmptyContent());
                        DashboardImpl.this.dashboardComponent.invalidate();
                        DashboardImpl.this.dashboardComponent.revalidate();
                        DashboardImpl.this.dashboardComponent.repaint();
                    }
                } else {
                    DashboardImpl.this.fillModel();
                    DashboardImpl.this.treeList.setModel(DashboardImpl.this.model);
                    DashboardImpl.this.switchMemberProjects();
                    if (!isTreeListShowing) {
                        DashboardImpl.this.dashboardComponent.setViewportView(DashboardImpl.this.treeList);
                        DashboardImpl.this.dashboardComponent.invalidate();
                        DashboardImpl.this.dashboardComponent.revalidate();
                        DashboardImpl.this.dashboardComponent.repaint();
                        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, DashboardImpl.this.dashboardComponent);
                        if (tc != null && TopComponent.getRegistry().getActivated() == tc) {
                            DashboardImpl.this.treeList.requestFocus();
                        }
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private JComponent createEmptyContent() {
        JPanel res = new JPanel(new GridBagLayout());
        res.setOpaque(false);
        TreeLabel lbl = new TreeLabel(NbBundle.getMessage(DashboardImpl.class, (String)"LBL_No_Kenai_Project_Open"));
        lbl.setForeground(ColorManager.getDefault().getDisabledColor());
        lbl.setHorizontalAlignment(0);
        LinkButton btnWhatIs = new LinkButton(NbBundle.getMessage(DashboardImpl.class, (String)"LBL_WhatIsKenai"), this.createWhatIsKenaiAction());
        this.model.removeRoot(this.userNode);
        this.model.removeRoot(this.myProjectsNode);
        this.model.removeRoot(this.openProjectsNode);
        this.userNode.set(null, false);
        res.add((Component)this.userNode.getComponent(UIManager.getColor("List.foreground"), ColorManager.getDefault().getDefaultBackground(), false, false), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 4, 3, 4), 0, 0));
        res.add((Component)new JLabel(), new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        res.add((Component)lbl, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 4, 0), 0, 0));
        res.add((Component)btnWhatIs, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(4, 0, 0, 0), 0, 0));
        res.add((Component)new JLabel(), new GridBagConstraints(0, 4, 3, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadingAllProjects(boolean forceRefresh) {
        if (this.kenai == null) {
            return;
        }
        String kenaiName = this.kenai.getUrl().getHost();
        Preferences prefs = NbPreferences.forModule(DashboardImpl.class).node(PREF_ALL_PROJECTS + ("kenai.com".equals(kenaiName) ? "" : "-" + kenaiName));
        int count = prefs.getInt(PREF_COUNT, 0);
        if (0 == count) {
            this.projectLoadingFinished();
            return;
        }
        ArrayList<String> ids = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String id = prefs.get(PREF_ID + i, null);
            if (null == id || id.trim().length() <= 0) continue;
            ids.add(id.trim());
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.otherProjectsLoader != null) {
                this.otherProjectsLoader.cancel();
            }
            if (ids.isEmpty()) {
                this.projectLoadingFinished();
                return;
            }
            this.otherProjectsLoader = new OtherProjectsLoader(ids, forceRefresh);
            this.requestProcessor.post((Runnable)this.otherProjectsLoader);
        }
    }

    private void storeAllProjects() {
        String kenaiName = this.kenai.getUrl().getHost();
        Preferences prefs = NbPreferences.forModule(DashboardImpl.class).node(PREF_ALL_PROJECTS + ("kenai.com".equals(kenaiName) ? "" : "-" + kenaiName));
        int index = 0;
        for (ProjectHandle project : this.openProjects) {
            prefs.put(PREF_ID + index++, project.getId());
        }
        prefs.putInt(PREF_COUNT, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOtherProjects(ArrayList<ProjectHandle> projects) {
        Object object = this.LOCK;
        synchronized (object) {
            this.removeProjectsFromModel(this.openProjects);
            if (!projects.isEmpty()) {
                this.model.removeRoot(this.noOpenProjects);
            }
            this.openProjects.clear();
            for (ProjectHandle p : projects) {
                if (this.openProjects.contains(p)) continue;
                this.openProjects.add(p);
            }
            Collections.sort(this.openProjects);
            this.otherProjectsLoaded = true;
            this.addProjectsToModel(-1, this.openProjects);
            this.userNode.set(this.login, !this.openProjects.isEmpty());
            this.storeAllProjects();
            this.switchMemberProjects();
            if (this.isOpened()) {
                this.switchContent();
            }
        }
        this.changeSupport.firePropertyChange("openedProjects", null, null);
    }

    private void switchMemberProjects() {
        for (TreeListNode n : this.model.getRootNodes()) {
            if (!(n instanceof ProjectNode)) continue;
            ProjectNode pn = (ProjectNode)n;
            pn.setMemberProject(this.memberProjects.contains(pn.getProject()));
        }
    }

    public void bookmarkingStarted() {
        this.userNode.loadingStarted(NbBundle.getMessage(UserNode.class, (String)"LBL_Bookmarking"));
    }

    public void bookmarkingFinished() {
        this.userNode.loadingFinished();
    }

    public void deletingStarted() {
        this.userNode.loadingStarted(NbBundle.getMessage(UserNode.class, (String)"LBL_Deleting"));
    }

    public void deletingFinished() {
        this.userNode.loadingFinished();
    }

    private void loggingStarted() {
        this.userNode.loadingStarted(NbBundle.getMessage(UserNode.class, (String)"LBL_Authenticating"));
    }

    private void loggingFinished() {
        this.userNode.loadingFinished();
    }

    private void xmppStarted() {
        this.userNode.loadingStarted(NbBundle.getMessage(UserNode.class, (String)"LBL_ConnectingXMPP"));
    }

    private void xmppFinsihed() {
        this.userNode.loadingFinished();
    }

    private void projectLoadingStarted() {
        this.noOpenProjects.loadingStarted();
    }

    private void projectLoadingFinished() {
        this.noOpenProjects.loadingFinished();
    }

    private void myProjectLoadingStarted() {
        this.noMyProjects.loadingStarted();
    }

    private void myProjectLoadingFinished() {
        this.noMyProjects.loadingFinished();
    }

    void myProjectsProgressStarted() {
        this.userNode.loadingStarted(NbBundle.getMessage(UserNode.class, (String)"LBL_LoadingIssues"));
    }

    void myProjectsProgressFinished() {
        this.userNode.loadingFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadingMemberProjects(boolean forceRefresh) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.memberProjectsLoader != null) {
                this.memberProjectsLoader.cancel();
            }
            if (null == this.login) {
                return;
            }
            this.memberProjectsLoader = new MemberProjectsLoader(this.login, forceRefresh);
            this.requestProcessor.post((Runnable)this.memberProjectsLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMemberProjects(ArrayList<ProjectHandle> projects) {
        Object object = this.LOCK;
        synchronized (object) {
            if (projects.isEmpty() && this.isOpened()) {
                this.switchContent();
            }
            this.removeMemberProjectsFromModel(this.memberProjects);
            if (!projects.isEmpty()) {
                this.model.removeRoot(this.noMyProjects);
            }
            this.memberProjects.clear();
            this.memberProjects.addAll(projects);
            this.memberProjectsLoaded = true;
            for (ProjectHandle p : projects) {
                if (this.memberProjects.contains(p)) continue;
                this.memberProjects.add(p);
            }
            Collections.sort(this.memberProjects);
            this.addMemberProjectsToModel(-1, this.memberProjects);
            this.userNode.set(this.login, !this.memberProjects.isEmpty());
            this.switchMemberProjects();
            if (this.isOpened()) {
                this.switchContent();
            }
        }
        this.changeSupport.firePropertyChange("openedProjects", null, null);
    }

    private void addProjectsToModel(int index, List<ProjectHandle> projects) {
        int counter = 2;
        for (ProjectHandle p : projects) {
            this.model.addRoot(counter++, new ProjectNode(p));
        }
    }

    private void addMemberProjectsToModel(int index, List<ProjectHandle> projects) {
        for (ProjectHandle p : projects) {
            this.model.addRoot(index, new MyProjectNode(p));
        }
    }

    private void removeProjectsFromModel(List<ProjectHandle> projects) {
        ArrayList<TreeListNode> nodesToRemove = new ArrayList<TreeListNode>(projects.size());
        int i = 0;
        for (TreeListNode root : this.model.getRootNodes()) {
            if (!(root instanceof ProjectNode)) continue;
            ProjectNode pn = (ProjectNode)root;
            ++i;
            if (!projects.contains(pn.getProject())) continue;
            nodesToRemove.add(root);
        }
        for (TreeListNode node : nodesToRemove) {
            this.model.removeRoot(node);
        }
        if (i == projects.size() && !this.model.getRootNodes().contains(this.noOpenProjects)) {
            this.model.addRoot(2, this.noOpenProjects);
        }
    }

    private void removeMemberProjectsFromModel(List<ProjectHandle> projects) {
        ArrayList<TreeListNode> nodesToRemove = new ArrayList<TreeListNode>(projects.size());
        int i = 0;
        for (TreeListNode root : this.model.getRootNodes()) {
            if (!(root instanceof MyProjectNode)) continue;
            MyProjectNode pn = (MyProjectNode)root;
            ++i;
            if (!projects.contains(pn.getProject())) continue;
            nodesToRemove.add(root);
        }
        for (TreeListNode node : nodesToRemove) {
            this.model.removeRoot(node);
        }
        if (i == projects.size() && !this.model.getRootNodes().contains(this.noMyProjects) && this.login != null) {
            this.model.addRoot(-1, this.noMyProjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showError(ErrorNode node) {
        Object object = this.LOCK;
        synchronized (object) {
            List<TreeListNode> roots = this.model.getRootNodes();
            if (!roots.contains(node)) {
                this.model.addRoot(1, node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearError(ErrorNode node) {
        Object object = this.LOCK;
        synchronized (object) {
            this.model.removeRoot(node);
        }
    }

    private class MemberProjectsLoader
    implements Runnable,
    Cancellable {
        private boolean cancelled = false;
        private Thread t = null;
        private final LoginHandle user;
        private boolean forceRefresh;

        public MemberProjectsLoader(LoginHandle login, boolean forceRefresh) {
            this.user = login;
            this.forceRefresh = forceRefresh;
        }

        @Override
        public void run() {
            DashboardImpl.this.myProjectLoadingStarted();
            final ArrayList[] res = new ArrayList[1];
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ProjectAccessor accessor = ProjectAccessor.getDefault();
                    res[0] = new ArrayList<ProjectHandle>(accessor.getMemberProjects(DashboardImpl.this.kenai, MemberProjectsLoader.this.user, MemberProjectsLoader.this.forceRefresh));
                }
            };
            this.t = new Thread(r);
            this.t.start();
            try {
                this.t.join(TIMEOUT_INTERVAL_MILLIS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DashboardImpl.this.myProjectLoadingFinished();
            DashboardImpl.this.myProjectLoadingFinished();
            if (this.cancelled) {
                return;
            }
            if (null == res[0]) {
                DashboardImpl.this.showError(DashboardImpl.this.memberProjectsError);
                return;
            }
            DashboardImpl.this.setMemberProjects(res[0]);
            DashboardImpl.this.clearError(DashboardImpl.this.memberProjectsError);
        }

        public boolean cancel() {
            this.cancelled = true;
            if (null != this.t) {
                this.t.interrupt();
            }
            return true;
        }
    }

    private class OtherProjectsLoader
    implements Runnable,
    Cancellable {
        private boolean cancelled = false;
        private Thread t = null;
        private final ArrayList<String> projectIds;
        private boolean forceRefresh;

        public OtherProjectsLoader(ArrayList<String> projectIds, boolean forceRefresh) {
            this.projectIds = projectIds;
            this.forceRefresh = forceRefresh;
        }

        @Override
        public void run() {
            DashboardImpl.this.projectLoadingStarted();
            final ArrayList[] res = new ArrayList[1];
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ArrayList<ProjectHandle> projects = new ArrayList<ProjectHandle>(OtherProjectsLoader.this.projectIds.size());
                    ProjectAccessor accessor = ProjectAccessor.getDefault();
                    for (String id : OtherProjectsLoader.this.projectIds) {
                        ProjectHandle handle = accessor.getNonMemberProject(DashboardImpl.this.kenai, id, OtherProjectsLoader.this.forceRefresh);
                        if (handle == null) continue;
                        projects.add(handle);
                    }
                    res[0] = projects;
                }
            };
            this.t = new Thread(r);
            this.t.start();
            try {
                this.t.join(TIMEOUT_INTERVAL_MILLIS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DashboardImpl.this.projectLoadingFinished();
            DashboardImpl.this.projectLoadingFinished();
            if (this.cancelled) {
                return;
            }
            if (null == res[0]) {
                DashboardImpl.this.showError(DashboardImpl.this.otherProjectsError);
                return;
            }
            DashboardImpl.this.setOtherProjects(res[0]);
            DashboardImpl.this.clearError(DashboardImpl.this.otherProjectsError);
        }

        public boolean cancel() {
            this.cancelled = true;
            if (null != this.t) {
                this.t.interrupt();
            }
            return true;
        }
    }

    private static class Holder {
        private static final DashboardImpl theInstance = new DashboardImpl();

        private Holder() {
        }
    }
}

