/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspcompiler;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public final class TldAntLogger
extends AntLogger {
    private static final Pattern TLD_ERROR = Pattern.compile("(.*)(org.apache.jasper.JasperException:)(.*)( file )(.*)");
    private static final Pattern FILE_PATTERN = Pattern.compile("([^\\(]*)(: )\\(line ([0-9]+), col ([0-9-]+)\\)");
    private static final String[] TASKS_OF_INTEREST = AntLogger.ALL_TASKS;
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 0};
    private static final Logger ERR = Logger.getLogger(TldAntLogger.class.getName());
    private static final boolean LOGGABLE = ERR.isLoggable(Level.FINE);

    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession antSession) {
        return true;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    public boolean interestedInScript(File file, AntSession antSession) {
        return true;
    }

    public String[] interestedInTasks(AntSession antSession) {
        return TASKS_OF_INTEREST;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent antEvent) {
        AntSession antSession = antEvent.getSession();
        int n = antEvent.getLogLevel();
        int n2 = antSession.getVerbosity();
        String string = antEvent.getMessage();
        assert (string != null);
        Matcher matcher = TLD_ERROR.matcher(string);
        if (matcher.matches()) {
            block14: {
                Matcher matcher2;
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "matched line: " + string);
                }
                String string2 = matcher.group(3) + matcher.group(4);
                antSession.println(matcher.group(2) + string2, true, null);
                String string3 = matcher.group(5).trim();
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "file part: " + string3);
                }
                if ((matcher2 = FILE_PATTERN.matcher(string3)).matches()) {
                    String string4 = matcher2.group(1).trim();
                    if (LOGGABLE) {
                        ERR.log(Level.FINE, "tld file: " + string4);
                    }
                    int n3 = Integer.parseInt(matcher2.group(3));
                    int n4 = Integer.parseInt(matcher2.group(4));
                    if (LOGGABLE) {
                        ERR.log(Level.FINE, "linking line: " + n3 + ", column: " + n4);
                    }
                    File file = antEvent.getScriptLocation();
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
                    if (LOGGABLE) {
                        ERR.log(Level.FINE, "wm: " + webModule);
                    }
                    if (webModule == null) {
                        antSession.println(string4, true, null);
                        antEvent.consume();
                        return;
                    }
                    FileObject fileObject2 = webModule.getDocumentBase().getFileObject(string4);
                    if (LOGGABLE) {
                        ERR.log(Level.FINE, "tldSource: " + fileObject2);
                    }
                    if (fileObject2 == null) {
                        antSession.println(string4, true, null);
                        antEvent.consume();
                        return;
                    }
                    if (n <= n2 && !antEvent.isConsumed()) {
                        try {
                            antSession.println(string4, true, antSession.createStandardHyperlink(fileObject2.getURL(), string2 + string4, n3, n4, -1, -1));
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            if ($assertionsDisabled) break block14;
                            throw new AssertionError((Object)fileStateInvalidException);
                        }
                    }
                }
            }
            antEvent.consume();
        }
    }
}

