/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.Inflector;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;

final class ActiveRecordAssociationFinder {
    private static final String HAS_MANY = "has_many";
    private static final String HAS_MANY_POLYMORPHS = "has_many_polymorphs";
    private static final String HAS_AND_BELONGS_TO_MANY = "has_and_belongs_to_many";
    static final String[] AR_ASSOCIATIONS = new String[]{"belongs_to", "has_one", "has_many", "has_many_polymorphs", "has_and_belongs_to_many"};
    private final RubyIndex index;
    private final SymbolNode closest;
    private final Node root;
    private final AstPath path;

    public ActiveRecordAssociationFinder(RubyIndex index, SymbolNode closest, Node root, AstPath path) {
        this.index = index;
        this.closest = closest;
        this.root = root;
        this.path = path;
    }

    private Node findAssociationNode() {
        for (Node child : this.closest.childNodes()) {
            if (!AstUtilities.isActiveRecordAssociation(child)) continue;
            return child;
        }
        ListIterator<Node> leafToRoot = this.path.leafToRoot();
        while (leafToRoot.hasNext()) {
            Node next = leafToRoot.next();
            if (!AstUtilities.isActiveRecordAssociation(next)) continue;
            return next;
        }
        return null;
    }

    private static String getExplicitySpecifiedClassName(Node associationNode) {
        if (associationNode.childNodes().isEmpty() || HAS_MANY_POLYMORPHS.equals(AstUtilities.getName(associationNode))) {
            return null;
        }
        ArrayNode parameters = (ArrayNode)associationNode.childNodes().get(0);
        for (Node param : parameters.childNodes()) {
            Node hashParams;
            HashNode hash;
            if (!(param instanceof HashNode) || (hash = (HashNode)param).childNodes().isEmpty() || (hashParams = (Node)param.childNodes().get(0)).childNodes().size() < 2) continue;
            for (int i = 0; i < hashParams.childNodes().size(); ++i) {
                Node each = (Node)hashParams.childNodes().get(i);
                if (!(each instanceof INameNode) || !"class_name".equals(AstUtilities.getName(each)) || hashParams.childNodes().size() <= i + 1) continue;
                Node value = (Node)hashParams.childNodes().get(i + 1);
                if (value instanceof StrNode) {
                    return ((StrNode)value).getValue();
                }
                return AstUtilities.safeGetName(value);
            }
        }
        return null;
    }

    static String getClassNameFor(Node associationNode, SymbolNode closest) {
        String associationName;
        String className = ActiveRecordAssociationFinder.getExplicitySpecifiedClassName(associationNode);
        if (className == null) {
            className = AstUtilities.getName((Node)closest);
            if (className.length() == 0) {
                return className;
            }
            className = RubyUtils.underlinedNameToCamel(className);
        }
        if (HAS_MANY.equals(associationName = AstUtilities.getName(associationNode)) || HAS_MANY_POLYMORPHS.equals(associationName) || HAS_AND_BELONGS_TO_MANY.equals(associationName)) {
            return Inflector.getDefault().singularize(className);
        }
        return className;
    }

    DeclarationFinder.DeclarationLocation findAssociationLocation() {
        Node associationNode = this.findAssociationNode();
        if (associationNode == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        String className = ActiveRecordAssociationFinder.getClassNameFor(associationNode, this.closest);
        if (className.length() == 0) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        Set<IndexedClass> modelClasses = this.index.getSubClasses("ActiveRecord::Base", null, className, false);
        if (modelClasses.isEmpty()) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        HashSet<IndexedClass> result = new HashSet<IndexedClass>();
        for (IndexedClass model : modelClasses) {
            if (!model.getName().equals(className)) continue;
            result.add(model);
        }
        return RubyDeclarationFinder.getLocation(result);
    }
}

