/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.File;
import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class SiteOutputProcessor
implements OutputProcessor {
    private static final String[] SITEGOALS = new String[]{"mojo-execute#site:site"};
    private Project project;

    public SiteOutputProcessor(Project prj) {
        this.project = prj;
    }

    @Override
    public String[] getRegisteredOutputSequences() {
        return SITEGOALS;
    }

    @Override
    public void processLine(String line, OutputVisitor visitor) {
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
        visitor.setLine("     View Generated Project Site");
        visitor.setOutputListener(new Listener(this.project), false);
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }

    private static class Listener
    implements OutputListener {
        private File root;

        private Listener(Project prj) {
            File fl = FileUtil.toFile((FileObject)prj.getProjectDirectory());
            this.root = new File(fl, "target" + File.separator + "site");
        }

        public void outputLineSelected(OutputEvent arg0) {
        }

        public void outputLineAction(OutputEvent arg0) {
            FileObject index;
            File site = FileUtil.normalizeFile((File)this.root);
            FileUtil.refreshFor((File[])new File[]{site});
            FileObject fo = FileUtil.toFileObject((File)site);
            if (fo != null && (index = fo.getFileObject("index.html")) != null) {
                URL link = URLMapper.findURL((FileObject)index, (int)1);
                HtmlBrowser.URLDisplayer.getDefault().showURL(link);
            }
        }

        public void outputLineCleared(OutputEvent arg0) {
        }
    }
}

