/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.Colon3Node;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.IdUtil;

public final class Colon2Node
extends Colon3Node
implements INameNode {
    private final Node leftNode;

    public Colon2Node(ISourcePosition position, Node leftNode, String name) {
        super(position, NodeType.COLON2NODE, name);
        this.leftNode = leftNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitColon2Node(this);
    }

    public Node getLeftNode() {
        return this.leftNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.leftNode);
    }

    @Override
    public String toString() {
        String result = "Colon2Node [";
        if (this.leftNode != null) {
            result = result + this.leftNode;
        }
        result = result + this.getName();
        return result + "]";
    }

    @Override
    public RubyModule getEnclosingModule(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.leftNode != null) {
            IRubyObject result = this.leftNode.interpret(runtime, context, self, aBlock);
            return RuntimeHelpers.prepareClassNamespace(context, result);
        }
        return context.getCurrentScope().getStaticScope().getModule();
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.leftNode == null) {
            return runtime.getObject().fastGetConstantFrom(this.name);
        }
        IRubyObject result = this.leftNode.interpret(runtime, context, self, aBlock);
        if (IdUtil.isConstant(this.name)) {
            if (result instanceof RubyModule) {
                return ((RubyModule)result).fastGetConstantFrom(this.name);
            }
            throw runtime.newTypeError(result + " is not a class/module");
        }
        return RuntimeHelpers.invoke(context, result, this.name, aBlock);
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            IRubyObject left = this.leftNode.interpret(runtime, context, self, aBlock);
            if (left instanceof RubyModule && ((RubyModule)left).fastGetConstantAt(this.name) != null) {
                return "constant";
            }
            if (left.getMetaClass().isMethodBound(this.name, true)) {
                return "method";
            }
        }
        catch (JumpException e) {
            // empty catch block
        }
        return null;
    }
}

