/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JEditorPane;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.client.PropertiesClient;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.ui.blame.BlameAction;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.FileSelector;
import org.netbeans.modules.versioning.util.ProjectUtilities;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public class SvnUtils {
    public static final String SVN_ADMIN_DIR;
    public static final String SVN_ENTRIES_DIR;
    private static final Pattern metadataPattern;
    public static final HashSet<Character> autoEscapedCharacters;
    private static final FileFilter svnFileFilter;
    private static Logger TY9_LOG;

    public static String createAnnotationFormat(String format) {
        String string = format;
        string = Utils.skipUnsupportedVariables((String)string, (String[])new String[]{"{status}", "{folder}", "{revision}", "{mime_type}"});
        string = string.replaceAll("\\{revision\\}", "\\{0\\}");
        string = string.replaceAll("\\{status\\}", "\\{1\\}");
        string = string.replaceAll("\\{folder\\}", "\\{2\\}");
        string = string.replaceAll("\\{mime_type\\}", "\\{3\\}");
        return string;
    }

    public static SVNUrl decodeAndEncodeUrl(SVNUrl url) throws MalformedURLException {
        return SvnUtils.encodeUrl(SvnUtils.decode(url));
    }

    public static SVNUrl encodeUrl(SVNUrl url) throws MalformedURLException {
        String sUrl = url.toString();
        StringBuilder sb = new StringBuilder(sUrl.length());
        for (int i = 0; i < sUrl.length(); ++i) {
            Character c = Character.valueOf(sUrl.charAt(i));
            if (autoEscapedCharacters.contains(c)) {
                char[] chars = Character.toChars(c.charValue());
                for (int j = 0; j < chars.length; ++j) {
                    sb.append('%');
                    sb.append(Integer.toHexString(chars[j]).toUpperCase());
                }
                continue;
            }
            sb.append(c);
        }
        return new SVNUrl(sb.toString());
    }

    public static Context getCurrentContext(Node[] nodes) {
        if (nodes == null) {
            nodes = TopComponent.getRegistry().getActivatedNodes();
        }
        VCSContext ctx = VCSContext.forNodes((Node[])nodes);
        return new Context(new ArrayList<File>(ctx.computeFiles(svnFileFilter)), new ArrayList<File>(ctx.getRootFiles()), new ArrayList<File>(ctx.getExclusions()));
    }

    public static Context getCurrentContext(Node[] nodes, int includingFileStatus, int includingFolderStatus, boolean fromCache) {
        Context context = SvnUtils.getCurrentContext(nodes);
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] files = context.getRootFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            FileInformation fi = fromCache ? cache.getCachedStatus(file) : cache.getStatus(file);
            int status = fi != null ? fi.getStatus() : 8;
            if (!(file.isDirectory() ? (status & includingFolderStatus) == 0 : (status & includingFileStatus) == 0)) continue;
            return Context.Empty;
        }
        return context;
    }

    public static Context getCurrentContext(Node[] nodes, int includingFileStatus, int includingFolderStatus) {
        return SvnUtils.getCurrentContext(nodes, includingFileStatus, includingFolderStatus, false);
    }

    public static boolean isAnnotationFormatValid(String format) {
        boolean retval = true;
        if (format != null) {
            try {
                new MessageFormat(format);
            }
            catch (IllegalArgumentException ex) {
                Subversion.LOG.log(Level.FINER, "Bad user input - annotation format", ex);
                retval = false;
            }
        }
        return retval;
    }

    public static boolean isVersionedProject(Node node, boolean checkStatus) {
        Lookup lookup = node.getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        return SvnUtils.isVersionedProject(project, checkStatus);
    }

    public static boolean isVersionedProject(Project project, boolean checkStatus) {
        if (project != null) {
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
            for (int j = 0; j < sourceGroups.length; ++j) {
                SourceGroup sourceGroup = sourceGroups[j];
                File f = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
                if (f == null) continue;
                if (checkStatus && (cache.getStatus(f).getStatus() & 0xFFFFFFFE) != 0) {
                    return true;
                }
                if (checkStatus || !SvnUtils.isManaged(f)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addProjectFiles(Collection<File> filteredFiles, Collection<File> rootFiles, Collection<File> rootFilesExclusions, Project project) {
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        for (int j = 0; j < sourceGroups.length; ++j) {
            SourceGroup sourceGroup = sourceGroups[j];
            FileObject srcRootFo = sourceGroup.getRootFolder();
            File rootFile = FileUtil.toFile((FileObject)srcRootFo);
            if (rootFile == null || (cache.getStatus(rootFile).getStatus() & 0xFFFFFFFE) == 0) continue;
            rootFiles.add(rootFile);
            boolean containsSubprojects = false;
            FileObject[] rootChildren = srcRootFo.getChildren();
            HashSet<File> projectFiles = new HashSet<File>(rootChildren.length);
            for (int i = 0; i < rootChildren.length; ++i) {
                File child;
                FileObject rootChildFo = rootChildren[i];
                if (SvnUtils.isAdministrative(rootChildFo.getNameExt()) || (child = FileUtil.toFile((FileObject)rootChildFo)) == null) continue;
                if (sourceGroup.contains(rootChildFo)) {
                    projectFiles.add(child);
                    continue;
                }
                int status = cache.getStatus(child).getStatus();
                if (status == 2) continue;
                rootFilesExclusions.add(child);
                containsSubprojects = true;
            }
            if (containsSubprojects) {
                filteredFiles.addAll(projectFiles);
                continue;
            }
            filteredFiles.add(rootFile);
        }
    }

    public static Context getProjectsContext(Project[] projects) {
        ArrayList<File> filtered = new ArrayList<File>();
        ArrayList<File> roots = new ArrayList<File>();
        ArrayList<File> exclusions = new ArrayList<File>();
        for (int i = 0; i < projects.length; ++i) {
            SvnUtils.addProjectFiles(filtered, roots, exclusions, projects[i]);
        }
        return new Context(filtered, roots, exclusions);
    }

    public static File[] toFileArray(Collection<FileObject> fileObjects) {
        HashSet<File> files = new HashSet<File>(fileObjects.size() * 4 / 3 + 1);
        Iterator<FileObject> i = fileObjects.iterator();
        while (i.hasNext()) {
            File f = FileUtil.toFile((FileObject)i.next());
            if (f == null) continue;
            files.add(f);
        }
        files.remove(null);
        return files.toArray(new File[files.size()]);
    }

    public static boolean isParentOrEqual(File parent, File file) {
        while (file != null) {
            if (file.equals(parent)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static boolean isAdministrative(File file) {
        String name = file.getName();
        boolean administrative = SvnUtils.isAdministrative(name);
        return administrative && !file.exists() || administrative && file.exists() && file.isDirectory();
    }

    public static boolean isAdministrative(String fileName) {
        return fileName.equals(SVN_ADMIN_DIR);
    }

    public static boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof SubversionVCS && !SvnUtils.isPartOfSubversionMetadata(file);
    }

    public static String previousRevision(String revision) {
        return revision == null ? null : Long.toString(Long.parseLong(revision) - 1L);
    }

    public static String getRelativePath(File file) throws SVNClientException {
        String repositoryPath = null;
        ArrayList<String> path = new ArrayList<String>();
        SVNUrl repositoryURL = null;
        boolean fileIsManaged = false;
        while (SvnUtils.isManaged(file)) {
            ISVNInfo info;
            block11: {
                fileIsManaged = true;
                info = null;
                try {
                    SvnClient client = Subversion.getInstance().getClient(false);
                    info = client.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block11;
                    if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) {
                        WorkingCopyAttributesCache.getInstance().logUnsupportedWC(ex, file);
                    }
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
            if (info != null && info.getUrl() != null) {
                SVNUrl fileURL = SvnUtils.decode(info.getUrl());
                repositoryURL = info.getRepository();
                if (fileURL != null && repositoryURL != null) {
                    String fileLink = fileURL.toString();
                    String repositoryLink = SvnUtils.decode(repositoryURL).toString();
                    try {
                        repositoryPath = fileLink.substring(repositoryLink.length());
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        Subversion.LOG.log(Level.INFO, "repoUrl: " + repositoryURL.toString() + "\nfileURL: " + fileLink, ex);
                        throw ex;
                    }
                    Iterator it = path.iterator();
                    StringBuffer sb = new StringBuffer();
                    while (it.hasNext()) {
                        String segment = (String)it.next();
                        sb.append("/");
                        sb.append(segment);
                    }
                    repositoryPath = repositoryPath + sb.toString();
                    break;
                }
            }
            path.add(0, file.getName());
            File parent = file.getParentFile();
            if (parent == null) break;
            file = parent;
        }
        if (repositoryURL == null && fileIsManaged) {
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{file});
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!fileIsManaged) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{file});
        }
        return repositoryPath;
    }

    public static SVNUrl getRepositoryRootUrl(File file) throws SVNClientException {
        SvnClient client;
        try {
            client = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            return null;
        }
        SVNUrl repositoryURL = null;
        boolean fileIsManaged = false;
        while (SvnUtils.isManaged(file)) {
            File parent;
            ISVNInfo info;
            block9: {
                fileIsManaged = true;
                info = null;
                try {
                    info = client.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block9;
                    if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) {
                        WorkingCopyAttributesCache.getInstance().logUnsupportedWC(ex, file);
                    }
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
            if (info != null && (repositoryURL = SvnUtils.decode(info.getRepository())) != null || (parent = file.getParentFile()) == null) break;
            file = parent;
        }
        if (repositoryURL == null && fileIsManaged) {
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{file});
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!fileIsManaged) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{file});
            Level oldLevel = Subversion.LOG.getLevel();
            Subversion.LOG.setLevel(Level.FINE);
            Subversion.LOG.log(Level.INFO, "getRepositoryRootUrl: file {0} {1}", new Object[]{file, VersioningSupport.getOwner((File)file)});
            Subversion.LOG.setLevel(oldLevel);
            if (!file.exists()) {
                Subversion.LOG.log(Level.INFO, "getRepositoryRootUrl: file {0} does not exist", new Object[]{file});
            }
        }
        return repositoryURL;
    }

    public static SVNUrl getRepositoryUrl(File file) throws SVNClientException {
        StringBuffer path = new StringBuffer();
        SVNUrl fileURL = null;
        SvnClient client = null;
        try {
            client = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            return null;
        }
        boolean fileIsManaged = false;
        while (SvnUtils.isManaged(file)) {
            ISVNInfo info;
            block13: {
                block12: {
                    fileIsManaged = true;
                    try {
                        ISVNStatus status = SvnUtils.getSingleStatus(client, file);
                        if (status != null && (fileURL = SvnUtils.decode(status.getUrl())) != null) {
                            break;
                        }
                    }
                    catch (SVNClientException ex) {
                        if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block12;
                        if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) {
                            WorkingCopyAttributesCache.getInstance().logUnsupportedWC(ex, file);
                        }
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                    }
                }
                info = null;
                try {
                    info = client.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block13;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
            if (info != null && (fileURL = SvnUtils.decode(info.getUrl())) != null) break;
            path.insert(0, file.getName()).insert(0, "/");
            File parent = file.getParentFile();
            if (parent == null) break;
            file = parent;
        }
        if (fileURL == null && fileIsManaged) {
            Subversion.LOG.log(Level.WARNING, "no repository url found for managed file {0}", new Object[]{file});
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (!fileIsManaged) {
            Subversion.LOG.log(Level.INFO, "no repository url found for not managed file {0}", new Object[]{file});
        }
        if (path.length() > 0) {
            fileURL = fileURL.appendPath(path.toString());
        }
        return fileURL;
    }

    public static Map<File, SVNUrl> getRepositoryUrls(File root) throws SVNClientException {
        HashMap<File, SVNUrl> ret;
        block6: {
            SVNUrl fileURL = null;
            SvnClient client = null;
            try {
                client = Subversion.getInstance().getClient(false);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                return null;
            }
            ret = new HashMap<File, SVNUrl>();
            try {
                ISVNStatus[] statuses;
                for (ISVNStatus status : statuses = client.getStatus(root, true, true)) {
                    if (status == null || (fileURL = SvnUtils.decode(status.getUrl())) == null) continue;
                    ret.put(status.getFile(), fileURL);
                }
            }
            catch (SVNClientException ex) {
                if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) break block6;
                if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) {
                    WorkingCopyAttributesCache.getInstance().logUnsupportedWC(ex, root);
                }
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
        return ret;
    }

    private static ISVNStatus getSingleStatus(SvnClient client, File file) throws SVNClientException {
        return client.getSingleStatus(file);
    }

    public static SVNUrl decode(SVNUrl url) {
        if (url == null) {
            return null;
        }
        String s = url.toString();
        StringBuffer sb = new StringBuffer(s.length());
        boolean inQuery = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '?') {
                inQuery = true;
                continue;
            }
            if (c == '+' && inQuery) {
                sb.append(' ');
                continue;
            }
            if (SvnUtils.isEncodedByte(c, s, i)) {
                ArrayList<Byte> byteList = new ArrayList<Byte>();
                do {
                    byteList.add((byte)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                } while ((i += 3) < s.length() && SvnUtils.isEncodedByte(c = s.charAt(i), s, i));
                if (byteList.size() <= 0) continue;
                byte[] bytes = new byte[byteList.size()];
                for (int ib = 0; ib < byteList.size(); ++ib) {
                    bytes[ib] = (Byte)byteList.get(ib);
                }
                try {
                    sb.append(new String(bytes, "UTF8"));
                }
                catch (Exception e) {
                    Subversion.LOG.log(Level.INFO, null, e);
                }
                --i;
                continue;
            }
            sb.append(c);
        }
        try {
            return new SVNUrl(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isEncodedByte(char c, String s, int i) {
        return c == '%' && i + 2 < s.length() && SvnUtils.isHexDigit(s.charAt(i + 1)) && SvnUtils.isHexDigit(s.charAt(i + 2));
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static String getRepositoryPath(File file) throws SVNClientException {
        SVNUrl url = SvnUtils.getRepositoryUrl(file);
        SVNUrl rootUrl = SvnUtils.getRepositoryRootUrl(file);
        return SVNUrlUtils.getRelativePath((SVNUrl)rootUrl, (SVNUrl)url, (boolean)true);
    }

    public static boolean isBinary(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            byte ch = buffer[i];
            if (ch >= 32 || ch == 9 || ch == 10 || ch == 13) continue;
            return true;
        }
        return false;
    }

    public static String fixLineEndings(String text) {
        return text.replaceAll("\r\n", "\n").replace('\r', '\n');
    }

    public static File[] flatten(File[] files, int status) {
        LinkedList<File> ret = new LinkedList<File>();
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            File dir = files[i];
            FileInformation info = cache.getStatus(dir);
            if ((status & info.getStatus()) != 0) {
                ret.add(dir);
            }
            File[] entries = cache.listFiles(dir);
            for (int e = 0; e < entries.length; ++e) {
                File entry = entries[e];
                info = cache.getStatus(entry);
                if ((status & info.getStatus()) == 0) continue;
                ret.add(entry);
            }
        }
        return ret.toArray(new File[ret.size()]);
    }

    public static File[] getModifiedFiles(Context context, int includeStatus) {
        File[] all = Subversion.getInstance().getStatusCache().listFiles(context, includeStatus);
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < all.length; ++i) {
            File file = all[i];
            String path = file.getAbsolutePath();
            if (SvnModuleConfig.getDefault().isExcludedFromCommit(path)) continue;
            files.add(file);
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        File[] rootFiles = context.getRootFiles();
        for (int i = 0; i < rootFiles.length; ++i) {
            File file = rootFiles[i];
            if (!file.isFile() || (cache.getStatus(file).getStatus() & includeStatus) == 0 || files.contains(file)) continue;
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    public static boolean isPartOfSubversionMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static int getComparableStatus(int status) {
        if (0 != (status & 0x4040)) {
            return 0;
        }
        if (0 != (status & 0x80)) {
            return 1;
        }
        if (0 != (status & 0x800)) {
            return 10;
        }
        if (0 != (status & 0x100)) {
            return 11;
        }
        if (0 != (status & 4)) {
            return 12;
        }
        if (0 != (status & 0x1000)) {
            return 13;
        }
        if (0 != (status & 0x10)) {
            return 14;
        }
        if (0 != (status & 0x400)) {
            return 30;
        }
        if (0 != (status & 0x200)) {
            return 31;
        }
        if (0 != (status & 0x20)) {
            return 32;
        }
        if (0 != (status & 8)) {
            return 50;
        }
        if (0 != (status & 2)) {
            return 100;
        }
        if (0 != (status & 1)) {
            return 101;
        }
        if (status == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + status);
    }

    public static String getCopy(File file) {
        SVNUrl url;
        try {
            url = SvnUtils.getRepositoryUrl(file);
        }
        catch (SVNClientException ex) {
            if (!SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
            return null;
        }
        return SvnUtils.getCopy(url, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    public static String getCopy(SVNUrl url) {
        return SvnUtils.getCopy(url, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    private static String getCopy(SVNUrl url, List<AnnotationExpression> annotationExpressions) {
        if (url != null) {
            String urlString = url.toString();
            Iterator<AnnotationExpression> it = annotationExpressions.iterator();
            while (it.hasNext()) {
                String name = it.next().getCopyName(urlString);
                if (name == null) continue;
                return name;
            }
        }
        return null;
    }

    public static void refreshParents(File folder) {
        if (folder == null) {
            return;
        }
        SvnUtils.refreshParents(folder.getParentFile());
        Subversion.getInstance().getStatusCache().refresh(folder, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    public static String ripUserFromHost(String host) {
        int idx = host.indexOf(64);
        if (idx < 0) {
            return host;
        }
        return host.substring(idx + 1);
    }

    public static SVNRevision getSVNRevision(String revisionString) {
        try {
            return SVNRevision.getRevision((String)revisionString);
        }
        catch (ParseException ex) {
            return new SVNRevision.Number(Long.parseLong(revisionString));
        }
    }

    public static List<String> getMatchinIgnoreParterns(List<String> patterns, String value, boolean onlyFirstMatch) {
        ArrayList<String> ret = new ArrayList<String>();
        if (patterns == null) {
            return ret;
        }
        Iterator<String> i = patterns.iterator();
        while (i.hasNext()) {
            try {
                String patternString = i.next();
                String shellPatternString = SvnUtils.regExpToFilePatterns(patternString);
                Pattern pattern = Pattern.compile(shellPatternString);
                if (!pattern.matcher(value).matches()) continue;
                ret.add(patternString);
                if (!onlyFirstMatch) continue;
                return ret;
            }
            catch (PatternSyntaxException e) {
                Subversion.LOG.log(Level.INFO, null, e);
            }
        }
        return ret;
    }

    private static String regExpToFilePatterns(String exp) {
        exp = exp.replaceAll("\\.", "\\\\.");
        exp = exp.replaceAll("\\*", ".*");
        exp = exp.replaceAll("\\?", ".");
        exp = exp.replaceAll("\\$", "\\\\\\$");
        exp = exp.replaceAll("\\^", "\\\\^");
        exp = exp.replaceAll("\\<", "\\\\<");
        exp = exp.replaceAll("\\>", "\\\\>");
        exp = SvnUtils.patchRegExpClassCharacters(exp);
        exp = exp.replaceAll("\\{", "\\\\{");
        exp = exp.replaceAll("\\}", "\\\\}");
        exp = exp.replaceAll("\\(", "\\\\(");
        exp = exp.replaceAll("\\)", "\\\\)");
        exp = exp.replaceAll("\\+", "\\\\+");
        exp = exp.replaceAll("\\|", "\\\\|");
        return exp;
    }

    private static String patchRegExpClassCharacters(String exp) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        StringBuilder builder = new StringBuilder(exp.length());
        int index = 0;
        int builderIndex = 0;
        while (index < exp.length()) {
            char ch = exp.charAt(index);
            if (ch == '\\') {
                builder.append(ch);
                if (++index < exp.length()) {
                    ++builderIndex;
                    builder.append(exp.charAt(index));
                }
            } else if (ch == '[') {
                builder.append(ch);
                indexes.add(builderIndex);
            } else {
                if (ch == ']') {
                    if (indexes.isEmpty()) {
                        builder.append("\\");
                        ++builderIndex;
                    } else {
                        indexes.removeLast();
                    }
                }
                builder.append(ch);
            }
            ++index;
            ++builderIndex;
        }
        for (Integer index2 : indexes) {
            builder.insert((int)index2, "\\");
        }
        return builder.toString();
    }

    public static String getMimeType(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        String foMime = fo == null ? "content/unknown" : fo.getMIMEType();
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        if ((cache.getStatus(file).getStatus() & 0x5DF8) == 0) {
            if (foMime.startsWith("text")) {
                return foMime;
            }
            return Utils.isFileContentText((File)file) ? "text/plain" : "application/octet-stream";
        }
        PropertiesClient client = new PropertiesClient(file);
        try {
            byte[] mimeProperty = client.getProperties().get("svn:mime-type");
            if (mimeProperty == null) {
                return Utils.isFileContentText((File)file) ? "text/plain" : "application/octet-stream";
            }
            return new String(mimeProperty);
        }
        catch (IOException e) {
            return foMime;
        }
    }

    public static <T> boolean equals(List<T> l1, List<T> l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null && l2 != null && l2.size() > 0 || l2 == null && l1 != null && l1.size() > 0) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (T t : l1) {
            if (l2.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static List<File> listRecursively(File root) {
        ArrayList<File> ret = new ArrayList<File>();
        if (root == null) {
            return ret;
        }
        ret.add(root);
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                if (SvnUtils.isPartOfSubversionMetadata(file) || SvnUtils.isAdministrative(file)) continue;
                if (file.isDirectory()) {
                    ret.addAll(SvnUtils.listRecursively(file));
                    continue;
                }
                ret.add(file);
            }
        }
        return ret;
    }

    public static List<File> listChildren(File root) {
        ArrayList<File> ret = new ArrayList<File>();
        if (root == null) {
            return ret;
        }
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                if (SvnUtils.isPartOfSubversionMetadata(file) || SvnUtils.isAdministrative(file)) continue;
                ret.add(file);
            }
        }
        return ret;
    }

    public static SvnFileNode[] getNodes(Context context, int includeStatus) {
        File[] files = Subversion.getInstance().getStatusCache().listFiles(context, includeStatus);
        SvnFileNode[] nodes = new SvnFileNode[files.length];
        for (int i = 0; i < files.length; ++i) {
            nodes[i] = new SvnFileNode(files[i]);
        }
        return nodes;
    }

    public static SVNRevision toSvnRevision(String revision) {
        Object svnrevision = "HEAD".equals(revision) || SVNRevision.HEAD.toString().equals(revision) ? SVNRevision.HEAD : (SVNRevision.BASE.toString().equals(revision) ? SVNRevision.BASE : new SVNRevision.Number(Long.parseLong(revision)));
        return svnrevision;
    }

    public static ISVNLogMessage[] getLogMessages(ISVNClientAdapter client, SVNUrl rootUrl, String[] paths, SVNRevision fromRevision, SVNRevision toRevision, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        HashSet<Long> alreadyHere = new HashSet<Long>();
        ArrayList<ISVNLogMessage> ret = new ArrayList<ISVNLogMessage>();
        boolean sorted = true;
        long lastRevNum = -1L;
        for (String path : paths) {
            ISVNLogMessage[] logs;
            for (ISVNLogMessage log : logs = client.getLogMessages(rootUrl.appendPath(path), null, fromRevision, toRevision, stopOnCopy, fetchChangePath, 0L)) {
                long revNum = log.getRevision().getNumber();
                if (alreadyHere.contains(revNum)) continue;
                ret.add(log);
                alreadyHere.add(revNum);
                sorted &= revNum > lastRevNum;
                lastRevNum = revNum;
            }
        }
        if (!sorted) {
            Collections.sort(ret, new Comparator<ISVNLogMessage>(){

                @Override
                public int compare(ISVNLogMessage m1, ISVNLogMessage m2) {
                    long revNum2;
                    long revNum1 = m1.getRevision().getNumber();
                    return revNum1 == (revNum2 = m2.getRevision().getNumber()) ? 0 : (revNum1 > revNum2 ? 1 : -1);
                }
            });
        }
        return ret.toArray(new ISVNLogMessage[ret.size()]);
    }

    public static void logT9Y(String msg) {
        if (TY9_LOG == null) {
            TY9_LOG = Logger.getLogger("org.netbeans.modules.subversion.t9y");
        }
        TY9_LOG.log(Level.FINEST, msg);
    }

    public static File[] getActionRoots(Context ctx) {
        File[] roots = ctx.getRootFiles();
        ArrayList<File> l = new ArrayList<File>();
        for (File file : roots) {
            if (!SvnUtils.isManaged(file)) continue;
            l.add(file);
        }
        roots = l.toArray(new File[l.size()]);
        if (Utils.shareCommonDataObject((File[])roots)) {
            return roots;
        }
        if (roots.length > 1) {
            FileSelector fs = new FileSelector(NbBundle.getMessage(SvnUtils.class, (String)"LBL_FileSelector_Title"), NbBundle.getMessage(SvnUtils.class, (String)"FileSelector.jLabel1.text"), new HelpCtx("org.netbeans.modules.subversion.FileSelector"), SvnModuleConfig.getDefault().getPreferences());
            if (fs.show(roots)) {
                return new File[]{fs.getSelectedFile()};
            }
            return null;
        }
        return new File[]{roots[0]};
    }

    public static File getPrimaryFile(File file) {
        File primaryFile = null;
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            DataObject dao = null;
            try {
                dao = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                Subversion.LOG.log(Level.INFO, "No DataObject found for " + file, ex);
            }
            if (dao != null) {
                primaryFile = FileUtil.toFile((FileObject)dao.getPrimaryFile());
            }
        }
        if (primaryFile == null) {
            primaryFile = file;
        }
        return primaryFile;
    }

    public static boolean isJava64() {
        String javaVMName = System.getProperty("java.vm.name");
        if (javaVMName == null) {
            return false;
        }
        return javaVMName.toLowerCase().contains("64-bit");
    }

    public static CommitOptions[] createDefaultCommitOptions(SvnFileNode[] nodes, boolean excludeNew) {
        CommitOptions[] commitOptions = new CommitOptions[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            SvnFileNode node = nodes[i];
            File file = node.getFile();
            commitOptions[i] = SvnModuleConfig.getDefault().isExcludedFromCommit(file.getAbsolutePath()) ? CommitOptions.EXCLUDE : SvnUtils.getDefaultCommitOptions(node, excludeNew);
        }
        return commitOptions;
    }

    public static String getTunnelName(String urlString) {
        assert (urlString.startsWith("svn+"));
        int idx = urlString.indexOf(":", 4);
        if (idx < 0) {
            idx = urlString.length();
        }
        return urlString.substring(4, idx);
    }

    public static void openInRevision(final File originalFile, SVNUrl repoUrl, SVNUrl fileUrl, final SVNRevision svnRevision, SVNRevision pegRevision, boolean showAnnotations) {
        File file;
        String rev = svnRevision.toString();
        try {
            file = VersionsCache.getInstance().getFileRevision(repoUrl, fileUrl, rev, pegRevision.toString(), originalFile.getName());
        }
        catch (IOException e) {
            SvnClientExceptionHandler.notifyException(e, true, true);
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        EditorCookie ec = null;
        OpenCookie oc = null;
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
        }
        catch (DataObjectNotFoundException ex) {
            Subversion.LOG.log(Level.FINE, null, ex);
        }
        CloneableEditorSupport ces = null;
        if (ec == null && oc != null) {
            oc.open();
        } else {
            ces = Utils.openFile((FileObject)fo, (String)rev);
        }
        if (showAnnotations) {
            if (ces == null) {
                return;
            }
            final CloneableEditorSupport support = ces;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JEditorPane[] panes = support.getOpenedPanes();
                    if (panes != null) {
                        BlameAction.showAnnotations(panes[0], originalFile, svnRevision);
                    }
                }
            });
        }
    }

    public static CommitOptions getDefaultCommitOptions(SvnFileNode node, boolean excludeNew) {
        CommitOptions commitOptions;
        switch (node.getInformation().getStatus()) {
            case 4: {
                commitOptions = excludeNew ? CommitOptions.EXCLUDE : SvnUtils.getDefaultCommitOptions(node);
                break;
            }
            case 256: 
            case 2048: {
                commitOptions = CommitOptions.COMMIT_REMOVE;
                break;
            }
            default: {
                commitOptions = CommitOptions.COMMIT;
            }
        }
        return commitOptions;
    }

    private static CommitOptions getDefaultCommitOptions(SvnFileNode node) {
        if (node.isFile()) {
            if (node.getMimeType().startsWith("text")) {
                return CommitOptions.ADD_TEXT;
            }
            return CommitOptions.ADD_BINARY;
        }
        return CommitOptions.ADD_DIRECTORY;
    }

    public void scanForProjects(File workingFolder, String[] checkedOutFolders, SvnProgressSupport support) {
        HashMap checkedOutProjects = new HashMap();
        checkedOutProjects.put(null, new HashSet());
        File normalizedWorkingFolder = FileUtil.normalizeFile((File)workingFolder);
        SvnUtils.refreshParents(normalizedWorkingFolder);
        FileObject fo = FileUtil.toFileObject((File)normalizedWorkingFolder);
        if (fo != null) {
            for (int i = 0; i < checkedOutFolders.length; ++i) {
                if (support != null && support.isCanceled()) {
                    return;
                }
                String module = checkedOutFolders[i];
                if (".".equals(module)) {
                    ProjectUtilities.scanForProjects((FileObject)fo, checkedOutProjects);
                    break;
                }
                FileObject subfolder = fo.getFileObject(module);
                if (subfolder == null) continue;
                ProjectUtilities.scanForProjects((FileObject)subfolder, checkedOutProjects);
            }
        }
        ProjectUtilities.openCheckedOutProjects(checkedOutProjects, (File)workingFolder);
    }

    public static void refreshFS(File ... files) {
        final HashSet<File> parents = new HashSet<File>();
        for (File f : files) {
            File parent = f.getParentFile();
            if (parent == null) continue;
            parents.add(parent);
            Subversion.LOG.log(Level.FINE, "scheduling for fs refresh: [{0}]", parent);
        }
        if (parents.size() > 0) {
            Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    FileUtil.refreshFor((File[])parents.toArray(new File[parents.size()]));
                }
            }, 100);
        }
    }

    static {
        String env;
        autoEscapedCharacters = new HashSet(6);
        autoEscapedCharacters.add(Character.valueOf(';'));
        autoEscapedCharacters.add(Character.valueOf('?'));
        autoEscapedCharacters.add(Character.valueOf('#'));
        autoEscapedCharacters.add(Character.valueOf('%'));
        autoEscapedCharacters.add(Character.valueOf('['));
        autoEscapedCharacters.add(Character.valueOf(']'));
        SVN_ADMIN_DIR = Utilities.isWindows() ? ((env = System.getenv("SVN_ASP_DOT_NET_HACK")) != null ? "_svn" : ".svn") : ".svn";
        SVN_ENTRIES_DIR = SVN_ADMIN_DIR + "/entries";
        metadataPattern = Pattern.compile(".*\\" + File.separatorChar + SVN_ADMIN_DIR + "(\\" + File.separatorChar + ".*|$)");
        svnFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (SvnUtils.isAdministrative(pathname)) {
                    return false;
                }
                return SharabilityQuery.getSharability((File)pathname) != 2;
            }
        };
        TY9_LOG = null;
    }

    public static class ByImportanceComparator<T>
    implements Comparator<FileInformation> {
        @Override
        public int compare(FileInformation i1, FileInformation i2) {
            return SvnUtils.getComparableStatus(i1.getStatus()) - SvnUtils.getComparableStatus(i2.getStatus());
        }
    }
}

