/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.osgi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class OSGiInstalledFileLocator
extends InstalledFileLocator {
    private static final String FILES = "OSGI-INF/files/";
    private final BundleContext context;

    public OSGiInstalledFileLocator(BundleContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File locate(String relativePath, String codeNameBase, boolean localized) {
        if (localized) {
            String ext;
            String baseName;
            int i = relativePath.lastIndexOf(46);
            if (i == -1 || i < relativePath.lastIndexOf(47)) {
                baseName = relativePath;
                ext = "";
            } else {
                baseName = relativePath.substring(0, i);
                ext = relativePath.substring(i);
            }
            Iterator it = NbBundle.getLocalizingSuffixes();
            while (it.hasNext()) {
                String locName = baseName + (String)it.next() + ext;
                File f = this.locate(locName, codeNameBase, false);
                if (f == null) continue;
                return f;
            }
        } else {
            String storage = this.context.getProperty("org.osgi.framework.storage");
            if (storage == null) {
                return null;
            }
            File f = this.unpackedLocation(storage, relativePath);
            if (f.exists()) {
                return f;
            }
            block12: for (Bundle owner : this.context.getBundles()) {
                if (codeNameBase != null && !owner.getSymbolicName().equals(codeNameBase)) continue;
                switch (owner.getState()) {
                    case 1: 
                    case 2: {
                        continue block12;
                    }
                    default: {
                        if (owner.getResource(FILES + relativePath) == null) continue block12;
                        try {
                            for (URL resource : NbCollections.iterable((Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)owner.findEntries(FILES, null, true), URL.class, (boolean)true))) {
                                String bundlepath = resource.getPath();
                                if (bundlepath.endsWith("/")) continue;
                                File f2 = this.unpackedLocation(storage, bundlepath.substring(FILES.length()));
                                File dir = f2.getParentFile();
                                if (!dir.isDirectory() && !dir.mkdirs()) {
                                    throw new IOException("Could not make " + dir);
                                }
                                InputStream is = resource.openStream();
                                try {
                                    FileOutputStream os = new FileOutputStream(f2);
                                    try {
                                        int read;
                                        byte[] buf = new byte[4096];
                                        while ((read = is.read(buf)) != -1) {
                                            ((OutputStream)os).write(buf, 0, read);
                                        }
                                    }
                                    finally {
                                        ((OutputStream)os).close();
                                    }
                                }
                                finally {
                                    is.close();
                                }
                            }
                            return f;
                        }
                        catch (IOException x) {
                            Exceptions.printStackTrace((Throwable)x);
                        }
                    }
                }
            }
        }
        return null;
    }

    private File unpackedLocation(String storage, String relativePath) {
        return new File(storage, "files/" + relativePath.replace('/', File.separatorChar));
    }
}

