/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataModelImplementation;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.mssql.MSSQLMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.mysql.MySQLMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.oracle.OracleMetadata;

public class JDBCConnMetadataModel
implements MetadataModelImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCConnMetadataModel.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private final WeakReference<Connection> connRef;
    private final String defaultSchemaName;
    private JDBCMetadata jdbcMetadata;

    public JDBCConnMetadataModel(Connection conn, String defaultSchemaName) {
        this.connRef = new WeakReference<Connection>(conn);
        this.defaultSchemaName = defaultSchemaName != null && defaultSchemaName.trim().length() == 0 ? null : defaultSchemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runReadAction(Action<Metadata> action) throws MetadataModelException {
        this.lock.lock();
        try {
            Connection conn = (Connection)this.connRef.get();
            if (conn == null) {
                return;
            }
            try {
                this.enterReadAccess(conn);
                if (this.jdbcMetadata != null) {
                    Metadata metadata = this.jdbcMetadata.getMetadata();
                    action.run(metadata);
                }
            }
            catch (SQLException e) {
                throw new MetadataModelException(e);
            }
            catch (MetadataException e) {
                throw new MetadataModelException(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        LOGGER.fine("Refreshing model");
        this.lock.lock();
        try {
            this.jdbcMetadata = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void enterReadAccess(Connection conn) throws SQLException {
        Connection oldConn;
        if (conn == null) {
            throw new NullPointerException("Connection can not be null");
        }
        Connection connection = oldConn = this.jdbcMetadata != null ? this.jdbcMetadata.getConnection() : null;
        if (oldConn != conn) {
            this.jdbcMetadata = conn != null ? JDBCConnMetadataModel.createMetadata(conn, this.defaultSchemaName) : null;
        }
    }

    private static JDBCMetadata createMetadata(Connection conn, String defaultSchemaName) {
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            if ("Oracle".equals(dmd.getDatabaseProductName())) {
                return new OracleMetadata(conn, defaultSchemaName);
            }
            if ("mysql".equalsIgnoreCase(dmd.getDatabaseProductName())) {
                return new MySQLMetadata(conn, defaultSchemaName);
            }
            String driverName = dmd.getDriverName();
            if (driverName != null && (driverName.contains("Microsoft SQL Server") || driverName.contains("jTDS"))) {
                return new MSSQLMetadata(conn, defaultSchemaName);
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        return new JDBCMetadata(conn, defaultSchemaName);
    }
}

