/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.jaxwsmodel.project.J2seBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class J2seJaxWsOpenHook
extends ProjectOpenedHook {
    Project prj;

    public J2seJaxWsOpenHook(Project project) {
        this.prj = project;
    }

    protected void projectOpened() {
        AntBuildExtender antBuildExtender = (AntBuildExtender)this.prj.getLookup().lookup(AntBuildExtender.class);
        JaxWsBuildScriptExtensionProvider jaxWsBuildScriptExtensionProvider = (JaxWsBuildScriptExtensionProvider)this.prj.getLookup().lookup(JaxWsBuildScriptExtensionProvider.class);
        if (antBuildExtender != null && jaxWsBuildScriptExtensionProvider != null) {
            FileObject fileObject = this.prj.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
            try {
                AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
                FileObject fileObject2 = WSUtils.findJaxWsFileObject(this.prj);
                if (fileObject == null || extension == null) {
                    if (fileObject2 != null && WSUtils.hasClients(fileObject2)) {
                        jaxWsBuildScriptExtensionProvider.addJaxWsExtension(antBuildExtender);
                        this.addJaxWsApiEndorsed(this.prj);
                    }
                } else if (fileObject2 == null || !WSUtils.hasClients(fileObject2)) {
                    jaxWsBuildScriptExtensionProvider.removeJaxWsExtension(antBuildExtender);
                } else {
                    FileObject fileObject3 = this.prj.getProjectDirectory().getFileObject("nbproject/project.xml");
                    if (fileObject3 != null) {
                        this.removeCompileDependencies(this.prj, fileObject3, antBuildExtender);
                    }
                    this.addJaxWsApiEndorsed(this.prj);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void projectClosed() {
    }

    private void removeCompileDependencies(Project project, FileObject fileObject, AntBuildExtender antBuildExtender) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
        String string = null;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.contains("wsimport-client-compile")) continue;
            bl = true;
            break;
        }
        bufferedReader.close();
        if (bl) {
            TransformerUtils.transformClients(project.getProjectDirectory(), J2seBuildScriptExtensionProvider.JAX_WS_STYLESHEET_RESOURCE);
            AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
            if (extension != null) {
                extension.removeDependency("-do-compile", "wsimport-client-compile");
                extension.removeDependency("-do-compile-single", "wsimport-client-compile");
                ProjectManager.getDefault().saveProject(project);
            }
        }
    }

    private void addJaxWsApiEndorsed(Project project) throws IOException {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            WSUtils.addJaxWsApiEndorsed(project, sourceGroupArray[0].getRootFolder());
        }
    }
}

