/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.ComponentAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.LocalStringsManager;

public class ComponentTask
extends ComponentAdmin {
    private String action;
    LocalStringsManager lsm = new LocalStringsManager();
    private static final String ACTION_ENABLE = "enable";
    private static final String ACTION_DISABLE = "disable";
    private static final Map ACTION_MAP = new HashMap(2);

    public void setAction(String action) {
        this.action = action;
    }

    protected void checkComponentConfig(AppServerAdmin.Server aServer, ComponentAdmin.Component comp) throws BuildException {
        super.checkComponentConfig(aServer, comp);
        if (this.action == null) {
            String msg = this.lsm.getString("ActionCommandMustBeSpecified");
            throw new BuildException(msg, this.getLocation());
        }
        if (!ACTION_MAP.containsKey(this.action)) {
            String msg = this.lsm.getString("InvalidActionCommand", new Object[]{this.action});
            throw new BuildException(msg, this.getLocation());
        }
        String theName = comp.getName();
        if (theName == null || theName.length() == 0) {
            String msg = this.lsm.getString("InvalidComponentName", new Object[]{theName});
            throw new BuildException(msg, this.getLocation());
        }
    }

    protected String getCommandString(AppServerAdmin.Server server, ComponentAdmin.Component comp) {
        String lTarget;
        StringBuffer cmdString = new StringBuffer();
        cmdString.append(ACTION_MAP.get(this.action));
        cmdString.append(server.getCommandParameters(true));
        if (comp.getType() != null) {
            cmdString.append(" --type ").append(comp.getType());
        }
        if ((lTarget = comp.getTarget()) != null && lTarget.length() > 0) {
            cmdString.append(" --target ").append(lTarget);
        }
        cmdString.append(" ").append(comp.getName());
        return cmdString.toString();
    }

    static {
        ACTION_MAP.put(ACTION_ENABLE, ACTION_ENABLE);
        ACTION_MAP.put(ACTION_DISABLE, ACTION_DISABLE);
    }
}

