/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.api.project.rake;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.api.project.rake.RakeArtifact;
import org.netbeans.modules.ruby.spi.project.rake.RakeArtifactProvider;
import org.netbeans.modules.ruby.spi.project.rake.RakeArtifactQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class RakeArtifactQuery {
    private RakeArtifactQuery() {
    }

    public static RakeArtifact findArtifactFromFile(File file) {
        if (!file.equals(FileUtil.normalizeFile((File)file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile((File)file));
        }
        for (RakeArtifactQueryImplementation aaqi : Lookup.getDefault().lookupAll(RakeArtifactQueryImplementation.class)) {
            RakeArtifact artifact = aaqi.findArtifact(file);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    public static RakeArtifact findArtifactByID(Project p, String id) {
        RakeArtifactProvider prov = (RakeArtifactProvider)p.getLookup().lookup(RakeArtifactProvider.class);
        if (prov == null) {
            return null;
        }
        RakeArtifact[] artifacts = prov.getBuildArtifacts();
        for (int i = 0; i < artifacts.length; ++i) {
            if (!artifacts[i].getID().equals(id)) continue;
            return artifacts[i];
        }
        return null;
    }

    public static RakeArtifact[] findArtifactsByType(Project p, String type) {
        RakeArtifactProvider prov = (RakeArtifactProvider)p.getLookup().lookup(RakeArtifactProvider.class);
        if (prov == null) {
            return new RakeArtifact[0];
        }
        RakeArtifact[] artifacts = prov.getBuildArtifacts();
        ArrayList<RakeArtifact> l = new ArrayList<RakeArtifact>(artifacts.length);
        for (RakeArtifact aa : artifacts) {
            if (!aa.getType().equals(type)) continue;
            l.add(aa);
        }
        return l.toArray(new RakeArtifact[l.size()]);
    }
}

