/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.server.ServerRegistry;
import org.netbeans.modules.server.ui.wizard.AddServerInstanceWizard;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.netbeans.spi.server.ServerWizardProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class ServerWizardVisual
extends JPanel {
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private final Map<ServerWizardProvider, String> displayNames = new HashMap<ServerWizardProvider, String>();
    private AddServerInstanceWizard wizard;
    private boolean updatingDisplayName = false;
    private JTextField displayNameEditField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JList serverListBox;

    public ServerWizardVisual() {
        this.initComponents();
        PriorityQueue<WizardAdapter> selected = new PriorityQueue<WizardAdapter>(5, new WizardPriority());
        for (int i = 0; i < this.serverListBox.getModel().getSize(); ++i) {
            selected.add((WizardAdapter)this.serverListBox.getModel().getElementAt(i));
        }
        if (!selected.isEmpty()) {
            WizardAdapter selectedItem = (WizardAdapter)selected.peek();
            this.serverListBox.setSelectedValue(selectedItem, true);
            this.fillDisplayName(selectedItem.getServerInstanceWizard());
        }
        this.displayNameEditField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ServerWizardVisual.this.displayNameEditFieldUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ServerWizardVisual.this.displayNameEditFieldUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ServerWizardVisual.this.displayNameEditFieldUpdate();
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void read(AddServerInstanceWizard wizard) {
        Object prop;
        if (this.wizard == null) {
            this.wizard = wizard;
        }
        if ((prop = wizard.getProperty("ServInstWizard_displayName")) != null) {
            this.displayNameEditField.setText((String)prop);
        }
    }

    public void store(AddServerInstanceWizard wizard) {
        wizard.putProperty("ServInstWizard_displayName", this.displayNameEditField.getText());
        Object selectedItem = this.serverListBox.getSelectedValue();
        if (selectedItem != null) {
            wizard.putProperty("ServInstWizard_server", ((WizardAdapter)selectedItem).getServerInstanceWizard());
        }
    }

    boolean hasValidData() {
        boolean result;
        boolean bl = result = this.isServerValid() && this.isDisplayNameValid();
        if (result) {
            this.wizard.setErrorMessage(null);
        }
        return result;
    }

    private boolean isServerValid() {
        boolean result;
        boolean bl = result = this.serverListBox.getSelectedValue() != null;
        if (!result) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerWizardVisual.class, (String)"MSG_SCV_ChooseServer"));
        }
        return result;
    }

    private boolean isDisplayNameValid() {
        String trimmed = this.displayNameEditField.getText().trim();
        if (trimmed.length() <= 0) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerWizardVisual.class, (String)"MSG_SCV_DisplayName"));
            return false;
        }
        if (this.existsDisplayName(trimmed)) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerWizardVisual.class, (String)"MSG_SCV_DisplayNameExists"));
            return false;
        }
        return true;
    }

    private boolean existsDisplayName(String displayName) {
        for (ServerInstanceProvider serverInstanceProvider : ServerRegistry.getInstance().getProviders()) {
            for (ServerInstance instance : serverInstanceProvider.getInstances()) {
                String instanceName = instance.getDisplayName();
                if (null != instanceName && instanceName.equalsIgnoreCase(displayName)) {
                    return true;
                }
                if (null != instanceName) continue;
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "corrupted ServerInstance: " + instance.toString());
            }
        }
        return false;
    }

    private void displayNameEditFieldUpdate() {
        if (!this.updatingDisplayName) {
            this.fireChange();
        }
    }

    private void fireChange() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private String generateDisplayName(ServerWizardProvider server) {
        String name;
        int count = 0;
        do {
            name = server.getDisplayName();
            if (count != 0) {
                name = name + " (" + String.valueOf(count) + ")";
            }
            ++count;
        } while (this.existsDisplayName(name));
        return name;
    }

    private void fillDisplayName(ServerWizardProvider server) {
        String name = this.displayNames.get(server);
        if (name == null) {
            name = this.generateDisplayName(server);
        }
        this.updatingDisplayName = true;
        this.displayNameEditField.setText(name);
        this.updatingDisplayName = false;
        this.fireChange();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.displayNameEditField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.serverListBox = new JList();
        this.setName(NbBundle.getBundle(ServerWizardVisual.class).getString("LBL_SCV_Name"));
        this.jLabel1.setLabelFor(this.serverListBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(ServerWizardVisual.class).getString("LBL_SCV_Server"));
        this.jLabel2.setLabelFor(this.displayNameEditField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(ServerWizardVisual.class).getString("LBL_SCV_DisplayName"));
        this.displayNameEditField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ServerWizardVisual.this.displayNameEditFieldKeyReleased(evt);
            }
        });
        this.serverListBox.setModel(new WizardListModel());
        this.serverListBox.setSelectionMode(0);
        this.serverListBox.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ServerWizardVisual.this.serverListBoxValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.serverListBox);
        this.serverListBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_NAME_Server"));
        this.serverListBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_DESC_Server"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.displayNameEditField, -1, 375, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 375, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jScrollPane1, -1, 202, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.displayNameEditField, -2, -1, -2)).addContainerGap()));
        this.displayNameEditField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_NAME_DisplayName"));
        this.displayNameEditField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_DESC_DisplayName"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_NAME"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerWizardVisual.class, (String)"A11Y_SCV_DESC"));
    }

    private void serverListBoxValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            WizardAdapter adapter = (WizardAdapter)this.serverListBox.getSelectedValue();
            if (adapter != null) {
                ServerWizardProvider server = adapter.getServerInstanceWizard();
                if (server != null) {
                    this.fillDisplayName(server);
                }
            } else {
                this.fireChange();
            }
        }
    }

    private void displayNameEditFieldKeyReleased(KeyEvent evt) {
        WizardAdapter wizardAdapter = (WizardAdapter)this.serverListBox.getSelectedValue();
        if (wizardAdapter != null) {
            this.displayNames.put(wizardAdapter.getServerInstanceWizard(), this.displayNameEditField.getText());
        }
    }

    private static class WizardPriority
    implements Comparator<WizardAdapter>,
    Serializable {
        private static final List<Pattern> PRIORITY_LIST = new ArrayList<Pattern>(4);

        private WizardPriority() {
        }

        @Override
        public int compare(WizardAdapter o1, WizardAdapter o2) {
            Integer priority1 = this.computePriority(o1.getServerInstanceWizard().getDisplayName());
            Integer priority2 = this.computePriority(o2.getServerInstanceWizard().getDisplayName());
            return -priority1.compareTo(priority2);
        }

        private int computePriority(String name) {
            int priority = 0;
            for (int i = 0; i < PRIORITY_LIST.size(); ++i) {
                if (!PRIORITY_LIST.get(i).matcher(name).matches()) continue;
                priority = i;
            }
            return priority;
        }

        static {
            PRIORITY_LIST.add(Pattern.compile(".*Sailfin.*"));
            PRIORITY_LIST.add(Pattern.compile(".*Sun\\s*Java\\s*System.*"));
            PRIORITY_LIST.add(Pattern.compile(".*GlassFish\\s*v1.*"));
            PRIORITY_LIST.add(Pattern.compile(".*GlassFish\\s*v2.*"));
            PRIORITY_LIST.add(Pattern.compile(".*GlassFish\\s*v3.*"));
            PRIORITY_LIST.add(Pattern.compile(".*GlassFish\\s*v3"));
            PRIORITY_LIST.add(Pattern.compile(".*GlassFish\\s*Server\\s*3.*"));
        }
    }

    private static class WizardAdapter
    implements Comparable<WizardAdapter> {
        private final ServerWizardProvider serverInstanceWizard;

        public WizardAdapter(ServerWizardProvider serverInstanceWizard) {
            this.serverInstanceWizard = serverInstanceWizard;
        }

        public ServerWizardProvider getServerInstanceWizard() {
            return this.serverInstanceWizard;
        }

        @Override
        public int compareTo(WizardAdapter o) {
            return this.serverInstanceWizard.getDisplayName().compareTo(o.getServerInstanceWizard().getDisplayName());
        }

        public String toString() {
            return this.serverInstanceWizard.getDisplayName();
        }
    }

    private static class WizardListModel
    implements ListModel {
        private final List<WizardAdapter> serverWizards = new ArrayList<WizardAdapter>();

        public WizardListModel() {
            for (ServerWizardProvider wizard : Lookups.forPath((String)"Servers").lookupAll(ServerWizardProvider.class)) {
                if (wizard.getInstantiatingIterator() == null) continue;
                this.serverWizards.add(new WizardAdapter(wizard));
            }
            Collections.sort(this.serverWizards);
        }

        public Object getElementAt(int index) {
            return this.serverWizards.get(index);
        }

        @Override
        public int getSize() {
            return this.serverWizards.size();
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

