/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ******************************************************************************
 *
 * Copyright (C) 1996-2005 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer
 *    unmodified other than the allowable addition of one or more
 *    copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 *
 * Version: Onyx 5.1.2
 *
 ******************************************************************************/

/* Global variables. */
extern cw_mema_t *cw_g_nxaa;

void *
nxa_malloc_e(void *a_arg, size_t a_size, const char *a_filename,
	     uint32_t a_line_num);

void *
nxa_calloc_e(void *a_arg, size_t a_number, size_t a_size,
	     const char *a_filename, uint32_t a_line_num);

void *
nxa_realloc_e(void *a_arg, void *a_ptr, size_t a_size, size_t a_old_size,
	      const char *a_filename, uint32_t a_line_num);

void
nxa_free_e(void *a_arg, void *a_ptr, size_t a_size, const char *a_filename,
	   uint32_t a_line_num);

#ifdef CW_DBG
#define nxa_malloc(a_size)						\
    nxa_malloc_e(NULL, (a_size), __FILE__, __LINE__)
#define nxa_calloc(a_num, a_size)					\
    nxa_calloc_e(NULL, (a_num), (a_size), __FILE__, __LINE__)
#define nxa_realloc(a_ptr, a_size, a_old_size)				\
    nxa_realloc_e(NULL, (a_ptr), (a_size), (a_old_size), __FILE__, __LINE__)
#define nxa_free(a_ptr, a_size)						\
    nxa_free_e(NULL, (a_ptr), (a_size), __FILE__, __LINE__)
#else
#define nxa_malloc(a_size)						\
    nxa_malloc_e(NULL, (a_size), NULL, 0)
#define nxa_calloc(a_num, a_size)					\
    nxa_calloc_e(NULL, (a_num), (a_size), NULL, 0)
#define nxa_realloc(a_ptr, a_size, a_old_size)				\
    nxa_realloc_e(NULL, (a_ptr), (a_size), (a_old_size), NULL, 0)
#define nxa_free(a_ptr, a_size)						\
    nxa_free_e(NULL, (a_ptr), (a_size), NULL, 0)
#endif

void
nxa_collect(void);

bool
nxa_active_get(void);

void
nxa_active_set(bool a_active);

#ifdef CW_PTHREADS
cw_nxoi_t
nxa_period_get(void);

void
nxa_period_set(cw_nxoi_t a_period);
#endif
cw_nxoi_t
nxa_threshold_get(void);

void
nxa_threshold_set(cw_nxoi_t a_threshold);

void
nxa_stats_get(cw_nxoi_t *r_collections, cw_nxoi_t *r_count,
	      cw_nxoi_t *r_ccount, cw_nxoi_t *r_cmark,
	      cw_nxoi_t *r_mcount, cw_nxoi_t *r_mmark,
	      cw_nxoi_t *r_scount, cw_nxoi_t *r_smark);
