<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authn_alias - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.2</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authn_alias</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authn_alias.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authn_alias.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Permet de crer des fournisseurs d'authentification tendus
 partir des fournisseurs rels</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authn_alias_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authn_alias.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.1 d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module permet de crer des fournisseurs d'authentification
    tendus dans le fichier de configuration et de leur assigner un
    alias. Les fournisseurs aliass peuvent ensuite tre rfrencs via
    les directives <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> ou <code class="directive"><a href="../mod/mod_auth_digest.html#authdigestprovider">AuthDigestProvider</a></code> de la mme
    manire que les fournisseurs d'authentification de base. Outre la
    possibilit de crer et assigner un alias  un fournisseur
    d'authentification tendu, ce module permet aussi de rfrencer le
    mme fournisseur d'authentification tendu au sein de diffrents
    contextes.</p>

</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#authnprovideralias">&lt;AuthnProviderAlias&gt;</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#example">Exemples</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="example" id="example">Exemples</a></h2>

        <p>Dans cet exemple, des mots de passe sont vrifis dans deux
	fichiers textes diffrents.</p>

        <div class="example"><h3>Vrification  partir de plusieurs fichiers de
	mots de passe au format texte</h3><p><code>

        # Premire vrification<br />
        &lt;AuthnProviderAlias file fichier1&gt;<br />
        <span class="indent">
            AuthUserFile /www/conf/mots-de-passe1<br />
        </span>
        &lt;/AuthnProviderAlias&gt;<br />
        <br />
        # vrification suivante<br />
        &lt;AuthnProviderAlias file fichier2&gt;   <br />
        <span class="indent">
            AuthUserFile /www/conf/mots-de-passe2<br />
        </span>
        &lt;/AuthnProviderAlias&gt;<br />
        <br />
        &lt;Directory /var/web/pages/secure&gt;<br />
        <span class="indent">
            AuthBasicProvider fichier1 fichier2<br />
            <br />
            AuthType Basic<br />
            AuthName "Zone protge"<br />
            Require valid-user<br />
        </span>
        &lt;/Directory&gt;<br />
        </code></p></div>

         <p>Dans l'exemple suivant, deux aliases de fournisseur
	 d'authentification ldap diffrents sont crs  partir du
	 fournisseur ldap. Ceci permet, pour un contexte donn, de
	 mettre en oeuvre une authentification ldap  partir de
	 plusieurs serveurs ldap :</p>

      <div class="example"><h3>Vrification auprs de plusieurs serveurs LDAP</h3><p><code>
      LoadModule authn_alias_module modules/mod_authn_alias.so<br /><br />
      &lt;AuthnProviderAlias ldap ldap-alias1&gt;<br />
      <span class="indent">
         AuthLDAPBindDN cn=votre-utilisateur,o=ctx<br />
         AuthLDAPBindPassword votre-mot-de-passe<br />
         AuthLDAPURL ldap://serveur.ldap/o=ctx<br />
      </span>
      &lt;/AuthnProviderAlias&gt;<br /><br />
      &lt;AuthnProviderAlias ldap ldap-autre-alias&gt;<br />
      <span class="indent">
         AuthLDAPBindDN cn=un-autre-utilisateur,o=dev<br />
         AuthLDAPBindPassword un-autre-mot-de-passe<br />
         AuthLDAPURL ldap://autre.serveur.ldap/o=dev?cn<br />
      </span>
      &lt;/AuthnProviderAlias&gt;<br /><br />

      Alias /secure /webpages/secure<br />
      &lt;Directory /webpages/secure&gt;<br />
      <span class="indent">
         Order deny,allow<br />
         Allow from all<br /><br />

         AuthBasicProvider ldap-autre-alias  ldap-alias1<br /><br />

         AuthType Basic<br />
         AuthName Zone-protge-par-LDAP<br />
         AuthzLDAPAuthoritative off<br />
         Require valid-user<br />
      </span>
      &lt;/Directory&gt;<br />
    </code></p></div>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthnProviderAlias" id="AuthnProviderAlias">&lt;AuthnProviderAlias&gt;</a> <a name="authnprovideralias" id="authnprovideralias">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Regroupe un ensemble de directives qui reprsentent une
extension d'un fournisseur d'authentification de base rfrenc par
l'alias spcifi</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;AuthnProviderAlias <var>fournisseur-de-base Alias</var>&gt;
... &lt;/AuthnProviderAlias&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_alias</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;AuthnProviderAlias&gt;</code> et
    <code>&lt;/AuthnProviderAlias&gt;</code> permettent de regrouper des
    directives qui reprsentent une extension d'un fournisseur
    d'authentification de base pouvant tre rfrence par l'alias
    spcifi dans les directives <code class="directive"><a href="../mod/mod_auth_basic.html#&#10;    authbasicprovider">
    AuthBasicProvider</a></code> ou <code class="directive"><a href="../mod/mod_auth_digest.html#&#10;    authdigestprovider">
    AuthDigestProvider</a></code>.</p>


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authn_alias.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authn_alias.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2011 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>