/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import msfgui.Base64;
import msfgui.MsfException;
import msfgui.MsfFrame;
import msfgui.MsfguiApp;
import msfgui.RpcConnection;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingworker.SwingWorker;

public class InteractWindow
extends MsfFrame {
    public final ReentrantLock lock = new ReentrantLock();
    public static final char POLL = 'r';
    public static final char PAUSE = 'p';
    public static final char STOP_POLLING = 's';
    private final Map session;
    private final RpcConnection rpcConn;
    private final String cmdPrefix;
    private String prompt;
    private Object sid;
    private final StringBuffer timerCommand;
    private static final ArrayList commands;
    private static int currentCommand;
    private JTextField inputField;
    private JTextArea outputArea;
    private JScrollPane outputScrollPane;
    private JLabel promptLabel;
    private JButton submitButton;

    public InteractWindow(final RpcConnection rpcConn, final Map session, final List autoCommands) {
        this(rpcConn, session, "console");
        this.inputField.setEnabled(false);
        new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    String data = Base64.encode((autoCommands.get(0) + "\n").getBytes());
                    if (autoCommands.get(0).toString().startsWith("use")) {
                        rpcConn.execute(InteractWindow.this.cmdPrefix + "write", session.get("id"), data);
                    }
                }
                catch (MsfException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
                for (Object cmd : autoCommands) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.publish(cmd);
                }
                InteractWindow.this.inputField.setEnabled(true);
                return null;
            }

            protected void process(List l) {
                for (Object cmd : l) {
                    InteractWindow.this.inputField.setText(cmd.toString());
                    InteractWindow.this.doInput();
                }
            }
        }.execute();
    }

    public InteractWindow(final RpcConnection rpcConn, Map session, String type) {
        super(type + " interaction window");
        this.initComponents();
        this.rpcConn = rpcConn;
        this.session = session;
        this.sid = session.get("id");
        if (type.equals("console")) {
            this.cmdPrefix = "console.";
            this.inputField.setFocusTraversalKeysEnabled(false);
            this.inputField.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent ke) {
                    if (ke.getKeyChar() == '\t') {
                        try {
                            Map res = (Map)rpcConn.execute("console.tabs", InteractWindow.this.sid, InteractWindow.this.inputField.getText());
                            List tabs = (List)res.get("tabs");
                            if (tabs.size() == 1) {
                                InteractWindow.this.inputField.setText(tabs.get(0).toString());
                            } else if (tabs.size() > 1) {
                                String prefix = tabs.get(0).toString();
                                for (Object o : tabs) {
                                    String s = o.toString();
                                    int len = Math.min(s.length(), prefix.length());
                                    for (int i = 0; i < len; ++i) {
                                        if (s.charAt(i) != prefix.charAt(i)) {
                                            prefix = prefix.substring(0, i);
                                            break;
                                        }
                                        if (s.length() >= prefix.length()) continue;
                                        prefix = s;
                                    }
                                    InteractWindow.this.outputArea.append("\n" + o.toString());
                                }
                                InteractWindow.this.outputArea.append("\n");
                                InteractWindow.this.inputField.setText(prefix);
                            }
                        }
                        catch (MsfException msfException) {
                            // empty catch block
                        }
                    }
                }

                public void keyPressed(KeyEvent ke) {
                }

                public void keyReleased(KeyEvent ke) {
                }
            });
        } else {
            this.cmdPrefix = "session." + type + "_";
        }
        this.timerCommand = new StringBuffer("p");
        this.prompt = ">>>";
        new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground() throws Exception {
                long time = 100L;
                while (InteractWindow.this.timerCommand.charAt(0) != 's') {
                    if (InteractWindow.this.timerCommand.charAt(0) == 'p') {
                        StringBuffer stringBuffer = InteractWindow.this.timerCommand;
                        synchronized (stringBuffer) {
                            InteractWindow.this.timerCommand.wait();
                            continue;
                        }
                    }
                    if (!InteractWindow.this.lock.tryLock()) {
                        this.publish("locked");
                        InteractWindow.this.lock.lock();
                        this.publish("unlocked");
                    }
                    try {
                        long start = System.currentTimeMillis();
                        Map received = (Map)rpcConn.execute(InteractWindow.this.cmdPrefix + "read", InteractWindow.this.sid);
                        time = System.currentTimeMillis() - start;
                        if (!received.get("encoding").equals("base64")) {
                            throw new MsfException("Uhoh. Unknown encoding. Time to update?");
                        }
                        byte[] decodedBytes = Base64.decode(received.get("data").toString());
                        if (decodedBytes.length > 0) {
                            InteractWindow.this.outputArea.append(new String(decodedBytes));
                            if (decodedBytes[decodedBytes.length - 1] != 10) {
                                InteractWindow.this.outputArea.append("\n");
                            }
                            this.publish("data");
                            this.publish(received);
                        }
                    }
                    catch (MsfException ex) {
                        if (!ex.getMessage().equals("unknown session")) {
                            JOptionPane.showMessageDialog(null, ex);
                        }
                        InteractWindow.this.timerCommand.setCharAt(0, 's');
                    }
                    InteractWindow.this.lock.unlock();
                    try {
                        Thread.sleep(100L + time * 3L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return null;
            }

            protected void process(List l) {
                for (Object o : l) {
                    if (o.equals("locked")) {
                        InteractWindow.this.submitButton.setEnabled(false);
                        InteractWindow.this.inputField.setEditable(false);
                        continue;
                    }
                    if (o.equals("unlocked")) {
                        InteractWindow.this.submitButton.setEnabled(true);
                        InteractWindow.this.inputField.setEditable(true);
                        continue;
                    }
                    if (o instanceof Map) {
                        InteractWindow.this.checkPrompt((Map)o);
                        continue;
                    }
                    InteractWindow.this.outputArea.setCaretPosition(InteractWindow.this.outputArea.getDocument().getLength());
                }
            }
        }.execute();
        if (type.equals("meterpreter")) {
            this.inputField.setText("help");
        }
        this.outputArea.setFont(new Font("Monospaced", this.outputArea.getFont().getStyle(), 12));
        this.checkPrompt(session);
    }

    public InteractWindow(RpcConnection rpcConn, Map session, String type, String initVal) {
        this(rpcConn, session, type);
        this.inputField.setText(initVal);
    }

    private void checkPrompt(Map o) {
        try {
            Object pobj = o.get("prompt");
            if (pobj == null) {
                return;
            }
            this.prompt = new String(Base64.decode(pobj.toString()));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.prompt.length(); ++i) {
                if (Character.isISOControl(this.prompt.charAt(i))) continue;
                sb.append(this.prompt.charAt(i));
            }
            this.prompt = sb.toString();
            this.promptLabel.setText(this.prompt);
        }
        catch (MsfException msfException) {
            // empty catch block
        }
    }

    private void doInput() {
        try {
            String command = this.inputField.getText();
            commands.add(command);
            String data = Base64.encode((command + "\n").getBytes());
            this.rpcConn.execute(this.cmdPrefix + "write", this.session.get("id"), data);
            this.outputArea.append(this.prompt + command + "\n");
            this.outputArea.setCaretPosition(this.outputArea.getDocument().getLength());
            this.inputField.setText("");
            currentCommand = 0;
        }
        catch (MsfException ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
    }

    private void initComponents() {
        this.outputScrollPane = new JScrollPane();
        this.outputArea = new JTextArea();
        this.inputField = new JTextField();
        this.submitButton = new JButton();
        this.promptLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                InteractWindow.this.formWindowOpened(evt);
            }

            public void windowClosing(WindowEvent evt) {
                InteractWindow.this.formWindowClosing(evt);
            }

            public void windowActivated(WindowEvent evt) {
                InteractWindow.this.formWindowActivated(evt);
            }
        });
        this.outputScrollPane.setAutoscrolls(true);
        this.outputScrollPane.setName("outputScrollPane");
        this.outputArea.setColumns(20);
        this.outputArea.setEditable(false);
        this.outputArea.setRows(5);
        this.outputArea.setName("outputArea");
        this.outputScrollPane.setViewportView(this.outputArea);
        ResourceMap resourceMap = Application.getInstance(MsfguiApp.class).getContext().getResourceMap(InteractWindow.class);
        this.inputField.setText(resourceMap.getString("inputField.text", new Object[0]));
        this.inputField.setName("inputField");
        this.inputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InteractWindow.this.inputFieldActionPerformed(evt);
            }
        });
        this.inputField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                InteractWindow.this.inputFieldKeyPressed(evt);
            }
        });
        this.submitButton.setText(resourceMap.getString("submitButton.text", new Object[0]));
        this.submitButton.setName("submitButton");
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InteractWindow.this.submitButtonActionPerformed(evt);
            }
        });
        this.promptLabel.setText(resourceMap.getString("promptLabel.text", new Object[0]));
        this.promptLabel.setName("promptLabel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.promptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputField, -1, 628, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton)).addComponent(this.outputScrollPane, -1, 737, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.outputScrollPane, -1, 533, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputField, -2, -1, -2).addComponent(this.submitButton).addComponent(this.promptLabel)).addContainerGap()));
        this.pack();
    }

    private void inputFieldActionPerformed(ActionEvent evt) {
        this.doInput();
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        this.inputFieldActionPerformed(evt);
    }

    private void inputFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 38) {
            currentCommand = (currentCommand - 1 + commands.size()) % commands.size();
            this.inputField.setText(commands.get(currentCommand).toString());
        } else if (evt.getKeyCode() == 40) {
            currentCommand = (currentCommand + 1) % commands.size();
            this.inputField.setText(commands.get(currentCommand).toString());
        } else if (evt.isControlDown() && this.cmdPrefix.equals("console.")) {
            try {
                if (evt.getKeyCode() == 67) {
                    this.rpcConn.execute("console.session_kill", this.session.get("id"));
                    this.outputArea.append("killing session...\n");
                } else if (evt.getKeyCode() == 90) {
                    this.rpcConn.execute("console.session_detach", this.session.get("id"));
                    this.outputArea.append("backgrounding session...\n");
                }
            }
            catch (MsfException ex) {
                JOptionPane.showMessageDialog(null, ex);
            }
        }
    }

    private void formWindowOpened(WindowEvent evt) {
        this.inputField.requestFocusInWindow();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.timerCommand.setCharAt(0, 'p');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formWindowActivated(WindowEvent evt) {
        this.timerCommand.setCharAt(0, 'r');
        StringBuffer stringBuffer = this.timerCommand;
        synchronized (stringBuffer) {
            this.timerCommand.notify();
        }
    }

    static {
        currentCommand = 0;
        commands = new ArrayList();
        commands.add("");
    }
}

