; -*- coding: iso-2022-7bit  -*-
;;; u-cns-6.el --- tables between UCS and CNS 11643:1992 plane 6

;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of Mule-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;;; Code:

(put 'chinese-cns11643-6 'unicode-assoc
     'cns11643-6-vs-unicode-assoc)

(defvar cns11643-6-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(L!!(B . "0x2F802") ; <CJK>
       (?$(L!"(B . "0x20062") ; <CJK>
       (?$(L!#(B . "0x3405") ; <CJK>
       (?$(L!$(B . "0x20088") ; <CJK>
       (?$(L!%(B . "0x200D0") ; <CJK>
       (?$(L!&(B . "0x200CF") ; <CJK>
       (?$(L!'(B . "0x2011E") ; <CJK>
       (?$(L!((B . "0x2011F") ; <CJK>
       (?$(L!)(B . "0x20120") ; <CJK>
       (?$(L!*(B . "0x2090E") ; <CJK>
       (?$(L!+(B . "0x2092C") ; <CJK>
       (?$(L!,(B . "0x20061") ; <CJK>
       (?$(L!-(B . "0x20004") ; <CJK>
       (?$(L!.(B . "0x20005") ; <CJK>
       (?$(L!/(B . "0x20003") ; <CJK>
       (?$(L!0(B . "0x3404") ; <CJK>
       (?$(L!1(B . "0x2F801") ; <CJK>
       (?$(L!2(B . "0x2007D") ; <CJK>
       (?$(L!3(B . "0x2008D") ; <CJK>
       (?$(L!4(B . "0x201A3") ; <CJK>
       (?$(L!5(B . "0x201A4") ; <CJK>
       (?$(L!6(B . "0x204DB") ; <CJK>
       (?$(L!7(B . "0x20500") ; <CJK>
       (?$(L!8(B . "0x2F81E") ; <CJK>
       (?$(L!9(B . "0x206A3") ; <CJK>
       (?$(L!:(B . "0x20832") ; <CJK>
       (?$(L!;(B . "0x353F") ; <CJK>
       (?$(L!<(B . "0x20AD4") ; <CJK>
       (?$(L!=(B . "0x20AD5") ; <CJK>
       (?$(L!>(B . "0x21C23") ; <CJK>
       (?$(L!?(B . "0x2232C") ; <CJK>
       (?$(L!@(B . "0x2237A") ; <CJK>
       (?$(L!A(B . "0x20503") ; <CJK>
       (?$(L!B(B . "0x20007") ; <CJK>
       (?$(L!C(B . "0x20008") ; <CJK>
       (?$(L!D(B . "0x2008F") ; <CJK>
       (?$(L!E(B . "0x2009C") ; <CJK>
       (?$(L!F(B . "0x200D5") ; <CJK>
       (?$(L!G(B . "0x20112") ; <CJK>
       (?$(L!H(B . "0x20113") ; <CJK>
       (?$(L!I(B . "0x20114") ; <CJK>
       (?$(L!J(B . "0x20121") ; <CJK>
       (?$(L!K(B . "0x201A8") ; <CJK>
       (?$(L!L(B . "0x201A6") ; <CJK>
       (?$(L!M(B . "0x20476") ; <CJK>
       (?$(L!N(B . "0x20501") ; <CJK>
       (?$(L!O(B . "0x2053D") ; <CJK>
       (?$(L!P(B . "0x2F814") ; <CJK>
       (?$(L!Q(B . "0x2053E") ; <CJK>
       (?$(L!R(B . "0x20629") ; <CJK>
       (?$(L!S(B . "0x20677") ; <CJK>
       (?$(L!T(B . "0x20678") ; <CJK>
       (?$(L!U(B . "0x206A6") ; <CJK>
       (?$(L!V(B . "0x206A9") ; <CJK>
       (?$(L!W(B . "0x206AC") ; <CJK>
       (?$(L!X(B . "0x20834") ; <CJK>
       (?$(L!Y(B . "0x20504") ; <CJK>
       (?$(L!Z(B . "0x2097B") ; <CJK>
       (?$(L![(B . "0x20A10") ; <CJK>
       (?$(L!\(B . "0x2062F") ; <CJK>
       (?$(L!](B . "0x20AD7") ; <CJK>
       (?$(L!^(B . "0x20B1C") ; <CJK>
       (?$(L!_(B . "0x20B1F") ; <CJK>
       (?$(L!`(B . "0x20B1A") ; <CJK>
       (?$(L!a(B . "0x2F836") ; <CJK>
       (?$(L!b(B . "0x20B1E") ; <CJK>
       (?$(L!c(B . "0x20B9E") ; <CJK>
       (?$(L!d(B . "0x20B9A") ; <CJK>
       (?$(L!e(B . "0x211A0") ; <CJK>
       (?$(L!f(B . "0x211A1") ; <CJK>
       (?$(L!g(B . "0x215D2") ; <CJK>
       (?$(L!h(B . "0x215D3") ; <CJK>
       (?$(L!i(B . "0x219B9") ; <CJK>
       (?$(L!j(B . "0x21B1D") ; <CJK>
       (?$(L!k(B . "0x21B55") ; <CJK>
       (?$(L!l(B . "0x21CFF") ; <CJK>
       (?$(L!m(B . "0x21FE7") ; <CJK>
       (?$(L!n(B . "0x382A") ; <CJK>
       (?$(L!o(B . "0x22011") ; <CJK>
       (?$(L!p(B . "0x22013") ; <CJK>
       (?$(L!q(B . "0x22012") ; <CJK>
       (?$(L!r(B . "0x221AF") ; <CJK>
       (?$(L!s(B . "0x221B1") ; <CJK>
       (?$(L!t(B . "0x2F890") ; <CJK>
       (?$(L!u(B . "0x2232D") ; <CJK>
       (?$(L!v(B . "0x2237B") ; <CJK>
       (?$(L!w(B . "0x2239D") ; <CJK>
       (?$(L!x(B . "0x2239A") ; <CJK>
       (?$(L!y(B . "0x38A7") ; <CJK>
       (?$(L!z(B . "0x2239F") ; <CJK>
       (?$(L!{(B . "0x223A0") ; <CJK>
       (?$(L!|(B . "0x2239C") ; <CJK>
       (?$(L!}(B . "0x224BD") ; <CJK>
       (?$(L!~(B . "0x38FA") ; <CJK>
       (?$(L"!(B . "0x225AA") ; <CJK>
       (?$(L""(B . "0x2306C") ; <CJK>
       (?$(L"#(B . "0x23091") ; <CJK>
       (?$(L"$(B . "0x23C74") ; <CJK>
       (?$(L"%(B . "0x2456A") ; <CJK>
       (?$(L"&(B . "0x2F929") ; <CJK>
       (?$(L"'(B . "0x25605") ; <CJK>
       (?$(L"((B . "0x2626B") ; <CJK>
       (?$(L")(B . "0x2626A") ; <CJK>
       (?$(L"*(B . "0x200E0") ; <CJK>
       (?$(L"+(B . "0x20012") ; <CJK>
       (?$(L",(B . "0x3400") ; <CJK>
       (?$(L"-(B . "0x2007F") ; <CJK>
       (?$(L".(B . "0x200A0") ; <CJK>
       (?$(L"/(B . "0x20099") ; <CJK>
       (?$(L"0(B . "0x20095") ; <CJK>
       (?$(L"1(B . "0x2009E") ; <CJK>
       (?$(L"2(B . "0x200DF") ; <CJK>
       (?$(L"3(B . "0x200DE") ; <CJK>
       (?$(L"4(B . "0x201AF") ; <CJK>
       (?$(L"5(B . "0x201AD") ; <CJK>
       (?$(L"6(B . "0x201B0") ; <CJK>
       (?$(L"7(B . "0x204DF") ; <CJK>
       (?$(L"8(B . "0x20543") ; <CJK>
       (?$(L"9(B . "0x20541") ; <CJK>
       (?$(L":(B . "0x20548") ; <CJK>
       (?$(L";(B . "0x20575") ; <CJK>
       (?$(L"<(B . "0x2F81A") ; <CJK>
       (?$(L"=(B . "0x20632") ; <CJK>
       (?$(L">(B . "0x2067B") ; <CJK>
       (?$(L"?(B . "0x20679") ; <CJK>
       (?$(L"@(B . "0x206B3") ; <CJK>
       (?$(L"A(B . "0x34DB") ; <CJK>
       (?$(L"B(B . "0x20BA7") ; <CJK>
       (?$(L"C(B . "0x206B2") ; <CJK>
       (?$(L"D(B . "0x206B0") ; <CJK>
       (?$(L"E(B . "0x206B4") ; <CJK>
       (?$(L"F(B . "0x2F829") ; <CJK>
       (?$(L"G(B . "0x208CD") ; <CJK>
       (?$(L"H(B . "0x208CE") ; <CJK>
       (?$(L"I(B . "0x2F82B") ; <CJK>
       (?$(L"J(B . "0x20910") ; <CJK>
       (?$(L"K(B . "0x20980") ; <CJK>
       (?$(L"L(B . "0x209D3") ; <CJK>
       (?$(L"M(B . "0x20A30") ; <CJK>
       (?$(L"N(B . "0x20098") ; <CJK>
       (?$(L"O(B . "0x20A2F") ; <CJK>
       (?$(L"P(B . "0x20A31") ; <CJK>
       (?$(L"Q(B . "0x20ADA") ; <CJK>
       (?$(L"R(B . "0x20AD9") ; <CJK>
       (?$(L"S(B . "0x20B27") ; <CJK>
       (?$(L"T(B . "0x20B28") ; <CJK>
       (?$(L"U(B . "0x20B21") ; <CJK>
       (?$(L"V(B . "0x20B25") ; <CJK>
       (?$(L"W(B . "0x20BA6") ; <CJK>
       (?$(L"X(B . "0x20BA2") ; <CJK>
       (?$(L"Y(B . "0x20BA1") ; <CJK>
       (?$(L"Z(B . "0x20BA4") ; <CJK>
       (?$(L"[(B . "0x2F839") ; <CJK>
       (?$(L"\(B . "0x20BAA") ; <CJK>
       (?$(L"](B . "0x20BA5") ; <CJK>
       (?$(L"^(B . "0x20BA3") ; <CJK>
       (?$(L"_(B . "0x20064") ; <CJK>
       (?$(L"`(B . "0x2123F") ; <CJK>
       (?$(L"a(B . "0x21244") ; <CJK>
       (?$(L"b(B . "0x2151B") ; <CJK>
       (?$(L"c(B . "0x21553") ; <CJK>
       (?$(L"d(B . "0x21584") ; <CJK>
       (?$(L"e(B . "0x21586") ; <CJK>
       (?$(L"f(B . "0x215D5") ; <CJK>
       (?$(L"g(B . "0x2F860") ; <CJK>
       (?$(L"h(B . "0x2193E") ; <CJK>
       (?$(L"i(B . "0x21940") ; <CJK>
       (?$(L"j(B . "0x21BCA") ; <CJK>
       (?$(L"k(B . "0x21BC9") ; <CJK>
       (?$(L"l(B . "0x21C26") ; <CJK>
       (?$(L"m(B . "0x21D00") ; <CJK>
       (?$(L"n(B . "0x21D31") ; <CJK>
       (?$(L"o(B . "0x21D3C") ; <CJK>
       (?$(L"p(B . "0x21D30") ; <CJK>
       (?$(L"q(B . "0x21D33") ; <CJK>
       (?$(L"r(B . "0x21D32") ; <CJK>
       (?$(L"s(B . "0x21D38") ; <CJK>
       (?$(L"t(B . "0x22034") ; <CJK>
       (?$(L"u(B . "0x22053") ; <CJK>
       (?$(L"v(B . "0x22054") ; <CJK>
       (?$(L"w(B . "0x221B4") ; <CJK>
       (?$(L"x(B . "0x221B2") ; <CJK>
       (?$(L"y(B . "0x2232F") ; <CJK>
       (?$(L"z(B . "0x223A5") ; <CJK>
       (?$(L"{(B . "0x223A7") ; <CJK>
       (?$(L"|(B . "0x223A4") ; <CJK>
       (?$(L"}(B . "0x223A8") ; <CJK>
       (?$(L"~(B . "0x223A9") ; <CJK>
       (?$(L#!(B . "0x223A2") ; <CJK>
       (?$(L#"(B . "0x223A3") ; <CJK>
       (?$(L##(B . "0x223A6") ; <CJK>
       (?$(L#$(B . "0x22481") ; <CJK>
       (?$(L#%(B . "0x22480") ; <CJK>
       (?$(L#&(B . "0x225AD") ; <CJK>
       (?$(L#'(B . "0x22A24") ; <CJK>
       (?$(L#((B . "0x22A65") ; <CJK>
       (?$(L#)(B . "0x22A68") ; <CJK>
       (?$(L#*(B . "0x22A69") ; <CJK>
       (?$(L#+(B . "0x2313C") ; <CJK>
       (?$(L#,(B . "0x2313B") ; <CJK>
       (?$(L#-(B . "0x2335D") ; <CJK>
       (?$(L#.(B . "0x23944") ; <CJK>
       (?$(L#/(B . "0x24182") ; <CJK>
       (?$(L#0(B . "0x244F1") ; <CJK>
       (?$(L#1(B . "0x2456B") ; <CJK>
       (?$(L#2(B . "0x2471B") ; <CJK>
       (?$(L#3(B . "0x248EB") ; <CJK>
       (?$(L#4(B . "0x24BBA") ; <CJK>
       (?$(L#5(B . "0x24BD3") ; <CJK>
       (?$(L#6(B . "0x24D13") ; <CJK>
       (?$(L#7(B . "0x25922") ; <CJK>
       (?$(L#8(B . "0x26AF4") ; <CJK>
       (?$(L#9(B . "0x2820F") ; <CJK>
       (?$(L#:(B . "0x28210") ; <CJK>
       (?$(L#;(B . "0x20507") ; <CJK>
       (?$(L#<(B . "0x29C0B") ; <CJK>
       (?$(L#=(B . "0x29C0A") ; <CJK>
       (?$(L#>(B . "0x20019") ; <CJK>
       (?$(L#?(B . "0x2001A") ; <CJK>
       (?$(L#@(B . "0x20018") ; <CJK>
       (?$(L#A(B . "0x20066") ; <CJK>
       (?$(L#B(B . "0x20082") ; <CJK>
       (?$(L#C(B . "0x200A8") ; <CJK>
       (?$(L#D(B . "0x200E5") ; <CJK>
       (?$(L#E(B . "0x200E7") ; <CJK>
       (?$(L#F(B . "0x200E4") ; <CJK>
       (?$(L#G(B . "0x20115") ; <CJK>
       (?$(L#H(B . "0x20123") ; <CJK>
       (?$(L#I(B . "0x20124") ; <CJK>
       (?$(L#J(B . "0x20143") ; <CJK>
       (?$(L#K(B . "0x201C3") ; <CJK>
       (?$(L#L(B . "0x201BC") ; <CJK>
       (?$(L#M(B . "0x201BB") ; <CJK>
       (?$(L#N(B . "0x3438") ; <CJK>
       (?$(L#O(B . "0x201B7") ; <CJK>
       (?$(L#P(B . "0x201B9") ; <CJK>
       (?$(L#Q(B . "0x201CF") ; <CJK>
       (?$(L#R(B . "0x2F80D") ; <CJK>
       (?$(L#S(B . "0x2047A") ; <CJK>
       (?$(L#T(B . "0x2047B") ; <CJK>
       (?$(L#U(B . "0x204E1") ; <CJK>
       (?$(L#V(B . "0x204E0") ; <CJK>
       (?$(L#W(B . "0x20509") ; <CJK>
       (?$(L#X(B . "0x2054D") ; <CJK>
       (?$(L#Y(B . "0x2F816") ; <CJK>
       (?$(L#Z(B . "0x2054B") ; <CJK>
       (?$(L#[(B . "0x20579") ; <CJK>
       (?$(L#\(B . "0x205B1") ; <CJK>
       (?$(L#](B . "0x20636") ; <CJK>
       (?$(L#^(B . "0x20635") ; <CJK>
       (?$(L#_(B . "0x20637") ; <CJK>
       (?$(L#`(B . "0x20638") ; <CJK>
       (?$(L#a(B . "0x2067F") ; <CJK>
       (?$(L#b(B . "0x20680") ; <CJK>
       (?$(L#c(B . "0x20681") ; <CJK>
       (?$(L#d(B . "0x26953") ; <CJK>
       (?$(L#e(B . "0x2067E") ; <CJK>
       (?$(L#f(B . "0x206CD") ; <CJK>
       (?$(L#g(B . "0x206BF") ; <CJK>
       (?$(L#h(B . "0x206BE") ; <CJK>
       (?$(L#i(B . "0x206C2") ; <CJK>
       (?$(L#j(B . "0x206B8") ; <CJK>
       (?$(L#k(B . "0x206C1") ; <CJK>
       (?$(L#l(B . "0x6530") ; <CJK>
       (?$(L#m(B . "0x20931") ; <CJK>
       (?$(L#n(B . "0x2092F") ; <CJK>
       (?$(L#o(B . "0x2096F") ; <CJK>
       (?$(L#p(B . "0x20982") ; <CJK>
       (?$(L#q(B . "0x353A") ; <CJK>
       (?$(L#r(B . "0x20987") ; <CJK>
       (?$(L#s(B . "0x20986") ; <CJK>
       (?$(L#t(B . "0x2098D") ; <CJK>
       (?$(L#u(B . "0x20994") ; <CJK>
       (?$(L#v(B . "0x209D7") ; <CJK>
       (?$(L#w(B . "0x209D4") ; <CJK>
       (?$(L#x(B . "0x209D8") ; <CJK>
       (?$(L#y(B . "0x20A16") ; <CJK>
       (?$(L#z(B . "0x20A14") ; <CJK>
       (?$(L#{(B . "0x20A2E") ; <CJK>
       (?$(L#|(B . "0x20A36") ; <CJK>
       (?$(L#}(B . "0x20A37") ; <CJK>
       (?$(L#~(B . "0x21FEE") ; <CJK>
       (?$(L$!(B . "0x20AE0") ; <CJK>
       (?$(L$"(B . "0x20AE5") ; <CJK>
       (?$(L$#(B . "0x20ADF") ; <CJK>
       (?$(L$$(B . "0x20B2B") ; <CJK>
       (?$(L$%(B . "0x20B29") ; <CJK>
       (?$(L$&(B . "0x20B2D") ; <CJK>
       (?$(L$'(B . "0x20B2F") ; <CJK>
       (?$(L$((B . "0x20BB7") ; <CJK>
       (?$(L$)(B . "0x20BC9") ; <CJK>
       (?$(L$*(B . "0x20BC1") ; <CJK>
       (?$(L$+(B . "0x20BCA") ; <CJK>
       (?$(L$,(B . "0x20BB2") ; <CJK>
       (?$(L$-(B . "0x20BAC") ; <CJK>
       (?$(L$.(B . "0x20BAE") ; <CJK>
       (?$(L$/(B . "0x211B2") ; <CJK>
       (?$(L$0(B . "0x211A8") ; <CJK>
       (?$(L$1(B . "0x211B0") ; <CJK>
       (?$(L$2(B . "0x211A7") ; <CJK>
       (?$(L$3(B . "0x2F851") ; <CJK>
       (?$(L$4(B . "0x21252") ; <CJK>
       (?$(L$5(B . "0x2124A") ; <CJK>
       (?$(L$6(B . "0x21556") ; <CJK>
       (?$(L$7(B . "0x21555") ; <CJK>
       (?$(L$8(B . "0x2155F") ; <CJK>
       (?$(L$9(B . "0x2155E") ; <CJK>
       (?$(L$:(B . "0x21588") ; <CJK>
       (?$(L$;(B . "0x2F85D") ; <CJK>
       (?$(L$<(B . "0x215DD") ; <CJK>
       (?$(L$=(B . "0x215E2") ; <CJK>
       (?$(L$>(B . "0x215E1") ; <CJK>
       (?$(L$?(B . "0x215DF") ; <CJK>
       (?$(L$@(B . "0x215E0") ; <CJK>
       (?$(L$A(B . "0x216AF") ; <CJK>
       (?$(L$B(B . "0x216B1") ; <CJK>
       (?$(L$C(B . "0x216BA") ; <CJK>
       (?$(L$D(B . "0x21945") ; <CJK>
       (?$(L$E(B . "0x21943") ; <CJK>
       (?$(L$F(B . "0x219BD") ; <CJK>
       (?$(L$G(B . "0x219C8") ; <CJK>
       (?$(L$H(B . "0x2F86C") ; <CJK>
       (?$(L$I(B . "0x219BE") ; <CJK>
       (?$(L$J(B . "0x219BF") ; <CJK>
       (?$(L$K(B . "0x2F874") ; <CJK>
       (?$(L$L(B . "0x21B59") ; <CJK>
       (?$(L$M(B . "0x21C29") ; <CJK>
       (?$(L$N(B . "0x21C2C") ; <CJK>
       (?$(L$O(B . "0x21C2F") ; <CJK>
       (?$(L$P(B . "0x21C2D") ; <CJK>
       (?$(L$Q(B . "0x21C2E") ; <CJK>
       (?$(L$R(B . "0x21D04") ; <CJK>
       (?$(L$S(B . "0x21D02") ; <CJK>
       (?$(L$T(B . "0x21D01") ; <CJK>
       (?$(L$U(B . "0x21D40") ; <CJK>
       (?$(L$V(B . "0x21D4A") ; <CJK>
       (?$(L$W(B . "0x21D3F") ; <CJK>
       (?$(L$X(B . "0x21D4F") ; <CJK>
       (?$(L$Y(B . "0x21D41") ; <CJK>
       (?$(L$Z(B . "0x21D4E") ; <CJK>
       (?$(L$[(B . "0x21FEB") ; <CJK>
       (?$(L$\(B . "0x21FEC") ; <CJK>
       (?$(L$](B . "0x200AC") ; <CJK>
       (?$(L$^(B . "0x2205B") ; <CJK>
       (?$(L$_(B . "0x22063") ; <CJK>
       (?$(L$`(B . "0x2205A") ; <CJK>
       (?$(L$a(B . "0x22059") ; <CJK>
       (?$(L$b(B . "0x221DC") ; <CJK>
       (?$(L$c(B . "0x221DB") ; <CJK>
       (?$(L$d(B . "0x221D9") ; <CJK>
       (?$(L$e(B . "0x221E0") ; <CJK>
       (?$(L$f(B . "0x221DD") ; <CJK>
       (?$(L$g(B . "0x20020") ; <CJK>
       (?$(L$h(B . "0x223B0") ; <CJK>
       (?$(L$i(B . "0x223B1") ; <CJK>
       (?$(L$j(B . "0x223B2") ; <CJK>
       (?$(L$k(B . "0x223B6") ; <CJK>
       (?$(L$l(B . "0x22451") ; <CJK>
       (?$(L$m(B . "0x22452") ; <CJK>
       (?$(L$n(B . "0x22450") ; <CJK>
       (?$(L$o(B . "0x22484") ; <CJK>
       (?$(L$p(B . "0x38C9") ; <CJK>
       (?$(L$q(B . "0x22483") ; <CJK>
       (?$(L$r(B . "0x225C3") ; <CJK>
       (?$(L$s(B . "0x225B8") ; <CJK>
       (?$(L$t(B . "0x225B9") ; <CJK>
       (?$(L$u(B . "0x225B2") ; <CJK>
       (?$(L$v(B . "0x22990") ; <CJK>
       (?$(L$w(B . "0x22A26") ; <CJK>
       (?$(L$x(B . "0x22A29") ; <CJK>
       (?$(L$y(B . "0x22A6E") ; <CJK>
       (?$(L$z(B . "0x23140") ; <CJK>
       (?$(L${(B . "0x2313E") ; <CJK>
       (?$(L$|(B . "0x23141") ; <CJK>
       (?$(L$}(B . "0x2335E") ; <CJK>
       (?$(L$~(B . "0x233BB") ; <CJK>
       (?$(L%!(B . "0x233BC") ; <CJK>
       (?$(L%"(B . "0x233B9") ; <CJK>
       (?$(L%#(B . "0x2F8EF") ; <CJK>
       (?$(L%$(B . "0x23880") ; <CJK>
       (?$(L%%(B . "0x3C4F") ; <CJK>
       (?$(L%&(B . "0x23945") ; <CJK>
       (?$(L%'(B . "0x239BA") ; <CJK>
       (?$(L%((B . "0x239BD") ; <CJK>
       (?$(L%)(B . "0x23C56") ; <CJK>
       (?$(L%*(B . "0x23C55") ; <CJK>
       (?$(L%+(B . "0x23C75") ; <CJK>
       (?$(L%,(B . "0x23C77") ; <CJK>
       (?$(L%-(B . "0x23C81") ; <CJK>
       (?$(L%.(B . "0x2F8FA") ; <CJK>
       (?$(L%/(B . "0x23C83") ; <CJK>
       (?$(L%0(B . "0x23C8B") ; <CJK>
       (?$(L%1(B . "0x23C84") ; <CJK>
       (?$(L%2(B . "0x24186") ; <CJK>
       (?$(L%3(B . "0x24183") ; <CJK>
       (?$(L%4(B . "0x2418B") ; <CJK>
       (?$(L%5(B . "0x2456D") ; <CJK>
       (?$(L%6(B . "0x24616") ; <CJK>
       (?$(L%7(B . "0x24728") ; <CJK>
       (?$(L%8(B . "0x248EA") ; <CJK>
       (?$(L%9(B . "0x24BD4") ; <CJK>
       (?$(L%:(B . "0x24C03") ; <CJK>
       (?$(L%;(B . "0x24D15") ; <CJK>
       (?$(L%<(B . "0x24F3D") ; <CJK>
       (?$(L%=(B . "0x24F3E") ; <CJK>
       (?$(L%>(B . "0x25416") ; <CJK>
       (?$(L%?(B . "0x2F94C") ; <CJK>
       (?$(L%@(B . "0x25606") ; <CJK>
       (?$(L%A(B . "0x2574D") ; <CJK>
       (?$(L%B(B . "0x26222") ; <CJK>
       (?$(L%C(B . "0x26273") ; <CJK>
       (?$(L%D(B . "0x2626D") ; <CJK>
       (?$(L%E(B . "0x2626E") ; <CJK>
       (?$(L%F(B . "0x264B1") ; <CJK>
       (?$(L%G(B . "0x2054E") ; <CJK>
       (?$(L%H(B . "0x2662D") ; <CJK>
       (?$(L%I(B . "0x43CD") ; <CJK>
       (?$(L%J(B . "0x268F9") ; <CJK>
       (?$(L%K(B . "0x26952") ; <CJK>
       (?$(L%L(B . "0x26B00") ; <CJK>
       (?$(L%M(B . "0x26AFC") ; <CJK>
       (?$(L%N(B . "0x26AFA") ; <CJK>
       (?$(L%O(B . "0x4492") ; <CJK>
       (?$(L%P(B . "0x26AF7") ; <CJK>
       (?$(L%Q(B . "0x26AF8") ; <CJK>
       (?$(L%R(B . "0x2F990") ; <CJK>
       (?$(L%S(B . "0x2F9C4") ; <CJK>
       (?$(L%T(B . "0x27C27") ; <CJK>
       (?$(L%U(B . "0x28211") ; <CJK>
       (?$(L%V(B . "0x200AE") ; <CJK>
       (?$(L%W(B . "0x28450") ; <CJK>
       (?$(L%X(B . "0x2844F") ; <CJK>
       (?$(L%Y(B . "0x2844D") ; <CJK>
       (?$(L%Z(B . "0x28671") ; <CJK>
       (?$(L%[(B . "0x2F9E2") ; <CJK>
       (?$(L%\(B . "0x28672") ; <CJK>
       (?$(L%](B . "0x28E18") ; <CJK>
       (?$(L%^(B . "0x20A44") ; <CJK>
       (?$(L%_(B . "0x20021") ; <CJK>
       (?$(L%`(B . "0x20067") ; <CJK>
       (?$(L%a(B . "0x200AF") ; <CJK>
       (?$(L%b(B . "0x200B0") ; <CJK>
       (?$(L%c(B . "0x20029") ; <CJK>
       (?$(L%d(B . "0x20117") ; <CJK>
       (?$(L%e(B . "0x20122") ; <CJK>
       (?$(L%f(B . "0x2F803") ; <CJK>
       (?$(L%g(B . "0x20025") ; <CJK>
       (?$(L%h(B . "0x20128") ; <CJK>
       (?$(L%i(B . "0x201FF") ; <CJK>
       (?$(L%j(B . "0x201D9") ; <CJK>
       (?$(L%k(B . "0x201DB") ; <CJK>
       (?$(L%l(B . "0x201DE") ; <CJK>
       (?$(L%m(B . "0x201F2") ; <CJK>
       (?$(L%n(B . "0x201FE") ; <CJK>
       (?$(L%o(B . "0x201F4") ; <CJK>
       (?$(L%p(B . "0x201DD") ; <CJK>
       (?$(L%q(B . "0x3445") ; <CJK>
       (?$(L%r(B . "0x2F804") ; <CJK>
       (?$(L%s(B . "0x20201") ; <CJK>
       (?$(L%t(B . "0x201DC") ; <CJK>
       (?$(L%u(B . "0x2047D") ; <CJK>
       (?$(L%v(B . "0x20481") ; <CJK>
       (?$(L%w(B . "0x2047E") ; <CJK>
       (?$(L%x(B . "0x2047F") ; <CJK>
       (?$(L%y(B . "0x204E5") ; <CJK>
       (?$(L%z(B . "0x2050F") ; <CJK>
       (?$(L%{(B . "0x34B5") ; <CJK>
       (?$(L%|(B . "0x2050A") ; <CJK>
       (?$(L%}(B . "0x34B6") ; <CJK>
       (?$(L%~(B . "0x2050B") ; <CJK>
       (?$(L&!(B . "0x20551") ; <CJK>
       (?$(L&"(B . "0x20552") ; <CJK>
       (?$(L&#(B . "0x20550") ; <CJK>
       (?$(L&$(B . "0x205B8") ; <CJK>
       (?$(L&%(B . "0x2063D") ; <CJK>
       (?$(L&&(B . "0x2063E") ; <CJK>
       (?$(L&'(B . "0x2063C") ; <CJK>
       (?$(L&((B . "0x20687") ; <CJK>
       (?$(L&)(B . "0x206D7") ; <CJK>
       (?$(L&*(B . "0x206DB") ; <CJK>
       (?$(L&+(B . "0x206CF") ; <CJK>
       (?$(L&,(B . "0x206E0") ; <CJK>
       (?$(L&-(B . "0x2084C") ; <CJK>
       (?$(L&.(B . "0x20842") ; <CJK>
       (?$(L&/(B . "0x208D4") ; <CJK>
       (?$(L&0(B . "0x20911") ; <CJK>
       (?$(L&1(B . "0x20914") ; <CJK>
       (?$(L&2(B . "0x20915") ; <CJK>
       (?$(L&3(B . "0x20912") ; <CJK>
       (?$(L&4(B . "0x20933") ; <CJK>
       (?$(L&5(B . "0x20935") ; <CJK>
       (?$(L&6(B . "0x3537") ; <CJK>
       (?$(L&7(B . "0x20971") ; <CJK>
       (?$(L&8(B . "0x3530") ; <CJK>
       (?$(L&9(B . "0x20991") ; <CJK>
       (?$(L&:(B . "0x20993") ; <CJK>
       (?$(L&;(B . "0x20995") ; <CJK>
       (?$(L&<(B . "0x209DC") ; <CJK>
       (?$(L&=(B . "0x20A42") ; <CJK>
       (?$(L&>(B . "0x20A40") ; <CJK>
       (?$(L&?(B . "0x253A6") ; <CJK>
       (?$(L&@(B . "0x20AE6") ; <CJK>
       (?$(L&A(B . "0x2128F") ; <CJK>
       (?$(L&B(B . "0x20B32") ; <CJK>
       (?$(L&C(B . "0x2F837") ; <CJK>
       (?$(L&D(B . "0x20B31") ; <CJK>
       (?$(L&E(B . "0x20BF5") ; <CJK>
       (?$(L&F(B . "0x20BCD") ; <CJK>
       (?$(L&G(B . "0x20BDE") ; <CJK>
       (?$(L&H(B . "0x20BD5") ; <CJK>
       (?$(L&I(B . "0x20BDA") ; <CJK>
       (?$(L&J(B . "0x20BEE") ; <CJK>
       (?$(L&K(B . "0x20BEC") ; <CJK>
       (?$(L&L(B . "0x20BCF") ; <CJK>
       (?$(L&M(B . "0x20BCE") ; <CJK>
       (?$(L&N(B . "0x2F83D") ; <CJK>
       (?$(L&O(B . "0x20BCC") ; <CJK>
       (?$(L&P(B . "0x20BF3") ; <CJK>
       (?$(L&Q(B . "0x211C1") ; <CJK>
       (?$(L&R(B . "0x211C4") ; <CJK>
       (?$(L&S(B . "0x211C6") ; <CJK>
       (?$(L&T(B . "0x211B4") ; <CJK>
       (?$(L&U(B . "0x211C3") ; <CJK>
       (?$(L&V(B . "0x211B8") ; <CJK>
       (?$(L&W(B . "0x211BB") ; <CJK>
       (?$(L&X(B . "0x211B7") ; <CJK>
       (?$(L&Y(B . "0x211BC") ; <CJK>
       (?$(L&Z(B . "0x211BF") ; <CJK>
       (?$(L&[(B . "0x211C7") ; <CJK>
       (?$(L&\(B . "0x211BE") ; <CJK>
       (?$(L&](B . "0x21260") ; <CJK>
       (?$(L&^(B . "0x2125D") ; <CJK>
       (?$(L&_(B . "0x21276") ; <CJK>
       (?$(L&`(B . "0x2126C") ; <CJK>
       (?$(L&a(B . "0x21275") ; <CJK>
       (?$(L&b(B . "0x2125B") ; <CJK>
       (?$(L&c(B . "0x21271") ; <CJK>
       (?$(L&d(B . "0x21273") ; <CJK>
       (?$(L&e(B . "0x21261") ; <CJK>
       (?$(L&f(B . "0x2125A") ; <CJK>
       (?$(L&g(B . "0x21262") ; <CJK>
       (?$(L&h(B . "0x21272") ; <CJK>
       (?$(L&i(B . "0x2125F") ; <CJK>
       (?$(L&j(B . "0x21258") ; <CJK>
       (?$(L&k(B . "0x2151E") ; <CJK>
       (?$(L&l(B . "0x21558") ; <CJK>
       (?$(L&m(B . "0x2158B") ; <CJK>
       (?$(L&n(B . "0x2158A") ; <CJK>
       (?$(L&o(B . "0x215F4") ; <CJK>
       (?$(L&p(B . "0x215F0") ; <CJK>
       (?$(L&q(B . "0x216D2") ; <CJK>
       (?$(L&r(B . "0x216CD") ; <CJK>
       (?$(L&s(B . "0x216CE") ; <CJK>
       (?$(L&t(B . "0x216BC") ; <CJK>
       (?$(L&u(B . "0x216D0") ; <CJK>
       (?$(L&v(B . "0x21946") ; <CJK>
       (?$(L&w(B . "0x21947") ; <CJK>
       (?$(L&x(B . "0x373E") ; <CJK>
       (?$(L&y(B . "0x374D") ; <CJK>
       (?$(L&z(B . "0x3751") ; <CJK>
       (?$(L&{(B . "0x219CE") ; <CJK>
       (?$(L&|(B . "0x219CF") ; <CJK>
       (?$(L&}(B . "0x219CC") ; <CJK>
       (?$(L&~(B . "0x219CB") ; <CJK>
       (?$(L'!(B . "0x2F872") ; <CJK>
       (?$(L'"(B . "0x21B60") ; <CJK>
       (?$(L'#(B . "0x21B5F") ; <CJK>
       (?$(L'$(B . "0x21B5D") ; <CJK>
       (?$(L'%(B . "0x21BD4") ; <CJK>
       (?$(L'&(B . "0x21C3A") ; <CJK>
       (?$(L''(B . "0x21C38") ; <CJK>
       (?$(L'((B . "0x21C3C") ; <CJK>
       (?$(L')(B . "0x21C36") ; <CJK>
       (?$(L'*(B . "0x21D08") ; <CJK>
       (?$(L'+(B . "0x21D7E") ; <CJK>
       (?$(L',(B . "0x21D5E") ; <CJK>
       (?$(L'-(B . "0x21D6E") ; <CJK>
       (?$(L'.(B . "0x21D53") ; <CJK>
       (?$(L'/(B . "0x21D70") ; <CJK>
       (?$(L'0(B . "0x21D57") ; <CJK>
       (?$(L'1(B . "0x21D5D") ; <CJK>
       (?$(L'2(B . "0x21D63") ; <CJK>
       (?$(L'3(B . "0x21D7A") ; <CJK>
       (?$(L'4(B . "0x21D79") ; <CJK>
       (?$(L'5(B . "0x21D93") ; <CJK>
       (?$(L'6(B . "0x2F881") ; <CJK>
       (?$(L'7(B . "0x2201D") ; <CJK>
       (?$(L'8(B . "0x22068") ; <CJK>
       (?$(L'9(B . "0x22073") ; <CJK>
       (?$(L':(B . "0x22074") ; <CJK>
       (?$(L';(B . "0x22066") ; <CJK>
       (?$(L'<(B . "0x2206F") ; <CJK>
       (?$(L'=(B . "0x22075") ; <CJK>
       (?$(L'>(B . "0x2207A") ; <CJK>
       (?$(L'?(B . "0x22070") ; <CJK>
       (?$(L'@(B . "0x2206D") ; <CJK>
       (?$(L'A(B . "0x22065") ; <CJK>
       (?$(L'B(B . "0x2218A") ; <CJK>
       (?$(L'C(B . "0x221ED") ; <CJK>
       (?$(L'D(B . "0x221E9") ; <CJK>
       (?$(L'E(B . "0x221E3") ; <CJK>
       (?$(L'F(B . "0x221EF") ; <CJK>
       (?$(L'G(B . "0x3873") ; <CJK>
       (?$(L'H(B . "0x221EA") ; <CJK>
       (?$(L'I(B . "0x22331") ; <CJK>
       (?$(L'J(B . "0x2F891") ; <CJK>
       (?$(L'K(B . "0x22338") ; <CJK>
       (?$(L'L(B . "0x26B20") ; <CJK>
       (?$(L'M(B . "0x22335") ; <CJK>
       (?$(L'N(B . "0x2233A") ; <CJK>
       (?$(L'O(B . "0x22381") ; <CJK>
       (?$(L'P(B . "0x22380") ; <CJK>
       (?$(L'Q(B . "0x223B8") ; <CJK>
       (?$(L'R(B . "0x223C1") ; <CJK>
       (?$(L'S(B . "0x223BA") ; <CJK>
       (?$(L'T(B . "0x22488") ; <CJK>
       (?$(L'U(B . "0x224CF") ; <CJK>
       (?$(L'V(B . "0x224CA") ; <CJK>
       (?$(L'W(B . "0x224C7") ; <CJK>
       (?$(L'X(B . "0x224C5") ; <CJK>
       (?$(L'Y(B . "0x224C8") ; <CJK>
       (?$(L'Z(B . "0x224D0") ; <CJK>
       (?$(L'[(B . "0x224C9") ; <CJK>
       (?$(L'\(B . "0x225BB") ; <CJK>
       (?$(L'](B . "0x225B6") ; <CJK>
       (?$(L'^(B . "0x225BD") ; <CJK>
       (?$(L'_(B . "0x2F89D") ; <CJK>
       (?$(L'`(B . "0x225B4") ; <CJK>
       (?$(L'a(B . "0x225C1") ; <CJK>
       (?$(L'b(B . "0x225D1") ; <CJK>
       (?$(L'c(B . "0x225D2") ; <CJK>
       (?$(L'd(B . "0x225CC") ; <CJK>
       (?$(L'e(B . "0x225D4") ; <CJK>
       (?$(L'f(B . "0x225CB") ; <CJK>
       (?$(L'g(B . "0x225CE") ; <CJK>
       (?$(L'h(B . "0x225D5") ; <CJK>
       (?$(L'i(B . "0x225D8") ; <CJK>
       (?$(L'j(B . "0x22995") ; <CJK>
       (?$(L'k(B . "0x22993") ; <CJK>
       (?$(L'l(B . "0x22999") ; <CJK>
       (?$(L'm(B . "0x22996") ; <CJK>
       (?$(L'n(B . "0x39BE") ; <CJK>
       (?$(L'o(B . "0x22A89") ; <CJK>
       (?$(L'p(B . "0x22A94") ; <CJK>
       (?$(L'q(B . "0x22A91") ; <CJK>
       (?$(L'r(B . "0x22A8F") ; <CJK>
       (?$(L's(B . "0x22A84") ; <CJK>
       (?$(L't(B . "0x22A97") ; <CJK>
       (?$(L'u(B . "0x22A86") ; <CJK>
       (?$(L'v(B . "0x22A85") ; <CJK>
       (?$(L'w(B . "0x22A8C") ; <CJK>
       (?$(L'x(B . "0x22EF2") ; <CJK>
       (?$(L'y(B . "0x22EED") ; <CJK>
       (?$(L'z(B . "0x22EEF") ; <CJK>
       (?$(L'{(B . "0x230D9") ; <CJK>
       (?$(L'|(B . "0x23146") ; <CJK>
       (?$(L'}(B . "0x23147") ; <CJK>
       (?$(L'~(B . "0x2314B") ; <CJK>
       (?$(L(!(B . "0x23150") ; <CJK>
       (?$(L("(B . "0x2314A") ; <CJK>
       (?$(L(#(B . "0x2314E") ; <CJK>
       (?$(L($(B . "0x2314C") ; <CJK>
       (?$(L(%(B . "0x23148") ; <CJK>
       (?$(L(&(B . "0x23363") ; <CJK>
       (?$(L('(B . "0x23361") ; <CJK>
       (?$(L(((B . "0x23362") ; <CJK>
       (?$(L()(B . "0x23360") ; <CJK>
       (?$(L(*(B . "0x233C3") ; <CJK>
       (?$(L(+(B . "0x233C5") ; <CJK>
       (?$(L(,(B . "0x233C1") ; <CJK>
       (?$(L(-(B . "0x233D0") ; <CJK>
       (?$(L(.(B . "0x2F8DC") ; <CJK>
       (?$(L(/(B . "0x23882") ; <CJK>
       (?$(L(0(B . "0x3C1E") ; <CJK>
       (?$(L(1(B . "0x23886") ; <CJK>
       (?$(L(2(B . "0x23884") ; <CJK>
       (?$(L(3(B . "0x2394C") ; <CJK>
       (?$(L(4(B . "0x23948") ; <CJK>
       (?$(L(5(B . "0x239B8") ; <CJK>
       (?$(L(6(B . "0x239BF") ; <CJK>
       (?$(L(7(B . "0x239C1") ; <CJK>
       (?$(L(8(B . "0x239C6") ; <CJK>
       (?$(L(9(B . "0x239C5") ; <CJK>
       (?$(L(:(B . "0x239C7") ; <CJK>
       (?$(L(;(B . "0x239C0") ; <CJK>
       (?$(L(<(B . "0x239C3") ; <CJK>
       (?$(L(=(B . "0x23AED") ; <CJK>
       (?$(L(>(B . "0x23B03") ; <CJK>
       (?$(L(?(B . "0x23B22") ; <CJK>
       (?$(L(@(B . "0x23B21") ; <CJK>
       (?$(L(A(B . "0x23C9F") ; <CJK>
       (?$(L(B(B . "0x23C90") ; <CJK>
       (?$(L(C(B . "0x23C9E") ; <CJK>
       (?$(L(D(B . "0x3CC8") ; <CJK>
       (?$(L(E(B . "0x23CA0") ; <CJK>
       (?$(L(F(B . "0x23C94") ; <CJK>
       (?$(L(G(B . "0x23C95") ; <CJK>
       (?$(L(H(B . "0x23CA1") ; <CJK>
       (?$(L(I(B . "0x3CC3") ; <CJK>
       (?$(L(J(B . "0x3CC7") ; <CJK>
       (?$(L(K(B . "0x2419A") ; <CJK>
       (?$(L(L(B . "0x24190") ; <CJK>
       (?$(L(M(B . "0x244F2") ; <CJK>
       (?$(L(N(B . "0x244F3") ; <CJK>
       (?$(L(O(B . "0x2456E") ; <CJK>
       (?$(L(P(B . "0x245AB") ; <CJK>
       (?$(L(Q(B . "0x245A9") ; <CJK>
       (?$(L(R(B . "0x2461A") ; <CJK>
       (?$(L(S(B . "0x24618") ; <CJK>
       (?$(L(T(B . "0x2461B") ; <CJK>
       (?$(L(U(B . "0x24760") ; <CJK>
       (?$(L(V(B . "0x2474C") ; <CJK>
       (?$(L(W(B . "0x24742") ; <CJK>
       (?$(L(X(B . "0x24733") ; <CJK>
       (?$(L(Y(B . "0x2473F") ; <CJK>
       (?$(L(Z(B . "0x2473E") ; <CJK>
       (?$(L([(B . "0x24738") ; <CJK>
       (?$(L(\(B . "0x24743") ; <CJK>
       (?$(L(](B . "0x24746") ; <CJK>
       (?$(L(^(B . "0x24736") ; <CJK>
       (?$(L(_(B . "0x248EE") ; <CJK>
       (?$(L(`(B . "0x248F5") ; <CJK>
       (?$(L(a(B . "0x248F4") ; <CJK>
       (?$(L(b(B . "0x3F56") ; <CJK>
       (?$(L(c(B . "0x24C1B") ; <CJK>
       (?$(L(d(B . "0x3540") ; <CJK>
       (?$(L(e(B . "0x24D2B") ; <CJK>
       (?$(L(f(B . "0x24D29") ; <CJK>
       (?$(L(g(B . "0x24D2A") ; <CJK>
       (?$(L(h(B . "0x24D2E") ; <CJK>
       (?$(L(i(B . "0x2503F") ; <CJK>
       (?$(L(j(B . "0x250E6") ; <CJK>
       (?$(L(k(B . "0x253A7") ; <CJK>
       (?$(L(l(B . "0x253A8") ; <CJK>
       (?$(L(m(B . "0x25418") ; <CJK>
       (?$(L(n(B . "0x25608") ; <CJK>
       (?$(L(o(B . "0x25750") ; <CJK>
       (?$(L(p(B . "0x25753") ; <CJK>
       (?$(L(q(B . "0x25A56") ; <CJK>
       (?$(L(r(B . "0x25A55") ; <CJK>
       (?$(L(s(B . "0x2626F") ; <CJK>
       (?$(L(t(B . "0x2627F") ; <CJK>
       (?$(L(u(B . "0x264B3") ; <CJK>
       (?$(L(v(B . "0x2663A") ; <CJK>
       (?$(L(w(B . "0x26638") ; <CJK>
       (?$(L(x(B . "0x26637") ; <CJK>
       (?$(L(y(B . "0x26636") ; <CJK>
       (?$(L(z(B . "0x20554") ; <CJK>
       (?$(L({(B . "0x2F980") ; <CJK>
       (?$(L(|(B . "0x268DD") ; <CJK>
       (?$(L(}(B . "0x268FC") ; <CJK>
       (?$(L(~(B . "0x268FA") ; <CJK>
       (?$(L)!(B . "0x26933") ; <CJK>
       (?$(L)"(B . "0x26B04") ; <CJK>
       (?$(L)#(B . "0x26B07") ; <CJK>
       (?$(L)$(B . "0x26B08") ; <CJK>
       (?$(L)%(B . "0x26B06") ; <CJK>
       (?$(L)&(B . "0x26B09") ; <CJK>
       (?$(L)'(B . "0x2F991") ; <CJK>
       (?$(L)((B . "0x2F993") ; <CJK>
       (?$(L))(B . "0x2721E") ; <CJK>
       (?$(L)*(B . "0x2F9D2") ; <CJK>
       (?$(L)+(B . "0x2840B") ; <CJK>
       (?$(L),(B . "0x28443") ; <CJK>
       (?$(L)-(B . "0x28452") ; <CJK>
       (?$(L).(B . "0x28458") ; <CJK>
       (?$(L)/(B . "0x2845E") ; <CJK>
       (?$(L)0(B . "0x28668") ; <CJK>
       (?$(L)1(B . "0x2868D") ; <CJK>
       (?$(L)2(B . "0x28682") ; <CJK>
       (?$(L)3(B . "0x2867B") ; <CJK>
       (?$(L)4(B . "0x28C58") ; <CJK>
       (?$(L)5(B . "0x49BD") ; <CJK>
       (?$(L)6(B . "0x2F800") ; <CJK>
       (?$(L)7(B . "0x2002C") ; <CJK>
       (?$(L)8(B . "0x2002E") ; <CJK>
       (?$(L)9(B . "0x2160B") ; <CJK>
       (?$(L):(B . "0x2002D") ; <CJK>
       (?$(L);(B . "0x20069") ; <CJK>
       (?$(L)<(B . "0x200B2") ; <CJK>
       (?$(L)=(B . "0x200B6") ; <CJK>
       (?$(L)>(B . "0x200A9") ; <CJK>
       (?$(L)?(B . "0x200ED") ; <CJK>
       (?$(L)@(B . "0x20119") ; <CJK>
       (?$(L)A(B . "0x2014F") ; <CJK>
       (?$(L)B(B . "0x20216") ; <CJK>
       (?$(L)C(B . "0x20203") ; <CJK>
       (?$(L)D(B . "0x2020E") ; <CJK>
       (?$(L)E(B . "0x20204") ; <CJK>
       (?$(L)F(B . "0x20207") ; <CJK>
       (?$(L)G(B . "0x20210") ; <CJK>
       (?$(L)H(B . "0x20227") ; <CJK>
       (?$(L)I(B . "0x20228") ; <CJK>
       (?$(L)J(B . "0x2020D") ; <CJK>
       (?$(L)K(B . "0x20229") ; <CJK>
       (?$(L)L(B . "0x2020F") ; <CJK>
       (?$(L)M(B . "0x20222") ; <CJK>
       (?$(L)N(B . "0x20211") ; <CJK>
       (?$(L)O(B . "0x20485") ; <CJK>
       (?$(L)P(B . "0x20484") ; <CJK>
       (?$(L)Q(B . "0x20483") ; <CJK>
       (?$(L)R(B . "0x2048A") ; <CJK>
       (?$(L)S(B . "0x20486") ; <CJK>
       (?$(L)T(B . "0x20510") ; <CJK>
       (?$(L)U(B . "0x20558") ; <CJK>
       (?$(L)V(B . "0x2055A") ; <CJK>
       (?$(L)W(B . "0x2070C") ; <CJK>
       (?$(L)X(B . "0x205C4") ; <CJK>
       (?$(L)Y(B . "0x205C5") ; <CJK>
       (?$(L)Z(B . "0x20647") ; <CJK>
       (?$(L)[(B . "0x20649") ; <CJK>
       (?$(L)\(B . "0x2064A") ; <CJK>
       (?$(L)](B . "0x2064B") ; <CJK>
       (?$(L)^(B . "0x221BB") ; <CJK>
       (?$(L)_(B . "0x2068D") ; <CJK>
       (?$(L)`(B . "0x2068B") ; <CJK>
       (?$(L)a(B . "0x20707") ; <CJK>
       (?$(L)b(B . "0x20706") ; <CJK>
       (?$(L)c(B . "0x2F820") ; <CJK>
       (?$(L)d(B . "0x206EF") ; <CJK>
       (?$(L)e(B . "0x206F0") ; <CJK>
       (?$(L)f(B . "0x206ED") ; <CJK>
       (?$(L)g(B . "0x206F9") ; <CJK>
       (?$(L)h(B . "0x20702") ; <CJK>
       (?$(L)i(B . "0x206E7") ; <CJK>
       (?$(L)j(B . "0x206F4") ; <CJK>
       (?$(L)k(B . "0x206F7") ; <CJK>
       (?$(L)l(B . "0x206F1") ; <CJK>
       (?$(L)m(B . "0x20853") ; <CJK>
       (?$(L)n(B . "0x20855") ; <CJK>
       (?$(L)o(B . "0x351A") ; <CJK>
       (?$(L)p(B . "0x208DA") ; <CJK>
       (?$(L)q(B . "0x208D9") ; <CJK>
       (?$(L)r(B . "0x352C") ; <CJK>
       (?$(L)s(B . "0x20938") ; <CJK>
       (?$(L)t(B . "0x20999") ; <CJK>
       (?$(L)u(B . "0x209A2") ; <CJK>
       (?$(L)v(B . "0x2099C") ; <CJK>
       (?$(L)w(B . "0x2099A") ; <CJK>
       (?$(L)x(B . "0x2099B") ; <CJK>
       (?$(L)y(B . "0x209E5") ; <CJK>
       (?$(L)z(B . "0x209E3") ; <CJK>
       (?$(L){(B . "0x209E1") ; <CJK>
       (?$(L)|(B . "0x209E0") ; <CJK>
       (?$(L)}(B . "0x209E2") ; <CJK>
       (?$(L)~(B . "0x209E4") ; <CJK>
       (?$(L*!(B . "0x5365") ; <CJK>
       (?$(L*"(B . "0x209E8") ; <CJK>
       (?$(L*#(B . "0x2F82F") ; <CJK>
       (?$(L*$(B . "0x20A13") ; <CJK>
       (?$(L*%(B . "0x20A56") ; <CJK>
       (?$(L*&(B . "0x20A4B") ; <CJK>
       (?$(L*'(B . "0x20A4A") ; <CJK>
       (?$(L*((B . "0x20A4D") ; <CJK>
       (?$(L*)(B . "0x20A4C") ; <CJK>
       (?$(L**(B . "0x3549") ; <CJK>
       (?$(L*+(B . "0x20AEA") ; <CJK>
       (?$(L*,(B . "0x20AE9") ; <CJK>
       (?$(L*-(B . "0x20AEB") ; <CJK>
       (?$(L*.(B . "0x20AEC") ; <CJK>
       (?$(L*/(B . "0x20B3A") ; <CJK>
       (?$(L*0(B . "0x20B3C") ; <CJK>
       (?$(L*1(B . "0x20B39") ; <CJK>
       (?$(L*2(B . "0x20B3B") ; <CJK>
       (?$(L*3(B . "0x20C14") ; <CJK>
       (?$(L*4(B . "0x20C0E") ; <CJK>
       (?$(L*5(B . "0x20C35") ; <CJK>
       (?$(L*6(B . "0x20C0A") ; <CJK>
       (?$(L*7(B . "0x20C3F") ; <CJK>
       (?$(L*8(B . "0x20C38") ; <CJK>
       (?$(L*9(B . "0x357C") ; <CJK>
       (?$(L*:(B . "0x20C4E") ; <CJK>
       (?$(L*;(B . "0x20C17") ; <CJK>
       (?$(L*<(B . "0x2F83F") ; <CJK>
       (?$(L*=(B . "0x20C1E") ; <CJK>
       (?$(L*>(B . "0x211B6") ; <CJK>
       (?$(L*?(B . "0x211CE") ; <CJK>
       (?$(L*@(B . "0x211CA") ; <CJK>
       (?$(L*A(B . "0x211CB") ; <CJK>
       (?$(L*B(B . "0x211CC") ; <CJK>
       (?$(L*C(B . "0x211C9") ; <CJK>
       (?$(L*D(B . "0x212B4") ; <CJK>
       (?$(L*E(B . "0x212AC") ; <CJK>
       (?$(L*F(B . "0x21288") ; <CJK>
       (?$(L*G(B . "0x21286") ; <CJK>
       (?$(L*H(B . "0x2128C") ; <CJK>
       (?$(L*I(B . "0x21293") ; <CJK>
       (?$(L*J(B . "0x2128A") ; <CJK>
       (?$(L*K(B . "0x212A4") ; <CJK>
       (?$(L*L(B . "0x21287") ; <CJK>
       (?$(L*M(B . "0x212A5") ; <CJK>
       (?$(L*N(B . "0x212A6") ; <CJK>
       (?$(L*O(B . "0x21285") ; <CJK>
       (?$(L*P(B . "0x212A3") ; <CJK>
       (?$(L*Q(B . "0x2128E") ; <CJK>
       (?$(L*R(B . "0x2151F") ; <CJK>
       (?$(L*S(B . "0x21563") ; <CJK>
       (?$(L*T(B . "0x2158D") ; <CJK>
       (?$(L*U(B . "0x215FA") ; <CJK>
       (?$(L*V(B . "0x215FB") ; <CJK>
       (?$(L*W(B . "0x21609") ; <CJK>
       (?$(L*X(B . "0x215FE") ; <CJK>
       (?$(L*Y(B . "0x215FF") ; <CJK>
       (?$(L*Z(B . "0x21602") ; <CJK>
       (?$(L*[(B . "0x21604") ; <CJK>
       (?$(L*\(B . "0x215FD") ; <CJK>
       (?$(L*](B . "0x21605") ; <CJK>
       (?$(L*^(B . "0x216F9") ; <CJK>
       (?$(L*_(B . "0x216F7") ; <CJK>
       (?$(L*`(B . "0x216DB") ; <CJK>
       (?$(L*a(B . "0x216DA") ; <CJK>
       (?$(L*b(B . "0x21951") ; <CJK>
       (?$(L*c(B . "0x21950") ; <CJK>
       (?$(L*d(B . "0x21957") ; <CJK>
       (?$(L*e(B . "0x219E2") ; <CJK>
       (?$(L*f(B . "0x219D8") ; <CJK>
       (?$(L*g(B . "0x219DA") ; <CJK>
       (?$(L*h(B . "0x219DC") ; <CJK>
       (?$(L*i(B . "0x21B20") ; <CJK>
       (?$(L*j(B . "0x21B1F") ; <CJK>
       (?$(L*k(B . "0x21B69") ; <CJK>
       (?$(L*l(B . "0x21BDD") ; <CJK>
       (?$(L*m(B . "0x21C40") ; <CJK>
       (?$(L*n(B . "0x21C41") ; <CJK>
       (?$(L*o(B . "0x21C43") ; <CJK>
       (?$(L*p(B . "0x21D0D") ; <CJK>
       (?$(L*q(B . "0x21D0C") ; <CJK>
       (?$(L*r(B . "0x21D87") ; <CJK>
       (?$(L*s(B . "0x21DA9") ; <CJK>
       (?$(L*t(B . "0x21D92") ; <CJK>
       (?$(L*u(B . "0x21D85") ; <CJK>
       (?$(L*v(B . "0x37BF") ; <CJK>
       (?$(L*w(B . "0x21D8C") ; <CJK>
       (?$(L*x(B . "0x21DA2") ; <CJK>
       (?$(L*y(B . "0x21D8F") ; <CJK>
       (?$(L*z(B . "0x21D8A") ; <CJK>
       (?$(L*{(B . "0x37BA") ; <CJK>
       (?$(L*|(B . "0x21D8D") ; <CJK>
       (?$(L*}(B . "0x21FF1") ; <CJK>
       (?$(L*~(B . "0x22037") ; <CJK>
       (?$(L+!(B . "0x2208B") ; <CJK>
       (?$(L+"(B . "0x22087") ; <CJK>
       (?$(L+#(B . "0x22082") ; <CJK>
       (?$(L+$(B . "0x2218E") ; <CJK>
       (?$(L+%(B . "0x221BC") ; <CJK>
       (?$(L+&(B . "0x221F8") ; <CJK>
       (?$(L+'(B . "0x221FA") ; <CJK>
       (?$(L+((B . "0x221EB") ; <CJK>
       (?$(L+)(B . "0x221F9") ; <CJK>
       (?$(L+*(B . "0x221FC") ; <CJK>
       (?$(L++(B . "0x22205") ; <CJK>
       (?$(L+,(B . "0x2231B") ; <CJK>
       (?$(L+-(B . "0x2231D") ; <CJK>
       (?$(L+.(B . "0x2231E") ; <CJK>
       (?$(L+/(B . "0x2F892") ; <CJK>
       (?$(L+0(B . "0x2233C") ; <CJK>
       (?$(L+1(B . "0x2233E") ; <CJK>
       (?$(L+2(B . "0x22384") ; <CJK>
       (?$(L+3(B . "0x223C8") ; <CJK>
       (?$(L+4(B . "0x223C9") ; <CJK>
       (?$(L+5(B . "0x223D3") ; <CJK>
       (?$(L+6(B . "0x223C7") ; <CJK>
       (?$(L+7(B . "0x223D2") ; <CJK>
       (?$(L+8(B . "0x22455") ; <CJK>
       (?$(L+9(B . "0x2F896") ; <CJK>
       (?$(L+:(B . "0x2248C") ; <CJK>
       (?$(L+;(B . "0x2248A") ; <CJK>
       (?$(L+<(B . "0x224D5") ; <CJK>
       (?$(L+=(B . "0x224D3") ; <CJK>
       (?$(L+>(B . "0x38D8") ; <CJK>
       (?$(L+?(B . "0x224D8") ; <CJK>
       (?$(L+@(B . "0x225D0") ; <CJK>
       (?$(L+A(B . "0x225EE") ; <CJK>
       (?$(L+B(B . "0x225F1") ; <CJK>
       (?$(L+C(B . "0x225FB") ; <CJK>
       (?$(L+D(B . "0x225D3") ; <CJK>
       (?$(L+E(B . "0x225EC") ; <CJK>
       (?$(L+F(B . "0x225CD") ; <CJK>
       (?$(L+G(B . "0x22615") ; <CJK>
       (?$(L+H(B . "0x22626") ; <CJK>
       (?$(L+I(B . "0x2260E") ; <CJK>
       (?$(L+J(B . "0x22627") ; <CJK>
       (?$(L+K(B . "0x2262A") ; <CJK>
       (?$(L+L(B . "0x22600") ; <CJK>
       (?$(L+M(B . "0x22604") ; <CJK>
       (?$(L+N(B . "0x22628") ; <CJK>
       (?$(L+O(B . "0x22608") ; <CJK>
       (?$(L+P(B . "0x22614") ; <CJK>
       (?$(L+Q(B . "0x2299B") ; <CJK>
       (?$(L+R(B . "0x39B2") ; <CJK>
       (?$(L+S(B . "0x229A1") ; <CJK>
       (?$(L+T(B . "0x2299D") ; <CJK>
       (?$(L+U(B . "0x229A0") ; <CJK>
       (?$(L+V(B . "0x2299E") ; <CJK>
       (?$(L+W(B . "0x229A2") ; <CJK>
       (?$(L+X(B . "0x2299C") ; <CJK>
       (?$(L+Y(B . "0x22A32") ; <CJK>
       (?$(L+Z(B . "0x22A34") ; <CJK>
       (?$(L+[(B . "0x22A93") ; <CJK>
       (?$(L+\(B . "0x22A96") ; <CJK>
       (?$(L+](B . "0x22A90") ; <CJK>
       (?$(L+^(B . "0x22AB4") ; <CJK>
       (?$(L+_(B . "0x22AB5") ; <CJK>
       (?$(L+`(B . "0x2F8B6") ; <CJK>
       (?$(L+a(B . "0x22AB6") ; <CJK>
       (?$(L+b(B . "0x22AC2") ; <CJK>
       (?$(L+c(B . "0x2F8B5") ; <CJK>
       (?$(L+d(B . "0x22ABA") ; <CJK>
       (?$(L+e(B . "0x22A92") ; <CJK>
       (?$(L+f(B . "0x22EFB") ; <CJK>
       (?$(L+g(B . "0x22F05") ; <CJK>
       (?$(L+h(B . "0x22EF3") ; <CJK>
       (?$(L+i(B . "0x22EFE") ; <CJK>
       (?$(L+j(B . "0x22EFD") ; <CJK>
       (?$(L+k(B . "0x2455D") ; <CJK>
       (?$(L+l(B . "0x22EFA") ; <CJK>
       (?$(L+m(B . "0x23043") ; <CJK>
       (?$(L+n(B . "0x23095") ; <CJK>
       (?$(L+o(B . "0x23094") ; <CJK>
       (?$(L+p(B . "0x3AC4") ; <CJK>
       (?$(L+q(B . "0x2316F") ; <CJK>
       (?$(L+r(B . "0x23173") ; <CJK>
       (?$(L+s(B . "0x2315C") ; <CJK>
       (?$(L+t(B . "0x2315B") ; <CJK>
       (?$(L+u(B . "0x23166") ; <CJK>
       (?$(L+v(B . "0x23174") ; <CJK>
       (?$(L+w(B . "0x23163") ; <CJK>
       (?$(L+x(B . "0x23167") ; <CJK>
       (?$(L+y(B . "0x23160") ; <CJK>
       (?$(L+z(B . "0x23162") ; <CJK>
       (?$(L+{(B . "0x23171") ; <CJK>
       (?$(L+|(B . "0x23172") ; <CJK>
       (?$(L+}(B . "0x2315E") ; <CJK>
       (?$(L+~(B . "0x23323") ; <CJK>
       (?$(L,!(B . "0x23326") ; <CJK>
       (?$(L,"(B . "0x23364") ; <CJK>
       (?$(L,#(B . "0x2F8D6") ; <CJK>
       (?$(L,$(B . "0x233F2") ; <CJK>
       (?$(L,%(B . "0x23401") ; <CJK>
       (?$(L,&(B . "0x233DD") ; <CJK>
       (?$(L,'(B . "0x233DC") ; <CJK>
       (?$(L,((B . "0x233DB") ; <CJK>
       (?$(L,)(B . "0x233F3") ; <CJK>
       (?$(L,*(B . "0x233FD") ; <CJK>
       (?$(L,+(B . "0x233D8") ; <CJK>
       (?$(L,,(B . "0x233F8") ; <CJK>
       (?$(L,-(B . "0x233FB") ; <CJK>
       (?$(L,.(B . "0x23883") ; <CJK>
       (?$(L,/(B . "0x2388C") ; <CJK>
       (?$(L,0(B . "0x2388E") ; <CJK>
       (?$(L,1(B . "0x23949") ; <CJK>
       (?$(L,2(B . "0x23954") ; <CJK>
       (?$(L,3(B . "0x23952") ; <CJK>
       (?$(L,4(B . "0x2394E") ; <CJK>
       (?$(L,5(B . "0x23958") ; <CJK>
       (?$(L,6(B . "0x23951") ; <CJK>
       (?$(L,7(B . "0x23955") ; <CJK>
       (?$(L,8(B . "0x23953") ; <CJK>
       (?$(L,9(B . "0x23957") ; <CJK>
       (?$(L,:(B . "0x23950") ; <CJK>
       (?$(L,;(B . "0x2394F") ; <CJK>
       (?$(L,<(B . "0x2394D") ; <CJK>
       (?$(L,=(B . "0x239D2") ; <CJK>
       (?$(L,>(B . "0x239D3") ; <CJK>
       (?$(L,?(B . "0x239C9") ; <CJK>
       (?$(L,@(B . "0x239D4") ; <CJK>
       (?$(L,A(B . "0x23AEF") ; <CJK>
       (?$(L,B(B . "0x2F8F8") ; <CJK>
       (?$(L,C(B . "0x200B1") ; <CJK>
       (?$(L,D(B . "0x23B05") ; <CJK>
       (?$(L,E(B . "0x23B04") ; <CJK>
       (?$(L,F(B . "0x23B2E") ; <CJK>
       (?$(L,G(B . "0x23B2D") ; <CJK>
       (?$(L,H(B . "0x23C45") ; <CJK>
       (?$(L,I(B . "0x23C5B") ; <CJK>
       (?$(L,J(B . "0x23C5A") ; <CJK>
       (?$(L,K(B . "0x23C59") ; <CJK>
       (?$(L,L(B . "0x23C9D") ; <CJK>
       (?$(L,M(B . "0x23C8E") ; <CJK>
       (?$(L,N(B . "0x23CBC") ; <CJK>
       (?$(L,O(B . "0x23CDD") ; <CJK>
       (?$(L,P(B . "0x23CBA") ; <CJK>
       (?$(L,Q(B . "0x2F8FD") ; <CJK>
       (?$(L,R(B . "0x23CD8") ; <CJK>
       (?$(L,S(B . "0x23CCB") ; <CJK>
       (?$(L,T(B . "0x23CD9") ; <CJK>
       (?$(L,U(B . "0x23CDA") ; <CJK>
       (?$(L,V(B . "0x23CC4") ; <CJK>
       (?$(L,W(B . "0x23CB8") ; <CJK>
       (?$(L,X(B . "0x23CBF") ; <CJK>
       (?$(L,Y(B . "0x23CDB") ; <CJK>
       (?$(L,Z(B . "0x23CC1") ; <CJK>
       (?$(L,[(B . "0x2F8FC") ; <CJK>
       (?$(L,\(B . "0x23CC5") ; <CJK>
       (?$(L,](B . "0x2F919") ; <CJK>
       (?$(L,^(B . "0x241B1") ; <CJK>
       (?$(L,_(B . "0x241AF") ; <CJK>
       (?$(L,`(B . "0x2F918") ; <CJK>
       (?$(L,a(B . "0x244F7") ; <CJK>
       (?$(L,b(B . "0x244F6") ; <CJK>
       (?$(L,c(B . "0x244F8") ; <CJK>
       (?$(L,d(B . "0x24550") ; <CJK>
       (?$(L,e(B . "0x24551") ; <CJK>
       (?$(L,f(B . "0x24571") ; <CJK>
       (?$(L,g(B . "0x24570") ; <CJK>
       (?$(L,h(B . "0x245B0") ; <CJK>
       (?$(L,i(B . "0x245AF") ; <CJK>
       (?$(L,j(B . "0x245AE") ; <CJK>
       (?$(L,k(B . "0x245AD") ; <CJK>
       (?$(L,l(B . "0x24625") ; <CJK>
       (?$(L,m(B . "0x2462C") ; <CJK>
       (?$(L,n(B . "0x24622") ; <CJK>
       (?$(L,o(B . "0x24633") ; <CJK>
       (?$(L,p(B . "0x24634") ; <CJK>
       (?$(L,q(B . "0x3E2B") ; <CJK>
       (?$(L,r(B . "0x2473A") ; <CJK>
       (?$(L,s(B . "0x24740") ; <CJK>
       (?$(L,t(B . "0x24768") ; <CJK>
       (?$(L,u(B . "0x3E61") ; <CJK>
       (?$(L,v(B . "0x24764") ; <CJK>
       (?$(L,w(B . "0x2475C") ; <CJK>
       (?$(L,x(B . "0x24757") ; <CJK>
       (?$(L,y(B . "0x24753") ; <CJK>
       (?$(L,z(B . "0x2474F") ; <CJK>
       (?$(L,{(B . "0x24751") ; <CJK>
       (?$(L,|(B . "0x24754") ; <CJK>
       (?$(L,}(B . "0x24766") ; <CJK>
       (?$(L,~(B . "0x72DD") ; <CJK>
       (?$(L-!(B . "0x3EB2") ; <CJK>
       (?$(L-"(B . "0x2490D") ; <CJK>
       (?$(L-#(B . "0x24908") ; <CJK>
       (?$(L-$(B . "0x2F92B") ; <CJK>
       (?$(L-%(B . "0x248FA") ; <CJK>
       (?$(L-&(B . "0x24AEA") ; <CJK>
       (?$(L-'(B . "0x24B2A") ; <CJK>
       (?$(L-((B . "0x24BBB") ; <CJK>
       (?$(L-)(B . "0x24BD5") ; <CJK>
       (?$(L-*(B . "0x24BD7") ; <CJK>
       (?$(L-+(B . "0x21DA4") ; <CJK>
       (?$(L-,(B . "0x200F0") ; <CJK>
       (?$(L--(B . "0x200B5") ; <CJK>
       (?$(L-.(B . "0x24C06") ; <CJK>
       (?$(L-/(B . "0x24C28") ; <CJK>
       (?$(L-0(B . "0x24C22") ; <CJK>
       (?$(L-1(B . "0x24C21") ; <CJK>
       (?$(L-2(B . "0x22456") ; <CJK>
       (?$(L-3(B . "0x24C23") ; <CJK>
       (?$(L-4(B . "0x211CD") ; <CJK>
       (?$(L-5(B . "0x24D30") ; <CJK>
       (?$(L-6(B . "0x24D34") ; <CJK>
       (?$(L-7(B . "0x24FC9") ; <CJK>
       (?$(L-8(B . "0x24FCA") ; <CJK>
       (?$(L-9(B . "0x24FC8") ; <CJK>
       (?$(L-:(B . "0x2F93D") ; <CJK>
       (?$(L-;(B . "0x25044") ; <CJK>
       (?$(L-<(B . "0x250F3") ; <CJK>
       (?$(L-=(B . "0x2F941") ; <CJK>
       (?$(L->(B . "0x250F8") ; <CJK>
       (?$(L-?(B . "0x250FC") ; <CJK>
       (?$(L-@(B . "0x250F6") ; <CJK>
       (?$(L-A(B . "0x250FB") ; <CJK>
       (?$(L-B(B . "0x250F7") ; <CJK>
       (?$(L-C(B . "0x25100") ; <CJK>
       (?$(L-D(B . "0x25102") ; <CJK>
       (?$(L-E(B . "0x2F940") ; <CJK>
       (?$(L-F(B . "0x2F94D") ; <CJK>
       (?$(L-G(B . "0x25424") ; <CJK>
       (?$(L-H(B . "0x2560D") ; <CJK>
       (?$(L-I(B . "0x4129") ; <CJK>
       (?$(L-J(B . "0x25762") ; <CJK>
       (?$(L-K(B . "0x25930") ; <CJK>
       (?$(L-L(B . "0x2592B") ; <CJK>
       (?$(L-M(B . "0x2592A") ; <CJK>
       (?$(L-N(B . "0x4192") ; <CJK>
       (?$(L-O(B . "0x2592D") ; <CJK>
       (?$(L-P(B . "0x25ADA") ; <CJK>
       (?$(L-Q(B . "0x25E28") ; <CJK>
       (?$(L-R(B . "0x25F86") ; <CJK>
       (?$(L-S(B . "0x26277") ; <CJK>
       (?$(L-T(B . "0x2627C") ; <CJK>
       (?$(L-U(B . "0x26350") ; <CJK>
       (?$(L-V(B . "0x2634E") ; <CJK>
       (?$(L-W(B . "0x263F2") ; <CJK>
       (?$(L-X(B . "0x264B2") ; <CJK>
       (?$(L-Y(B . "0x264CE") ; <CJK>
       (?$(L-Z(B . "0x264CF") ; <CJK>
       (?$(L-[(B . "0x264E5") ; <CJK>
       (?$(L-\(B . "0x23407") ; <CJK>
       (?$(L-](B . "0x26535") ; <CJK>
       (?$(L-^(B . "0x26531") ; <CJK>
       (?$(L-_(B . "0x26613") ; <CJK>
       (?$(L-`(B . "0x2662B") ; <CJK>
       (?$(L-a(B . "0x2662C") ; <CJK>
       (?$(L-b(B . "0x26645") ; <CJK>
       (?$(L-c(B . "0x26660") ; <CJK>
       (?$(L-d(B . "0x26641") ; <CJK>
       (?$(L-e(B . "0x26658") ; <CJK>
       (?$(L-f(B . "0x26647") ; <CJK>
       (?$(L-g(B . "0x2665B") ; <CJK>
       (?$(L-h(B . "0x26650") ; <CJK>
       (?$(L-i(B . "0x2F982") ; <CJK>
       (?$(L-j(B . "0x2665F") ; <CJK>
       (?$(L-k(B . "0x2664A") ; <CJK>
       (?$(L-l(B . "0x26656") ; <CJK>
       (?$(L-m(B . "0x26643") ; <CJK>
       (?$(L-n(B . "0x26644") ; <CJK>
       (?$(L-o(B . "0x26651") ; <CJK>
       (?$(L-p(B . "0x268FD") ; <CJK>
       (?$(L-q(B . "0x26934") ; <CJK>
       (?$(L-r(B . "0x26935") ; <CJK>
       (?$(L-s(B . "0x26954") ; <CJK>
       (?$(L-t(B . "0x26955") ; <CJK>
       (?$(L-u(B . "0x26A0C") ; <CJK>
       (?$(L-v(B . "0x26A0B") ; <CJK>
       (?$(L-w(B . "0x26A0A") ; <CJK>
       (?$(L-x(B . "0x26AF9") ; <CJK>
       (?$(L-y(B . "0x26B35") ; <CJK>
       (?$(L-z(B . "0x26B24") ; <CJK>
       (?$(L-{(B . "0x26B13") ; <CJK>
       (?$(L-|(B . "0x26B1C") ; <CJK>
       (?$(L-}(B . "0x26B69") ; <CJK>
       (?$(L-~(B . "0x26B25") ; <CJK>
       (?$(L.!(B . "0x26B21") ; <CJK>
       (?$(L."(B . "0x2F995") ; <CJK>
       (?$(L.#(B . "0x2F996") ; <CJK>
       (?$(L.$(B . "0x2F998") ; <CJK>
       (?$(L.%(B . "0x27220") ; <CJK>
       (?$(L.&(B . "0x275A9") ; <CJK>
       (?$(L.'(B . "0x275A8") ; <CJK>
       (?$(L.((B . "0x275DE") ; <CJK>
       (?$(L.)(B . "0x27609") ; <CJK>
       (?$(L.*(B . "0x2760A") ; <CJK>
       (?$(L.+(B . "0x2760B") ; <CJK>
       (?$(L.,(B . "0x277E3") ; <CJK>
       (?$(L.-(B . "0x27807") ; <CJK>
       (?$(L..(B . "0x278B2") ; <CJK>
       (?$(L./(B . "0x278B3") ; <CJK>
       (?$(L.0(B . "0x2795D") ; <CJK>
       (?$(L.1(B . "0x27E58") ; <CJK>
       (?$(L.2(B . "0x27E86") ; <CJK>
       (?$(L.3(B . "0x27E87") ; <CJK>
       (?$(L.4(B . "0x27FB9") ; <CJK>
       (?$(L.5(B . "0x27FB8") ; <CJK>
       (?$(L.6(B . "0x2840C") ; <CJK>
       (?$(L.7(B . "0x28444") ; <CJK>
       (?$(L.8(B . "0x28466") ; <CJK>
       (?$(L.9(B . "0x28480") ; <CJK>
       (?$(L.:(B . "0x28475") ; <CJK>
       (?$(L.;(B . "0x2846D") ; <CJK>
       (?$(L.<(B . "0x2847E") ; <CJK>
       (?$(L.=(B . "0x28467") ; <CJK>
       (?$(L.>(B . "0x28481") ; <CJK>
       (?$(L.?(B . "0x28477") ; <CJK>
       (?$(L.@(B . "0x286A8") ; <CJK>
       (?$(L.A(B . "0x286A2") ; <CJK>
       (?$(L.B(B . "0x286A5") ; <CJK>
       (?$(L.C(B . "0x2869B") ; <CJK>
       (?$(L.D(B . "0x28C57") ; <CJK>
       (?$(L.E(B . "0x28E0F") ; <CJK>
       (?$(L.F(B . "0x28E32") ; <CJK>
       (?$(L.G(B . "0x28E2C") ; <CJK>
       (?$(L.H(B . "0x28E33") ; <CJK>
       (?$(L.I(B . "0x291E7") ; <CJK>
       (?$(L.J(B . "0x2006E") ; <CJK>
       (?$(L.K(B . "0x200B7") ; <CJK>
       (?$(L.L(B . "0x200F6") ; <CJK>
       (?$(L.M(B . "0x200F2") ; <CJK>
       (?$(L.N(B . "0x200F3") ; <CJK>
       (?$(L.O(B . "0x20517") ; <CJK>
       (?$(L.P(B . "0x20130") ; <CJK>
       (?$(L.Q(B . "0x20154") ; <CJK>
       (?$(L.R(B . "0x20153") ; <CJK>
       (?$(L.S(B . "0x20252") ; <CJK>
       (?$(L.T(B . "0x2023D") ; <CJK>
       (?$(L.U(B . "0x2023C") ; <CJK>
       (?$(L.V(B . "0x20234") ; <CJK>
       (?$(L.W(B . "0x20233") ; <CJK>
       (?$(L.X(B . "0x20254") ; <CJK>
       (?$(L.Y(B . "0x2022F") ; <CJK>
       (?$(L.Z(B . "0x3458") ; <CJK>
       (?$(L.[(B . "0x20255") ; <CJK>
       (?$(L.\(B . "0x2023F") ; <CJK>
       (?$(L.](B . "0x20237") ; <CJK>
       (?$(L.^(B . "0x20256") ; <CJK>
       (?$(L._(B . "0x20261") ; <CJK>
       (?$(L.`(B . "0x20258") ; <CJK>
       (?$(L.a(B . "0x2F806") ; <CJK>
       (?$(L.b(B . "0x2023B") ; <CJK>
       (?$(L.c(B . "0x20232") ; <CJK>
       (?$(L.d(B . "0x2022E") ; <CJK>
       (?$(L.e(B . "0x2023E") ; <CJK>
       (?$(L.f(B . "0x2003B") ; <CJK>
       (?$(L.g(B . "0x2048C") ; <CJK>
       (?$(L.h(B . "0x2048D") ; <CJK>
       (?$(L.i(B . "0x20513") ; <CJK>
       (?$(L.j(B . "0x20516") ; <CJK>
       (?$(L.k(B . "0x20512") ; <CJK>
       (?$(L.l(B . "0x2055B") ; <CJK>
       (?$(L.m(B . "0x2058A") ; <CJK>
       (?$(L.n(B . "0x205D7") ; <CJK>
       (?$(L.o(B . "0x205CE") ; <CJK>
       (?$(L.p(B . "0x20650") ; <CJK>
       (?$(L.q(B . "0x20651") ; <CJK>
       (?$(L.r(B . "0x2064F") ; <CJK>
       (?$(L.s(B . "0x2068E") ; <CJK>
       (?$(L.t(B . "0x2068F") ; <CJK>
       (?$(L.u(B . "0x206F2") ; <CJK>
       (?$(L.v(B . "0x2F821") ; <CJK>
       (?$(L.w(B . "0x20728") ; <CJK>
       (?$(L.x(B . "0x2071A") ; <CJK>
       (?$(L.y(B . "0x20725") ; <CJK>
       (?$(L.z(B . "0x2071D") ; <CJK>
       (?$(L.{(B . "0x20714") ; <CJK>
       (?$(L.|(B . "0x20720") ; <CJK>
       (?$(L.}(B . "0x2071F") ; <CJK>
       (?$(L.~(B . "0x2071B") ; <CJK>
       (?$(L/!(B . "0x20717") ; <CJK>
       (?$(L/"(B . "0x20715") ; <CJK>
       (?$(L/#(B . "0x2071C") ; <CJK>
       (?$(L/$(B . "0x20713") ; <CJK>
       (?$(L/%(B . "0x2F825") ; <CJK>
       (?$(L/&(B . "0x20860") ; <CJK>
       (?$(L/'(B . "0x351C") ; <CJK>
       (?$(L/((B . "0x20866") ; <CJK>
       (?$(L/)(B . "0x208E3") ; <CJK>
       (?$(L/*(B . "0x208DE") ; <CJK>
       (?$(L/+(B . "0x208E0") ; <CJK>
       (?$(L/,(B . "0x208E1") ; <CJK>
       (?$(L/-(B . "0x2091A") ; <CJK>
       (?$(L/.(B . "0x2091B") ; <CJK>
       (?$(L//(B . "0x20918") ; <CJK>
       (?$(L/0(B . "0x2091C") ; <CJK>
       (?$(L/1(B . "0x20919") ; <CJK>
       (?$(L/2(B . "0x20942") ; <CJK>
       (?$(L/3(B . "0x20940") ; <CJK>
       (?$(L/4(B . "0x2093E") ; <CJK>
       (?$(L/5(B . "0x20944") ; <CJK>
       (?$(L/6(B . "0x20974") ; <CJK>
       (?$(L/7(B . "0x20943") ; <CJK>
       (?$(L/8(B . "0x2F82D") ; <CJK>
       (?$(L/9(B . "0x209F2") ; <CJK>
       (?$(L/:(B . "0x20A1B") ; <CJK>
       (?$(L/;(B . "0x20A19") ; <CJK>
       (?$(L/<(B . "0x20A1E") ; <CJK>
       (?$(L/=(B . "0x2F830") ; <CJK>
       (?$(L/>(B . "0x20A5E") ; <CJK>
       (?$(L/?(B . "0x20A66") ; <CJK>
       (?$(L/@(B . "0x20A5D") ; <CJK>
       (?$(L/A(B . "0x20A5A") ; <CJK>
       (?$(L/B(B . "0x20A5F") ; <CJK>
       (?$(L/C(B . "0x20A60") ; <CJK>
       (?$(L/D(B . "0x20A5B") ; <CJK>
       (?$(L/E(B . "0x20A5C") ; <CJK>
       (?$(L/F(B . "0x20A59") ; <CJK>
       (?$(L/G(B . "0x20AF0") ; <CJK>
       (?$(L/H(B . "0x20AF1") ; <CJK>
       (?$(L/I(B . "0x20B43") ; <CJK>
       (?$(L/J(B . "0x20B40") ; <CJK>
       (?$(L/K(B . "0x20B42") ; <CJK>
       (?$(L/L(B . "0x20B41") ; <CJK>
       (?$(L/M(B . "0x20B3F") ; <CJK>
       (?$(L/N(B . "0x20C57") ; <CJK>
       (?$(L/O(B . "0x20C69") ; <CJK>
       (?$(L/P(B . "0x20C6F") ; <CJK>
       (?$(L/Q(B . "0x20CAB") ; <CJK>
       (?$(L/R(B . "0x20C71") ; <CJK>
       (?$(L/S(B . "0x20C93") ; <CJK>
       (?$(L/T(B . "0x20C56") ; <CJK>
       (?$(L/U(B . "0x20C90") ; <CJK>
       (?$(L/V(B . "0x20C6D") ; <CJK>
       (?$(L/W(B . "0x20C6C") ; <CJK>
       (?$(L/X(B . "0x20C70") ; <CJK>
       (?$(L/Y(B . "0x20C66") ; <CJK>
       (?$(L/Z(B . "0x20C67") ; <CJK>
       (?$(L/[(B . "0x211D7") ; <CJK>
       (?$(L/\(B . "0x211B5") ; <CJK>
       (?$(L/](B . "0x211DB") ; <CJK>
       (?$(L/^(B . "0x211D8") ; <CJK>
       (?$(L/_(B . "0x211D5") ; <CJK>
       (?$(L/`(B . "0x211D4") ; <CJK>
       (?$(L/a(B . "0x212BA") ; <CJK>
       (?$(L/b(B . "0x212B7") ; <CJK>
       (?$(L/c(B . "0x212BE") ; <CJK>
       (?$(L/d(B . "0x212B9") ; <CJK>
       (?$(L/e(B . "0x3637") ; <CJK>
       (?$(L/f(B . "0x212E0") ; <CJK>
       (?$(L/g(B . "0x212DD") ; <CJK>
       (?$(L/h(B . "0x212DE") ; <CJK>
       (?$(L/i(B . "0x24918") ; <CJK>
       (?$(L/j(B . "0x212D8") ; <CJK>
       (?$(L/k(B . "0x212BD") ; <CJK>
       (?$(L/l(B . "0x212DB") ; <CJK>
       (?$(L/m(B . "0x2151D") ; <CJK>
       (?$(L/n(B . "0x21525") ; <CJK>
       (?$(L/o(B . "0x21721") ; <CJK>
       (?$(L/p(B . "0x2170C") ; <CJK>
       (?$(L/q(B . "0x21729") ; <CJK>
       (?$(L/r(B . "0x2172D") ; <CJK>
       (?$(L/s(B . "0x2171B") ; <CJK>
       (?$(L/t(B . "0x2170E") ; <CJK>
       (?$(L/u(B . "0x2171F") ; <CJK>
       (?$(L/v(B . "0x21704") ; <CJK>
       (?$(L/w(B . "0x2171C") ; <CJK>
       (?$(L/x(B . "0x21705") ; <CJK>
       (?$(L/y(B . "0x21706") ; <CJK>
       (?$(L/z(B . "0x21720") ; <CJK>
       (?$(L/{(B . "0x2170D") ; <CJK>
       (?$(L/|(B . "0x2172A") ; <CJK>
       (?$(L/}(B . "0x21723") ; <CJK>
       (?$(L/~(B . "0x21711") ; <CJK>
       (?$(L0!(B . "0x2195C") ; <CJK>
       (?$(L0"(B . "0x21966") ; <CJK>
       (?$(L0#(B . "0x2195B") ; <CJK>
       (?$(L0$(B . "0x2194F") ; <CJK>
       (?$(L0%(B . "0x2195E") ; <CJK>
       (?$(L0&(B . "0x2195D") ; <CJK>
       (?$(L0'(B . "0x219F1") ; <CJK>
       (?$(L0((B . "0x219EA") ; <CJK>
       (?$(L0)(B . "0x219F4") ; <CJK>
       (?$(L0*(B . "0x219EB") ; <CJK>
       (?$(L0+(B . "0x219F0") ; <CJK>
       (?$(L0,(B . "0x219FA") ; <CJK>
       (?$(L0-(B . "0x219FB") ; <CJK>
       (?$(L0.(B . "0x21B28") ; <CJK>
       (?$(L0/(B . "0x21B2C") ; <CJK>
       (?$(L00(B . "0x21B6B") ; <CJK>
       (?$(L01(B . "0x21B2A") ; <CJK>
       (?$(L02(B . "0x21B6A") ; <CJK>
       (?$(L03(B . "0x21B6F") ; <CJK>
       (?$(L04(B . "0x21BDB") ; <CJK>
       (?$(L05(B . "0x21BE0") ; <CJK>
       (?$(L06(B . "0x24FD1") ; <CJK>
       (?$(L07(B . "0x21BE3") ; <CJK>
       (?$(L08(B . "0x21BE5") ; <CJK>
       (?$(L09(B . "0x21BE7") ; <CJK>
       (?$(L0:(B . "0x21C4D") ; <CJK>
       (?$(L0;(B . "0x21C55") ; <CJK>
       (?$(L0<(B . "0x21C54") ; <CJK>
       (?$(L0=(B . "0x21C53") ; <CJK>
       (?$(L0>(B . "0x21C52") ; <CJK>
       (?$(L0?(B . "0x21C4E") ; <CJK>
       (?$(L0@(B . "0x21C60") ; <CJK>
       (?$(L0A(B . "0x221C0") ; <CJK>
       (?$(L0B(B . "0x21D0F") ; <CJK>
       (?$(L0C(B . "0x21D11") ; <CJK>
       (?$(L0D(B . "0x21D13") ; <CJK>
       (?$(L0E(B . "0x21DC6") ; <CJK>
       (?$(L0F(B . "0x21DB3") ; <CJK>
       (?$(L0G(B . "0x21DC7") ; <CJK>
       (?$(L0H(B . "0x21DD2") ; <CJK>
       (?$(L0I(B . "0x21DB8") ; <CJK>
       (?$(L0J(B . "0x21DAC") ; <CJK>
       (?$(L0K(B . "0x21DAE") ; <CJK>
       (?$(L0L(B . "0x21DCF") ; <CJK>
       (?$(L0M(B . "0x21DC5") ; <CJK>
       (?$(L0N(B . "0x2F87B") ; <CJK>
       (?$(L0O(B . "0x21DCC") ; <CJK>
       (?$(L0P(B . "0x21DAB") ; <CJK>
       (?$(L0Q(B . "0x21DC9") ; <CJK>
       (?$(L0R(B . "0x21DB9") ; <CJK>
       (?$(L0S(B . "0x21FFB") ; <CJK>
       (?$(L0T(B . "0x21FF8") ; <CJK>
       (?$(L0U(B . "0x21FF7") ; <CJK>
       (?$(L0V(B . "0x21FF9") ; <CJK>
       (?$(L0W(B . "0x22020") ; <CJK>
       (?$(L0X(B . "0x2203B") ; <CJK>
       (?$(L0Y(B . "0x22039") ; <CJK>
       (?$(L0Z(B . "0x2209E") ; <CJK>
       (?$(L0[(B . "0x2209A") ; <CJK>
       (?$(L0\(B . "0x220AA") ; <CJK>
       (?$(L0](B . "0x220AB") ; <CJK>
       (?$(L0^(B . "0x220AF") ; <CJK>
       (?$(L0_(B . "0x22096") ; <CJK>
       (?$(L0`(B . "0x220A9") ; <CJK>
       (?$(L0a(B . "0x220A6") ; <CJK>
       (?$(L0b(B . "0x22091") ; <CJK>
       (?$(L0c(B . "0x3843") ; <CJK>
       (?$(L0d(B . "0x220AE") ; <CJK>
       (?$(L0e(B . "0x2209F") ; <CJK>
       (?$(L0f(B . "0x220AC") ; <CJK>
       (?$(L0g(B . "0x220A0") ; <CJK>
       (?$(L0h(B . "0x22192") ; <CJK>
       (?$(L0i(B . "0x22191") ; <CJK>
       (?$(L0j(B . "0x221BF") ; <CJK>
       (?$(L0k(B . "0x22217") ; <CJK>
       (?$(L0l(B . "0x2220A") ; <CJK>
       (?$(L0m(B . "0x2220C") ; <CJK>
       (?$(L0n(B . "0x2234A") ; <CJK>
       (?$(L0o(B . "0x22346") ; <CJK>
       (?$(L0p(B . "0x22334") ; <CJK>
       (?$(L0q(B . "0x22345") ; <CJK>
       (?$(L0r(B . "0x22343") ; <CJK>
       (?$(L0s(B . "0x22344") ; <CJK>
       (?$(L0t(B . "0x2F893") ; <CJK>
       (?$(L0u(B . "0x22387") ; <CJK>
       (?$(L0v(B . "0x22386") ; <CJK>
       (?$(L0w(B . "0x2238A") ; <CJK>
       (?$(L0x(B . "0x223DA") ; <CJK>
       (?$(L0y(B . "0x223D8") ; <CJK>
       (?$(L0z(B . "0x38B4") ; <CJK>
       (?$(L0{(B . "0x20518") ; <CJK>
       (?$(L0|(B . "0x20134") ; <CJK>
       (?$(L0}(B . "0x223D6") ; <CJK>
       (?$(L0~(B . "0x223D4") ; <CJK>
       (?$(L1!(B . "0x22454") ; <CJK>
       (?$(L1"(B . "0x22459") ; <CJK>
       (?$(L1#(B . "0x2245A") ; <CJK>
       (?$(L1$(B . "0x22457") ; <CJK>
       (?$(L1%(B . "0x38E0") ; <CJK>
       (?$(L1&(B . "0x224DD") ; <CJK>
       (?$(L1'(B . "0x224E9") ; <CJK>
       (?$(L1((B . "0x224E0") ; <CJK>
       (?$(L1)(B . "0x22605") ; <CJK>
       (?$(L1*(B . "0x22612") ; <CJK>
       (?$(L1+(B . "0x22613") ; <CJK>
       (?$(L1,(B . "0x22607") ; <CJK>
       (?$(L1-(B . "0x22616") ; <CJK>
       (?$(L1.(B . "0x22623") ; <CJK>
       (?$(L1/(B . "0x22602") ; <CJK>
       (?$(L10(B . "0x2F8A1") ; <CJK>
       (?$(L11(B . "0x2264A") ; <CJK>
       (?$(L12(B . "0x22636") ; <CJK>
       (?$(L13(B . "0x22640") ; <CJK>
       (?$(L14(B . "0x22656") ; <CJK>
       (?$(L15(B . "0x22643") ; <CJK>
       (?$(L16(B . "0x2F8A0") ; <CJK>
       (?$(L17(B . "0x2264B") ; <CJK>
       (?$(L18(B . "0x22646") ; <CJK>
       (?$(L19(B . "0x2263E") ; <CJK>
       (?$(L1:(B . "0x22649") ; <CJK>
       (?$(L1;(B . "0x229A7") ; <CJK>
       (?$(L1<(B . "0x229B6") ; <CJK>
       (?$(L1=(B . "0x229A6") ; <CJK>
       (?$(L1>(B . "0x229A8") ; <CJK>
       (?$(L1?(B . "0x229AC") ; <CJK>
       (?$(L1@(B . "0x229A9") ; <CJK>
       (?$(L1A(B . "0x229AB") ; <CJK>
       (?$(L1B(B . "0x22A38") ; <CJK>
       (?$(L1C(B . "0x22A37") ; <CJK>
       (?$(L1D(B . "0x22A39") ; <CJK>
       (?$(L1E(B . "0x22A41") ; <CJK>
       (?$(L1F(B . "0x22A3E") ; <CJK>
       (?$(L1G(B . "0x22AC0") ; <CJK>
       (?$(L1H(B . "0x22ABB") ; <CJK>
       (?$(L1I(B . "0x22ABF") ; <CJK>
       (?$(L1J(B . "0x22ABD") ; <CJK>
       (?$(L1K(B . "0x22AFE") ; <CJK>
       (?$(L1L(B . "0x22B1E") ; <CJK>
       (?$(L1M(B . "0x22AEE") ; <CJK>
       (?$(L1N(B . "0x22AFC") ; <CJK>
       (?$(L1O(B . "0x2F8B7") ; <CJK>
       (?$(L1P(B . "0x22AF9") ; <CJK>
       (?$(L1Q(B . "0x22B06") ; <CJK>
       (?$(L1R(B . "0x22AE4") ; <CJK>
       (?$(L1S(B . "0x22AE9") ; <CJK>
       (?$(L1T(B . "0x22AE5") ; <CJK>
       (?$(L1U(B . "0x22B03") ; <CJK>
       (?$(L1V(B . "0x22AFD") ; <CJK>
       (?$(L1W(B . "0x22B49") ; <CJK>
       (?$(L1X(B . "0x22EBE") ; <CJK>
       (?$(L1Y(B . "0x22F0A") ; <CJK>
       (?$(L1Z(B . "0x25626") ; <CJK>
       (?$(L1[(B . "0x22F18") ; <CJK>
       (?$(L1\(B . "0x22F0D") ; <CJK>
       (?$(L1](B . "0x22F0F") ; <CJK>
       (?$(L1^(B . "0x22F0E") ; <CJK>
       (?$(L1_(B . "0x22F20") ; <CJK>
       (?$(L1`(B . "0x23071") ; <CJK>
       (?$(L1a(B . "0x23099") ; <CJK>
       (?$(L1b(B . "0x230E2") ; <CJK>
       (?$(L1c(B . "0x230DF") ; <CJK>
       (?$(L1d(B . "0x230DE") ; <CJK>
       (?$(L1e(B . "0x23178") ; <CJK>
       (?$(L1f(B . "0x23179") ; <CJK>
       (?$(L1g(B . "0x3AE4") ; <CJK>
       (?$(L1h(B . "0x2317C") ; <CJK>
       (?$(L1i(B . "0x2317D") ; <CJK>
       (?$(L1j(B . "0x23184") ; <CJK>
       (?$(L1k(B . "0x2318B") ; <CJK>
       (?$(L1l(B . "0x2318A") ; <CJK>
       (?$(L1m(B . "0x2F8D2") ; <CJK>
       (?$(L1n(B . "0x23189") ; <CJK>
       (?$(L1o(B . "0x2332C") ; <CJK>
       (?$(L1p(B . "0x23329") ; <CJK>
       (?$(L1q(B . "0x2336C") ; <CJK>
       (?$(L1r(B . "0x6804") ; <CJK>
       (?$(L1s(B . "0x23409") ; <CJK>
       (?$(L1t(B . "0x23408") ; <CJK>
       (?$(L1u(B . "0x2340C") ; <CJK>
       (?$(L1v(B . "0x2340D") ; <CJK>
       (?$(L1w(B . "0x23410") ; <CJK>
       (?$(L1x(B . "0x3C26") ; <CJK>
       (?$(L1y(B . "0x2389F") ; <CJK>
       (?$(L1z(B . "0x23898") ; <CJK>
       (?$(L1{(B . "0x238A2") ; <CJK>
       (?$(L1|(B . "0x2389A") ; <CJK>
       (?$(L1}(B . "0x239D5") ; <CJK>
       (?$(L1~(B . "0x239E2") ; <CJK>
       (?$(L2!(B . "0x239F0") ; <CJK>
       (?$(L2"(B . "0x239EA") ; <CJK>
       (?$(L2#(B . "0x239EB") ; <CJK>
       (?$(L2$(B . "0x239ED") ; <CJK>
       (?$(L2%(B . "0x239E8") ; <CJK>
       (?$(L2&(B . "0x239E0") ; <CJK>
       (?$(L2'(B . "0x23A85") ; <CJK>
       (?$(L2((B . "0x23A86") ; <CJK>
       (?$(L2)(B . "0x23AF0") ; <CJK>
       (?$(L2*(B . "0x21E46") ; <CJK>
       (?$(L2+(B . "0x23B45") ; <CJK>
       (?$(L2,(B . "0x23B38") ; <CJK>
       (?$(L2-(B . "0x23B3E") ; <CJK>
       (?$(L2.(B . "0x23B42") ; <CJK>
       (?$(L2/(B . "0x23B40") ; <CJK>
       (?$(L20(B . "0x23C47") ; <CJK>
       (?$(L21(B . "0x23C5C") ; <CJK>
       (?$(L22(B . "0x23C5E") ; <CJK>
       (?$(L23(B . "0x23CB4") ; <CJK>
       (?$(L24(B . "0x23CC2") ; <CJK>
       (?$(L25(B . "0x23D14") ; <CJK>
       (?$(L26(B . "0x23CE5") ; <CJK>
       (?$(L27(B . "0x23D15") ; <CJK>
       (?$(L28(B . "0x23D11") ; <CJK>
       (?$(L29(B . "0x2F8FF") ; <CJK>
       (?$(L2:(B . "0x23CEE") ; <CJK>
       (?$(L2;(B . "0x23CE7") ; <CJK>
       (?$(L2<(B . "0x23CF5") ; <CJK>
       (?$(L2=(B . "0x23CF4") ; <CJK>
       (?$(L2>(B . "0x23CE8") ; <CJK>
       (?$(L2?(B . "0x23D01") ; <CJK>
       (?$(L2@(B . "0x23CEF") ; <CJK>
       (?$(L2A(B . "0x23CF1") ; <CJK>
       (?$(L2B(B . "0x2F900") ; <CJK>
       (?$(L2C(B . "0x241DB") ; <CJK>
       (?$(L2D(B . "0x241BF") ; <CJK>
       (?$(L2E(B . "0x241DA") ; <CJK>
       (?$(L2F(B . "0x241C7") ; <CJK>
       (?$(L2G(B . "0x241DD") ; <CJK>
       (?$(L2H(B . "0x2F91A") ; <CJK>
       (?$(L2I(B . "0x241EB") ; <CJK>
       (?$(L2J(B . "0x241E1") ; <CJK>
       (?$(L2K(B . "0x241C1") ; <CJK>
       (?$(L2L(B . "0x241BD") ; <CJK>
       (?$(L2M(B . "0x24507") ; <CJK>
       (?$(L2N(B . "0x244FD") ; <CJK>
       (?$(L2O(B . "0x24501") ; <CJK>
       (?$(L2P(B . "0x2450A") ; <CJK>
       (?$(L2Q(B . "0x24503") ; <CJK>
       (?$(L2R(B . "0x24572") ; <CJK>
       (?$(L2S(B . "0x24574") ; <CJK>
       (?$(L2T(B . "0x24575") ; <CJK>
       (?$(L2U(B . "0x245B2") ; <CJK>
       (?$(L2V(B . "0x245B1") ; <CJK>
       (?$(L2W(B . "0x245B4") ; <CJK>
       (?$(L2X(B . "0x2464C") ; <CJK>
       (?$(L2Y(B . "0x24642") ; <CJK>
       (?$(L2Z(B . "0x24640") ; <CJK>
       (?$(L2[(B . "0x24649") ; <CJK>
       (?$(L2\(B . "0x2463C") ; <CJK>
       (?$(L2](B . "0x2464D") ; <CJK>
       (?$(L2^(B . "0x2464A") ; <CJK>
       (?$(L2_(B . "0x2463B") ; <CJK>
       (?$(L2`(B . "0x24761") ; <CJK>
       (?$(L2a(B . "0x24774") ; <CJK>
       (?$(L2b(B . "0x2F926") ; <CJK>
       (?$(L2c(B . "0x2477F") ; <CJK>
       (?$(L2d(B . "0x2477A") ; <CJK>
       (?$(L2e(B . "0x24788") ; <CJK>
       (?$(L2f(B . "0x2477C") ; <CJK>
       (?$(L2g(B . "0x3E6F") ; <CJK>
       (?$(L2h(B . "0x24770") ; <CJK>
       (?$(L2i(B . "0x2490F") ; <CJK>
       (?$(L2j(B . "0x24928") ; <CJK>
       (?$(L2k(B . "0x24913") ; <CJK>
       (?$(L2l(B . "0x2492A") ; <CJK>
       (?$(L2m(B . "0x24AED") ; <CJK>
       (?$(L2n(B . "0x24AEF") ; <CJK>
       (?$(L2o(B . "0x24B2E") ; <CJK>
       (?$(L2p(B . "0x24BC1") ; <CJK>
       (?$(L2q(B . "0x24BDD") ; <CJK>
       (?$(L2r(B . "0x20B47") ; <CJK>
       (?$(L2s(B . "0x24C2D") ; <CJK>
       (?$(L2t(B . "0x24C2B") ; <CJK>
       (?$(L2u(B . "0x24C35") ; <CJK>
       (?$(L2v(B . "0x24C2F") ; <CJK>
       (?$(L2w(B . "0x24C31") ; <CJK>
       (?$(L2x(B . "0x24C34") ; <CJK>
       (?$(L2y(B . "0x2F935") ; <CJK>
       (?$(L2z(B . "0x24C30") ; <CJK>
       (?$(L2{(B . "0x24D3A") ; <CJK>
       (?$(L2|(B . "0x24D39") ; <CJK>
       (?$(L2}(B . "0x24D37") ; <CJK>
       (?$(L2~(B . "0x24D4B") ; <CJK>
       (?$(L3!(B . "0x24D54") ; <CJK>
       (?$(L3"(B . "0x24D4D") ; <CJK>
       (?$(L3#(B . "0x24D51") ; <CJK>
       (?$(L3$(B . "0x24D47") ; <CJK>
       (?$(L3%(B . "0x24F27") ; <CJK>
       (?$(L3&(B . "0x24F50") ; <CJK>
       (?$(L3'(B . "0x24F4D") ; <CJK>
       (?$(L3((B . "0x24F4E") ; <CJK>
       (?$(L3)(B . "0x24F54") ; <CJK>
       (?$(L3*(B . "0x24FD2") ; <CJK>
       (?$(L3+(B . "0x24FCE") ; <CJK>
       (?$(L3,(B . "0x2504B") ; <CJK>
       (?$(L3-(B . "0x25049") ; <CJK>
       (?$(L3.(B . "0x25105") ; <CJK>
       (?$(L3/(B . "0x2510F") ; <CJK>
       (?$(L30(B . "0x25119") ; <CJK>
       (?$(L31(B . "0x2F943") ; <CJK>
       (?$(L32(B . "0x25106") ; <CJK>
       (?$(L33(B . "0x2510C") ; <CJK>
       (?$(L34(B . "0x25129") ; <CJK>
       (?$(L35(B . "0x25104") ; <CJK>
       (?$(L36(B . "0x25108") ; <CJK>
       (?$(L37(B . "0x25125") ; <CJK>
       (?$(L38(B . "0x401C") ; <CJK>
       (?$(L39(B . "0x25103") ; <CJK>
       (?$(L3:(B . "0x25127") ; <CJK>
       (?$(L3;(B . "0x25110") ; <CJK>
       (?$(L3<(B . "0x2510A") ; <CJK>
       (?$(L3=(B . "0x2F942") ; <CJK>
       (?$(L3>(B . "0x26B5D") ; <CJK>
       (?$(L3?(B . "0x253AA") ; <CJK>
       (?$(L3@(B . "0x253AB") ; <CJK>
       (?$(L3A(B . "0x253A9") ; <CJK>
       (?$(L3B(B . "0x25441") ; <CJK>
       (?$(L3C(B . "0x2543A") ; <CJK>
       (?$(L3D(B . "0x2543C") ; <CJK>
       (?$(L3E(B . "0x2542B") ; <CJK>
       (?$(L3F(B . "0x25449") ; <CJK>
       (?$(L3G(B . "0x25615") ; <CJK>
       (?$(L3H(B . "0x4100") ; <CJK>
       (?$(L3I(B . "0x25616") ; <CJK>
       (?$(L3J(B . "0x2F953") ; <CJK>
       (?$(L3K(B . "0x25631") ; <CJK>
       (?$(L3L(B . "0x23C4A") ; <CJK>
       (?$(L3M(B . "0x2573C") ; <CJK>
       (?$(L3N(B . "0x2577C") ; <CJK>
       (?$(L3O(B . "0x2576D") ; <CJK>
       (?$(L3P(B . "0x2576A") ; <CJK>
       (?$(L3Q(B . "0x25763") ; <CJK>
       (?$(L3R(B . "0x2576B") ; <CJK>
       (?$(L3S(B . "0x2577B") ; <CJK>
       (?$(L3T(B . "0x25764") ; <CJK>
       (?$(L3U(B . "0x2577A") ; <CJK>
       (?$(L3V(B . "0x25769") ; <CJK>
       (?$(L3W(B . "0x2576F") ; <CJK>
       (?$(L3X(B . "0x25937") ; <CJK>
       (?$(L3Y(B . "0x25935") ; <CJK>
       (?$(L3Z(B . "0x2593C") ; <CJK>
       (?$(L3[(B . "0x25936") ; <CJK>
       (?$(L3\(B . "0x2593D") ; <CJK>
       (?$(L3](B . "0x2593E") ; <CJK>
       (?$(L3^(B . "0x25AE1") ; <CJK>
       (?$(L3_(B . "0x25AE0") ; <CJK>
       (?$(L3`(B . "0x25E2D") ; <CJK>
       (?$(L3a(B . "0x25E2B") ; <CJK>
       (?$(L3b(B . "0x25F8D") ; <CJK>
       (?$(L3c(B . "0x25F92") ; <CJK>
       (?$(L3d(B . "0x42B6") ; <CJK>
       (?$(L3e(B . "0x25F8E") ; <CJK>
       (?$(L3f(B . "0x2F96B") ; <CJK>
       (?$(L3g(B . "0x25F91") ; <CJK>
       (?$(L3h(B . "0x25F96") ; <CJK>
       (?$(L3i(B . "0x2627B") ; <CJK>
       (?$(L3j(B . "0x26278") ; <CJK>
       (?$(L3k(B . "0x26281") ; <CJK>
       (?$(L3l(B . "0x26296") ; <CJK>
       (?$(L3m(B . "0x262A3") ; <CJK>
       (?$(L3n(B . "0x26295") ; <CJK>
       (?$(L3o(B . "0x26297") ; <CJK>
       (?$(L3p(B . "0x26354") ; <CJK>
       (?$(L3q(B . "0x26352") ; <CJK>
       (?$(L3r(B . "0x263F5") ; <CJK>
       (?$(L3s(B . "0x26400") ; <CJK>
       (?$(L3t(B . "0x263FB") ; <CJK>
       (?$(L3u(B . "0x263F4") ; <CJK>
       (?$(L3v(B . "0x263F6") ; <CJK>
       (?$(L3w(B . "0x264E8") ; <CJK>
       (?$(L3x(B . "0x264EA") ; <CJK>
       (?$(L3y(B . "0x2663E") ; <CJK>
       (?$(L3z(B . "0x2663D") ; <CJK>
       (?$(L3{(B . "0x2663B") ; <CJK>
       (?$(L3|(B . "0x26680") ; <CJK>
       (?$(L3}(B . "0x43E4") ; <CJK>
       (?$(L3~(B . "0x26688") ; <CJK>
       (?$(L4!(B . "0x26681") ; <CJK>
       (?$(L4"(B . "0x26682") ; <CJK>
       (?$(L4#(B . "0x266CE") ; <CJK>
       (?$(L4$(B . "0x26683") ; <CJK>
       (?$(L4%(B . "0x26677") ; <CJK>
       (?$(L4&(B . "0x26679") ; <CJK>
       (?$(L4'(B . "0x26673") ; <CJK>
       (?$(L4((B . "0x2666D") ; <CJK>
       (?$(L4)(B . "0x26670") ; <CJK>
       (?$(L4*(B . "0x2668D") ; <CJK>
       (?$(L4+(B . "0x26675") ; <CJK>
       (?$(L4,(B . "0x2668C") ; <CJK>
       (?$(L4-(B . "0x2666A") ; <CJK>
       (?$(L4.(B . "0x26691") ; <CJK>
       (?$(L4/(B . "0x26689") ; <CJK>
       (?$(L40(B . "0x2668E") ; <CJK>
       (?$(L41(B . "0x212DC") ; <CJK>
       (?$(L42(B . "0x268FF") ; <CJK>
       (?$(L43(B . "0x26959") ; <CJK>
       (?$(L44(B . "0x269C7") ; <CJK>
       (?$(L45(B . "0x26A12") ; <CJK>
       (?$(L46(B . "0x26A14") ; <CJK>
       (?$(L47(B . "0x26A13") ; <CJK>
       (?$(L48(B . "0x26ACB") ; <CJK>
       (?$(L49(B . "0x26B42") ; <CJK>
       (?$(L4:(B . "0x44AD") ; <CJK>
       (?$(L4;(B . "0x26B3D") ; <CJK>
       (?$(L4<(B . "0x82FF") ; <CJK>
       (?$(L4=(B . "0x26B40") ; <CJK>
       (?$(L4>(B . "0x26B44") ; <CJK>
       (?$(L4?(B . "0x26B62") ; <CJK>
       (?$(L4@(B . "0x26B43") ; <CJK>
       (?$(L4A(B . "0x26B3F") ; <CJK>
       (?$(L4B(B . "0x26B45") ; <CJK>
       (?$(L4C(B . "0x26B3C") ; <CJK>
       (?$(L4D(B . "0x2F997") ; <CJK>
       (?$(L4E(B . "0x26B46") ; <CJK>
       (?$(L4F(B . "0x26B47") ; <CJK>
       (?$(L4G(B . "0x2F9B3") ; <CJK>
       (?$(L4H(B . "0x2719E") ; <CJK>
       (?$(L4I(B . "0x2719D") ; <CJK>
       (?$(L4J(B . "0x2722C") ; <CJK>
       (?$(L4K(B . "0x27229") ; <CJK>
       (?$(L4L(B . "0x2722F") ; <CJK>
       (?$(L4M(B . "0x2722E") ; <CJK>
       (?$(L4N(B . "0x27230") ; <CJK>
       (?$(L4O(B . "0x275E1") ; <CJK>
       (?$(L4P(B . "0x275E2") ; <CJK>
       (?$(L4Q(B . "0x2760E") ; <CJK>
       (?$(L4R(B . "0x27619") ; <CJK>
       (?$(L4S(B . "0x27612") ; <CJK>
       (?$(L4T(B . "0x278B4") ; <CJK>
       (?$(L4U(B . "0x27BDA") ; <CJK>
       (?$(L4V(B . "0x27D26") ; <CJK>
       (?$(L4W(B . "0x27E59") ; <CJK>
       (?$(L4X(B . "0x27E5A") ; <CJK>
       (?$(L4Y(B . "0x27E88") ; <CJK>
       (?$(L4Z(B . "0x27FC0") ; <CJK>
       (?$(L4[(B . "0x27FBA") ; <CJK>
       (?$(L4\(B . "0x282A0") ; <CJK>
       (?$(L4](B . "0x2F9DD") ; <CJK>
       (?$(L4^(B . "0x282A2") ; <CJK>
       (?$(L4_(B . "0x28486") ; <CJK>
       (?$(L4`(B . "0x8FEC") ; <CJK>
       (?$(L4a(B . "0x2849D") ; <CJK>
       (?$(L4b(B . "0x28488") ; <CJK>
       (?$(L4c(B . "0x2848F") ; <CJK>
       (?$(L4d(B . "0x2848E") ; <CJK>
       (?$(L4e(B . "0x2849B") ; <CJK>
       (?$(L4f(B . "0x286C1") ; <CJK>
       (?$(L4g(B . "0x286C3") ; <CJK>
       (?$(L4h(B . "0x286C4") ; <CJK>
       (?$(L4i(B . "0x28696") ; <CJK>
       (?$(L4j(B . "0x286C7") ; <CJK>
       (?$(L4k(B . "0x286C6") ; <CJK>
       (?$(L4l(B . "0x286BF") ; <CJK>
       (?$(L4m(B . "0x48C3") ; <CJK>
       (?$(L4n(B . "0x2890F") ; <CJK>
       (?$(L4o(B . "0x28E55") ; <CJK>
       (?$(L4p(B . "0x28E42") ; <CJK>
       (?$(L4q(B . "0x28E46") ; <CJK>
       (?$(L4r(B . "0x28E4B") ; <CJK>
       (?$(L4s(B . "0x28E43") ; <CJK>
       (?$(L4t(B . "0x28E53") ; <CJK>
       (?$(L4u(B . "0x28E48") ; <CJK>
       (?$(L4v(B . "0x28E49") ; <CJK>
       (?$(L4w(B . "0x28E4A") ; <CJK>
       (?$(L4x(B . "0x28E4E") ; <CJK>
       (?$(L4y(B . "0x24BDE") ; <CJK>
       (?$(L4z(B . "0x20691") ; <CJK>
       (?$(L4{(B . "0x2944B") ; <CJK>
       (?$(L4|(B . "0x29680") ; <CJK>
       (?$(L4}(B . "0x29681") ; <CJK>
       (?$(L4~(B . "0x29683") ; <CJK>
       (?$(L5!(B . "0x2028A") ; <CJK>
       (?$(L5"(B . "0x29682") ; <CJK>
       (?$(L5#(B . "0x22342") ; <CJK>
       (?$(L5$(B . "0x20922") ; <CJK>
       (?$(L5%(B . "0x20070") ; <CJK>
       (?$(L5&(B . "0x20071") ; <CJK>
       (?$(L5'(B . "0x200BC") ; <CJK>
       (?$(L5((B . "0x21D18") ; <CJK>
       (?$(L5)(B . "0x200BE") ; <CJK>
       (?$(L5*(B . "0x200BA") ; <CJK>
       (?$(L5+(B . "0x200F8") ; <CJK>
       (?$(L5,(B . "0x20137") ; <CJK>
       (?$(L5-(B . "0x20135") ; <CJK>
       (?$(L5.(B . "0x20AFC") ; <CJK>
       (?$(L5/(B . "0x20156") ; <CJK>
       (?$(L50(B . "0x20159") ; <CJK>
       (?$(L51(B . "0x2015E") ; <CJK>
       (?$(L52(B . "0x2026D") ; <CJK>
       (?$(L53(B . "0x20291") ; <CJK>
       (?$(L54(B . "0x20292") ; <CJK>
       (?$(L55(B . "0x20268") ; <CJK>
       (?$(L56(B . "0x20266") ; <CJK>
       (?$(L57(B . "0x20273") ; <CJK>
       (?$(L58(B . "0x3467") ; <CJK>
       (?$(L59(B . "0x20296") ; <CJK>
       (?$(L5:(B . "0x2028B") ; <CJK>
       (?$(L5;(B . "0x2028C") ; <CJK>
       (?$(L5<(B . "0x20496") ; <CJK>
       (?$(L5=(B . "0x204EE") ; <CJK>
       (?$(L5>(B . "0x2051C") ; <CJK>
       (?$(L5?(B . "0x2051A") ; <CJK>
       (?$(L5@(B . "0x20519") ; <CJK>
       (?$(L5A(B . "0x2051B") ; <CJK>
       (?$(L5B(B . "0x2055D") ; <CJK>
       (?$(L5C(B . "0x2055E") ; <CJK>
       (?$(L5D(B . "0x2F818") ; <CJK>
       (?$(L5E(B . "0x205DC") ; <CJK>
       (?$(L5F(B . "0x205E2") ; <CJK>
       (?$(L5G(B . "0x20652") ; <CJK>
       (?$(L5H(B . "0x20692") ; <CJK>
       (?$(L5I(B . "0x20730") ; <CJK>
       (?$(L5J(B . "0x20752") ; <CJK>
       (?$(L5K(B . "0x20742") ; <CJK>
       (?$(L5L(B . "0x20741") ; <CJK>
       (?$(L5M(B . "0x20745") ; <CJK>
       (?$(L5N(B . "0x20737") ; <CJK>
       (?$(L5O(B . "0x20740") ; <CJK>
       (?$(L5P(B . "0x2073F") ; <CJK>
       (?$(L5Q(B . "0x2073D") ; <CJK>
       (?$(L5R(B . "0x20738") ; <CJK>
       (?$(L5S(B . "0x2073A") ; <CJK>
       (?$(L5T(B . "0x20749") ; <CJK>
       (?$(L5U(B . "0x2086B") ; <CJK>
       (?$(L5V(B . "0x20878") ; <CJK>
       (?$(L5W(B . "0x20879") ; <CJK>
       (?$(L5X(B . "0x2F826") ; <CJK>
       (?$(L5Y(B . "0x2086C") ; <CJK>
       (?$(L5Z(B . "0x208E9") ; <CJK>
       (?$(L5[(B . "0x208E6") ; <CJK>
       (?$(L5\(B . "0x208E5") ; <CJK>
       (?$(L5](B . "0x208EA") ; <CJK>
       (?$(L5^(B . "0x208E7") ; <CJK>
       (?$(L5_(B . "0x208E8") ; <CJK>
       (?$(L5`(B . "0x2091F") ; <CJK>
       (?$(L5a(B . "0x2094B") ; <CJK>
       (?$(L5b(B . "0x2094A") ; <CJK>
       (?$(L5c(B . "0x20953") ; <CJK>
       (?$(L5d(B . "0x20976") ; <CJK>
       (?$(L5e(B . "0x209A3") ; <CJK>
       (?$(L5f(B . "0x209A4") ; <CJK>
       (?$(L5g(B . "0x209F6") ; <CJK>
       (?$(L5h(B . "0x209F3") ; <CJK>
       (?$(L5i(B . "0x209F9") ; <CJK>
       (?$(L5j(B . "0x209F7") ; <CJK>
       (?$(L5k(B . "0x209FC") ; <CJK>
       (?$(L5l(B . "0x20A1D") ; <CJK>
       (?$(L5m(B . "0x20A6D") ; <CJK>
       (?$(L5n(B . "0x20A71") ; <CJK>
       (?$(L5o(B . "0x20A6C") ; <CJK>
       (?$(L5p(B . "0x20A6E") ; <CJK>
       (?$(L5q(B . "0x20A70") ; <CJK>
       (?$(L5r(B . "0x20A6F") ; <CJK>
       (?$(L5s(B . "0x20A67") ; <CJK>
       (?$(L5t(B . "0x20A68") ; <CJK>
       (?$(L5u(B . "0x20AFA") ; <CJK>
       (?$(L5v(B . "0x20AF9") ; <CJK>
       (?$(L5w(B . "0x20B4E") ; <CJK>
       (?$(L5x(B . "0x53DE") ; <CJK>
       (?$(L5y(B . "0x20B4D") ; <CJK>
       (?$(L5z(B . "0x20B4F") ; <CJK>
       (?$(L5{(B . "0x20B4A") ; <CJK>
       (?$(L5|(B . "0x20B4C") ; <CJK>
       (?$(L5}(B . "0x3596") ; <CJK>
       (?$(L5~(B . "0x2F842") ; <CJK>
       (?$(L6!(B . "0x20CEE") ; <CJK>
       (?$(L6"(B . "0x20CB2") ; <CJK>
       (?$(L6#(B . "0x20CC0") ; <CJK>
       (?$(L6$(B . "0x20CC1") ; <CJK>
       (?$(L6%(B . "0x20CF4") ; <CJK>
       (?$(L6&(B . "0x20CC8") ; <CJK>
       (?$(L6'(B . "0x20CC5") ; <CJK>
       (?$(L6((B . "0x20CC6") ; <CJK>
       (?$(L6)(B . "0x20CAD") ; <CJK>
       (?$(L6*(B . "0x211E2") ; <CJK>
       (?$(L6+(B . "0x211EA") ; <CJK>
       (?$(L6,(B . "0x211E3") ; <CJK>
       (?$(L6-(B . "0x211E1") ; <CJK>
       (?$(L6.(B . "0x212F7") ; <CJK>
       (?$(L6/(B . "0x21301") ; <CJK>
       (?$(L60(B . "0x21312") ; <CJK>
       (?$(L61(B . "0x212F6") ; <CJK>
       (?$(L62(B . "0x212F1") ; <CJK>
       (?$(L63(B . "0x2131F") ; <CJK>
       (?$(L64(B . "0x212EE") ; <CJK>
       (?$(L65(B . "0x2F852") ; <CJK>
       (?$(L66(B . "0x212F3") ; <CJK>
       (?$(L67(B . "0x21315") ; <CJK>
       (?$(L68(B . "0x21316") ; <CJK>
       (?$(L69(B . "0x21317") ; <CJK>
       (?$(L6:(B . "0x212F8") ; <CJK>
       (?$(L6;(B . "0x21319") ; <CJK>
       (?$(L6<(B . "0x212F2") ; <CJK>
       (?$(L6=(B . "0x212F4") ; <CJK>
       (?$(L6>(B . "0x212F5") ; <CJK>
       (?$(L6?(B . "0x21313") ; <CJK>
       (?$(L6@(B . "0x21306") ; <CJK>
       (?$(L6A(B . "0x21526") ; <CJK>
       (?$(L6B(B . "0x21524") ; <CJK>
       (?$(L6C(B . "0x2155A") ; <CJK>
       (?$(L6D(B . "0x22EC8") ; <CJK>
       (?$(L6E(B . "0x21597") ; <CJK>
       (?$(L6F(B . "0x21595") ; <CJK>
       (?$(L6G(B . "0x2159A") ; <CJK>
       (?$(L6H(B . "0x2161F") ; <CJK>
       (?$(L6I(B . "0x20AFB") ; <CJK>
       (?$(L6J(B . "0x21629") ; <CJK>
       (?$(L6K(B . "0x21620") ; <CJK>
       (?$(L6L(B . "0x2F862") ; <CJK>
       (?$(L6M(B . "0x2F863") ; <CJK>
       (?$(L6N(B . "0x2174C") ; <CJK>
       (?$(L6O(B . "0x21730") ; <CJK>
       (?$(L6P(B . "0x21738") ; <CJK>
       (?$(L6Q(B . "0x2173D") ; <CJK>
       (?$(L6R(B . "0x21751") ; <CJK>
       (?$(L6S(B . "0x2174F") ; <CJK>
       (?$(L6T(B . "0x2174A") ; <CJK>
       (?$(L6U(B . "0x21734") ; <CJK>
       (?$(L6V(B . "0x21736") ; <CJK>
       (?$(L6W(B . "0x5A30") ; <CJK>
       (?$(L6X(B . "0x2196A") ; <CJK>
       (?$(L6Y(B . "0x21968") ; <CJK>
       (?$(L6Z(B . "0x21A1C") ; <CJK>
       (?$(L6[(B . "0x21A0E") ; <CJK>
       (?$(L6\(B . "0x21A1E") ; <CJK>
       (?$(L6](B . "0x3759") ; <CJK>
       (?$(L6^(B . "0x21A09") ; <CJK>
       (?$(L6_(B . "0x21A08") ; <CJK>
       (?$(L6`(B . "0x21A13") ; <CJK>
       (?$(L6a(B . "0x21A01") ; <CJK>
       (?$(L6b(B . "0x21A0F") ; <CJK>
       (?$(L6c(B . "0x21A14") ; <CJK>
       (?$(L6d(B . "0x21A06") ; <CJK>
       (?$(L6e(B . "0x21A07") ; <CJK>
       (?$(L6f(B . "0x5BB2") ; <CJK>
       (?$(L6g(B . "0x2F873") ; <CJK>
       (?$(L6h(B . "0x3776") ; <CJK>
       (?$(L6i(B . "0x21B79") ; <CJK>
       (?$(L6j(B . "0x21BEA") ; <CJK>
       (?$(L6k(B . "0x21BED") ; <CJK>
       (?$(L6l(B . "0x21BE9") ; <CJK>
       (?$(L6m(B . "0x21BEE") ; <CJK>
       (?$(L6n(B . "0x21C68") ; <CJK>
       (?$(L6o(B . "0x21C64") ; <CJK>
       (?$(L6p(B . "0x21C67") ; <CJK>
       (?$(L6q(B . "0x21C72") ; <CJK>
       (?$(L6r(B . "0x21C62") ; <CJK>
       (?$(L6s(B . "0x21C74") ; <CJK>
       (?$(L6t(B . "0x21C79") ; <CJK>
       (?$(L6u(B . "0x21D19") ; <CJK>
       (?$(L6v(B . "0x21D17") ; <CJK>
       (?$(L6w(B . "0x21D15") ; <CJK>
       (?$(L6x(B . "0x21D16") ; <CJK>
       (?$(L6y(B . "0x21DE6") ; <CJK>
       (?$(L6z(B . "0x262A4") ; <CJK>
       (?$(L6{(B . "0x21DEE") ; <CJK>
       (?$(L6|(B . "0x37D2") ; <CJK>
       (?$(L6}(B . "0x21DDF") ; <CJK>
       (?$(L6~(B . "0x21DE4") ; <CJK>
       (?$(L7!(B . "0x21DDA") ; <CJK>
       (?$(L7"(B . "0x21DEA") ; <CJK>
       (?$(L7#(B . "0x21DED") ; <CJK>
       (?$(L7$(B . "0x21DE3") ; <CJK>
       (?$(L7%(B . "0x21DE9") ; <CJK>
       (?$(L7&(B . "0x21FFD") ; <CJK>
       (?$(L7'(B . "0x20657") ; <CJK>
       (?$(L7((B . "0x22021") ; <CJK>
       (?$(L7)(B . "0x220C6") ; <CJK>
       (?$(L7*(B . "0x220B8") ; <CJK>
       (?$(L7+(B . "0x220CB") ; <CJK>
       (?$(L7,(B . "0x2F885") ; <CJK>
       (?$(L7-(B . "0x220BD") ; <CJK>
       (?$(L7.(B . "0x220B5") ; <CJK>
       (?$(L7/(B . "0x220BB") ; <CJK>
       (?$(L70(B . "0x220BF") ; <CJK>
       (?$(L71(B . "0x220BE") ; <CJK>
       (?$(L72(B . "0x220B2") ; <CJK>
       (?$(L73(B . "0x220C1") ; <CJK>
       (?$(L74(B . "0x220C2") ; <CJK>
       (?$(L75(B . "0x22199") ; <CJK>
       (?$(L76(B . "0x221C6") ; <CJK>
       (?$(L77(B . "0x2222C") ; <CJK>
       (?$(L78(B . "0x2222D") ; <CJK>
       (?$(L79(B . "0x22225") ; <CJK>
       (?$(L7:(B . "0x2221E") ; <CJK>
       (?$(L7;(B . "0x2221F") ; <CJK>
       (?$(L7<(B . "0x22223") ; <CJK>
       (?$(L7=(B . "0x22350") ; <CJK>
       (?$(L7>(B . "0x2234E") ; <CJK>
       (?$(L7?(B . "0x2234D") ; <CJK>
       (?$(L7@(B . "0x22352") ; <CJK>
       (?$(L7A(B . "0x223E9") ; <CJK>
       (?$(L7B(B . "0x223EC") ; <CJK>
       (?$(L7C(B . "0x223E8") ; <CJK>
       (?$(L7D(B . "0x22458") ; <CJK>
       (?$(L7E(B . "0x2245C") ; <CJK>
       (?$(L7F(B . "0x2245B") ; <CJK>
       (?$(L7G(B . "0x2248F") ; <CJK>
       (?$(L7H(B . "0x23972") ; <CJK>
       (?$(L7I(B . "0x224F6") ; <CJK>
       (?$(L7J(B . "0x22500") ; <CJK>
       (?$(L7K(B . "0x224FC") ; <CJK>
       (?$(L7L(B . "0x224F8") ; <CJK>
       (?$(L7M(B . "0x224EA") ; <CJK>
       (?$(L7N(B . "0x224FE") ; <CJK>
       (?$(L7O(B . "0x224F7") ; <CJK>
       (?$(L7P(B . "0x224FD") ; <CJK>
       (?$(L7Q(B . "0x22670") ; <CJK>
       (?$(L7R(B . "0x22662") ; <CJK>
       (?$(L7S(B . "0x22644") ; <CJK>
       (?$(L7T(B . "0x3920") ; <CJK>
       (?$(L7U(B . "0x2264D") ; <CJK>
       (?$(L7V(B . "0x2264C") ; <CJK>
       (?$(L7W(B . "0x2263F") ; <CJK>
       (?$(L7X(B . "0x22666") ; <CJK>
       (?$(L7Y(B . "0x22635") ; <CJK>
       (?$(L7Z(B . "0x3929") ; <CJK>
       (?$(L7[(B . "0x22634") ; <CJK>
       (?$(L7\(B . "0x2268D") ; <CJK>
       (?$(L7](B . "0x22684") ; <CJK>
       (?$(L7^(B . "0x3938") ; <CJK>
       (?$(L7_(B . "0x22686") ; <CJK>
       (?$(L7`(B . "0x22689") ; <CJK>
       (?$(L7a(B . "0x22687") ; <CJK>
       (?$(L7b(B . "0x22683") ; <CJK>
       (?$(L7c(B . "0x22675") ; <CJK>
       (?$(L7d(B . "0x22679") ; <CJK>
       (?$(L7e(B . "0x226AF") ; <CJK>
       (?$(L7f(B . "0x226B0") ; <CJK>
       (?$(L7g(B . "0x229B7") ; <CJK>
       (?$(L7h(B . "0x229BB") ; <CJK>
       (?$(L7i(B . "0x229B9") ; <CJK>
       (?$(L7j(B . "0x22A46") ; <CJK>
       (?$(L7k(B . "0x22A47") ; <CJK>
       (?$(L7l(B . "0x22A45") ; <CJK>
       (?$(L7m(B . "0x22AEA") ; <CJK>
       (?$(L7n(B . "0x22AF6") ; <CJK>
       (?$(L7o(B . "0x22B68") ; <CJK>
       (?$(L7p(B . "0x22B39") ; <CJK>
       (?$(L7q(B . "0x2F8B9") ; <CJK>
       (?$(L7r(B . "0x22B3D") ; <CJK>
       (?$(L7s(B . "0x22B3B") ; <CJK>
       (?$(L7t(B . "0x22B4D") ; <CJK>
       (?$(L7u(B . "0x22B30") ; <CJK>
       (?$(L7v(B . "0x22B4A") ; <CJK>
       (?$(L7w(B . "0x22B3E") ; <CJK>
       (?$(L7x(B . "0x22B40") ; <CJK>
       (?$(L7y(B . "0x22B4C") ; <CJK>
       (?$(L7z(B . "0x22B47") ; <CJK>
       (?$(L7{(B . "0x22B38") ; <CJK>
       (?$(L7|(B . "0x22B52") ; <CJK>
       (?$(L7}(B . "0x22B3A") ; <CJK>
       (?$(L7~(B . "0x22B53") ; <CJK>
       (?$(L8!(B . "0x22EC4") ; <CJK>
       (?$(L8"(B . "0x22EC1") ; <CJK>
       (?$(L8#(B . "0x22F1C") ; <CJK>
       (?$(L8$(B . "0x22F1D") ; <CJK>
       (?$(L8%(B . "0x22F2A") ; <CJK>
       (?$(L8&(B . "0x22F1E") ; <CJK>
       (?$(L8'(B . "0x22F2F") ; <CJK>
       (?$(L8((B . "0x22F22") ; <CJK>
       (?$(L8)(B . "0x22F2E") ; <CJK>
       (?$(L8*(B . "0x22F25") ; <CJK>
       (?$(L8+(B . "0x3A89") ; <CJK>
       (?$(L8,(B . "0x3AB0") ; <CJK>
       (?$(L8-(B . "0x2304A") ; <CJK>
       (?$(L8.(B . "0x2304B") ; <CJK>
       (?$(L8/(B . "0x23076") ; <CJK>
       (?$(L80(B . "0x3ABF") ; <CJK>
       (?$(L81(B . "0x230E8") ; <CJK>
       (?$(L82(B . "0x230EF") ; <CJK>
       (?$(L83(B . "0x230E9") ; <CJK>
       (?$(L84(B . "0x3AC5") ; <CJK>
       (?$(L85(B . "0x230EA") ; <CJK>
       (?$(L86(B . "0x2F8CC") ; <CJK>
       (?$(L87(B . "0x3AEA") ; <CJK>
       (?$(L88(B . "0x2319B") ; <CJK>
       (?$(L89(B . "0x2319E") ; <CJK>
       (?$(L8:(B . "0x23193") ; <CJK>
       (?$(L8;(B . "0x231A7") ; <CJK>
       (?$(L8<(B . "0x2319C") ; <CJK>
       (?$(L8=(B . "0x231A0") ; <CJK>
       (?$(L8>(B . "0x2319A") ; <CJK>
       (?$(L8?(B . "0x231AB") ; <CJK>
       (?$(L8@(B . "0x231BE") ; <CJK>
       (?$(L8A(B . "0x231A9") ; <CJK>
       (?$(L8B(B . "0x2332D") ; <CJK>
       (?$(L8C(B . "0x2336E") ; <CJK>
       (?$(L8D(B . "0x23444") ; <CJK>
       (?$(L8E(B . "0x2343D") ; <CJK>
       (?$(L8F(B . "0x2343A") ; <CJK>
       (?$(L8G(B . "0x23468") ; <CJK>
       (?$(L8H(B . "0x2343C") ; <CJK>
       (?$(L8I(B . "0x2346A") ; <CJK>
       (?$(L8J(B . "0x2F8E0") ; <CJK>
       (?$(L8K(B . "0x23438") ; <CJK>
       (?$(L8L(B . "0x23465") ; <CJK>
       (?$(L8M(B . "0x23439") ; <CJK>
       (?$(L8N(B . "0x2346D") ; <CJK>
       (?$(L8O(B . "0x23436") ; <CJK>
       (?$(L8P(B . "0x2F8E3") ; <CJK>
       (?$(L8Q(B . "0x2343E") ; <CJK>
       (?$(L8R(B . "0x2347E") ; <CJK>
       (?$(L8S(B . "0x23437") ; <CJK>
       (?$(L8T(B . "0x23899") ; <CJK>
       (?$(L8U(B . "0x238A9") ; <CJK>
       (?$(L8V(B . "0x238AD") ; <CJK>
       (?$(L8W(B . "0x238A7") ; <CJK>
       (?$(L8X(B . "0x238A8") ; <CJK>
       (?$(L8Y(B . "0x23966") ; <CJK>
       (?$(L8Z(B . "0x23969") ; <CJK>
       (?$(L8[(B . "0x2396D") ; <CJK>
       (?$(L8\(B . "0x23967") ; <CJK>
       (?$(L8](B . "0x2396B") ; <CJK>
       (?$(L8^(B . "0x2396A") ; <CJK>
       (?$(L8_(B . "0x239EE") ; <CJK>
       (?$(L8`(B . "0x23A01") ; <CJK>
       (?$(L8a(B . "0x23A03") ; <CJK>
       (?$(L8b(B . "0x239F4") ; <CJK>
       (?$(L8c(B . "0x239FB") ; <CJK>
       (?$(L8d(B . "0x3C37") ; <CJK>
       (?$(L8e(B . "0x239F6") ; <CJK>
       (?$(L8f(B . "0x239FC") ; <CJK>
       (?$(L8g(B . "0x23AF4") ; <CJK>
       (?$(L8h(B . "0x23B08") ; <CJK>
       (?$(L8i(B . "0x23B0A") ; <CJK>
       (?$(L8j(B . "0x23B09") ; <CJK>
       (?$(L8k(B . "0x23B6D") ; <CJK>
       (?$(L8l(B . "0x23B62") ; <CJK>
       (?$(L8m(B . "0x23B41") ; <CJK>
       (?$(L8n(B . "0x23B5E") ; <CJK>
       (?$(L8o(B . "0x23B5C") ; <CJK>
       (?$(L8p(B . "0x23CF3") ; <CJK>
       (?$(L8q(B . "0x23D26") ; <CJK>
       (?$(L8r(B . "0x3CE4") ; <CJK>
       (?$(L8s(B . "0x23D39") ; <CJK>
       (?$(L8t(B . "0x2F904") ; <CJK>
       (?$(L8u(B . "0x23D6C") ; <CJK>
       (?$(L8v(B . "0x23D2B") ; <CJK>
       (?$(L8w(B . "0x23D2E") ; <CJK>
       (?$(L8x(B . "0x23D3B") ; <CJK>
       (?$(L8y(B . "0x23D5E") ; <CJK>
       (?$(L8z(B . "0x23DFB") ; <CJK>
       (?$(L8{(B . "0x23D27") ; <CJK>
       (?$(L8|(B . "0x23D24") ; <CJK>
       (?$(L8}(B . "0x23D69") ; <CJK>
       (?$(L8~(B . "0x23D30") ; <CJK>
       (?$(L9!(B . "0x2F905") ; <CJK>
       (?$(L9"(B . "0x23D62") ; <CJK>
       (?$(L9#(B . "0x23D38") ; <CJK>
       (?$(L9$(B . "0x23D35") ; <CJK>
       (?$(L9%(B . "0x23D2A") ; <CJK>
       (?$(L9&(B . "0x23D2C") ; <CJK>
       (?$(L9'(B . "0x23D68") ; <CJK>
       (?$(L9((B . "0x23D31") ; <CJK>
       (?$(L9)(B . "0x23D2F") ; <CJK>
       (?$(L9*(B . "0x23D2D") ; <CJK>
       (?$(L9+(B . "0x23D3A") ; <CJK>
       (?$(L9,(B . "0x23D36") ; <CJK>
       (?$(L9-(B . "0x2F903") ; <CJK>
       (?$(L9.(B . "0x23D21") ; <CJK>
       (?$(L9/(B . "0x23D3C") ; <CJK>
       (?$(L90(B . "0x23D20") ; <CJK>
       (?$(L91(B . "0x23D64") ; <CJK>
       (?$(L92(B . "0x23D3E") ; <CJK>
       (?$(L93(B . "0x3CE8") ; <CJK>
       (?$(L94(B . "0x241F7") ; <CJK>
       (?$(L95(B . "0x24212") ; <CJK>
       (?$(L96(B . "0x241F1") ; <CJK>
       (?$(L97(B . "0x241F5") ; <CJK>
       (?$(L98(B . "0x24222") ; <CJK>
       (?$(L99(B . "0x241F2") ; <CJK>
       (?$(L9:(B . "0x241DF") ; <CJK>
       (?$(L9;(B . "0x24215") ; <CJK>
       (?$(L9<(B . "0x24216") ; <CJK>
       (?$(L9=(B . "0x2457A") ; <CJK>
       (?$(L9>(B . "0x24576") ; <CJK>
       (?$(L9?(B . "0x245BE") ; <CJK>
       (?$(L9@(B . "0x3E20") ; <CJK>
       (?$(L9A(B . "0x245BD") ; <CJK>
       (?$(L9B(B . "0x24609") ; <CJK>
       (?$(L9C(B . "0x24608") ; <CJK>
       (?$(L9D(B . "0x24657") ; <CJK>
       (?$(L9E(B . "0x247A3") ; <CJK>
       (?$(L9F(B . "0x247BF") ; <CJK>
       (?$(L9G(B . "0x247B8") ; <CJK>
       (?$(L9H(B . "0x247AF") ; <CJK>
       (?$(L9I(B . "0x2479C") ; <CJK>
       (?$(L9J(B . "0x247A5") ; <CJK>
       (?$(L9K(B . "0x24772") ; <CJK>
       (?$(L9L(B . "0x24775") ; <CJK>
       (?$(L9M(B . "0x2479D") ; <CJK>
       (?$(L9N(B . "0x24799") ; <CJK>
       (?$(L9O(B . "0x247B9") ; <CJK>
       (?$(L9P(B . "0x2494E") ; <CJK>
       (?$(L9Q(B . "0x24939") ; <CJK>
       (?$(L9R(B . "0x2493B") ; <CJK>
       (?$(L9S(B . "0x24935") ; <CJK>
       (?$(L9T(B . "0x2493C") ; <CJK>
       (?$(L9U(B . "0x24955") ; <CJK>
       (?$(L9V(B . "0x24AF0") ; <CJK>
       (?$(L9W(B . "0x24AF3") ; <CJK>
       (?$(L9X(B . "0x24AF4") ; <CJK>
       (?$(L9Y(B . "0x24B3B") ; <CJK>
       (?$(L9Z(B . "0x24B3C") ; <CJK>
       (?$(L9[(B . "0x24B3A") ; <CJK>
       (?$(L9\(B . "0x24B36") ; <CJK>
       (?$(L9](B . "0x24C07") ; <CJK>
       (?$(L9^(B . "0x20CEB") ; <CJK>
       (?$(L9_(B . "0x24C55") ; <CJK>
       (?$(L9`(B . "0x24C50") ; <CJK>
       (?$(L9a(B . "0x24C4F") ; <CJK>
       (?$(L9b(B . "0x24C52") ; <CJK>
       (?$(L9c(B . "0x24C56") ; <CJK>
       (?$(L9d(B . "0x200BD") ; <CJK>
       (?$(L9e(B . "0x24C32") ; <CJK>
       (?$(L9f(B . "0x24D63") ; <CJK>
       (?$(L9g(B . "0x24D6B") ; <CJK>
       (?$(L9h(B . "0x24D66") ; <CJK>
       (?$(L9i(B . "0x24D57") ; <CJK>
       (?$(L9j(B . "0x24D5D") ; <CJK>
       (?$(L9k(B . "0x3F86") ; <CJK>
       (?$(L9l(B . "0x24D6D") ; <CJK>
       (?$(L9m(B . "0x24D61") ; <CJK>
       (?$(L9n(B . "0x24D69") ; <CJK>
       (?$(L9o(B . "0x24D5A") ; <CJK>
       (?$(L9p(B . "0x24D5C") ; <CJK>
       (?$(L9q(B . "0x24D62") ; <CJK>
       (?$(L9r(B . "0x24F2A") ; <CJK>
       (?$(L9s(B . "0x24F29") ; <CJK>
       (?$(L9t(B . "0x24F58") ; <CJK>
       (?$(L9u(B . "0x24F5A") ; <CJK>
       (?$(L9v(B . "0x24FD7") ; <CJK>
       (?$(L9w(B . "0x24FDB") ; <CJK>
       (?$(L9x(B . "0x24FDC") ; <CJK>
       (?$(L9y(B . "0x24FDD") ; <CJK>
       (?$(L9z(B . "0x24FD8") ; <CJK>
       (?$(L9{(B . "0x25054") ; <CJK>
       (?$(L9|(B . "0x2505B") ; <CJK>
       (?$(L9}(B . "0x2505C") ; <CJK>
       (?$(L9~(B . "0x25053") ; <CJK>
       (?$(L:!(B . "0x2504F") ; <CJK>
       (?$(L:"(B . "0x25056") ; <CJK>
       (?$(L:#(B . "0x25050") ; <CJK>
       (?$(L:$(B . "0x2505A") ; <CJK>
       (?$(L:%(B . "0x2506B") ; <CJK>
       (?$(L:&(B . "0x25136") ; <CJK>
       (?$(L:'(B . "0x25153") ; <CJK>
       (?$(L:((B . "0x2513A") ; <CJK>
       (?$(L:)(B . "0x2513C") ; <CJK>
       (?$(L:*(B . "0x2513E") ; <CJK>
       (?$(L:+(B . "0x25149") ; <CJK>
       (?$(L:,(B . "0x25140") ; <CJK>
       (?$(L:-(B . "0x2F946") ; <CJK>
       (?$(L:.(B . "0x2F947") ; <CJK>
       (?$(L:/(B . "0x25364") ; <CJK>
       (?$(L:0(B . "0x25365") ; <CJK>
       (?$(L:1(B . "0x253B5") ; <CJK>
       (?$(L:2(B . "0x253B6") ; <CJK>
       (?$(L:3(B . "0x253B2") ; <CJK>
       (?$(L:4(B . "0x25448") ; <CJK>
       (?$(L:5(B . "0x2544A") ; <CJK>
       (?$(L:6(B . "0x25472") ; <CJK>
       (?$(L:7(B . "0x25469") ; <CJK>
       (?$(L:8(B . "0x2545A") ; <CJK>
       (?$(L:9(B . "0x2544C") ; <CJK>
       (?$(L::(B . "0x2562C") ; <CJK>
       (?$(L:;(B . "0x25630") ; <CJK>
       (?$(L:<(B . "0x2564B") ; <CJK>
       (?$(L:=(B . "0x25649") ; <CJK>
       (?$(L:>(B . "0x25642") ; <CJK>
       (?$(L:?(B . "0x25644") ; <CJK>
       (?$(L:@(B . "0x2564A") ; <CJK>
       (?$(L:A(B . "0x2564F") ; <CJK>
       (?$(L:B(B . "0x25792") ; <CJK>
       (?$(L:C(B . "0x2F957") ; <CJK>
       (?$(L:D(B . "0x25797") ; <CJK>
       (?$(L:E(B . "0x25780") ; <CJK>
       (?$(L:F(B . "0x25782") ; <CJK>
       (?$(L:G(B . "0x25786") ; <CJK>
       (?$(L:H(B . "0x25953") ; <CJK>
       (?$(L:I(B . "0x2595E") ; <CJK>
       (?$(L:J(B . "0x25952") ; <CJK>
       (?$(L:K(B . "0x2595B") ; <CJK>
       (?$(L:L(B . "0x2594E") ; <CJK>
       (?$(L:M(B . "0x25A6D") ; <CJK>
       (?$(L:N(B . "0x25A6E") ; <CJK>
       (?$(L:O(B . "0x25AFA") ; <CJK>
       (?$(L:P(B . "0x25AF6") ; <CJK>
       (?$(L:Q(B . "0x25AFB") ; <CJK>
       (?$(L:R(B . "0x25E33") ; <CJK>
       (?$(L:S(B . "0x25E3D") ; <CJK>
       (?$(L:T(B . "0x25E37") ; <CJK>
       (?$(L:U(B . "0x25E3E") ; <CJK>
       (?$(L:V(B . "0x25E35") ; <CJK>
       (?$(L:W(B . "0x25F9A") ; <CJK>
       (?$(L:X(B . "0x25FAB") ; <CJK>
       (?$(L:Y(B . "0x25FA6") ; <CJK>
       (?$(L:Z(B . "0x25FB0") ; <CJK>
       (?$(L:[(B . "0x25F99") ; <CJK>
       (?$(L:\(B . "0x25FA0") ; <CJK>
       (?$(L:](B . "0x25F9E") ; <CJK>
       (?$(L:^(B . "0x25FA8") ; <CJK>
       (?$(L:_(B . "0x25FA1") ; <CJK>
       (?$(L:`(B . "0x25FAA") ; <CJK>
       (?$(L:a(B . "0x25FAD") ; <CJK>
       (?$(L:b(B . "0x25FBB") ; <CJK>
       (?$(L:c(B . "0x25F9C") ; <CJK>
       (?$(L:d(B . "0x25FA5") ; <CJK>
       (?$(L:e(B . "0x200B3") ; <CJK>
       (?$(L:f(B . "0x26227") ; <CJK>
       (?$(L:g(B . "0x2628D") ; <CJK>
       (?$(L:h(B . "0x2628E") ; <CJK>
       (?$(L:i(B . "0x2628F") ; <CJK>
       (?$(L:j(B . "0x26292") ; <CJK>
       (?$(L:k(B . "0x4356") ; <CJK>
       (?$(L:l(B . "0x26291") ; <CJK>
       (?$(L:m(B . "0x262AD") ; <CJK>
       (?$(L:n(B . "0x26357") ; <CJK>
       (?$(L:o(B . "0x26358") ; <CJK>
       (?$(L:p(B . "0x2635E") ; <CJK>
       (?$(L:q(B . "0x2635D") ; <CJK>
       (?$(L:r(B . "0x2635C") ; <CJK>
       (?$(L:s(B . "0x2635B") ; <CJK>
       (?$(L:t(B . "0x4367") ; <CJK>
       (?$(L:u(B . "0x2640A") ; <CJK>
       (?$(L:v(B . "0x26403") ; <CJK>
       (?$(L:w(B . "0x2640E") ; <CJK>
       (?$(L:x(B . "0x264B8") ; <CJK>
       (?$(L:y(B . "0x2654D") ; <CJK>
       (?$(L:z(B . "0x2653F") ; <CJK>
       (?$(L:{(B . "0x26547") ; <CJK>
       (?$(L:|(B . "0x2654B") ; <CJK>
       (?$(L:}(B . "0x2654A") ; <CJK>
       (?$(L:~(B . "0x2653D") ; <CJK>
       (?$(L;!(B . "0x8038") ; <CJK>
       (?$(L;"(B . "0x26541") ; <CJK>
       (?$(L;#(B . "0x2654C") ; <CJK>
       (?$(L;$(B . "0x8081") ; <CJK>
       (?$(L;%(B . "0x26662") ; <CJK>
       (?$(L;&(B . "0x26669") ; <CJK>
       (?$(L;'(B . "0x26661") ; <CJK>
       (?$(L;((B . "0x43D1") ; <CJK>
       (?$(L;)(B . "0x266AA") ; <CJK>
       (?$(L;*(B . "0x266A6") ; <CJK>
       (?$(L;+(B . "0x266AC") ; <CJK>
       (?$(L;,(B . "0x266BD") ; <CJK>
       (?$(L;-(B . "0x266BB") ; <CJK>
       (?$(L;.(B . "0x266A4") ; <CJK>
       (?$(L;/(B . "0x266BA") ; <CJK>
       (?$(L;0(B . "0x2669A") ; <CJK>
       (?$(L;1(B . "0x43EB") ; <CJK>
       (?$(L;2(B . "0x266A1") ; <CJK>
       (?$(L;3(B . "0x266C1") ; <CJK>
       (?$(L;4(B . "0x268E0") ; <CJK>
       (?$(L;5(B . "0x2690A") ; <CJK>
       (?$(L;6(B . "0x26903") ; <CJK>
       (?$(L;7(B . "0x26906") ; <CJK>
       (?$(L;8(B . "0x26939") ; <CJK>
       (?$(L;9(B . "0x2693A") ; <CJK>
       (?$(L;:(B . "0x26936") ; <CJK>
       (?$(L;;(B . "0x2695B") ; <CJK>
       (?$(L;<(B . "0x2695F") ; <CJK>
       (?$(L;=(B . "0x2695E") ; <CJK>
       (?$(L;>(B . "0x26967") ; <CJK>
       (?$(L;?(B . "0x26961") ; <CJK>
       (?$(L;@(B . "0x26962") ; <CJK>
       (?$(L;A(B . "0x2695D") ; <CJK>
       (?$(L;B(B . "0x269CA") ; <CJK>
       (?$(L;C(B . "0x269CC") ; <CJK>
       (?$(L;D(B . "0x269CE") ; <CJK>
       (?$(L;E(B . "0x26A18") ; <CJK>
       (?$(L;F(B . "0x26A1D") ; <CJK>
       (?$(L;G(B . "0x26A1F") ; <CJK>
       (?$(L;H(B . "0x26A20") ; <CJK>
       (?$(L;I(B . "0x26A17") ; <CJK>
       (?$(L;J(B . "0x26A15") ; <CJK>
       (?$(L;K(B . "0x26B1F") ; <CJK>
       (?$(L;L(B . "0x26B27") ; <CJK>
       (?$(L;M(B . "0x26B26") ; <CJK>
       (?$(L;N(B . "0x21E10") ; <CJK>
       (?$(L;O(B . "0x26B8B") ; <CJK>
       (?$(L;P(B . "0x26BAE") ; <CJK>
       (?$(L;Q(B . "0x26B8A") ; <CJK>
       (?$(L;R(B . "0x2F999") ; <CJK>
       (?$(L;S(B . "0x26B92") ; <CJK>
       (?$(L;T(B . "0x26B89") ; <CJK>
       (?$(L;U(B . "0x26B87") ; <CJK>
       (?$(L;V(B . "0x44B6") ; <CJK>
       (?$(L;W(B . "0x26B8F") ; <CJK>
       (?$(L;X(B . "0x26B84") ; <CJK>
       (?$(L;Y(B . "0x26B83") ; <CJK>
       (?$(L;Z(B . "0x26B8C") ; <CJK>
       (?$(L;[(B . "0x26B93") ; <CJK>
       (?$(L;\(B . "0x26B8D") ; <CJK>
       (?$(L;](B . "0x26B98") ; <CJK>
       (?$(L;^(B . "0x26B7D") ; <CJK>
       (?$(L;_(B . "0x26B7E") ; <CJK>
       (?$(L;`(B . "0x26BD2") ; <CJK>
       (?$(L;a(B . "0x26B80") ; <CJK>
       (?$(L;b(B . "0x26B99") ; <CJK>
       (?$(L;c(B . "0x271AC") ; <CJK>
       (?$(L;d(B . "0x27250") ; <CJK>
       (?$(L;e(B . "0x27255") ; <CJK>
       (?$(L;f(B . "0x27242") ; <CJK>
       (?$(L;g(B . "0x2723F") ; <CJK>
       (?$(L;h(B . "0x2723C") ; <CJK>
       (?$(L;i(B . "0x45A3") ; <CJK>
       (?$(L;j(B . "0x2724C") ; <CJK>
       (?$(L;k(B . "0x27249") ; <CJK>
       (?$(L;l(B . "0x27257") ; <CJK>
       (?$(L;m(B . "0x27258") ; <CJK>
       (?$(L;n(B . "0x2724F") ; <CJK>
       (?$(L;o(B . "0x2725C") ; <CJK>
       (?$(L;p(B . "0x27247") ; <CJK>
       (?$(L;q(B . "0x2F9B7") ; <CJK>
       (?$(L;r(B . "0x275AB") ; <CJK>
       (?$(L;s(B . "0x4610") ; <CJK>
       (?$(L;t(B . "0x275AF") ; <CJK>
       (?$(L;u(B . "0x275AD") ; <CJK>
       (?$(L;v(B . "0x275E8") ; <CJK>
       (?$(L;w(B . "0x275E7") ; <CJK>
       (?$(L;x(B . "0x27630") ; <CJK>
       (?$(L;y(B . "0x27626") ; <CJK>
       (?$(L;z(B . "0x2762F") ; <CJK>
       (?$(L;{(B . "0x27628") ; <CJK>
       (?$(L;|(B . "0x2762B") ; <CJK>
       (?$(L;}(B . "0x2761D") ; <CJK>
       (?$(L;~(B . "0x2762D") ; <CJK>
       (?$(L<!(B . "0x27620") ; <CJK>
       (?$(L<"(B . "0x2762A") ; <CJK>
       (?$(L<#(B . "0x2762C") ; <CJK>
       (?$(L<$(B . "0x27635") ; <CJK>
       (?$(L<%(B . "0x27621") ; <CJK>
       (?$(L<&(B . "0x27623") ; <CJK>
       (?$(L<'(B . "0x27624") ; <CJK>
       (?$(L<((B . "0x27636") ; <CJK>
       (?$(L<)(B . "0x27637") ; <CJK>
       (?$(L<*(B . "0x277E9") ; <CJK>
       (?$(L<+(B . "0x278BA") ; <CJK>
       (?$(L<,(B . "0x278B8") ; <CJK>
       (?$(L<-(B . "0x2F9CC") ; <CJK>
       (?$(L<.(B . "0x2796D") ; <CJK>
       (?$(L</(B . "0x2796A") ; <CJK>
       (?$(L<0(B . "0x27968") ; <CJK>
       (?$(L<1(B . "0x27969") ; <CJK>
       (?$(L<2(B . "0x2796B") ; <CJK>
       (?$(L<3(B . "0x27961") ; <CJK>
       (?$(L<4(B . "0x27BDC") ; <CJK>
       (?$(L<5(B . "0x27BDB") ; <CJK>
       (?$(L<6(B . "0x27C2D") ; <CJK>
       (?$(L<7(B . "0x27C2C") ; <CJK>
       (?$(L<8(B . "0x27CA2") ; <CJK>
       (?$(L<9(B . "0x27D2B") ; <CJK>
       (?$(L<:(B . "0x27D32") ; <CJK>
       (?$(L<;(B . "0x2F9D7") ; <CJK>
       (?$(L<<(B . "0x27E94") ; <CJK>
       (?$(L<=(B . "0x27E92") ; <CJK>
       (?$(L<>(B . "0x27E90") ; <CJK>
       (?$(L<?(B . "0x27FC9") ; <CJK>
       (?$(L<@(B . "0x27FC4") ; <CJK>
       (?$(L<A(B . "0x27FC1") ; <CJK>
       (?$(L<B(B . "0x27FC3") ; <CJK>
       (?$(L<C(B . "0x27FCD") ; <CJK>
       (?$(L<D(B . "0x28214") ; <CJK>
       (?$(L<E(B . "0x282A7") ; <CJK>
       (?$(L<F(B . "0x282AF") ; <CJK>
       (?$(L<G(B . "0x282AA") ; <CJK>
       (?$(L<H(B . "0x2840D") ; <CJK>
       (?$(L<I(B . "0x28454") ; <CJK>
       (?$(L<J(B . "0x2845B") ; <CJK>
       (?$(L<K(B . "0x28461") ; <CJK>
       (?$(L<L(B . "0x284AE") ; <CJK>
       (?$(L<M(B . "0x284B3") ; <CJK>
       (?$(L<N(B . "0x284C0") ; <CJK>
       (?$(L<O(B . "0x284C4") ; <CJK>
       (?$(L<P(B . "0x284BF") ; <CJK>
       (?$(L<Q(B . "0x284CB") ; <CJK>
       (?$(L<R(B . "0x284AD") ; <CJK>
       (?$(L<S(B . "0x284A7") ; <CJK>
       (?$(L<T(B . "0x284A4") ; <CJK>
       (?$(L<U(B . "0x284BD") ; <CJK>
       (?$(L<V(B . "0x284AF") ; <CJK>
       (?$(L<W(B . "0x284B2") ; <CJK>
       (?$(L<X(B . "0x284A5") ; <CJK>
       (?$(L<Y(B . "0x286E7") ; <CJK>
       (?$(L<Z(B . "0x286E0") ; <CJK>
       (?$(L<[(B . "0x286CE") ; <CJK>
       (?$(L<\(B . "0x286DE") ; <CJK>
       (?$(L<](B . "0x286D5") ; <CJK>
       (?$(L<^(B . "0x286DF") ; <CJK>
       (?$(L<_(B . "0x286D9") ; <CJK>
       (?$(L<`(B . "0x287F2") ; <CJK>
       (?$(L<a(B . "0x28923") ; <CJK>
       (?$(L<b(B . "0x28940") ; <CJK>
       (?$(L<c(B . "0x491B") ; <CJK>
       (?$(L<d(B . "0x2893E") ; <CJK>
       (?$(L<e(B . "0x4987") ; <CJK>
       (?$(L<f(B . "0x28CCF") ; <CJK>
       (?$(L<g(B . "0x20B54") ; <CJK>
       (?$(L<h(B . "0x28E5B") ; <CJK>
       (?$(L<i(B . "0x28E58") ; <CJK>
       (?$(L<j(B . "0x28E62") ; <CJK>
       (?$(L<k(B . "0x28E5F") ; <CJK>
       (?$(L<l(B . "0x28E67") ; <CJK>
       (?$(L<m(B . "0x28E63") ; <CJK>
       (?$(L<n(B . "0x28E5E") ; <CJK>
       (?$(L<o(B . "0x28E60") ; <CJK>
       (?$(L<p(B . "0x28F85") ; <CJK>
       (?$(L<q(B . "0x28F86") ; <CJK>
       (?$(L<r(B . "0x28F87") ; <CJK>
       (?$(L<s(B . "0x291E8") ; <CJK>
       (?$(L<t(B . "0x291E6") ; <CJK>
       (?$(L<u(B . "0x29671") ; <CJK>
       (?$(L<v(B . "0x29685") ; <CJK>
       (?$(L<w(B . "0x2FA02") ; <CJK>
       (?$(L<x(B . "0x29686") ; <CJK>
       (?$(L<y(B . "0x29810") ; <CJK>
       (?$(L<z(B . "0x209F8") ; <CJK>
       (?$(L<{(B . "0x200BF") ; <CJK>
       (?$(L<|(B . "0x20B61") ; <CJK>
       (?$(L<}(B . "0x200FE") ; <CJK>
       (?$(L<~(B . "0x200FC") ; <CJK>
       (?$(L=!(B . "0x20139") ; <CJK>
       (?$(L="(B . "0x20161") ; <CJK>
       (?$(L=#(B . "0x20160") ; <CJK>
       (?$(L=$(B . "0x202E2") ; <CJK>
       (?$(L=%(B . "0x202EA") ; <CJK>
       (?$(L=&(B . "0x202E3") ; <CJK>
       (?$(L='(B . "0x202B4") ; <CJK>
       (?$(L=((B . "0x202AE") ; <CJK>
       (?$(L=)(B . "0x202BE") ; <CJK>
       (?$(L=*(B . "0x202B8") ; <CJK>
       (?$(L=+(B . "0x202A8") ; <CJK>
       (?$(L=,(B . "0x202AA") ; <CJK>
       (?$(L=-(B . "0x202A9") ; <CJK>
       (?$(L=.(B . "0x202B3") ; <CJK>
       (?$(L=/(B . "0x202D5") ; <CJK>
       (?$(L=0(B . "0x202AD") ; <CJK>
       (?$(L=1(B . "0x202B9") ; <CJK>
       (?$(L=2(B . "0x202BB") ; <CJK>
       (?$(L=3(B . "0x202B1") ; <CJK>
       (?$(L=4(B . "0x202C2") ; <CJK>
       (?$(L=5(B . "0x2F808") ; <CJK>
       (?$(L=6(B . "0x202EB") ; <CJK>
       (?$(L=7(B . "0x202BA") ; <CJK>
       (?$(L=8(B . "0x202D2") ; <CJK>
       (?$(L=9(B . "0x202D4") ; <CJK>
       (?$(L=:(B . "0x204F1") ; <CJK>
       (?$(L=;(B . "0x2051D") ; <CJK>
       (?$(L=<(B . "0x2F812") ; <CJK>
       (?$(L==(B . "0x20562") ; <CJK>
       (?$(L=>(B . "0x2058C") ; <CJK>
       (?$(L=?(B . "0x205E6") ; <CJK>
       (?$(L=@(B . "0x205E7") ; <CJK>
       (?$(L=A(B . "0x2065A") ; <CJK>
       (?$(L=B(B . "0x20658") ; <CJK>
       (?$(L=C(B . "0x20659") ; <CJK>
       (?$(L=D(B . "0x20696") ; <CJK>
       (?$(L=E(B . "0x20697") ; <CJK>
       (?$(L=F(B . "0x20761") ; <CJK>
       (?$(L=G(B . "0x20767") ; <CJK>
       (?$(L=H(B . "0x20771") ; <CJK>
       (?$(L=I(B . "0x20765") ; <CJK>
       (?$(L=J(B . "0x2077D") ; <CJK>
       (?$(L=K(B . "0x2077E") ; <CJK>
       (?$(L=L(B . "0x2087D") ; <CJK>
       (?$(L=M(B . "0x20884") ; <CJK>
       (?$(L=N(B . "0x2087C") ; <CJK>
       (?$(L=O(B . "0x2087E") ; <CJK>
       (?$(L=P(B . "0x2087F") ; <CJK>
       (?$(L=Q(B . "0x20880") ; <CJK>
       (?$(L=R(B . "0x208EF") ; <CJK>
       (?$(L=S(B . "0x208F4") ; <CJK>
       (?$(L=T(B . "0x2091E") ; <CJK>
       (?$(L=U(B . "0x2094E") ; <CJK>
       (?$(L=V(B . "0x209FB") ; <CJK>
       (?$(L=W(B . "0x209FA") ; <CJK>
       (?$(L=X(B . "0x209FD") ; <CJK>
       (?$(L=Y(B . "0x2F831") ; <CJK>
       (?$(L=Z(B . "0x2F832") ; <CJK>
       (?$(L=[(B . "0x20A79") ; <CJK>
       (?$(L=\(B . "0x20A7C") ; <CJK>
       (?$(L=](B . "0x20A7D") ; <CJK>
       (?$(L=^(B . "0x20A84") ; <CJK>
       (?$(L=_(B . "0x20A7B") ; <CJK>
       (?$(L=`(B . "0x20A78") ; <CJK>
       (?$(L=a(B . "0x3557") ; <CJK>
       (?$(L=b(B . "0x20B5E") ; <CJK>
       (?$(L=c(B . "0x20B5A") ; <CJK>
       (?$(L=d(B . "0x20B5C") ; <CJK>
       (?$(L=e(B . "0x20B59") ; <CJK>
       (?$(L=f(B . "0x20B55") ; <CJK>
       (?$(L=g(B . "0x20B63") ; <CJK>
       (?$(L=h(B . "0x20B56") ; <CJK>
       (?$(L=i(B . "0x20B5F") ; <CJK>
       (?$(L=j(B . "0x20B60") ; <CJK>
       (?$(L=k(B . "0x20B5B") ; <CJK>
       (?$(L=l(B . "0x20D4A") ; <CJK>
       (?$(L=m(B . "0x20D65") ; <CJK>
       (?$(L=n(B . "0x20DB3") ; <CJK>
       (?$(L=o(B . "0x20D2C") ; <CJK>
       (?$(L=p(B . "0x20D77") ; <CJK>
       (?$(L=q(B . "0x20D3D") ; <CJK>
       (?$(L=r(B . "0x20D52") ; <CJK>
       (?$(L=s(B . "0x20D61") ; <CJK>
       (?$(L=t(B . "0x20D2A") ; <CJK>
       (?$(L=u(B . "0x20D3E") ; <CJK>
       (?$(L=v(B . "0x20D34") ; <CJK>
       (?$(L=w(B . "0x20D29") ; <CJK>
       (?$(L=x(B . "0x20DB2") ; <CJK>
       (?$(L=y(B . "0x20DAD") ; <CJK>
       (?$(L=z(B . "0x20D40") ; <CJK>
       (?$(L={(B . "0x20D53") ; <CJK>
       (?$(L=|(B . "0x2F844") ; <CJK>
       (?$(L=}(B . "0x20D3F") ; <CJK>
       (?$(L=~(B . "0x20D41") ; <CJK>
       (?$(L>!(B . "0x20D72") ; <CJK>
       (?$(L>"(B . "0x211F6") ; <CJK>
       (?$(L>#(B . "0x211F5") ; <CJK>
       (?$(L>$(B . "0x211F4") ; <CJK>
       (?$(L>%(B . "0x211F2") ; <CJK>
       (?$(L>&(B . "0x211F9") ; <CJK>
       (?$(L>'(B . "0x21327") ; <CJK>
       (?$(L>((B . "0x21354") ; <CJK>
       (?$(L>)(B . "0x21355") ; <CJK>
       (?$(L>*(B . "0x2132E") ; <CJK>
       (?$(L>+(B . "0x2F854") ; <CJK>
       (?$(L>,(B . "0x2F853") ; <CJK>
       (?$(L>-(B . "0x2132C") ; <CJK>
       (?$(L>.(B . "0x21338") ; <CJK>
       (?$(L>/(B . "0x21339") ; <CJK>
       (?$(L>0(B . "0x21331") ; <CJK>
       (?$(L>1(B . "0x2134F") ; <CJK>
       (?$(L>2(B . "0x21373") ; <CJK>
       (?$(L>3(B . "0x21330") ; <CJK>
       (?$(L>4(B . "0x2132B") ; <CJK>
       (?$(L>5(B . "0x21351") ; <CJK>
       (?$(L>6(B . "0x2152C") ; <CJK>
       (?$(L>7(B . "0x2155B") ; <CJK>
       (?$(L>8(B . "0x2155C") ; <CJK>
       (?$(L>9(B . "0x21568") ; <CJK>
       (?$(L>:(B . "0x2156C") ; <CJK>
       (?$(L>;(B . "0x2156B") ; <CJK>
       (?$(L><(B . "0x21569") ; <CJK>
       (?$(L>=(B . "0x2159F") ; <CJK>
       (?$(L>>(B . "0x21638") ; <CJK>
       (?$(L>?(B . "0x2163C") ; <CJK>
       (?$(L>@(B . "0x2163A") ; <CJK>
       (?$(L>A(B . "0x21635") ; <CJK>
       (?$(L>B(B . "0x369D") ; <CJK>
       (?$(L>C(B . "0x21639") ; <CJK>
       (?$(L>D(B . "0x21636") ; <CJK>
       (?$(L>E(B . "0x2163B") ; <CJK>
       (?$(L>F(B . "0x21760") ; <CJK>
       (?$(L>G(B . "0x21761") ; <CJK>
       (?$(L>H(B . "0x21763") ; <CJK>
       (?$(L>I(B . "0x21764") ; <CJK>
       (?$(L>J(B . "0x21794") ; <CJK>
       (?$(L>K(B . "0x21793") ; <CJK>
       (?$(L>L(B . "0x2175E") ; <CJK>
       (?$(L>M(B . "0x21768") ; <CJK>
       (?$(L>N(B . "0x2176A") ; <CJK>
       (?$(L>O(B . "0x21765") ; <CJK>
       (?$(L>P(B . "0x2F866") ; <CJK>
       (?$(L>Q(B . "0x21790") ; <CJK>
       (?$(L>R(B . "0x2175F") ; <CJK>
       (?$(L>S(B . "0x21772") ; <CJK>
       (?$(L>T(B . "0x2F865") ; <CJK>
       (?$(L>U(B . "0x21A3C") ; <CJK>
       (?$(L>V(B . "0x21A27") ; <CJK>
       (?$(L>W(B . "0x21A24") ; <CJK>
       (?$(L>X(B . "0x21A26") ; <CJK>
       (?$(L>Y(B . "0x21A25") ; <CJK>
       (?$(L>Z(B . "0x375F") ; <CJK>
       (?$(L>[(B . "0x21A28") ; <CJK>
       (?$(L>\(B . "0x21A36") ; <CJK>
       (?$(L>](B . "0x21B31") ; <CJK>
       (?$(L>^(B . "0x21B30") ; <CJK>
       (?$(L>_(B . "0x21B34") ; <CJK>
       (?$(L>`(B . "0x21B81") ; <CJK>
       (?$(L>a(B . "0x21B7D") ; <CJK>
       (?$(L>b(B . "0x21B82") ; <CJK>
       (?$(L>c(B . "0x21B80") ; <CJK>
       (?$(L>d(B . "0x3779") ; <CJK>
       (?$(L>e(B . "0x202D3") ; <CJK>
       (?$(L>f(B . "0x21BF2") ; <CJK>
       (?$(L>g(B . "0x21C66") ; <CJK>
       (?$(L>h(B . "0x21C8C") ; <CJK>
       (?$(L>i(B . "0x21C7B") ; <CJK>
       (?$(L>j(B . "0x21C83") ; <CJK>
       (?$(L>k(B . "0x3798") ; <CJK>
       (?$(L>l(B . "0x21C8E") ; <CJK>
       (?$(L>m(B . "0x21C7A") ; <CJK>
       (?$(L>n(B . "0x21C92") ; <CJK>
       (?$(L>o(B . "0x21C91") ; <CJK>
       (?$(L>p(B . "0x21C82") ; <CJK>
       (?$(L>q(B . "0x21D1B") ; <CJK>
       (?$(L>r(B . "0x21D1C") ; <CJK>
       (?$(L>s(B . "0x21E27") ; <CJK>
       (?$(L>t(B . "0x21E21") ; <CJK>
       (?$(L>u(B . "0x37DC") ; <CJK>
       (?$(L>v(B . "0x5D2B") ; <CJK>
       (?$(L>w(B . "0x21E43") ; <CJK>
       (?$(L>x(B . "0x37DF") ; <CJK>
       (?$(L>y(B . "0x21E18") ; <CJK>
       (?$(L>z(B . "0x21E7B") ; <CJK>
       (?$(L>{(B . "0x21E1A") ; <CJK>
       (?$(L>|(B . "0x21E4B") ; <CJK>
       (?$(L>}(B . "0x21E4A") ; <CJK>
       (?$(L>~(B . "0x21E4D") ; <CJK>
       (?$(L?!(B . "0x21E4F") ; <CJK>
       (?$(L?"(B . "0x21E19") ; <CJK>
       (?$(L?#(B . "0x21E35") ; <CJK>
       (?$(L?$(B . "0x21E13") ; <CJK>
       (?$(L?%(B . "0x21E52") ; <CJK>
       (?$(L?&(B . "0x21E14") ; <CJK>
       (?$(L?'(B . "0x21E1E") ; <CJK>
       (?$(L?((B . "0x21E2C") ; <CJK>
       (?$(L?)(B . "0x21E20") ; <CJK>
       (?$(L?*(B . "0x21E22") ; <CJK>
       (?$(L?+(B . "0x21E12") ; <CJK>
       (?$(L?,(B . "0x21E1F") ; <CJK>
       (?$(L?-(B . "0x22000") ; <CJK>
       (?$(L?.(B . "0x22023") ; <CJK>
       (?$(L?/(B . "0x22040") ; <CJK>
       (?$(L?0(B . "0x22043") ; <CJK>
       (?$(L?1(B . "0x220E4") ; <CJK>
       (?$(L?2(B . "0x220DB") ; <CJK>
       (?$(L?3(B . "0x220EA") ; <CJK>
       (?$(L?4(B . "0x220DD") ; <CJK>
       (?$(L?5(B . "0x220CC") ; <CJK>
       (?$(L?6(B . "0x220D9") ; <CJK>
       (?$(L?7(B . "0x220E8") ; <CJK>
       (?$(L?8(B . "0x220F6") ; <CJK>
       (?$(L?9(B . "0x220E3") ; <CJK>
       (?$(L?:(B . "0x220D3") ; <CJK>
       (?$(L?;(B . "0x220DA") ; <CJK>
       (?$(L?<(B . "0x220D6") ; <CJK>
       (?$(L?=(B . "0x220E7") ; <CJK>
       (?$(L?>(B . "0x2223A") ; <CJK>
       (?$(L??(B . "0x2223F") ; <CJK>
       (?$(L?@(B . "0x22240") ; <CJK>
       (?$(L?A(B . "0x22248") ; <CJK>
       (?$(L?B(B . "0x22259") ; <CJK>
       (?$(L?C(B . "0x22237") ; <CJK>
       (?$(L?D(B . "0x22244") ; <CJK>
       (?$(L?E(B . "0x2F88C") ; <CJK>
       (?$(L?F(B . "0x2F88B") ; <CJK>
       (?$(L?G(B . "0x22255") ; <CJK>
       (?$(L?H(B . "0x22239") ; <CJK>
       (?$(L?I(B . "0x22354") ; <CJK>
       (?$(L?J(B . "0x22355") ; <CJK>
       (?$(L?K(B . "0x22356") ; <CJK>
       (?$(L?L(B . "0x22357") ; <CJK>
       (?$(L?M(B . "0x22358") ; <CJK>
       (?$(L?N(B . "0x22359") ; <CJK>
       (?$(L?O(B . "0x2238D") ; <CJK>
       (?$(L?P(B . "0x223F2") ; <CJK>
       (?$(L?Q(B . "0x223F8") ; <CJK>
       (?$(L?R(B . "0x223F5") ; <CJK>
       (?$(L?S(B . "0x223F6") ; <CJK>
       (?$(L?T(B . "0x223FC") ; <CJK>
       (?$(L?U(B . "0x223FE") ; <CJK>
       (?$(L?V(B . "0x223F1") ; <CJK>
       (?$(L?W(B . "0x223FD") ; <CJK>
       (?$(L?X(B . "0x2245E") ; <CJK>
       (?$(L?Y(B . "0x22496") ; <CJK>
       (?$(L?Z(B . "0x22497") ; <CJK>
       (?$(L?[(B . "0x2249C") ; <CJK>
       (?$(L?\(B . "0x2249B") ; <CJK>
       (?$(L?](B . "0x22495") ; <CJK>
       (?$(L?^(B . "0x2F89A") ; <CJK>
       (?$(L?_(B . "0x2251A") ; <CJK>
       (?$(L?`(B . "0x22509") ; <CJK>
       (?$(L?a(B . "0x22504") ; <CJK>
       (?$(L?b(B . "0x2250E") ; <CJK>
       (?$(L?c(B . "0x2251C") ; <CJK>
       (?$(L?d(B . "0x22518") ; <CJK>
       (?$(L?e(B . "0x2250D") ; <CJK>
       (?$(L?f(B . "0x22510") ; <CJK>
       (?$(L?g(B . "0x2250C") ; <CJK>
       (?$(L?h(B . "0x22503") ; <CJK>
       (?$(L?i(B . "0x2267B") ; <CJK>
       (?$(L?j(B . "0x226A6") ; <CJK>
       (?$(L?k(B . "0x22677") ; <CJK>
       (?$(L?l(B . "0x22688") ; <CJK>
       (?$(L?m(B . "0x22674") ; <CJK>
       (?$(L?n(B . "0x226DA") ; <CJK>
       (?$(L?o(B . "0x22676") ; <CJK>
       (?$(L?p(B . "0x22678") ; <CJK>
       (?$(L?q(B . "0x2268A") ; <CJK>
       (?$(L?r(B . "0x2268F") ; <CJK>
       (?$(L?s(B . "0x2267D") ; <CJK>
       (?$(L?t(B . "0x22690") ; <CJK>
       (?$(L?u(B . "0x226ED") ; <CJK>
       (?$(L?v(B . "0x226D9") ; <CJK>
       (?$(L?w(B . "0x226D0") ; <CJK>
       (?$(L?x(B . "0x2271A") ; <CJK>
       (?$(L?y(B . "0x226D7") ; <CJK>
       (?$(L?z(B . "0x226E2") ; <CJK>
       (?$(L?{(B . "0x226E1") ; <CJK>
       (?$(L?|(B . "0x226C5") ; <CJK>
       (?$(L?}(B . "0x226E0") ; <CJK>
       (?$(L?~(B . "0x226CA") ; <CJK>
       (?$(L@!(B . "0x22725") ; <CJK>
       (?$(L@"(B . "0x226CC") ; <CJK>
       (?$(L@#(B . "0x2F8B3") ; <CJK>
       (?$(L@$(B . "0x229C6") ; <CJK>
       (?$(L@%(B . "0x229C1") ; <CJK>
       (?$(L@&(B . "0x22A4D") ; <CJK>
       (?$(L@'(B . "0x22B4B") ; <CJK>
       (?$(L@((B . "0x22B64") ; <CJK>
       (?$(L@)(B . "0x22B95") ; <CJK>
       (?$(L@*(B . "0x22B99") ; <CJK>
       (?$(L@+(B . "0x2F8BC") ; <CJK>
       (?$(L@,(B . "0x22B94") ; <CJK>
       (?$(L@-(B . "0x22BA2") ; <CJK>
       (?$(L@.(B . "0x22BAE") ; <CJK>
       (?$(L@/(B . "0x22B9E") ; <CJK>
       (?$(L@0(B . "0x22BA7") ; <CJK>
       (?$(L@1(B . "0x22B86") ; <CJK>
       (?$(L@2(B . "0x39FD") ; <CJK>
       (?$(L@3(B . "0x22BA4") ; <CJK>
       (?$(L@4(B . "0x22B91") ; <CJK>
       (?$(L@5(B . "0x22B93") ; <CJK>
       (?$(L@6(B . "0x2F8BB") ; <CJK>
       (?$(L@7(B . "0x22B88") ; <CJK>
       (?$(L@8(B . "0x22ECD") ; <CJK>
       (?$(L@9(B . "0x22ECA") ; <CJK>
       (?$(L@:(B . "0x22F3F") ; <CJK>
       (?$(L@;(B . "0x22F40") ; <CJK>
       (?$(L@<(B . "0x22F46") ; <CJK>
       (?$(L@=(B . "0x22F41") ; <CJK>
       (?$(L@>(B . "0x22F45") ; <CJK>
       (?$(L@?(B . "0x22F58") ; <CJK>
       (?$(L@@(B . "0x22F3B") ; <CJK>
       (?$(L@A(B . "0x22F48") ; <CJK>
       (?$(L@B(B . "0x2304E") ; <CJK>
       (?$(L@C(B . "0x23052") ; <CJK>
       (?$(L@D(B . "0x2304F") ; <CJK>
       (?$(L@E(B . "0x2307B") ; <CJK>
       (?$(L@F(B . "0x2307A") ; <CJK>
       (?$(L@G(B . "0x230A0") ; <CJK>
       (?$(L@H(B . "0x2309F") ; <CJK>
       (?$(L@I(B . "0x230FB") ; <CJK>
       (?$(L@J(B . "0x230F7") ; <CJK>
       (?$(L@K(B . "0x231B8") ; <CJK>
       (?$(L@L(B . "0x231B9") ; <CJK>
       (?$(L@M(B . "0x231BB") ; <CJK>
       (?$(L@N(B . "0x231B7") ; <CJK>
       (?$(L@O(B . "0x3AF4") ; <CJK>
       (?$(L@P(B . "0x231BA") ; <CJK>
       (?$(L@Q(B . "0x3AEF") ; <CJK>
       (?$(L@R(B . "0x231DA") ; <CJK>
       (?$(L@S(B . "0x231B5") ; <CJK>
       (?$(L@T(B . "0x231BF") ; <CJK>
       (?$(L@U(B . "0x231BC") ; <CJK>
       (?$(L@V(B . "0x231C0") ; <CJK>
       (?$(L@W(B . "0x2F8D3") ; <CJK>
       (?$(L@X(B . "0x2F8D9") ; <CJK>
       (?$(L@Y(B . "0x23375") ; <CJK>
       (?$(L@Z(B . "0x23379") ; <CJK>
       (?$(L@[(B . "0x23376") ; <CJK>
       (?$(L@\(B . "0x23435") ; <CJK>
       (?$(L@](B . "0x23440") ; <CJK>
       (?$(L@^(B . "0x234C0") ; <CJK>
       (?$(L@_(B . "0x23481") ; <CJK>
       (?$(L@`(B . "0x234AD") ; <CJK>
       (?$(L@a(B . "0x234AF") ; <CJK>
       (?$(L@b(B . "0x234AC") ; <CJK>
       (?$(L@c(B . "0x2348F") ; <CJK>
       (?$(L@d(B . "0x234A8") ; <CJK>
       (?$(L@e(B . "0x234AA") ; <CJK>
       (?$(L@f(B . "0x234A9") ; <CJK>
       (?$(L@g(B . "0x23488") ; <CJK>
       (?$(L@h(B . "0x2347F") ; <CJK>
       (?$(L@i(B . "0x23480") ; <CJK>
       (?$(L@j(B . "0x234BC") ; <CJK>
       (?$(L@k(B . "0x238AE") ; <CJK>
       (?$(L@l(B . "0x238BB") ; <CJK>
       (?$(L@m(B . "0x238BD") ; <CJK>
       (?$(L@n(B . "0x3C31") ; <CJK>
       (?$(L@o(B . "0x23978") ; <CJK>
       (?$(L@p(B . "0x23974") ; <CJK>
       (?$(L@q(B . "0x23A0C") ; <CJK>
       (?$(L@r(B . "0x23A11") ; <CJK>
       (?$(L@s(B . "0x23A08") ; <CJK>
       (?$(L@t(B . "0x23A06") ; <CJK>
       (?$(L@u(B . "0x23A10") ; <CJK>
       (?$(L@v(B . "0x23A8F") ; <CJK>
       (?$(L@w(B . "0x23A90") ; <CJK>
       (?$(L@x(B . "0x23A8D") ; <CJK>
       (?$(L@y(B . "0x23A8E") ; <CJK>
       (?$(L@z(B . "0x23A96") ; <CJK>
       (?$(L@{(B . "0x23A95") ; <CJK>
       (?$(L@|(B . "0x23B0B") ; <CJK>
       (?$(L@}(B . "0x23B0C") ; <CJK>
       (?$(L@~(B . "0x23B7C") ; <CJK>
       (?$(LA!(B . "0x23B73") ; <CJK>
       (?$(LA"(B . "0x23B75") ; <CJK>
       (?$(LA#(B . "0x23B76") ; <CJK>
       (?$(LA$(B . "0x23B7D") ; <CJK>
       (?$(LA%(B . "0x23B78") ; <CJK>
       (?$(LA&(B . "0x23B71") ; <CJK>
       (?$(LA'(B . "0x23C4B") ; <CJK>
       (?$(LA((B . "0x23C4E") ; <CJK>
       (?$(LA)(B . "0x23D33") ; <CJK>
       (?$(LA*(B . "0x23D32") ; <CJK>
       (?$(LA+(B . "0x3D03") ; <CJK>
       (?$(LA,(B . "0x23D91") ; <CJK>
       (?$(LA-(B . "0x23DE7") ; <CJK>
       (?$(LA.(B . "0x23DE9") ; <CJK>
       (?$(LA/(B . "0x23DA2") ; <CJK>
       (?$(LA0(B . "0x23D94") ; <CJK>
       (?$(LA1(B . "0x23D87") ; <CJK>
       (?$(LA2(B . "0x23DA3") ; <CJK>
       (?$(LA3(B . "0x23DDD") ; <CJK>
       (?$(LA4(B . "0x23D7B") ; <CJK>
       (?$(LA5(B . "0x23D83") ; <CJK>
       (?$(LA6(B . "0x23D81") ; <CJK>
       (?$(LA7(B . "0x23DDF") ; <CJK>
       (?$(LA8(B . "0x23D7C") ; <CJK>
       (?$(LA9(B . "0x23DE4") ; <CJK>
       (?$(LA:(B . "0x23DE2") ; <CJK>
       (?$(LA;(B . "0x23D93") ; <CJK>
       (?$(LA<(B . "0x23D7D") ; <CJK>
       (?$(LA=(B . "0x23DBF") ; <CJK>
       (?$(LA>(B . "0x23D9B") ; <CJK>
       (?$(LA?(B . "0x23D8E") ; <CJK>
       (?$(LA@(B . "0x23D9F") ; <CJK>
       (?$(LAA(B . "0x3D09") ; <CJK>
       (?$(LAB(B . "0x23D8C") ; <CJK>
       (?$(LAC(B . "0x23D7F") ; <CJK>
       (?$(LAD(B . "0x23D9C") ; <CJK>
       (?$(LAE(B . "0x23D84") ; <CJK>
       (?$(LAF(B . "0x23D42") ; <CJK>
       (?$(LAG(B . "0x23DE6") ; <CJK>
       (?$(LAH(B . "0x24251") ; <CJK>
       (?$(LAI(B . "0x2424A") ; <CJK>
       (?$(LAJ(B . "0x24264") ; <CJK>
       (?$(LAK(B . "0x24225") ; <CJK>
       (?$(LAL(B . "0x2422F") ; <CJK>
       (?$(LAM(B . "0x2422E") ; <CJK>
       (?$(LAN(B . "0x2422B") ; <CJK>
       (?$(LAO(B . "0x24228") ; <CJK>
       (?$(LAP(B . "0x24232") ; <CJK>
       (?$(LAQ(B . "0x2422D") ; <CJK>
       (?$(LAR(B . "0x24231") ; <CJK>
       (?$(LAS(B . "0x24239") ; <CJK>
       (?$(LAT(B . "0x2422C") ; <CJK>
       (?$(LAU(B . "0x24261") ; <CJK>
       (?$(LAV(B . "0x24511") ; <CJK>
       (?$(LAW(B . "0x24510") ; <CJK>
       (?$(LAX(B . "0x24512") ; <CJK>
       (?$(LAY(B . "0x24553") ; <CJK>
       (?$(LAZ(B . "0x24555") ; <CJK>
       (?$(LA[(B . "0x2457B") ; <CJK>
       (?$(LA\(B . "0x24581") ; <CJK>
       (?$(LA](B . "0x2457D") ; <CJK>
       (?$(LA^(B . "0x2457C") ; <CJK>
       (?$(LA_(B . "0x245C2") ; <CJK>
       (?$(LA`(B . "0x245C5") ; <CJK>
       (?$(LAa(B . "0x2F922") ; <CJK>
       (?$(LAb(B . "0x245C4") ; <CJK>
       (?$(LAc(B . "0x2F923") ; <CJK>
       (?$(LAd(B . "0x2466B") ; <CJK>
       (?$(LAe(B . "0x24668") ; <CJK>
       (?$(LAf(B . "0x3E3E") ; <CJK>
       (?$(LAg(B . "0x2465C") ; <CJK>
       (?$(LAh(B . "0x2465D") ; <CJK>
       (?$(LAi(B . "0x2466A") ; <CJK>
       (?$(LAj(B . "0x2F924") ; <CJK>
       (?$(LAk(B . "0x24C76") ; <CJK>
       (?$(LAl(B . "0x24776") ; <CJK>
       (?$(LAm(B . "0x3E77") ; <CJK>
       (?$(LAn(B . "0x247C4") ; <CJK>
       (?$(LAo(B . "0x247CB") ; <CJK>
       (?$(LAp(B . "0x247C8") ; <CJK>
       (?$(LAq(B . "0x247D4") ; <CJK>
       (?$(LAr(B . "0x247D5") ; <CJK>
       (?$(LAs(B . "0x247C9") ; <CJK>
       (?$(LAt(B . "0x247D7") ; <CJK>
       (?$(LAu(B . "0x3E7B") ; <CJK>
       (?$(LAv(B . "0x24978") ; <CJK>
       (?$(LAw(B . "0x2495A") ; <CJK>
       (?$(LAx(B . "0x2495B") ; <CJK>
       (?$(LAy(B . "0x2495C") ; <CJK>
       (?$(LAz(B . "0x24956") ; <CJK>
       (?$(LA{(B . "0x24958") ; <CJK>
       (?$(LA|(B . "0x24971") ; <CJK>
       (?$(LA}(B . "0x269D4") ; <CJK>
       (?$(LA~(B . "0x24B40") ; <CJK>
       (?$(LB!(B . "0x2F933") ; <CJK>
       (?$(LB"(B . "0x24B3F") ; <CJK>
       (?$(LB#(B . "0x24B43") ; <CJK>
       (?$(LB$(B . "0x24B41") ; <CJK>
       (?$(LB%(B . "0x24BE2") ; <CJK>
       (?$(LB&(B . "0x24BE0") ; <CJK>
       (?$(LB'(B . "0x24BE3") ; <CJK>
       (?$(LB((B . "0x24C66") ; <CJK>
       (?$(LB)(B . "0x24C73") ; <CJK>
       (?$(LB*(B . "0x24C6C") ; <CJK>
       (?$(LB+(B . "0x24C71") ; <CJK>
       (?$(LB,(B . "0x24C6A") ; <CJK>
       (?$(LB-(B . "0x24C6D") ; <CJK>
       (?$(LB.(B . "0x24C6E") ; <CJK>
       (?$(LB/(B . "0x24C6B") ; <CJK>
       (?$(LB0(B . "0x24D8C") ; <CJK>
       (?$(LB1(B . "0x24D77") ; <CJK>
       (?$(LB2(B . "0x2F93A") ; <CJK>
       (?$(LB3(B . "0x24D7F") ; <CJK>
       (?$(LB4(B . "0x24D89") ; <CJK>
       (?$(LB5(B . "0x24D7A") ; <CJK>
       (?$(LB6(B . "0x24D85") ; <CJK>
       (?$(LB7(B . "0x24D78") ; <CJK>
       (?$(LB8(B . "0x24D8A") ; <CJK>
       (?$(LB9(B . "0x24D86") ; <CJK>
       (?$(LB:(B . "0x24F2C") ; <CJK>
       (?$(LB;(B . "0x24F67") ; <CJK>
       (?$(LB<(B . "0x24F5B") ; <CJK>
       (?$(LB=(B . "0x24FE5") ; <CJK>
       (?$(LB>(B . "0x24FE1") ; <CJK>
       (?$(LB?(B . "0x25061") ; <CJK>
       (?$(LB@(B . "0x25069") ; <CJK>
       (?$(LBA(B . "0x2506A") ; <CJK>
       (?$(LBB(B . "0x25165") ; <CJK>
       (?$(LBC(B . "0x2516D") ; <CJK>
       (?$(LBD(B . "0x25163") ; <CJK>
       (?$(LBE(B . "0x25186") ; <CJK>
       (?$(LBF(B . "0x2515C") ; <CJK>
       (?$(LBG(B . "0x25162") ; <CJK>
       (?$(LBH(B . "0x2F948") ; <CJK>
       (?$(LBI(B . "0x25179") ; <CJK>
       (?$(LBJ(B . "0x25169") ; <CJK>
       (?$(LBK(B . "0x25170") ; <CJK>
       (?$(LBL(B . "0x25176") ; <CJK>
       (?$(LBM(B . "0x2515D") ; <CJK>
       (?$(LBN(B . "0x25187") ; <CJK>
       (?$(LBO(B . "0x2516E") ; <CJK>
       (?$(LBP(B . "0x25171") ; <CJK>
       (?$(LBQ(B . "0x2517C") ; <CJK>
       (?$(LBR(B . "0x25173") ; <CJK>
       (?$(LBS(B . "0x2515B") ; <CJK>
       (?$(LBT(B . "0x2516B") ; <CJK>
       (?$(LBU(B . "0x253BF") ; <CJK>
       (?$(LBV(B . "0x253C1") ; <CJK>
       (?$(LBW(B . "0x253BD") ; <CJK>
       (?$(LBX(B . "0x253C9") ; <CJK>
       (?$(LBY(B . "0x253BC") ; <CJK>
       (?$(LBZ(B . "0x253C2") ; <CJK>
       (?$(LB[(B . "0x253C0") ; <CJK>
       (?$(LB\(B . "0x25492") ; <CJK>
       (?$(LB](B . "0x254A9") ; <CJK>
       (?$(LB^(B . "0x2548F") ; <CJK>
       (?$(LB_(B . "0x25476") ; <CJK>
       (?$(LB`(B . "0x2547B") ; <CJK>
       (?$(LBa(B . "0x25475") ; <CJK>
       (?$(LBb(B . "0x254A4") ; <CJK>
       (?$(LBc(B . "0x25664") ; <CJK>
       (?$(LBd(B . "0x2573D") ; <CJK>
       (?$(LBe(B . "0x257AF") ; <CJK>
       (?$(LBf(B . "0x413A") ; <CJK>
       (?$(LBg(B . "0x2F958") ; <CJK>
       (?$(LBh(B . "0x2579D") ; <CJK>
       (?$(LBi(B . "0x25799") ; <CJK>
       (?$(LBj(B . "0x257B1") ; <CJK>
       (?$(LBk(B . "0x25963") ; <CJK>
       (?$(LBl(B . "0x25962") ; <CJK>
       (?$(LBm(B . "0x25964") ; <CJK>
       (?$(LBn(B . "0x25969") ; <CJK>
       (?$(LBo(B . "0x41A0") ; <CJK>
       (?$(LBp(B . "0x25A75") ; <CJK>
       (?$(LBq(B . "0x25A73") ; <CJK>
       (?$(LBr(B . "0x25A71") ; <CJK>
       (?$(LBs(B . "0x25A74") ; <CJK>
       (?$(LBt(B . "0x25B0C") ; <CJK>
       (?$(LBu(B . "0x25B16") ; <CJK>
       (?$(LBv(B . "0x41E5") ; <CJK>
       (?$(LBw(B . "0x25B11") ; <CJK>
       (?$(LBx(B . "0x25B1F") ; <CJK>
       (?$(LBy(B . "0x25B1A") ; <CJK>
       (?$(LBz(B . "0x25B0D") ; <CJK>
       (?$(LB{(B . "0x25B1B") ; <CJK>
       (?$(LB|(B . "0x25B13") ; <CJK>
       (?$(LB}(B . "0x25E4E") ; <CJK>
       (?$(LB~(B . "0x25E55") ; <CJK>
       (?$(LC!(B . "0x25E50") ; <CJK>
       (?$(LC"(B . "0x427D") ; <CJK>
       (?$(LC#(B . "0x25FD2") ; <CJK>
       (?$(LC$(B . "0x25FD3") ; <CJK>
       (?$(LC%(B . "0x25FD1") ; <CJK>
       (?$(LC&(B . "0x25FF1") ; <CJK>
       (?$(LC'(B . "0x25FDC") ; <CJK>
       (?$(LC((B . "0x25FC8") ; <CJK>
       (?$(LC)(B . "0x25FCC") ; <CJK>
       (?$(LC*(B . "0x25FD0") ; <CJK>
       (?$(LC+(B . "0x25FCF") ; <CJK>
       (?$(LC,(B . "0x25FDF") ; <CJK>
       (?$(LC-(B . "0x2622B") ; <CJK>
       (?$(LC.(B . "0x2622E") ; <CJK>
       (?$(LC/(B . "0x2622D") ; <CJK>
       (?$(LC0(B . "0x2629D") ; <CJK>
       (?$(LC1(B . "0x2629E") ; <CJK>
       (?$(LC2(B . "0x2629F") ; <CJK>
       (?$(LC3(B . "0x262A9") ; <CJK>
       (?$(LC4(B . "0x262A0") ; <CJK>
       (?$(LC5(B . "0x26298") ; <CJK>
       (?$(LC6(B . "0x262A1") ; <CJK>
       (?$(LC7(B . "0x262AB") ; <CJK>
       (?$(LC8(B . "0x262AF") ; <CJK>
       (?$(LC9(B . "0x2636E") ; <CJK>
       (?$(LC:(B . "0x2635F") ; <CJK>
       (?$(LC;(B . "0x2635A") ; <CJK>
       (?$(LC<(B . "0x436D") ; <CJK>
       (?$(LC=(B . "0x26365") ; <CJK>
       (?$(LC>(B . "0x26368") ; <CJK>
       (?$(LC?(B . "0x26372") ; <CJK>
       (?$(LC@(B . "0x26417") ; <CJK>
       (?$(LCA(B . "0x26416") ; <CJK>
       (?$(LCB(B . "0x26418") ; <CJK>
       (?$(LCC(B . "0x26419") ; <CJK>
       (?$(LCD(B . "0x2641A") ; <CJK>
       (?$(LCE(B . "0x26422") ; <CJK>
       (?$(LCF(B . "0x2641B") ; <CJK>
       (?$(LCG(B . "0x2641C") ; <CJK>
       (?$(LCH(B . "0x264BE") ; <CJK>
       (?$(LCI(B . "0x264EE") ; <CJK>
       (?$(LCJ(B . "0x2655A") ; <CJK>
       (?$(LCK(B . "0x26550") ; <CJK>
       (?$(LCL(B . "0x26558") ; <CJK>
       (?$(LCM(B . "0x26554") ; <CJK>
       (?$(LCN(B . "0x26557") ; <CJK>
       (?$(LCO(B . "0x26556") ; <CJK>
       (?$(LCP(B . "0x26615") ; <CJK>
       (?$(LCQ(B . "0x2669B") ; <CJK>
       (?$(LCR(B . "0x26693") ; <CJK>
       (?$(LCS(B . "0x26692") ; <CJK>
       (?$(LCT(B . "0x26672") ; <CJK>
       (?$(LCU(B . "0x26698") ; <CJK>
       (?$(LCV(B . "0x26699") ; <CJK>
       (?$(LCW(B . "0x266DF") ; <CJK>
       (?$(LCX(B . "0x43F8") ; <CJK>
       (?$(LCY(B . "0x266D5") ; <CJK>
       (?$(LCZ(B . "0x8158") ; <CJK>
       (?$(LC[(B . "0x266D4") ; <CJK>
       (?$(LC\(B . "0x266F3") ; <CJK>
       (?$(LC](B . "0x266F4") ; <CJK>
       (?$(LC^(B . "0x266E7") ; <CJK>
       (?$(LC_(B . "0x266E1") ; <CJK>
       (?$(LC`(B . "0x266E6") ; <CJK>
       (?$(LCa(B . "0x266EB") ; <CJK>
       (?$(LCb(B . "0x266EC") ; <CJK>
       (?$(LCc(B . "0x202DB") ; <CJK>
       (?$(LCd(B . "0x4450") ; <CJK>
       (?$(LCe(B . "0x2690D") ; <CJK>
       (?$(LCf(B . "0x2690C") ; <CJK>
       (?$(LCg(B . "0x21B2F") ; <CJK>
       (?$(LCh(B . "0x26968") ; <CJK>
       (?$(LCi(B . "0x26965") ; <CJK>
       (?$(LCj(B . "0x2696B") ; <CJK>
       (?$(LCk(B . "0x26969") ; <CJK>
       (?$(LCl(B . "0x269D1") ; <CJK>
       (?$(LCm(B . "0x269D3") ; <CJK>
       (?$(LCn(B . "0x26A27") ; <CJK>
       (?$(LCo(B . "0x26A28") ; <CJK>
       (?$(LCp(B . "0x4468") ; <CJK>
       (?$(LCq(B . "0x4467") ; <CJK>
       (?$(LCr(B . "0x26A24") ; <CJK>
       (?$(LCs(B . "0x26AD7") ; <CJK>
       (?$(LCt(B . "0x26BCA") ; <CJK>
       (?$(LCu(B . "0x26BC7") ; <CJK>
       (?$(LCv(B . "0x2F99E") ; <CJK>
       (?$(LCw(B . "0x26BD8") ; <CJK>
       (?$(LCx(B . "0x26BE1") ; <CJK>
       (?$(LCy(B . "0x26BC6") ; <CJK>
       (?$(LCz(B . "0x26BF8") ; <CJK>
       (?$(LC{(B . "0x26BC3") ; <CJK>
       (?$(LC|(B . "0x26BF4") ; <CJK>
       (?$(LC}(B . "0x26C17") ; <CJK>
       (?$(LC~(B . "0x26BEA") ; <CJK>
       (?$(LD!(B . "0x26BCB") ; <CJK>
       (?$(LD"(B . "0x26B86") ; <CJK>
       (?$(LD#(B . "0x26BC4") ; <CJK>
       (?$(LD$(B . "0x26BD9") ; <CJK>
       (?$(LD%(B . "0x26C19") ; <CJK>
       (?$(LD&(B . "0x26BC2") ; <CJK>
       (?$(LD'(B . "0x26BE2") ; <CJK>
       (?$(LD((B . "0x44CF") ; <CJK>
       (?$(LD)(B . "0x26BDE") ; <CJK>
       (?$(LD*(B . "0x26BED") ; <CJK>
       (?$(LD+(B . "0x2F99C") ; <CJK>
       (?$(LD,(B . "0x44CD") ; <CJK>
       (?$(LD-(B . "0x26C1D") ; <CJK>
       (?$(LD.(B . "0x26BDD") ; <CJK>
       (?$(LD/(B . "0x26BDB") ; <CJK>
       (?$(LD0(B . "0x26BE8") ; <CJK>
       (?$(LD1(B . "0x26BE9") ; <CJK>
       (?$(LD2(B . "0x26BBF") ; <CJK>
       (?$(LD3(B . "0x26BE0") ; <CJK>
       (?$(LD4(B . "0x26BD1") ; <CJK>
       (?$(LD5(B . "0x26BDC") ; <CJK>
       (?$(LD6(B . "0x26BCE") ; <CJK>
       (?$(LD7(B . "0x26C1E") ; <CJK>
       (?$(LD8(B . "0x26BCC") ; <CJK>
       (?$(LD9(B . "0x26BF2") ; <CJK>
       (?$(LD:(B . "0x26BF3") ; <CJK>
       (?$(LD;(B . "0x2F99F") ; <CJK>
       (?$(LD<(B . "0x2F9A2") ; <CJK>
       (?$(LD=(B . "0x2F9A3") ; <CJK>
       (?$(LD>(B . "0x2F9A1") ; <CJK>
       (?$(LD?(B . "0x271AB") ; <CJK>
       (?$(LD@(B . "0x271AA") ; <CJK>
       (?$(LDA(B . "0x271A7") ; <CJK>
       (?$(LDB(B . "0x271A9") ; <CJK>
       (?$(LDC(B . "0x27288") ; <CJK>
       (?$(LDD(B . "0x27275") ; <CJK>
       (?$(LDE(B . "0x27260") ; <CJK>
       (?$(LDF(B . "0x2726C") ; <CJK>
       (?$(LDG(B . "0x27273") ; <CJK>
       (?$(LDH(B . "0x45AB") ; <CJK>
       (?$(LDI(B . "0x2726E") ; <CJK>
       (?$(LDJ(B . "0x27274") ; <CJK>
       (?$(LDK(B . "0x27276") ; <CJK>
       (?$(LDL(B . "0x27268") ; <CJK>
       (?$(LDM(B . "0x27277") ; <CJK>
       (?$(LDN(B . "0x27286") ; <CJK>
       (?$(LDO(B . "0x275EA") ; <CJK>
       (?$(LDP(B . "0x27651") ; <CJK>
       (?$(LDQ(B . "0x27650") ; <CJK>
       (?$(LDR(B . "0x27658") ; <CJK>
       (?$(LDS(B . "0x2764D") ; <CJK>
       (?$(LDT(B . "0x2764F") ; <CJK>
       (?$(LDU(B . "0x2764E") ; <CJK>
       (?$(LDV(B . "0x2765C") ; <CJK>
       (?$(LDW(B . "0x27652") ; <CJK>
       (?$(LDX(B . "0x27644") ; <CJK>
       (?$(LDY(B . "0x2764A") ; <CJK>
       (?$(LDZ(B . "0x2764B") ; <CJK>
       (?$(LD[(B . "0x277EA") ; <CJK>
       (?$(LD\(B . "0x27810") ; <CJK>
       (?$(LD](B . "0x27811") ; <CJK>
       (?$(LD^(B . "0x278CD") ; <CJK>
       (?$(LD_(B . "0x278BF") ; <CJK>
       (?$(LD`(B . "0x278C4") ; <CJK>
       (?$(LDa(B . "0x278D0") ; <CJK>
       (?$(LDb(B . "0x278CE") ; <CJK>
       (?$(LDc(B . "0x278C0") ; <CJK>
       (?$(LDd(B . "0x278C2") ; <CJK>
       (?$(LDe(B . "0x278CF") ; <CJK>
       (?$(LDf(B . "0x278C9") ; <CJK>
       (?$(LDg(B . "0x278BB") ; <CJK>
       (?$(LDh(B . "0x27997") ; <CJK>
       (?$(LDi(B . "0x27992") ; <CJK>
       (?$(LDj(B . "0x2796F") ; <CJK>
       (?$(LDk(B . "0x2797E") ; <CJK>
       (?$(LDl(B . "0x2799A") ; <CJK>
       (?$(LDm(B . "0x46C1") ; <CJK>
       (?$(LDn(B . "0x27986") ; <CJK>
       (?$(LDo(B . "0x27973") ; <CJK>
       (?$(LDp(B . "0x8A24") ; <CJK>
       (?$(LDq(B . "0x27977") ; <CJK>
       (?$(LDr(B . "0x2798F") ; <CJK>
       (?$(LDs(B . "0x27970") ; <CJK>
       (?$(LDt(B . "0x27981") ; <CJK>
       (?$(LDu(B . "0x27982") ; <CJK>
       (?$(LDv(B . "0x27999") ; <CJK>
       (?$(LDw(B . "0x2797D") ; <CJK>
       (?$(LDx(B . "0x2797F") ; <CJK>
       (?$(LDy(B . "0x2797B") ; <CJK>
       (?$(LDz(B . "0x27987") ; <CJK>
       (?$(LD{(B . "0x27BB2") ; <CJK>
       (?$(LD|(B . "0x27C2F") ; <CJK>
       (?$(LD}(B . "0x27C34") ; <CJK>
       (?$(LD~(B . "0x27C2E") ; <CJK>
       (?$(LE!(B . "0x27C32") ; <CJK>
       (?$(LE"(B . "0x4747") ; <CJK>
       (?$(LE#(B . "0x27CAA") ; <CJK>
       (?$(LE$(B . "0x4757") ; <CJK>
       (?$(LE%(B . "0x27CA9") ; <CJK>
       (?$(LE&(B . "0x27D38") ; <CJK>
       (?$(LE'(B . "0x27D36") ; <CJK>
       (?$(LE((B . "0x27D37") ; <CJK>
       (?$(LE)(B . "0x27D47") ; <CJK>
       (?$(LE*(B . "0x27D33") ; <CJK>
       (?$(LE+(B . "0x27D39") ; <CJK>
       (?$(LE,(B . "0x27D35") ; <CJK>
       (?$(LE-(B . "0x27D44") ; <CJK>
       (?$(LE.(B . "0x27EA5") ; <CJK>
       (?$(LE/(B . "0x27EA6") ; <CJK>
       (?$(LE0(B . "0x27E9E") ; <CJK>
       (?$(LE1(B . "0x27FE3") ; <CJK>
       (?$(LE2(B . "0x27FDF") ; <CJK>
       (?$(LE3(B . "0x27FD3") ; <CJK>
       (?$(LE4(B . "0x27FF1") ; <CJK>
       (?$(LE5(B . "0x27FE4") ; <CJK>
       (?$(LE6(B . "0x27FE0") ; <CJK>
       (?$(LE7(B . "0x27FD6") ; <CJK>
       (?$(LE8(B . "0x8DC3") ; <CJK>
       (?$(LE9(B . "0x27FE6") ; <CJK>
       (?$(LE:(B . "0x27FD8") ; <CJK>
       (?$(LE;(B . "0x27FDE") ; <CJK>
       (?$(LE<(B . "0x27FDB") ; <CJK>
       (?$(LE=(B . "0x27FDC") ; <CJK>
       (?$(LE>(B . "0x2821B") ; <CJK>
       (?$(LE?(B . "0x2821F") ; <CJK>
       (?$(LE@(B . "0x2821D") ; <CJK>
       (?$(LEA(B . "0x2821C") ; <CJK>
       (?$(LEB(B . "0x2821E") ; <CJK>
       (?$(LEC(B . "0x28220") ; <CJK>
       (?$(LED(B . "0x28221") ; <CJK>
       (?$(LEE(B . "0x484E") ; <CJK>
       (?$(LEF(B . "0x282B6") ; <CJK>
       (?$(LEG(B . "0x282BC") ; <CJK>
       (?$(LEH(B . "0x282C6") ; <CJK>
       (?$(LEI(B . "0x282C7") ; <CJK>
       (?$(LEJ(B . "0x282BA") ; <CJK>
       (?$(LEK(B . "0x282BE") ; <CJK>
       (?$(LEL(B . "0x282BD") ; <CJK>
       (?$(LEM(B . "0x282B5") ; <CJK>
       (?$(LEN(B . "0x282B4") ; <CJK>
       (?$(LEO(B . "0x2840F") ; <CJK>
       (?$(LEP(B . "0x28462") ; <CJK>
       (?$(LEQ(B . "0x284EB") ; <CJK>
       (?$(LER(B . "0x284D9") ; <CJK>
       (?$(LES(B . "0x284E4") ; <CJK>
       (?$(LET(B . "0x284D7") ; <CJK>
       (?$(LEU(B . "0x284D8") ; <CJK>
       (?$(LEV(B . "0x284D6") ; <CJK>
       (?$(LEW(B . "0x284CE") ; <CJK>
       (?$(LEX(B . "0x284DD") ; <CJK>
       (?$(LEY(B . "0x284E7") ; <CJK>
       (?$(LEZ(B . "0x284D2") ; <CJK>
       (?$(LE[(B . "0x284C5") ; <CJK>
       (?$(LE\(B . "0x284C9") ; <CJK>
       (?$(LE](B . "0x284DB") ; <CJK>
       (?$(LE^(B . "0x28692") ; <CJK>
       (?$(LE_(B . "0x2868A") ; <CJK>
       (?$(LE`(B . "0x2868B") ; <CJK>
       (?$(LEa(B . "0x28689") ; <CJK>
       (?$(LEb(B . "0x28708") ; <CJK>
       (?$(LEc(B . "0x28703") ; <CJK>
       (?$(LEd(B . "0x28706") ; <CJK>
       (?$(LEe(B . "0x28705") ; <CJK>
       (?$(LEf(B . "0x286F5") ; <CJK>
       (?$(LEg(B . "0x2870B") ; <CJK>
       (?$(LEh(B . "0x286FB") ; <CJK>
       (?$(LEi(B . "0x287FC") ; <CJK>
       (?$(LEj(B . "0x28801") ; <CJK>
       (?$(LEk(B . "0x28802") ; <CJK>
       (?$(LEl(B . "0x287FA") ; <CJK>
       (?$(LEm(B . "0x28808") ; <CJK>
       (?$(LEn(B . "0x287F7") ; <CJK>
       (?$(LEo(B . "0x28800") ; <CJK>
       (?$(LEp(B . "0x287FF") ; <CJK>
       (?$(LEq(B . "0x28806") ; <CJK>
       (?$(LEr(B . "0x287F6") ; <CJK>
       (?$(LEs(B . "0x287FB") ; <CJK>
       (?$(LEt(B . "0x2880A") ; <CJK>
       (?$(LEu(B . "0x28925") ; <CJK>
       (?$(LEv(B . "0x28943") ; <CJK>
       (?$(LEw(B . "0x28944") ; <CJK>
       (?$(LEx(B . "0x28C64") ; <CJK>
       (?$(LEy(B . "0x28C62") ; <CJK>
       (?$(LEz(B . "0x28C5E") ; <CJK>
       (?$(LE{(B . "0x28C5B") ; <CJK>
       (?$(LE|(B . "0x28CD6") ; <CJK>
       (?$(LE}(B . "0x20072") ; <CJK>
       (?$(LE~(B . "0x200C2") ; <CJK>
       (?$(LF!(B . "0x28E77") ; <CJK>
       (?$(LF"(B . "0x28E82") ; <CJK>
       (?$(LF#(B . "0x28E7C") ; <CJK>
       (?$(LF$(B . "0x28E7D") ; <CJK>
       (?$(LF%(B . "0x28E86") ; <CJK>
       (?$(LF&(B . "0x28E81") ; <CJK>
       (?$(LF'(B . "0x28E84") ; <CJK>
       (?$(LF((B . "0x28E76") ; <CJK>
       (?$(LF)(B . "0x28E83") ; <CJK>
       (?$(LF*(B . "0x28E7F") ; <CJK>
       (?$(LF+(B . "0x28E7E") ; <CJK>
       (?$(LF,(B . "0x28F88") ; <CJK>
       (?$(LF-(B . "0x28F8D") ; <CJK>
       (?$(LF.(B . "0x28F8B") ; <CJK>
       (?$(LF/(B . "0x28F91") ; <CJK>
       (?$(LF0(B . "0x28F8F") ; <CJK>
       (?$(LF1(B . "0x2907C") ; <CJK>
       (?$(LF2(B . "0x29079") ; <CJK>
       (?$(LF3(B . "0x2907A") ; <CJK>
       (?$(LF4(B . "0x291EA") ; <CJK>
       (?$(LF5(B . "0x2944C") ; <CJK>
       (?$(LF6(B . "0x29599") ; <CJK>
       (?$(LF7(B . "0x202D1") ; <CJK>
       (?$(LF8(B . "0x2968B") ; <CJK>
       (?$(LF9(B . "0x2968D") ; <CJK>
       (?$(LF:(B . "0x2968A") ; <CJK>
       (?$(LF;(B . "0x2968E") ; <CJK>
       (?$(LF<(B . "0x29811") ; <CJK>
       (?$(LF=(B . "0x22256") ; <CJK>
       (?$(LF>(B . "0x2FA15") ; <CJK>
       (?$(LF?(B . "0x20074") ; <CJK>
       (?$(LF@(B . "0x200C3") ; <CJK>
       (?$(LFA(B . "0x200C4") ; <CJK>
       (?$(LFB(B . "0x2011B") ; <CJK>
       (?$(LFC(B . "0x2015F") ; <CJK>
       (?$(LFD(B . "0x2016A") ; <CJK>
       (?$(LFE(B . "0x20169") ; <CJK>
       (?$(LFF(B . "0x2016B") ; <CJK>
       (?$(LFG(B . "0x2030C") ; <CJK>
       (?$(LFH(B . "0x202F6") ; <CJK>
       (?$(LFI(B . "0x202ED") ; <CJK>
       (?$(LFJ(B . "0x20329") ; <CJK>
       (?$(LFK(B . "0x202FE") ; <CJK>
       (?$(LFL(B . "0x202F1") ; <CJK>
       (?$(LFM(B . "0x20317") ; <CJK>
       (?$(LFN(B . "0x202FF") ; <CJK>
       (?$(LFO(B . "0x202EE") ; <CJK>
       (?$(LFP(B . "0x202FD") ; <CJK>
       (?$(LFQ(B . "0x2031C") ; <CJK>
       (?$(LFR(B . "0x202FC") ; <CJK>
       (?$(LFS(B . "0x20300") ; <CJK>
       (?$(LFT(B . "0x20320") ; <CJK>
       (?$(LFU(B . "0x3477") ; <CJK>
       (?$(LFV(B . "0x202F9") ; <CJK>
       (?$(LFW(B . "0x20367") ; <CJK>
       (?$(LFX(B . "0x20308") ; <CJK>
       (?$(LFY(B . "0x2049E") ; <CJK>
       (?$(LFZ(B . "0x204F3") ; <CJK>
       (?$(LF[(B . "0x20525") ; <CJK>
       (?$(LF\(B . "0x20527") ; <CJK>
       (?$(LF](B . "0x2051F") ; <CJK>
       (?$(LF^(B . "0x20565") ; <CJK>
       (?$(LF_(B . "0x20563") ; <CJK>
       (?$(LF`(B . "0x20594") ; <CJK>
       (?$(LFa(B . "0x20597") ; <CJK>
       (?$(LFb(B . "0x205F1") ; <CJK>
       (?$(LFc(B . "0x2065F") ; <CJK>
       (?$(LFd(B . "0x20662") ; <CJK>
       (?$(LFe(B . "0x51F2") ; <CJK>
       (?$(LFf(B . "0x20660") ; <CJK>
       (?$(LFg(B . "0x2F822") ; <CJK>
       (?$(LFh(B . "0x2078C") ; <CJK>
       (?$(LFi(B . "0x20782") ; <CJK>
       (?$(LFj(B . "0x20790") ; <CJK>
       (?$(LFk(B . "0x2078B") ; <CJK>
       (?$(LFl(B . "0x2078D") ; <CJK>
       (?$(LFm(B . "0x20781") ; <CJK>
       (?$(LFn(B . "0x2079D") ; <CJK>
       (?$(LFo(B . "0x2088E") ; <CJK>
       (?$(LFp(B . "0x2088F") ; <CJK>
       (?$(LFq(B . "0x20892") ; <CJK>
       (?$(LFr(B . "0x20923") ; <CJK>
       (?$(LFs(B . "0x20952") ; <CJK>
       (?$(LFt(B . "0x2F82E") ; <CJK>
       (?$(LFu(B . "0x20A00") ; <CJK>
       (?$(LFv(B . "0x20A01") ; <CJK>
       (?$(LFw(B . "0x20A02") ; <CJK>
       (?$(LFx(B . "0x20A1F") ; <CJK>
       (?$(LFy(B . "0x20A8C") ; <CJK>
       (?$(LFz(B . "0x20A89") ; <CJK>
       (?$(LF{(B . "0x20A8B") ; <CJK>
       (?$(LF|(B . "0x20A88") ; <CJK>
       (?$(LF}(B . "0x20A8D") ; <CJK>
       (?$(LF~(B . "0x20A8F") ; <CJK>
       (?$(LG!(B . "0x26385") ; <CJK>
       (?$(LG"(B . "0x20B00") ; <CJK>
       (?$(LG#(B . "0x20B05") ; <CJK>
       (?$(LG$(B . "0x20B01") ; <CJK>
       (?$(LG%(B . "0x20B68") ; <CJK>
       (?$(LG&(B . "0x20B6E") ; <CJK>
       (?$(LG'(B . "0x20B67") ; <CJK>
       (?$(LG((B . "0x20B75") ; <CJK>
       (?$(LG)(B . "0x55B6") ; <CJK>
       (?$(LG*(B . "0x2F845") ; <CJK>
       (?$(LG+(B . "0x20DD7") ; <CJK>
       (?$(LG,(B . "0x2F846") ; <CJK>
       (?$(LG-(B . "0x20048") ; <CJK>
       (?$(LG.(B . "0x20DD4") ; <CJK>
       (?$(LG/(B . "0x20DD8") ; <CJK>
       (?$(LG0(B . "0x2F847") ; <CJK>
       (?$(LG1(B . "0x2F848") ; <CJK>
       (?$(LG2(B . "0x20DBA") ; <CJK>
       (?$(LG3(B . "0x2F849") ; <CJK>
       (?$(LG4(B . "0x20DDB") ; <CJK>
       (?$(LG5(B . "0x20DBF") ; <CJK>
       (?$(LG6(B . "0x20E35") ; <CJK>
       (?$(LG7(B . "0x20DBC") ; <CJK>
       (?$(LG8(B . "0x20DD9") ; <CJK>
       (?$(LG9(B . "0x35C4") ; <CJK>
       (?$(LG:(B . "0x20DDD") ; <CJK>
       (?$(LG;(B . "0x20E00") ; <CJK>
       (?$(LG<(B . "0x20DD5") ; <CJK>
       (?$(LG=(B . "0x20E30") ; <CJK>
       (?$(LG>(B . "0x20DBD") ; <CJK>
       (?$(LG?(B . "0x20DDC") ; <CJK>
       (?$(LG@(B . "0x211FD") ; <CJK>
       (?$(LGA(B . "0x211FE") ; <CJK>
       (?$(LGB(B . "0x21207") ; <CJK>
       (?$(LGC(B . "0x24517") ; <CJK>
       (?$(LGD(B . "0x2136F") ; <CJK>
       (?$(LGE(B . "0x21369") ; <CJK>
       (?$(LGF(B . "0x21370") ; <CJK>
       (?$(LGG(B . "0x21367") ; <CJK>
       (?$(LGH(B . "0x213A9") ; <CJK>
       (?$(LGI(B . "0x21395") ; <CJK>
       (?$(LGJ(B . "0x21390") ; <CJK>
       (?$(LGK(B . "0x2136C") ; <CJK>
       (?$(LGL(B . "0x21397") ; <CJK>
       (?$(LGM(B . "0x21371") ; <CJK>
       (?$(LGN(B . "0x3652") ; <CJK>
       (?$(LGO(B . "0x21374") ; <CJK>
       (?$(LGP(B . "0x2136D") ; <CJK>
       (?$(LGQ(B . "0x2138E") ; <CJK>
       (?$(LGR(B . "0x2152F") ; <CJK>
       (?$(LGS(B . "0x2A31B") ; <CJK>
       (?$(LGT(B . "0x215A9") ; <CJK>
       (?$(LGU(B . "0x2164E") ; <CJK>
       (?$(LGV(B . "0x2F85F") ; <CJK>
       (?$(LGW(B . "0x2165A") ; <CJK>
       (?$(LGX(B . "0x21648") ; <CJK>
       (?$(LGY(B . "0x21655") ; <CJK>
       (?$(LGZ(B . "0x2164C") ; <CJK>
       (?$(LG[(B . "0x21649") ; <CJK>
       (?$(LG\(B . "0x2164F") ; <CJK>
       (?$(LG](B . "0x2164A") ; <CJK>
       (?$(LG^(B . "0x217D6") ; <CJK>
       (?$(LG_(B . "0x217A0") ; <CJK>
       (?$(LG`(B . "0x217A9") ; <CJK>
       (?$(LGa(B . "0x2F867") ; <CJK>
       (?$(LGb(B . "0x2179D") ; <CJK>
       (?$(LGc(B . "0x217D4") ; <CJK>
       (?$(LGd(B . "0x217A4") ; <CJK>
       (?$(LGe(B . "0x217A8") ; <CJK>
       (?$(LGf(B . "0x217A6") ; <CJK>
       (?$(LGg(B . "0x217E6") ; <CJK>
       (?$(LGh(B . "0x2197D") ; <CJK>
       (?$(LGi(B . "0x21977") ; <CJK>
       (?$(LGj(B . "0x2197A") ; <CJK>
       (?$(LGk(B . "0x21A41") ; <CJK>
       (?$(LGl(B . "0x21A49") ; <CJK>
       (?$(LGm(B . "0x21A59") ; <CJK>
       (?$(LGn(B . "0x21A45") ; <CJK>
       (?$(LGo(B . "0x21A48") ; <CJK>
       (?$(LGp(B . "0x21A40") ; <CJK>
       (?$(LGq(B . "0x21B8E") ; <CJK>
       (?$(LGr(B . "0x21B95") ; <CJK>
       (?$(LGs(B . "0x21B90") ; <CJK>
       (?$(LGt(B . "0x21BF7") ; <CJK>
       (?$(LGu(B . "0x21BF8") ; <CJK>
       (?$(LGv(B . "0x21BF6") ; <CJK>
       (?$(LGw(B . "0x21BFB") ; <CJK>
       (?$(LGx(B . "0x21C9E") ; <CJK>
       (?$(LGy(B . "0x21C9D") ; <CJK>
       (?$(LGz(B . "0x21C99") ; <CJK>
       (?$(LG{(B . "0x2F877") ; <CJK>
       (?$(LG|(B . "0x21CA3") ; <CJK>
       (?$(LG}(B . "0x21CA9") ; <CJK>
       (?$(LG~(B . "0x21C98") ; <CJK>
       (?$(LH!(B . "0x21CA0") ; <CJK>
       (?$(LH"(B . "0x21C96") ; <CJK>
       (?$(LH#(B . "0x21C94") ; <CJK>
       (?$(LH$(B . "0x21C95") ; <CJK>
       (?$(LH%(B . "0x21C9F") ; <CJK>
       (?$(LH&(B . "0x21CA1") ; <CJK>
       (?$(LH'(B . "0x21D21") ; <CJK>
       (?$(LH((B . "0x21D1D") ; <CJK>
       (?$(LH)(B . "0x21D1F") ; <CJK>
       (?$(LH*(B . "0x21E6D") ; <CJK>
       (?$(LH+(B . "0x2F87C") ; <CJK>
       (?$(LH,(B . "0x21E9A") ; <CJK>
       (?$(LH-(B . "0x21E92") ; <CJK>
       (?$(LH.(B . "0x21E7A") ; <CJK>
       (?$(LH/(B . "0x21E7D") ; <CJK>
       (?$(LH0(B . "0x21EA1") ; <CJK>
       (?$(LH1(B . "0x21E9D") ; <CJK>
       (?$(LH2(B . "0x21E99") ; <CJK>
       (?$(LH3(B . "0x21E6B") ; <CJK>
       (?$(LH4(B . "0x21E6E") ; <CJK>
       (?$(LH5(B . "0x2F87D") ; <CJK>
       (?$(LH6(B . "0x22045") ; <CJK>
       (?$(LH7(B . "0x2F884") ; <CJK>
       (?$(LH8(B . "0x220FB") ; <CJK>
       (?$(LH9(B . "0x220EB") ; <CJK>
       (?$(LH:(B . "0x220F2") ; <CJK>
       (?$(LH;(B . "0x220F9") ; <CJK>
       (?$(LH<(B . "0x2F886") ; <CJK>
       (?$(LH=(B . "0x220F8") ; <CJK>
       (?$(LH>(B . "0x220ED") ; <CJK>
       (?$(LH?(B . "0x22101") ; <CJK>
       (?$(LH@(B . "0x220F7") ; <CJK>
       (?$(LHA(B . "0x22106") ; <CJK>
       (?$(LHB(B . "0x2219B") ; <CJK>
       (?$(LHC(B . "0x221CA") ; <CJK>
       (?$(LHD(B . "0x386B") ; <CJK>
       (?$(LHE(B . "0x5EC3") ; <CJK>
       (?$(LHF(B . "0x2226B") ; <CJK>
       (?$(LHG(B . "0x2226C") ; <CJK>
       (?$(LHH(B . "0x22274") ; <CJK>
       (?$(LHI(B . "0x22267") ; <CJK>
       (?$(LHJ(B . "0x2225B") ; <CJK>
       (?$(LHK(B . "0x22260") ; <CJK>
       (?$(LHL(B . "0x22276") ; <CJK>
       (?$(LHM(B . "0x22263") ; <CJK>
       (?$(LHN(B . "0x22261") ; <CJK>
       (?$(LHO(B . "0x22328") ; <CJK>
       (?$(LHP(B . "0x2235B") ; <CJK>
       (?$(LHQ(B . "0x2235E") ; <CJK>
       (?$(LHR(B . "0x22360") ; <CJK>
       (?$(LHS(B . "0x2235D") ; <CJK>
       (?$(LHT(B . "0x2235C") ; <CJK>
       (?$(LHU(B . "0x223F4") ; <CJK>
       (?$(LHV(B . "0x22400") ; <CJK>
       (?$(LHW(B . "0x22408") ; <CJK>
       (?$(LHX(B . "0x22407") ; <CJK>
       (?$(LHY(B . "0x22401") ; <CJK>
       (?$(LHZ(B . "0x22405") ; <CJK>
       (?$(LH[(B . "0x22464") ; <CJK>
       (?$(LH\(B . "0x22463") ; <CJK>
       (?$(LH](B . "0x2249E") ; <CJK>
       (?$(LH^(B . "0x224A0") ; <CJK>
       (?$(LH_(B . "0x224A1") ; <CJK>
       (?$(LH`(B . "0x2249F") ; <CJK>
       (?$(LHa(B . "0x22526") ; <CJK>
       (?$(LHb(B . "0x2252D") ; <CJK>
       (?$(LHc(B . "0x22528") ; <CJK>
       (?$(LHd(B . "0x2251D") ; <CJK>
       (?$(LHe(B . "0x226EC") ; <CJK>
       (?$(LHf(B . "0x226E3") ; <CJK>
       (?$(LHg(B . "0x226EB") ; <CJK>
       (?$(LHh(B . "0x22716") ; <CJK>
       (?$(LHi(B . "0x226C8") ; <CJK>
       (?$(LHj(B . "0x2661B") ; <CJK>
       (?$(LHk(B . "0x226E9") ; <CJK>
       (?$(LHl(B . "0x226E4") ; <CJK>
       (?$(LHm(B . "0x22724") ; <CJK>
       (?$(LHn(B . "0x226D1") ; <CJK>
       (?$(LHo(B . "0x3941") ; <CJK>
       (?$(LHp(B . "0x226DD") ; <CJK>
       (?$(LHq(B . "0x226C2") ; <CJK>
       (?$(LHr(B . "0x226CB") ; <CJK>
       (?$(LHs(B . "0x226C7") ; <CJK>
       (?$(LHt(B . "0x226E7") ; <CJK>
       (?$(LHu(B . "0x3950") ; <CJK>
       (?$(LHv(B . "0x226EA") ; <CJK>
       (?$(LHw(B . "0x2274B") ; <CJK>
       (?$(LHx(B . "0x2F8A5") ; <CJK>
       (?$(LHy(B . "0x22760") ; <CJK>
       (?$(LHz(B . "0x2277D") ; <CJK>
       (?$(LH{(B . "0x2273E") ; <CJK>
       (?$(LH|(B . "0x2F8A4") ; <CJK>
       (?$(LH}(B . "0x22752") ; <CJK>
       (?$(LH~(B . "0x2274E") ; <CJK>
       (?$(LI!(B . "0x2273C") ; <CJK>
       (?$(LI"(B . "0x22732") ; <CJK>
       (?$(LI#(B . "0x22730") ; <CJK>
       (?$(LI$(B . "0x22723") ; <CJK>
       (?$(LI%(B . "0x229CA") ; <CJK>
       (?$(LI&(B . "0x229CB") ; <CJK>
       (?$(LI'(B . "0x229C9") ; <CJK>
       (?$(LI((B . "0x229C8") ; <CJK>
       (?$(LI)(B . "0x229CD") ; <CJK>
       (?$(LI*(B . "0x22B98") ; <CJK>
       (?$(LI+(B . "0x22BA0") ; <CJK>
       (?$(LI,(B . "0x22B9F") ; <CJK>
       (?$(LI-(B . "0x22B9C") ; <CJK>
       (?$(LI.(B . "0x22BA3") ; <CJK>
       (?$(LI/(B . "0x22B97") ; <CJK>
       (?$(LI0(B . "0x2F8BE") ; <CJK>
       (?$(LI1(B . "0x22BF1") ; <CJK>
       (?$(LI2(B . "0x22C09") ; <CJK>
       (?$(LI3(B . "0x22C03") ; <CJK>
       (?$(LI4(B . "0x22BEA") ; <CJK>
       (?$(LI5(B . "0x22C45") ; <CJK>
       (?$(LI6(B . "0x22BED") ; <CJK>
       (?$(LI7(B . "0x22C05") ; <CJK>
       (?$(LI8(B . "0x22C1A") ; <CJK>
       (?$(LI9(B . "0x22C15") ; <CJK>
       (?$(LI:(B . "0x22C01") ; <CJK>
       (?$(LI;(B . "0x22BEC") ; <CJK>
       (?$(LI<(B . "0x22C0E") ; <CJK>
       (?$(LI=(B . "0x22C17") ; <CJK>
       (?$(LI>(B . "0x22C42") ; <CJK>
       (?$(LI?(B . "0x22C12") ; <CJK>
       (?$(LI@(B . "0x22C10") ; <CJK>
       (?$(LIA(B . "0x22BEF") ; <CJK>
       (?$(LIB(B . "0x22BFF") ; <CJK>
       (?$(LIC(B . "0x22C00") ; <CJK>
       (?$(LID(B . "0x22C0C") ; <CJK>
       (?$(LIE(B . "0x22C0F") ; <CJK>
       (?$(LIF(B . "0x22C04") ; <CJK>
       (?$(LIG(B . "0x22C08") ; <CJK>
       (?$(LIH(B . "0x22C14") ; <CJK>
       (?$(LII(B . "0x22C43") ; <CJK>
       (?$(LIJ(B . "0x2F8BD") ; <CJK>
       (?$(LIK(B . "0x22C1B") ; <CJK>
       (?$(LIL(B . "0x22C11") ; <CJK>
       (?$(LIM(B . "0x22C13") ; <CJK>
       (?$(LIN(B . "0x22ECF") ; <CJK>
       (?$(LIO(B . "0x22ECE") ; <CJK>
       (?$(LIP(B . "0x22F6F") ; <CJK>
       (?$(LIQ(B . "0x22F6E") ; <CJK>
       (?$(LIR(B . "0x22F7A") ; <CJK>
       (?$(LIS(B . "0x22F70") ; <CJK>
       (?$(LIT(B . "0x22F64") ; <CJK>
       (?$(LIU(B . "0x22F5E") ; <CJK>
       (?$(LIV(B . "0x22F6C") ; <CJK>
       (?$(LIW(B . "0x2F8C9") ; <CJK>
       (?$(LIX(B . "0x22F5B") ; <CJK>
       (?$(LIY(B . "0x22F61") ; <CJK>
       (?$(LIZ(B . "0x22F65") ; <CJK>
       (?$(LI[(B . "0x2307F") ; <CJK>
       (?$(LI\(B . "0x23080") ; <CJK>
       (?$(LI](B . "0x2307C") ; <CJK>
       (?$(LI^(B . "0x230A7") ; <CJK>
       (?$(LI_(B . "0x230A6") ; <CJK>
       (?$(LI`(B . "0x230A1") ; <CJK>
       (?$(LIa(B . "0x3AC0") ; <CJK>
       (?$(LIb(B . "0x230A8") ; <CJK>
       (?$(LIc(B . "0x230A3") ; <CJK>
       (?$(LId(B . "0x230A2") ; <CJK>
       (?$(LIe(B . "0x230AD") ; <CJK>
       (?$(LIf(B . "0x230A5") ; <CJK>
       (?$(LIg(B . "0x23101") ; <CJK>
       (?$(LIh(B . "0x230FF") ; <CJK>
       (?$(LIi(B . "0x230FC") ; <CJK>
       (?$(LIj(B . "0x23100") ; <CJK>
       (?$(LIk(B . "0x23135") ; <CJK>
       (?$(LIl(B . "0x231EE") ; <CJK>
       (?$(LIm(B . "0x231EF") ; <CJK>
       (?$(LIn(B . "0x231F6") ; <CJK>
       (?$(LIo(B . "0x231E8") ; <CJK>
       (?$(LIp(B . "0x231EA") ; <CJK>
       (?$(LIq(B . "0x231E3") ; <CJK>
       (?$(LIr(B . "0x2321F") ; <CJK>
       (?$(LIs(B . "0x3AFC") ; <CJK>
       (?$(LIt(B . "0x231E4") ; <CJK>
       (?$(LIu(B . "0x231FA") ; <CJK>
       (?$(LIv(B . "0x231F1") ; <CJK>
       (?$(LIw(B . "0x231FB") ; <CJK>
       (?$(LIx(B . "0x2F8D4") ; <CJK>
       (?$(LIy(B . "0x2333D") ; <CJK>
       (?$(LIz(B . "0x2333C") ; <CJK>
       (?$(LI{(B . "0x3479") ; <CJK>
       (?$(LI|(B . "0x23378") ; <CJK>
       (?$(LI}(B . "0x23377") ; <CJK>
       (?$(LI~(B . "0x440B") ; <CJK>
       (?$(LJ!(B . "0x234D1") ; <CJK>
       (?$(LJ"(B . "0x234C7") ; <CJK>
       (?$(LJ#(B . "0x234DF") ; <CJK>
       (?$(LJ$(B . "0x234D0") ; <CJK>
       (?$(LJ%(B . "0x234E0") ; <CJK>
       (?$(LJ&(B . "0x234D6") ; <CJK>
       (?$(LJ'(B . "0x234D8") ; <CJK>
       (?$(LJ((B . "0x23516") ; <CJK>
       (?$(LJ)(B . "0x2350E") ; <CJK>
       (?$(LJ*(B . "0x234D9") ; <CJK>
       (?$(LJ+(B . "0x2350F") ; <CJK>
       (?$(LJ,(B . "0x23511") ; <CJK>
       (?$(LJ-(B . "0x234CD") ; <CJK>
       (?$(LJ.(B . "0x23489") ; <CJK>
       (?$(LJ/(B . "0x234CE") ; <CJK>
       (?$(LJ0(B . "0x23514") ; <CJK>
       (?$(LJ1(B . "0x234DA") ; <CJK>
       (?$(LJ2(B . "0x23512") ; <CJK>
       (?$(LJ3(B . "0x234D3") ; <CJK>
       (?$(LJ4(B . "0x234C2") ; <CJK>
       (?$(LJ5(B . "0x234E1") ; <CJK>
       (?$(LJ6(B . "0x234E9") ; <CJK>
       (?$(LJ7(B . "0x234EA") ; <CJK>
       (?$(LJ8(B . "0x234DE") ; <CJK>
       (?$(LJ9(B . "0x23515") ; <CJK>
       (?$(LJ:(B . "0x238D9") ; <CJK>
       (?$(LJ;(B . "0x238D6") ; <CJK>
       (?$(LJ<(B . "0x238CD") ; <CJK>
       (?$(LJ=(B . "0x238D0") ; <CJK>
       (?$(LJ>(B . "0x238D3") ; <CJK>
       (?$(LJ?(B . "0x2F8F0") ; <CJK>
       (?$(LJ@(B . "0x23982") ; <CJK>
       (?$(LJA(B . "0x23985") ; <CJK>
       (?$(LJB(B . "0x2397F") ; <CJK>
       (?$(LJC(B . "0x2397D") ; <CJK>
       (?$(LJD(B . "0x23981") ; <CJK>
       (?$(LJE(B . "0x23983") ; <CJK>
       (?$(LJF(B . "0x23984") ; <CJK>
       (?$(LJG(B . "0x284A0") ; <CJK>
       (?$(LJH(B . "0x23A28") ; <CJK>
       (?$(LJI(B . "0x23A0F") ; <CJK>
       (?$(LJJ(B . "0x23A17") ; <CJK>
       (?$(LJK(B . "0x23A1A") ; <CJK>
       (?$(LJL(B . "0x23A25") ; <CJK>
       (?$(LJM(B . "0x2F8F7") ; <CJK>
       (?$(LJN(B . "0x23A9B") ; <CJK>
       (?$(LJO(B . "0x23A99") ; <CJK>
       (?$(LJP(B . "0x23B92") ; <CJK>
       (?$(LJQ(B . "0x23B8C") ; <CJK>
       (?$(LJR(B . "0x23B95") ; <CJK>
       (?$(LJS(B . "0x23B8D") ; <CJK>
       (?$(LJT(B . "0x23BA3") ; <CJK>
       (?$(LJU(B . "0x23B93") ; <CJK>
       (?$(LJV(B . "0x23B91") ; <CJK>
       (?$(LJW(B . "0x23DDB") ; <CJK>
       (?$(LJX(B . "0x23D99") ; <CJK>
       (?$(LJY(B . "0x23D9A") ; <CJK>
       (?$(LJZ(B . "0x23E08") ; <CJK>
       (?$(LJ[(B . "0x23E4C") ; <CJK>
       (?$(LJ\(B . "0x23E0D") ; <CJK>
       (?$(LJ](B . "0x23E01") ; <CJK>
       (?$(LJ^(B . "0x23E4E") ; <CJK>
       (?$(LJ_(B . "0x23E02") ; <CJK>
       (?$(LJ`(B . "0x23E4D") ; <CJK>
       (?$(LJa(B . "0x23E21") ; <CJK>
       (?$(LJb(B . "0x23DFC") ; <CJK>
       (?$(LJc(B . "0x2F909") ; <CJK>
       (?$(LJd(B . "0x23D8A") ; <CJK>
       (?$(LJe(B . "0x2F908") ; <CJK>
       (?$(LJf(B . "0x23D95") ; <CJK>
       (?$(LJg(B . "0x23E11") ; <CJK>
       (?$(LJh(B . "0x23E12") ; <CJK>
       (?$(LJi(B . "0x23E46") ; <CJK>
       (?$(LJj(B . "0x23E1C") ; <CJK>
       (?$(LJk(B . "0x23E49") ; <CJK>
       (?$(LJl(B . "0x23E0C") ; <CJK>
       (?$(LJm(B . "0x3D1E") ; <CJK>
       (?$(LJn(B . "0x23E13") ; <CJK>
       (?$(LJo(B . "0x23E16") ; <CJK>
       (?$(LJp(B . "0x23DFD") ; <CJK>
       (?$(LJq(B . "0x23E0F") ; <CJK>
       (?$(LJr(B . "0x23E1F") ; <CJK>
       (?$(LJs(B . "0x24230") ; <CJK>
       (?$(LJt(B . "0x2426E") ; <CJK>
       (?$(LJu(B . "0x2426B") ; <CJK>
       (?$(LJv(B . "0x2429B") ; <CJK>
       (?$(LJw(B . "0x2427B") ; <CJK>
       (?$(LJx(B . "0x24263") ; <CJK>
       (?$(LJy(B . "0x24297") ; <CJK>
       (?$(LJz(B . "0x2426D") ; <CJK>
       (?$(LJ{(B . "0x2429C") ; <CJK>
       (?$(LJ|(B . "0x24298") ; <CJK>
       (?$(LJ}(B . "0x2426F") ; <CJK>
       (?$(LJ~(B . "0x24267") ; <CJK>
       (?$(LK!(B . "0x24269") ; <CJK>
       (?$(LK"(B . "0x24515") ; <CJK>
       (?$(LK#(B . "0x24563") ; <CJK>
       (?$(LK$(B . "0x24586") ; <CJK>
       (?$(LK%(B . "0x2458A") ; <CJK>
       (?$(LK&(B . "0x24587") ; <CJK>
       (?$(LK'(B . "0x24588") ; <CJK>
       (?$(LK((B . "0x24585") ; <CJK>
       (?$(LK)(B . "0x24589") ; <CJK>
       (?$(LK*(B . "0x245CA") ; <CJK>
       (?$(LK+(B . "0x245C7") ; <CJK>
       (?$(LK,(B . "0x245CB") ; <CJK>
       (?$(LK-(B . "0x245CC") ; <CJK>
       (?$(LK.(B . "0x245C9") ; <CJK>
       (?$(LK/(B . "0x2460D") ; <CJK>
       (?$(LK0(B . "0x24683") ; <CJK>
       (?$(LK1(B . "0x24684") ; <CJK>
       (?$(LK2(B . "0x24678") ; <CJK>
       (?$(LK3(B . "0x24682") ; <CJK>
       (?$(LK4(B . "0x24673") ; <CJK>
       (?$(LK5(B . "0x24679") ; <CJK>
       (?$(LK6(B . "0x2468C") ; <CJK>
       (?$(LK7(B . "0x247D0") ; <CJK>
       (?$(LK8(B . "0x247CF") ; <CJK>
       (?$(LK9(B . "0x247D2") ; <CJK>
       (?$(LK:(B . "0x247D9") ; <CJK>
       (?$(LK;(B . "0x247CC") ; <CJK>
       (?$(LK<(B . "0x247EB") ; <CJK>
       (?$(LK=(B . "0x247FD") ; <CJK>
       (?$(LK>(B . "0x247EC") ; <CJK>
       (?$(LK?(B . "0x247E8") ; <CJK>
       (?$(LK@(B . "0x247F8") ; <CJK>
       (?$(LKA(B . "0x247FA") ; <CJK>
       (?$(LKB(B . "0x2F927") ; <CJK>
       (?$(LKC(B . "0x3E85") ; <CJK>
       (?$(LKD(B . "0x247E1") ; <CJK>
       (?$(LKE(B . "0x247FB") ; <CJK>
       (?$(LKF(B . "0x248E7") ; <CJK>
       (?$(LKG(B . "0x2F92E") ; <CJK>
       (?$(LKH(B . "0x249A5") ; <CJK>
       (?$(LKI(B . "0x24991") ; <CJK>
       (?$(LKJ(B . "0x249A6") ; <CJK>
       (?$(LKK(B . "0x2497C") ; <CJK>
       (?$(LKL(B . "0x24992") ; <CJK>
       (?$(LKM(B . "0x249A2") ; <CJK>
       (?$(LKN(B . "0x249A0") ; <CJK>
       (?$(LKO(B . "0x24AFC") ; <CJK>
       (?$(LKP(B . "0x24AFE") ; <CJK>
       (?$(LKQ(B . "0x24B57") ; <CJK>
       (?$(LKR(B . "0x24B53") ; <CJK>
       (?$(LKS(B . "0x24B58") ; <CJK>
       (?$(LKT(B . "0x24BE7") ; <CJK>
       (?$(LKU(B . "0x24C8E") ; <CJK>
       (?$(LKV(B . "0x2F938") ; <CJK>
       (?$(LKW(B . "0x24C83") ; <CJK>
       (?$(LKX(B . "0x24C8B") ; <CJK>
       (?$(LKY(B . "0x24C84") ; <CJK>
       (?$(LKZ(B . "0x3F97") ; <CJK>
       (?$(LK[(B . "0x24DA2") ; <CJK>
       (?$(LK\(B . "0x24DB7") ; <CJK>
       (?$(LK](B . "0x24DA9") ; <CJK>
       (?$(LK^(B . "0x24DA5") ; <CJK>
       (?$(LK_(B . "0x24D9F") ; <CJK>
       (?$(LK`(B . "0x24DAA") ; <CJK>
       (?$(LKa(B . "0x24D97") ; <CJK>
       (?$(LKb(B . "0x24DA1") ; <CJK>
       (?$(LKc(B . "0x24D9E") ; <CJK>
       (?$(LKd(B . "0x24DAB") ; <CJK>
       (?$(LKe(B . "0x24D99") ; <CJK>
       (?$(LKf(B . "0x24DA3") ; <CJK>
       (?$(LKg(B . "0x24F30") ; <CJK>
       (?$(LKh(B . "0x24F32") ; <CJK>
       (?$(LKi(B . "0x24F2F") ; <CJK>
       (?$(LKj(B . "0x24F70") ; <CJK>
       (?$(LKk(B . "0x24F6C") ; <CJK>
       (?$(LKl(B . "0x24F6F") ; <CJK>
       (?$(LKm(B . "0x24FE8") ; <CJK>
       (?$(LKn(B . "0x24FEE") ; <CJK>
       (?$(LKo(B . "0x24FEA") ; <CJK>
       (?$(LKp(B . "0x2506D") ; <CJK>
       (?$(LKq(B . "0x25076") ; <CJK>
       (?$(LKr(B . "0x25070") ; <CJK>
       (?$(LKs(B . "0x25071") ; <CJK>
       (?$(LKt(B . "0x2506C") ; <CJK>
       (?$(LKu(B . "0x251EB") ; <CJK>
       (?$(LKv(B . "0x251B5") ; <CJK>
       (?$(LKw(B . "0x25196") ; <CJK>
       (?$(LKx(B . "0x25190") ; <CJK>
       (?$(LKy(B . "0x2518D") ; <CJK>
       (?$(LKz(B . "0x2F949") ; <CJK>
       (?$(LK{(B . "0x251A2") ; <CJK>
       (?$(LK|(B . "0x251B0") ; <CJK>
       (?$(LK}(B . "0x25192") ; <CJK>
       (?$(LK~(B . "0x251A0") ; <CJK>
       (?$(LL!(B . "0x25193") ; <CJK>
       (?$(LL"(B . "0x251C3") ; <CJK>
       (?$(LL#(B . "0x2518E") ; <CJK>
       (?$(LL$(B . "0x251B6") ; <CJK>
       (?$(LL%(B . "0x2519D") ; <CJK>
       (?$(LL&(B . "0x25195") ; <CJK>
       (?$(LL'(B . "0x251B3") ; <CJK>
       (?$(LL((B . "0x251A4") ; <CJK>
       (?$(LL)(B . "0x25370") ; <CJK>
       (?$(LL*(B . "0x253D4") ; <CJK>
       (?$(LL+(B . "0x4093") ; <CJK>
       (?$(LL,(B . "0x253CF") ; <CJK>
       (?$(LL-(B . "0x20170") ; <CJK>
       (?$(LL.(B . "0x25494") ; <CJK>
       (?$(LL/(B . "0x7861") ; <CJK>
       (?$(LL0(B . "0x254C0") ; <CJK>
       (?$(LL1(B . "0x254B4") ; <CJK>
       (?$(LL2(B . "0x254C1") ; <CJK>
       (?$(LL3(B . "0x40B2") ; <CJK>
       (?$(LL4(B . "0x254BD") ; <CJK>
       (?$(LL5(B . "0x254AF") ; <CJK>
       (?$(LL6(B . "0x25677") ; <CJK>
       (?$(LL7(B . "0x25678") ; <CJK>
       (?$(LL8(B . "0x2566B") ; <CJK>
       (?$(LL9(B . "0x2566D") ; <CJK>
       (?$(LL:(B . "0x2566E") ; <CJK>
       (?$(LL;(B . "0x25672") ; <CJK>
       (?$(LL<(B . "0x2566F") ; <CJK>
       (?$(LL=(B . "0x25671") ; <CJK>
       (?$(LL>(B . "0x230AB") ; <CJK>
       (?$(LL?(B . "0x2568C") ; <CJK>
       (?$(LL@(B . "0x2573F") ; <CJK>
       (?$(LLA(B . "0x257B6") ; <CJK>
       (?$(LLB(B . "0x257B7") ; <CJK>
       (?$(LLC(B . "0x7A06") ; <CJK>
       (?$(LLD(B . "0x257BB") ; <CJK>
       (?$(LLE(B . "0x257B8") ; <CJK>
       (?$(LLF(B . "0x2079C") ; <CJK>
       (?$(LLG(B . "0x257B9") ; <CJK>
       (?$(LLH(B . "0x7A01") ; <CJK>
       (?$(LLI(B . "0x2598B") ; <CJK>
       (?$(LLJ(B . "0x2597A") ; <CJK>
       (?$(LLK(B . "0x25984") ; <CJK>
       (?$(LLL(B . "0x25988") ; <CJK>
       (?$(LLM(B . "0x25991") ; <CJK>
       (?$(LLN(B . "0x25979") ; <CJK>
       (?$(LLO(B . "0x2598E") ; <CJK>
       (?$(LLP(B . "0x25980") ; <CJK>
       (?$(LLQ(B . "0x25982") ; <CJK>
       (?$(LLR(B . "0x2597C") ; <CJK>
       (?$(LLS(B . "0x41A4") ; <CJK>
       (?$(LLT(B . "0x25A84") ; <CJK>
       (?$(LLU(B . "0x25A7F") ; <CJK>
       (?$(LLV(B . "0x41F2") ; <CJK>
       (?$(LLW(B . "0x25B3B") ; <CJK>
       (?$(LLX(B . "0x25B71") ; <CJK>
       (?$(LLY(B . "0x25B3D") ; <CJK>
       (?$(LLZ(B . "0x25B30") ; <CJK>
       (?$(LL[(B . "0x41F1") ; <CJK>
       (?$(LL\(B . "0x25B3E") ; <CJK>
       (?$(LL](B . "0x25B38") ; <CJK>
       (?$(LL^(B . "0x25E5E") ; <CJK>
       (?$(LL_(B . "0x25E64") ; <CJK>
       (?$(LL`(B . "0x4281") ; <CJK>
       (?$(LLa(B . "0x25E5D") ; <CJK>
       (?$(LLb(B . "0x25E6D") ; <CJK>
       (?$(LLc(B . "0x25E4F") ; <CJK>
       (?$(LLd(B . "0x25E62") ; <CJK>
       (?$(LLe(B . "0x25E5F") ; <CJK>
       (?$(LLf(B . "0x25FEC") ; <CJK>
       (?$(LLg(B . "0x25FF2") ; <CJK>
       (?$(LLh(B . "0x25FF4") ; <CJK>
       (?$(LLi(B . "0x25FF7") ; <CJK>
       (?$(LLj(B . "0x25FF6") ; <CJK>
       (?$(LLk(B . "0x26007") ; <CJK>
       (?$(LLl(B . "0x25FED") ; <CJK>
       (?$(LLm(B . "0x25FEA") ; <CJK>
       (?$(LLn(B . "0x25FF0") ; <CJK>
       (?$(LLo(B . "0x25FF8") ; <CJK>
       (?$(LLp(B . "0x25FF3") ; <CJK>
       (?$(LLq(B . "0x42DC") ; <CJK>
       (?$(LLr(B . "0x2F972") ; <CJK>
       (?$(LLs(B . "0x26231") ; <CJK>
       (?$(LLt(B . "0x2622F") ; <CJK>
       (?$(LLu(B . "0x262B6") ; <CJK>
       (?$(LLv(B . "0x262AE") ; <CJK>
       (?$(LLw(B . "0x262AA") ; <CJK>
       (?$(LLx(B . "0x262BF") ; <CJK>
       (?$(LLy(B . "0x262CC") ; <CJK>
       (?$(LLz(B . "0x262C7") ; <CJK>
       (?$(LL{(B . "0x26C83") ; <CJK>
       (?$(LL|(B . "0x26380") ; <CJK>
       (?$(LL}(B . "0x2637B") ; <CJK>
       (?$(LL~(B . "0x2637F") ; <CJK>
       (?$(LM!(B . "0x2637D") ; <CJK>
       (?$(LM"(B . "0x26383") ; <CJK>
       (?$(LM#(B . "0x2F978") ; <CJK>
       (?$(LM$(B . "0x26446") ; <CJK>
       (?$(LM%(B . "0x2642D") ; <CJK>
       (?$(LM&(B . "0x26425") ; <CJK>
       (?$(LM'(B . "0x26426") ; <CJK>
       (?$(LM((B . "0x2642C") ; <CJK>
       (?$(LM)(B . "0x26437") ; <CJK>
       (?$(LM*(B . "0x26431") ; <CJK>
       (?$(LM+(B . "0x26433") ; <CJK>
       (?$(LM,(B . "0x26432") ; <CJK>
       (?$(LM-(B . "0x26427") ; <CJK>
       (?$(LM.(B . "0x2642A") ; <CJK>
       (?$(LM/(B . "0x2642E") ; <CJK>
       (?$(LM0(B . "0x2642F") ; <CJK>
       (?$(LM1(B . "0x264C0") ; <CJK>
       (?$(LM2(B . "0x26571") ; <CJK>
       (?$(LM3(B . "0x26561") ; <CJK>
       (?$(LM4(B . "0x26562") ; <CJK>
       (?$(LM5(B . "0x26566") ; <CJK>
       (?$(LM6(B . "0x26618") ; <CJK>
       (?$(LM7(B . "0x266C5") ; <CJK>
       (?$(LM8(B . "0x266C3") ; <CJK>
       (?$(LM9(B . "0x266C4") ; <CJK>
       (?$(LM:(B . "0x266C2") ; <CJK>
       (?$(LM;(B . "0x266AE") ; <CJK>
       (?$(LM<(B . "0x26710") ; <CJK>
       (?$(LM=(B . "0x26708") ; <CJK>
       (?$(LM>(B . "0x2671F") ; <CJK>
       (?$(LM?(B . "0x2673A") ; <CJK>
       (?$(LM@(B . "0x2673B") ; <CJK>
       (?$(LMA(B . "0x26736") ; <CJK>
       (?$(LMB(B . "0x2670C") ; <CJK>
       (?$(LMC(B . "0x26706") ; <CJK>
       (?$(LMD(B . "0x2672A") ; <CJK>
       (?$(LME(B . "0x26757") ; <CJK>
       (?$(LMF(B . "0x26750") ; <CJK>
       (?$(LMG(B . "0x26720") ; <CJK>
       (?$(LMH(B . "0x2F985") ; <CJK>
       (?$(LMI(B . "0x2672C") ; <CJK>
       (?$(LMJ(B . "0x26721") ; <CJK>
       (?$(LMK(B . "0x2670B") ; <CJK>
       (?$(LML(B . "0x26719") ; <CJK>
       (?$(LMM(B . "0x26735") ; <CJK>
       (?$(LMN(B . "0x26718") ; <CJK>
       (?$(LMO(B . "0x2670F") ; <CJK>
       (?$(LMP(B . "0x26713") ; <CJK>
       (?$(LMQ(B . "0x26755") ; <CJK>
       (?$(LMR(B . "0x26739") ; <CJK>
       (?$(LMS(B . "0x2671A") ; <CJK>
       (?$(LMT(B . "0x440C") ; <CJK>
       (?$(LMU(B . "0x26717") ; <CJK>
       (?$(LMV(B . "0x268E4") ; <CJK>
       (?$(LMW(B . "0x268E9") ; <CJK>
       (?$(LMX(B . "0x2458B") ; <CJK>
       (?$(LMY(B . "0x26910") ; <CJK>
       (?$(LMZ(B . "0x26912") ; <CJK>
       (?$(LM[(B . "0x2693F") ; <CJK>
       (?$(LM\(B . "0x2696E") ; <CJK>
       (?$(LM](B . "0x24518") ; <CJK>
       (?$(LM^(B . "0x2F98C") ; <CJK>
       (?$(LM_(B . "0x269D6") ; <CJK>
       (?$(LM`(B . "0x269D5") ; <CJK>
       (?$(LMa(B . "0x269D7") ; <CJK>
       (?$(LMb(B . "0x20B02") ; <CJK>
       (?$(LMc(B . "0x446D") ; <CJK>
       (?$(LMd(B . "0x26A31") ; <CJK>
       (?$(LMe(B . "0x26A30") ; <CJK>
       (?$(LMf(B . "0x26A3A") ; <CJK>
       (?$(LMg(B . "0x26B85") ; <CJK>
       (?$(LMh(B . "0x26B6B") ; <CJK>
       (?$(LMi(B . "0x26C48") ; <CJK>
       (?$(LMj(B . "0x26C4B") ; <CJK>
       (?$(LMk(B . "0x26C37") ; <CJK>
       (?$(LMl(B . "0x26C7B") ; <CJK>
       (?$(LMm(B . "0x26C6C") ; <CJK>
       (?$(LMn(B . "0x26C85") ; <CJK>
       (?$(LMo(B . "0x26C65") ; <CJK>
       (?$(LMp(B . "0x26C36") ; <CJK>
       (?$(LMq(B . "0x26C86") ; <CJK>
       (?$(LMr(B . "0x26C34") ; <CJK>
       (?$(LMs(B . "0x26C68") ; <CJK>
       (?$(LMt(B . "0x26C5A") ; <CJK>
       (?$(LMu(B . "0x26C58") ; <CJK>
       (?$(LMv(B . "0x26C72") ; <CJK>
       (?$(LMw(B . "0x26C6A") ; <CJK>
       (?$(LMx(B . "0x26BD3") ; <CJK>
       (?$(LMy(B . "0x26C3C") ; <CJK>
       (?$(LMz(B . "0x26C33") ; <CJK>
       (?$(LM{(B . "0x26C3B") ; <CJK>
       (?$(LM|(B . "0x26C4D") ; <CJK>
       (?$(LM}(B . "0x26C4F") ; <CJK>
       (?$(LM~(B . "0x26C7C") ; <CJK>
       (?$(LN!(B . "0x26CB0") ; <CJK>
       (?$(LN"(B . "0x26C5B") ; <CJK>
       (?$(LN#(B . "0x26C55") ; <CJK>
       (?$(LN$(B . "0x26C64") ; <CJK>
       (?$(LN%(B . "0x26C6B") ; <CJK>
       (?$(LN&(B . "0x26C53") ; <CJK>
       (?$(LN'(B . "0x44E6") ; <CJK>
       (?$(LN((B . "0x26C57") ; <CJK>
       (?$(LN)(B . "0x26C5E") ; <CJK>
       (?$(LN*(B . "0x26C6D") ; <CJK>
       (?$(LN+(B . "0x26C35") ; <CJK>
       (?$(LN,(B . "0x26C69") ; <CJK>
       (?$(LN-(B . "0x26C59") ; <CJK>
       (?$(LN.(B . "0x26C66") ; <CJK>
       (?$(LN/(B . "0x26C50") ; <CJK>
       (?$(LN0(B . "0x26C51") ; <CJK>
       (?$(LN1(B . "0x26C5C") ; <CJK>
       (?$(LN2(B . "0x26D5D") ; <CJK>
       (?$(LN3(B . "0x26C87") ; <CJK>
       (?$(LN4(B . "0x26C78") ; <CJK>
       (?$(LN5(B . "0x26C49") ; <CJK>
       (?$(LN6(B . "0x26C4E") ; <CJK>
       (?$(LN7(B . "0x26BF1") ; <CJK>
       (?$(LN8(B . "0x26C73") ; <CJK>
       (?$(LN9(B . "0x26C88") ; <CJK>
       (?$(LN:(B . "0x26BCF") ; <CJK>
       (?$(LN;(B . "0x2F9A4") ; <CJK>
       (?$(LN<(B . "0x271B1") ; <CJK>
       (?$(LN=(B . "0x271B3") ; <CJK>
       (?$(LN>(B . "0x2729C") ; <CJK>
       (?$(LN?(B . "0x272A4") ; <CJK>
       (?$(LN@(B . "0x27290") ; <CJK>
       (?$(LNA(B . "0x272B8") ; <CJK>
       (?$(LNB(B . "0x272A0") ; <CJK>
       (?$(LNC(B . "0x2729D") ; <CJK>
       (?$(LND(B . "0x272A8") ; <CJK>
       (?$(LNE(B . "0x272A9") ; <CJK>
       (?$(LNF(B . "0x2F9B9") ; <CJK>
       (?$(LNG(B . "0x272B1") ; <CJK>
       (?$(LNH(B . "0x27293") ; <CJK>
       (?$(LNI(B . "0x2729B") ; <CJK>
       (?$(LNJ(B . "0x272A2") ; <CJK>
       (?$(LNK(B . "0x272A1") ; <CJK>
       (?$(LNL(B . "0x272B0") ; <CJK>
       (?$(LNM(B . "0x272A7") ; <CJK>
       (?$(LNN(B . "0x275B3") ; <CJK>
       (?$(LNO(B . "0x8849") ; <CJK>
       (?$(LNP(B . "0x275B4") ; <CJK>
       (?$(LNQ(B . "0x275F1") ; <CJK>
       (?$(LNR(B . "0x275ED") ; <CJK>
       (?$(LNS(B . "0x275EC") ; <CJK>
       (?$(LNT(B . "0x27668") ; <CJK>
       (?$(LNU(B . "0x27675") ; <CJK>
       (?$(LNV(B . "0x2766A") ; <CJK>
       (?$(LNW(B . "0x27662") ; <CJK>
       (?$(LNX(B . "0x27667") ; <CJK>
       (?$(LNY(B . "0x27660") ; <CJK>
       (?$(LNZ(B . "0x27677") ; <CJK>
       (?$(LN[(B . "0x2765F") ; <CJK>
       (?$(LN\(B . "0x27679") ; <CJK>
       (?$(LN](B . "0x27823") ; <CJK>
       (?$(LN^(B . "0x27821") ; <CJK>
       (?$(LN_(B . "0x2781C") ; <CJK>
       (?$(LN`(B . "0x8999") ; <CJK>
       (?$(LNa(B . "0x2781F") ; <CJK>
       (?$(LNb(B . "0x2781E") ; <CJK>
       (?$(LNc(B . "0x278D6") ; <CJK>
       (?$(LNd(B . "0x278D3") ; <CJK>
       (?$(LNe(B . "0x278D9") ; <CJK>
       (?$(LNf(B . "0x278D7") ; <CJK>
       (?$(LNg(B . "0x278D4") ; <CJK>
       (?$(LNh(B . "0x278DC") ; <CJK>
       (?$(LNi(B . "0x278D8") ; <CJK>
       (?$(LNj(B . "0x279A3") ; <CJK>
       (?$(LNk(B . "0x46D1") ; <CJK>
       (?$(LNl(B . "0x279BE") ; <CJK>
       (?$(LNm(B . "0x279A9") ; <CJK>
       (?$(LNn(B . "0x279A1") ; <CJK>
       (?$(LNo(B . "0x279A0") ; <CJK>
       (?$(LNp(B . "0x279AB") ; <CJK>
       (?$(LNq(B . "0x279A2") ; <CJK>
       (?$(LNr(B . "0x279BA") ; <CJK>
       (?$(LNs(B . "0x279C2") ; <CJK>
       (?$(LNt(B . "0x2799C") ; <CJK>
       (?$(LNu(B . "0x279BB") ; <CJK>
       (?$(LNv(B . "0x279AA") ; <CJK>
       (?$(LNw(B . "0x279AC") ; <CJK>
       (?$(LNx(B . "0x279A5") ; <CJK>
       (?$(LNy(B . "0x279C1") ; <CJK>
       (?$(LNz(B . "0x472C") ; <CJK>
       (?$(LN{(B . "0x27BE2") ; <CJK>
       (?$(LN|(B . "0x27C36") ; <CJK>
       (?$(LN}(B . "0x27C3D") ; <CJK>
       (?$(LN~(B . "0x27C3A") ; <CJK>
       (?$(LO!(B . "0x22461") ; <CJK>
       (?$(LO"(B . "0x27C48") ; <CJK>
       (?$(LO#(B . "0x27C3C") ; <CJK>
       (?$(LO$(B . "0x27CB7") ; <CJK>
       (?$(LO%(B . "0x27CAC") ; <CJK>
       (?$(LO&(B . "0x27CB3") ; <CJK>
       (?$(LO'(B . "0x27CB6") ; <CJK>
       (?$(LO((B . "0x27CB2") ; <CJK>
       (?$(LO)(B . "0x476E") ; <CJK>
       (?$(LO*(B . "0x27D5D") ; <CJK>
       (?$(LO+(B . "0x27D49") ; <CJK>
       (?$(LO,(B . "0x27D4E") ; <CJK>
       (?$(LO-(B . "0x27D4F") ; <CJK>
       (?$(LO.(B . "0x27D4D") ; <CJK>
       (?$(LO/(B . "0x27D5C") ; <CJK>
       (?$(LO0(B . "0x27E5D") ; <CJK>
       (?$(LO1(B . "0x27EBB") ; <CJK>
       (?$(LO2(B . "0x27ECE") ; <CJK>
       (?$(LO3(B . "0x27EBF") ; <CJK>
       (?$(LO4(B . "0x27EBA") ; <CJK>
       (?$(LO5(B . "0x27EC3") ; <CJK>
       (?$(LO6(B . "0x47E5") ; <CJK>
       (?$(LO7(B . "0x28006") ; <CJK>
       (?$(LO8(B . "0x27FF8") ; <CJK>
       (?$(LO9(B . "0x27FFE") ; <CJK>
       (?$(LO:(B . "0x28013") ; <CJK>
       (?$(LO;(B . "0x27FF6") ; <CJK>
       (?$(LO<(B . "0x47E6") ; <CJK>
       (?$(LO=(B . "0x28234") ; <CJK>
       (?$(LO>(B . "0x2822D") ; <CJK>
       (?$(LO?(B . "0x2822A") ; <CJK>
       (?$(LO@(B . "0x28235") ; <CJK>
       (?$(LOA(B . "0x2822C") ; <CJK>
       (?$(LOB(B . "0x282D4") ; <CJK>
       (?$(LOC(B . "0x282DA") ; <CJK>
       (?$(LOD(B . "0x282D3") ; <CJK>
       (?$(LOE(B . "0x282D2") ; <CJK>
       (?$(LOF(B . "0x282CE") ; <CJK>
       (?$(LOG(B . "0x282CF") ; <CJK>
       (?$(LOH(B . "0x489F") ; <CJK>
       (?$(LOI(B . "0x284FD") ; <CJK>
       (?$(LOJ(B . "0x2850B") ; <CJK>
       (?$(LOK(B . "0x284FE") ; <CJK>
       (?$(LOL(B . "0x284F8") ; <CJK>
       (?$(LOM(B . "0x284F7") ; <CJK>
       (?$(LON(B . "0x28517") ; <CJK>
       (?$(LOO(B . "0x284FA") ; <CJK>
       (?$(LOP(B . "0x284F9") ; <CJK>
       (?$(LOQ(B . "0x28500") ; <CJK>
       (?$(LOR(B . "0x284F5") ; <CJK>
       (?$(LOS(B . "0x284F1") ; <CJK>
       (?$(LOT(B . "0x28503") ; <CJK>
       (?$(LOU(B . "0x28505") ; <CJK>
       (?$(LOV(B . "0x2851C") ; <CJK>
       (?$(LOW(B . "0x286AC") ; <CJK>
       (?$(LOX(B . "0x2869A") ; <CJK>
       (?$(LOY(B . "0x286AD") ; <CJK>
       (?$(LOZ(B . "0x286A0") ; <CJK>
       (?$(LO[(B . "0x2871B") ; <CJK>
       (?$(LO\(B . "0x28725") ; <CJK>
       (?$(LO](B . "0x28724") ; <CJK>
       (?$(LO^(B . "0x28726") ; <CJK>
       (?$(LO_(B . "0x28727") ; <CJK>
       (?$(LO`(B . "0x28728") ; <CJK>
       (?$(LOa(B . "0x2872A") ; <CJK>
       (?$(LOb(B . "0x2871A") ; <CJK>
       (?$(LOc(B . "0x2872E") ; <CJK>
       (?$(LOd(B . "0x28715") ; <CJK>
       (?$(LOe(B . "0x28815") ; <CJK>
       (?$(LOf(B . "0x28814") ; <CJK>
       (?$(LOg(B . "0x28817") ; <CJK>
       (?$(LOh(B . "0x28818") ; <CJK>
       (?$(LOi(B . "0x2880F") ; <CJK>
       (?$(LOj(B . "0x28813") ; <CJK>
       (?$(LOk(B . "0x2880B") ; <CJK>
       (?$(LOl(B . "0x28822") ; <CJK>
       (?$(LOm(B . "0x2137A") ; <CJK>
       (?$(LOn(B . "0x28926") ; <CJK>
       (?$(LOo(B . "0x921F") ; <CJK>
       (?$(LOp(B . "0x28951") ; <CJK>
       (?$(LOq(B . "0x2894D") ; <CJK>
       (?$(LOr(B . "0x2894E") ; <CJK>
       (?$(LOs(B . "0x2894A") ; <CJK>
       (?$(LOt(B . "0x2894B") ; <CJK>
       (?$(LOu(B . "0x2894C") ; <CJK>
       (?$(LOv(B . "0x28950") ; <CJK>
       (?$(LOw(B . "0x28962") ; <CJK>
       (?$(LOx(B . "0x2894F") ; <CJK>
       (?$(LOy(B . "0x28952") ; <CJK>
       (?$(LOz(B . "0x28C68") ; <CJK>
       (?$(LO{(B . "0x28C69") ; <CJK>
       (?$(LO|(B . "0x28CE5") ; <CJK>
       (?$(LO}(B . "0x28CF0") ; <CJK>
       (?$(LO~(B . "0x28CE1") ; <CJK>
       (?$(LP!(B . "0x28CE2") ; <CJK>
       (?$(LP"(B . "0x2F9F2") ; <CJK>
       (?$(LP#(B . "0x28EA5") ; <CJK>
       (?$(LP$(B . "0x28EA9") ; <CJK>
       (?$(LP%(B . "0x28EA4") ; <CJK>
       (?$(LP&(B . "0x28EAF") ; <CJK>
       (?$(LP'(B . "0x28EAC") ; <CJK>
       (?$(LP((B . "0x28EAE") ; <CJK>
       (?$(LP)(B . "0x28EAA") ; <CJK>
       (?$(LP*(B . "0x28F95") ; <CJK>
       (?$(LP+(B . "0x28F99") ; <CJK>
       (?$(LP,(B . "0x28F93") ; <CJK>
       (?$(LP-(B . "0x28F9D") ; <CJK>
       (?$(LP.(B . "0x28F98") ; <CJK>
       (?$(LP/(B . "0x28F9C") ; <CJK>
       (?$(LP0(B . "0x28F97") ; <CJK>
       (?$(LP1(B . "0x4A0D") ; <CJK>
       (?$(LP2(B . "0x29089") ; <CJK>
       (?$(LP3(B . "0x29087") ; <CJK>
       (?$(LP4(B . "0x291D7") ; <CJK>
       (?$(LP5(B . "0x291ED") ; <CJK>
       (?$(LP6(B . "0x291F1") ; <CJK>
       (?$(LP7(B . "0x291F0") ; <CJK>
       (?$(LP8(B . "0x29205") ; <CJK>
       (?$(LP9(B . "0x29203") ; <CJK>
       (?$(LP:(B . "0x29204") ; <CJK>
       (?$(LP;(B . "0x2925F") ; <CJK>
       (?$(LP<(B . "0x29457") ; <CJK>
       (?$(LP=(B . "0x2959C") ; <CJK>
       (?$(LP>(B . "0x295A1") ; <CJK>
       (?$(LP?(B . "0x2959A") ; <CJK>
       (?$(LP@(B . "0x2968F") ; <CJK>
       (?$(LPA(B . "0x29693") ; <CJK>
       (?$(LPB(B . "0x2969E") ; <CJK>
       (?$(LPC(B . "0x296A3") ; <CJK>
       (?$(LPD(B . "0x29698") ; <CJK>
       (?$(LPE(B . "0x29699") ; <CJK>
       (?$(LPF(B . "0x29695") ; <CJK>
       (?$(LPG(B . "0x2986E") ; <CJK>
       (?$(LPH(B . "0x2986A") ; <CJK>
       (?$(LPI(B . "0x29AF4") ; <CJK>
       (?$(LPJ(B . "0x29AF7") ; <CJK>
       (?$(LPK(B . "0x29C79") ; <CJK>
       (?$(LPL(B . "0x29F8F") ; <CJK>
       (?$(LPM(B . "0x29F91") ; <CJK>
       (?$(LPN(B . "0x2A00B") ; <CJK>
       (?$(LPO(B . "0x2A502") ; <CJK>
       (?$(LPP(B . "0x20084") ; <CJK>
       (?$(LPQ(B . "0x20104") ; <CJK>
       (?$(LPR(B . "0x20180") ; <CJK>
       (?$(LPS(B . "0x2032F") ; <CJK>
       (?$(LPT(B . "0x2033F") ; <CJK>
       (?$(LPU(B . "0x2033B") ; <CJK>
       (?$(LPV(B . "0x20362") ; <CJK>
       (?$(LPW(B . "0x20344") ; <CJK>
       (?$(LPX(B . "0x20333") ; <CJK>
       (?$(LPY(B . "0x2035F") ; <CJK>
       (?$(LPZ(B . "0x2032B") ; <CJK>
       (?$(LP[(B . "0x2F809") ; <CJK>
       (?$(LP\(B . "0x20339") ; <CJK>
       (?$(LP](B . "0x20336") ; <CJK>
       (?$(LP^(B . "0x20348") ; <CJK>
       (?$(LP_(B . "0x20335") ; <CJK>
       (?$(LP`(B . "0x2036C") ; <CJK>
       (?$(LPa(B . "0x20358") ; <CJK>
       (?$(LPb(B . "0x2033A") ; <CJK>
       (?$(LPc(B . "0x204A8") ; <CJK>
       (?$(LPd(B . "0x204F4") ; <CJK>
       (?$(LPe(B . "0x20529") ; <CJK>
       (?$(LPf(B . "0x2059A") ; <CJK>
       (?$(LPg(B . "0x20600") ; <CJK>
       (?$(LPh(B . "0x207BB") ; <CJK>
       (?$(LPi(B . "0x207BD") ; <CJK>
       (?$(LPj(B . "0x207B7") ; <CJK>
       (?$(LPk(B . "0x207B2") ; <CJK>
       (?$(LPl(B . "0x34F8") ; <CJK>
       (?$(LPm(B . "0x207A8") ; <CJK>
       (?$(LPn(B . "0x207AB") ; <CJK>
       (?$(LPo(B . "0x207A6") ; <CJK>
       (?$(LPp(B . "0x207BC") ; <CJK>
       (?$(LPq(B . "0x20897") ; <CJK>
       (?$(LPr(B . "0x20896") ; <CJK>
       (?$(LPs(B . "0x208F8") ; <CJK>
       (?$(LPt(B . "0x5313") ; <CJK>
       (?$(LPu(B . "0x20951") ; <CJK>
       (?$(LPv(B . "0x3533") ; <CJK>
       (?$(LPw(B . "0x209B5") ; <CJK>
       (?$(LPx(B . "0x209B4") ; <CJK>
       (?$(LPy(B . "0x209B6") ; <CJK>
       (?$(LPz(B . "0x353C") ; <CJK>
       (?$(LP{(B . "0x209B7") ; <CJK>
       (?$(LP|(B . "0x20A05") ; <CJK>
       (?$(LP}(B . "0x20A23") ; <CJK>
       (?$(LP~(B . "0x20A95") ; <CJK>
       (?$(LQ!(B . "0x20A98") ; <CJK>
       (?$(LQ"(B . "0x354F") ; <CJK>
       (?$(LQ#(B . "0x20A94") ; <CJK>
       (?$(LQ$(B . "0x20A93") ; <CJK>
       (?$(LQ%(B . "0x20B07") ; <CJK>
       (?$(LQ&(B . "0x20B73") ; <CJK>
       (?$(LQ'(B . "0x20B71") ; <CJK>
       (?$(LQ((B . "0x20B72") ; <CJK>
       (?$(LQ)(B . "0x20B78") ; <CJK>
       (?$(LQ*(B . "0x20E5F") ; <CJK>
       (?$(LQ+(B . "0x20E6A") ; <CJK>
       (?$(LQ,(B . "0x20E67") ; <CJK>
       (?$(LQ-(B . "0x20E6B") ; <CJK>
       (?$(LQ.(B . "0x20E69") ; <CJK>
       (?$(LQ/(B . "0x20E8E") ; <CJK>
       (?$(LQ0(B . "0x20E49") ; <CJK>
       (?$(LQ1(B . "0x20E80") ; <CJK>
       (?$(LQ2(B . "0x35DC") ; <CJK>
       (?$(LQ3(B . "0x20E44") ; <CJK>
       (?$(LQ4(B . "0x20E8F") ; <CJK>
       (?$(LQ5(B . "0x20E45") ; <CJK>
       (?$(LQ6(B . "0x2F84C") ; <CJK>
       (?$(LQ7(B . "0x20E4F") ; <CJK>
       (?$(LQ8(B . "0x20E63") ; <CJK>
       (?$(LQ9(B . "0x20E36") ; <CJK>
       (?$(LQ:(B . "0x20E48") ; <CJK>
       (?$(LQ;(B . "0x20E5C") ; <CJK>
       (?$(LQ<(B . "0x20E93") ; <CJK>
       (?$(LQ=(B . "0x20E61") ; <CJK>
       (?$(LQ>(B . "0x20E60") ; <CJK>
       (?$(LQ?(B . "0x20E4E") ; <CJK>
       (?$(LQ@(B . "0x20E5E") ; <CJK>
       (?$(LQA(B . "0x20E3F") ; <CJK>
       (?$(LQB(B . "0x20EA4") ; <CJK>
       (?$(LQC(B . "0x55E0") ; <CJK>
       (?$(LQD(B . "0x20E68") ; <CJK>
       (?$(LQE(B . "0x2120B") ; <CJK>
       (?$(LQF(B . "0x21211") ; <CJK>
       (?$(LQG(B . "0x2120D") ; <CJK>
       (?$(LQH(B . "0x2120E") ; <CJK>
       (?$(LQI(B . "0x213C2") ; <CJK>
       (?$(LQJ(B . "0x2F857") ; <CJK>
       (?$(LQK(B . "0x213B0") ; <CJK>
       (?$(LQL(B . "0x213C3") ; <CJK>
       (?$(LQM(B . "0x213C8") ; <CJK>
       (?$(LQN(B . "0x21365") ; <CJK>
       (?$(LQO(B . "0x213D7") ; <CJK>
       (?$(LQP(B . "0x213BD") ; <CJK>
       (?$(LQQ(B . "0x213B8") ; <CJK>
       (?$(LQR(B . "0x213B6") ; <CJK>
       (?$(LQS(B . "0x213C7") ; <CJK>
       (?$(LQT(B . "0x213BC") ; <CJK>
       (?$(LQU(B . "0x213B1") ; <CJK>
       (?$(LQV(B . "0x213AF") ; <CJK>
       (?$(LQW(B . "0x2F85B") ; <CJK>
       (?$(LQX(B . "0x21535") ; <CJK>
       (?$(LQY(B . "0x21530") ; <CJK>
       (?$(LQZ(B . "0x2155D") ; <CJK>
       (?$(LQ[(B . "0x20B76") ; <CJK>
       (?$(LQ\(B . "0x2156F") ; <CJK>
       (?$(LQ](B . "0x215B0") ; <CJK>
       (?$(LQ^(B . "0x2F85E") ; <CJK>
       (?$(LQ_(B . "0x215B4") ; <CJK>
       (?$(LQ`(B . "0x2165C") ; <CJK>
       (?$(LQa(B . "0x2165D") ; <CJK>
       (?$(LQb(B . "0x21808") ; <CJK>
       (?$(LQc(B . "0x217EE") ; <CJK>
       (?$(LQd(B . "0x2180B") ; <CJK>
       (?$(LQe(B . "0x217F2") ; <CJK>
       (?$(LQf(B . "0x217FD") ; <CJK>
       (?$(LQg(B . "0x217F1") ; <CJK>
       (?$(LQh(B . "0x21810") ; <CJK>
       (?$(LQi(B . "0x2F868") ; <CJK>
       (?$(LQj(B . "0x21814") ; <CJK>
       (?$(LQk(B . "0x2198B") ; <CJK>
       (?$(LQl(B . "0x2198C") ; <CJK>
       (?$(LQm(B . "0x21985") ; <CJK>
       (?$(LQn(B . "0x21A7A") ; <CJK>
       (?$(LQo(B . "0x21A6C") ; <CJK>
       (?$(LQp(B . "0x21A60") ; <CJK>
       (?$(LQq(B . "0x21A67") ; <CJK>
       (?$(LQr(B . "0x21A66") ; <CJK>
       (?$(LQs(B . "0x21A6A") ; <CJK>
       (?$(LQt(B . "0x21A5F") ; <CJK>
       (?$(LQu(B . "0x21A6D") ; <CJK>
       (?$(LQv(B . "0x21A68") ; <CJK>
       (?$(LQw(B . "0x21A64") ; <CJK>
       (?$(LQx(B . "0x21B3A") ; <CJK>
       (?$(LQy(B . "0x21B3B") ; <CJK>
       (?$(LQz(B . "0x21B39") ; <CJK>
       (?$(LQ{(B . "0x21C02") ; <CJK>
       (?$(LQ|(B . "0x21C04") ; <CJK>
       (?$(LQ}(B . "0x21C03") ; <CJK>
       (?$(LQ~(B . "0x21CB4") ; <CJK>
       (?$(LR!(B . "0x21CB3") ; <CJK>
       (?$(LR"(B . "0x21CBB") ; <CJK>
       (?$(LR#(B . "0x21CAC") ; <CJK>
       (?$(LR$(B . "0x21CB6") ; <CJK>
       (?$(LR%(B . "0x21CB1") ; <CJK>
       (?$(LR&(B . "0x21CAF") ; <CJK>
       (?$(LR'(B . "0x21CB5") ; <CJK>
       (?$(LR((B . "0x21CBE") ; <CJK>
       (?$(LR)(B . "0x21CB2") ; <CJK>
       (?$(LR*(B . "0x21D24") ; <CJK>
       (?$(LR+(B . "0x21EB6") ; <CJK>
       (?$(LR,(B . "0x21EB9") ; <CJK>
       (?$(LR-(B . "0x21EAC") ; <CJK>
       (?$(LR.(B . "0x21EB0") ; <CJK>
       (?$(LR/(B . "0x21ED7") ; <CJK>
       (?$(LR0(B . "0x21EBB") ; <CJK>
       (?$(LR1(B . "0x21EFE") ; <CJK>
       (?$(LR2(B . "0x21ECB") ; <CJK>
       (?$(LR3(B . "0x2F87F") ; <CJK>
       (?$(LR4(B . "0x37F5") ; <CJK>
       (?$(LR5(B . "0x21EB3") ; <CJK>
       (?$(LR6(B . "0x21EBE") ; <CJK>
       (?$(LR7(B . "0x21ECD") ; <CJK>
       (?$(LR8(B . "0x21EBC") ; <CJK>
       (?$(LR9(B . "0x21EBA") ; <CJK>
       (?$(LR:(B . "0x21EC7") ; <CJK>
       (?$(LR;(B . "0x22116") ; <CJK>
       (?$(LR<(B . "0x2211B") ; <CJK>
       (?$(LR=(B . "0x22117") ; <CJK>
       (?$(LR>(B . "0x22115") ; <CJK>
       (?$(LR?(B . "0x2219F") ; <CJK>
       (?$(LR@(B . "0x2F88E") ; <CJK>
       (?$(LRA(B . "0x22282") ; <CJK>
       (?$(LRB(B . "0x22283") ; <CJK>
       (?$(LRC(B . "0x2228E") ; <CJK>
       (?$(LRD(B . "0x2226A") ; <CJK>
       (?$(LRE(B . "0x22289") ; <CJK>
       (?$(LRF(B . "0x22294") ; <CJK>
       (?$(LRG(B . "0x22286") ; <CJK>
       (?$(LRH(B . "0x22290") ; <CJK>
       (?$(LRI(B . "0x22362") ; <CJK>
       (?$(LRJ(B . "0x22390") ; <CJK>
       (?$(LRK(B . "0x2240C") ; <CJK>
       (?$(LRL(B . "0x2240F") ; <CJK>
       (?$(LRM(B . "0x38C3") ; <CJK>
       (?$(LRN(B . "0x224A5") ; <CJK>
       (?$(LRO(B . "0x224A7") ; <CJK>
       (?$(LRP(B . "0x224A6") ; <CJK>
       (?$(LRQ(B . "0x224A4") ; <CJK>
       (?$(LRR(B . "0x22535") ; <CJK>
       (?$(LRS(B . "0x22538") ; <CJK>
       (?$(LRT(B . "0x22536") ; <CJK>
       (?$(LRU(B . "0x22543") ; <CJK>
       (?$(LRV(B . "0x22547") ; <CJK>
       (?$(LRW(B . "0x22537") ; <CJK>
       (?$(LRX(B . "0x22743") ; <CJK>
       (?$(LRY(B . "0x227A2") ; <CJK>
       (?$(LRZ(B . "0x22751") ; <CJK>
       (?$(LR[(B . "0x22772") ; <CJK>
       (?$(LR\(B . "0x2276D") ; <CJK>
       (?$(LR](B . "0x2272F") ; <CJK>
       (?$(LR^(B . "0x22754") ; <CJK>
       (?$(LR_(B . "0x2276E") ; <CJK>
       (?$(LR`(B . "0x22755") ; <CJK>
       (?$(LRa(B . "0x22737") ; <CJK>
       (?$(LRb(B . "0x2274F") ; <CJK>
       (?$(LRc(B . "0x22750") ; <CJK>
       (?$(LRd(B . "0x6139") ; <CJK>
       (?$(LRe(B . "0x2279E") ; <CJK>
       (?$(LRf(B . "0x2F8A8") ; <CJK>
       (?$(LRg(B . "0x227B3") ; <CJK>
       (?$(LRh(B . "0x227A7") ; <CJK>
       (?$(LRi(B . "0x3971") ; <CJK>
       (?$(LRj(B . "0x227F9") ; <CJK>
       (?$(LRk(B . "0x22791") ; <CJK>
       (?$(LRl(B . "0x2F8A7") ; <CJK>
       (?$(LRm(B . "0x227B6") ; <CJK>
       (?$(LRn(B . "0x227DD") ; <CJK>
       (?$(LRo(B . "0x22799") ; <CJK>
       (?$(LRp(B . "0x229DF") ; <CJK>
       (?$(LRq(B . "0x229D5") ; <CJK>
       (?$(LRr(B . "0x247F5") ; <CJK>
       (?$(LRs(B . "0x22C28") ; <CJK>
       (?$(LRt(B . "0x22C40") ; <CJK>
       (?$(LRu(B . "0x22C71") ; <CJK>
       (?$(LRv(B . "0x22C98") ; <CJK>
       (?$(LRw(B . "0x22C95") ; <CJK>
       (?$(LRx(B . "0x22C65") ; <CJK>
       (?$(LRy(B . "0x22C78") ; <CJK>
       (?$(LRz(B . "0x22C7F") ; <CJK>
       (?$(LR{(B . "0x22C60") ; <CJK>
       (?$(LR|(B . "0x22C7C") ; <CJK>
       (?$(LR}(B . "0x22C96") ; <CJK>
       (?$(LR~(B . "0x22C6A") ; <CJK>
       (?$(LS!(B . "0x22C79") ; <CJK>
       (?$(LS"(B . "0x22C73") ; <CJK>
       (?$(LS#(B . "0x22C72") ; <CJK>
       (?$(LS$(B . "0x22C7B") ; <CJK>
       (?$(LS%(B . "0x22C70") ; <CJK>
       (?$(LS&(B . "0x22ED5") ; <CJK>
       (?$(LS'(B . "0x22ED7") ; <CJK>
       (?$(LS((B . "0x22F8F") ; <CJK>
       (?$(LS)(B . "0x22F89") ; <CJK>
       (?$(LS*(B . "0x22F9E") ; <CJK>
       (?$(LS+(B . "0x22F87") ; <CJK>
       (?$(LS,(B . "0x22FA0") ; <CJK>
       (?$(LS-(B . "0x22F8D") ; <CJK>
       (?$(LS.(B . "0x22F88") ; <CJK>
       (?$(LS/(B . "0x22F7F") ; <CJK>
       (?$(LS0(B . "0x22F8C") ; <CJK>
       (?$(LS1(B . "0x22F93") ; <CJK>
       (?$(LS2(B . "0x23059") ; <CJK>
       (?$(LS3(B . "0x295B0") ; <CJK>
       (?$(LS4(B . "0x230B1") ; <CJK>
       (?$(LS5(B . "0x251F4") ; <CJK>
       (?$(LS6(B . "0x230AF") ; <CJK>
       (?$(LS7(B . "0x230B2") ; <CJK>
       (?$(LS8(B . "0x23108") ; <CJK>
       (?$(LS9(B . "0x2310A") ; <CJK>
       (?$(LS:(B . "0x23136") ; <CJK>
       (?$(LS;(B . "0x23137") ; <CJK>
       (?$(LS<(B . "0x2F8CF") ; <CJK>
       (?$(LS=(B . "0x3B01") ; <CJK>
       (?$(LS>(B . "0x23236") ; <CJK>
       (?$(LS?(B . "0x23229") ; <CJK>
       (?$(LS@(B . "0x2324A") ; <CJK>
       (?$(LSA(B . "0x23226") ; <CJK>
       (?$(LSB(B . "0x23228") ; <CJK>
       (?$(LSC(B . "0x23224") ; <CJK>
       (?$(LSD(B . "0x2322A") ; <CJK>
       (?$(LSE(B . "0x23248") ; <CJK>
       (?$(LSF(B . "0x23344") ; <CJK>
       (?$(LSG(B . "0x23384") ; <CJK>
       (?$(LSH(B . "0x2338C") ; <CJK>
       (?$(LSI(B . "0x234C4") ; <CJK>
       (?$(LSJ(B . "0x234DC") ; <CJK>
       (?$(LSK(B . "0x23587") ; <CJK>
       (?$(LSL(B . "0x23553") ; <CJK>
       (?$(LSM(B . "0x2357F") ; <CJK>
       (?$(LSN(B . "0x23531") ; <CJK>
       (?$(LSO(B . "0x23551") ; <CJK>
       (?$(LSP(B . "0x2354B") ; <CJK>
       (?$(LSQ(B . "0x23552") ; <CJK>
       (?$(LSR(B . "0x23580") ; <CJK>
       (?$(LSS(B . "0x235A5") ; <CJK>
       (?$(LST(B . "0x23581") ; <CJK>
       (?$(LSU(B . "0x23543") ; <CJK>
       (?$(LSV(B . "0x23534") ; <CJK>
       (?$(LSW(B . "0x23536") ; <CJK>
       (?$(LSX(B . "0x23532") ; <CJK>
       (?$(LSY(B . "0x23548") ; <CJK>
       (?$(LSZ(B . "0x23549") ; <CJK>
       (?$(LS[(B . "0x2353C") ; <CJK>
       (?$(LS\(B . "0x2354D") ; <CJK>
       (?$(LS](B . "0x2354A") ; <CJK>
       (?$(LS^(B . "0x2F8E6") ; <CJK>
       (?$(LS_(B . "0x2358A") ; <CJK>
       (?$(LS`(B . "0x23546") ; <CJK>
       (?$(LSa(B . "0x2353E") ; <CJK>
       (?$(LSb(B . "0x23583") ; <CJK>
       (?$(LSc(B . "0x23550") ; <CJK>
       (?$(LSd(B . "0x235B4") ; <CJK>
       (?$(LSe(B . "0x238F0") ; <CJK>
       (?$(LSf(B . "0x238E4") ; <CJK>
       (?$(LSg(B . "0x238E3") ; <CJK>
       (?$(LSh(B . "0x238E5") ; <CJK>
       (?$(LSi(B . "0x238E6") ; <CJK>
       (?$(LSj(B . "0x238E7") ; <CJK>
       (?$(LSk(B . "0x238E1") ; <CJK>
       (?$(LSl(B . "0x238EF") ; <CJK>
       (?$(LSm(B . "0x238E8") ; <CJK>
       (?$(LSn(B . "0x238DD") ; <CJK>
       (?$(LSo(B . "0x23903") ; <CJK>
       (?$(LSp(B . "0x23988") ; <CJK>
       (?$(LSq(B . "0x23A26") ; <CJK>
       (?$(LSr(B . "0x23A16") ; <CJK>
       (?$(LSs(B . "0x23A3B") ; <CJK>
       (?$(LSt(B . "0x23A2F") ; <CJK>
       (?$(LSu(B . "0x23A39") ; <CJK>
       (?$(LSv(B . "0x23A34") ; <CJK>
       (?$(LSw(B . "0x2F8F4") ; <CJK>
       (?$(LSx(B . "0x23A35") ; <CJK>
       (?$(LSy(B . "0x23A31") ; <CJK>
       (?$(LSz(B . "0x23A38") ; <CJK>
       (?$(LS{(B . "0x20B81") ; <CJK>
       (?$(LS|(B . "0x23AAA") ; <CJK>
       (?$(LS}(B . "0x23AA3") ; <CJK>
       (?$(LS~(B . "0x23AA4") ; <CJK>
       (?$(LT!(B . "0x23AA0") ; <CJK>
       (?$(LT"(B . "0x23AA1") ; <CJK>
       (?$(LT#(B . "0x23AA9") ; <CJK>
       (?$(LT$(B . "0x23AA5") ; <CJK>
       (?$(LT%(B . "0x23BAF") ; <CJK>
       (?$(LT&(B . "0x23BB1") ; <CJK>
       (?$(LT'(B . "0x23BAB") ; <CJK>
       (?$(LT((B . "0x23BAE") ; <CJK>
       (?$(LT)(B . "0x23BB0") ; <CJK>
       (?$(LT*(B . "0x23BB3") ; <CJK>
       (?$(LT+(B . "0x23BAC") ; <CJK>
       (?$(LT,(B . "0x23BA9") ; <CJK>
       (?$(LT-(B . "0x23BB2") ; <CJK>
       (?$(LT.(B . "0x23BA8") ; <CJK>
       (?$(LT/(B . "0x23BB4") ; <CJK>
       (?$(LT0(B . "0x23BC2") ; <CJK>
       (?$(LT1(B . "0x23C4F") ; <CJK>
       (?$(LT2(B . "0x23C66") ; <CJK>
       (?$(LT3(B . "0x23E1E") ; <CJK>
       (?$(LT4(B . "0x23E15") ; <CJK>
       (?$(LT5(B . "0x23E10") ; <CJK>
       (?$(LT6(B . "0x23E7F") ; <CJK>
       (?$(LT7(B . "0x23E7E") ; <CJK>
       (?$(LT8(B . "0x23E60") ; <CJK>
       (?$(LT9(B . "0x23ECC") ; <CJK>
       (?$(LT:(B . "0x23EB2") ; <CJK>
       (?$(LT;(B . "0x23E62") ; <CJK>
       (?$(LT<(B . "0x23E8D") ; <CJK>
       (?$(LT=(B . "0x23E8E") ; <CJK>
       (?$(LT>(B . "0x23E77") ; <CJK>
       (?$(LT?(B . "0x23E7C") ; <CJK>
       (?$(LT@(B . "0x23E8F") ; <CJK>
       (?$(LTA(B . "0x23E5D") ; <CJK>
       (?$(LTB(B . "0x23E6D") ; <CJK>
       (?$(LTC(B . "0x23E63") ; <CJK>
       (?$(LTD(B . "0x23EAF") ; <CJK>
       (?$(LTE(B . "0x23E90") ; <CJK>
       (?$(LTF(B . "0x23E7D") ; <CJK>
       (?$(LTG(B . "0x23E7A") ; <CJK>
       (?$(LTH(B . "0x23E06") ; <CJK>
       (?$(LTI(B . "0x2F90B") ; <CJK>
       (?$(LTJ(B . "0x23E68") ; <CJK>
       (?$(LTK(B . "0x23EB4") ; <CJK>
       (?$(LTL(B . "0x23E78") ; <CJK>
       (?$(LTM(B . "0x23EB1") ; <CJK>
       (?$(LTN(B . "0x6ED7") ; <CJK>
       (?$(LTO(B . "0x2F90C") ; <CJK>
       (?$(LTP(B . "0x3D41") ; <CJK>
       (?$(LTQ(B . "0x242E8") ; <CJK>
       (?$(LTR(B . "0x242E9") ; <CJK>
       (?$(LTS(B . "0x242C0") ; <CJK>
       (?$(LTT(B . "0x3DD7") ; <CJK>
       (?$(LTU(B . "0x242EA") ; <CJK>
       (?$(LTV(B . "0x242B7") ; <CJK>
       (?$(LTW(B . "0x242BA") ; <CJK>
       (?$(LTX(B . "0x242B5") ; <CJK>
       (?$(LTY(B . "0x2F91D") ; <CJK>
       (?$(LTZ(B . "0x242B4") ; <CJK>
       (?$(LT[(B . "0x242BC") ; <CJK>
       (?$(LT\(B . "0x242C6") ; <CJK>
       (?$(LT](B . "0x242B8") ; <CJK>
       (?$(LT^(B . "0x242BD") ; <CJK>
       (?$(LT_(B . "0x242C2") ; <CJK>
       (?$(LT`(B . "0x2434D") ; <CJK>
       (?$(LTa(B . "0x242F0") ; <CJK>
       (?$(LTb(B . "0x242C7") ; <CJK>
       (?$(LTc(B . "0x242C1") ; <CJK>
       (?$(LTd(B . "0x242C3") ; <CJK>
       (?$(LTe(B . "0x242F1") ; <CJK>
       (?$(LTf(B . "0x242EC") ; <CJK>
       (?$(LTg(B . "0x3DE2") ; <CJK>
       (?$(LTh(B . "0x2451C") ; <CJK>
       (?$(LTi(B . "0x24520") ; <CJK>
       (?$(LTj(B . "0x24558") ; <CJK>
       (?$(LTk(B . "0x24565") ; <CJK>
       (?$(LTl(B . "0x24564") ; <CJK>
       (?$(LTm(B . "0x2458C") ; <CJK>
       (?$(LTn(B . "0x2458D") ; <CJK>
       (?$(LTo(B . "0x245D9") ; <CJK>
       (?$(LTp(B . "0x245E0") ; <CJK>
       (?$(LTq(B . "0x24610") ; <CJK>
       (?$(LTr(B . "0x24694") ; <CJK>
       (?$(LTs(B . "0x24692") ; <CJK>
       (?$(LTt(B . "0x24696") ; <CJK>
       (?$(LTu(B . "0x24695") ; <CJK>
       (?$(LTv(B . "0x246BF") ; <CJK>
       (?$(LTw(B . "0x246A0") ; <CJK>
       (?$(LTx(B . "0x3E45") ; <CJK>
       (?$(LTy(B . "0x247F4") ; <CJK>
       (?$(LTz(B . "0x247F6") ; <CJK>
       (?$(LT{(B . "0x247DC") ; <CJK>
       (?$(LT|(B . "0x733D") ; <CJK>
       (?$(LT}(B . "0x24816") ; <CJK>
       (?$(LT~(B . "0x24815") ; <CJK>
       (?$(LU!(B . "0x2481C") ; <CJK>
       (?$(LU"(B . "0x2480F") ; <CJK>
       (?$(LU#(B . "0x2482C") ; <CJK>
       (?$(LU$(B . "0x24814") ; <CJK>
       (?$(LU%(B . "0x24825") ; <CJK>
       (?$(LU&(B . "0x24817") ; <CJK>
       (?$(LU'(B . "0x24812") ; <CJK>
       (?$(LU((B . "0x2481E") ; <CJK>
       (?$(LU)(B . "0x24980") ; <CJK>
       (?$(LU*(B . "0x249A8") ; <CJK>
       (?$(LU+(B . "0x249AF") ; <CJK>
       (?$(LU,(B . "0x249D6") ; <CJK>
       (?$(LU-(B . "0x249E2") ; <CJK>
       (?$(LU.(B . "0x249B4") ; <CJK>
       (?$(LU/(B . "0x249B3") ; <CJK>
       (?$(LU0(B . "0x249B0") ; <CJK>
       (?$(LU1(B . "0x249B2") ; <CJK>
       (?$(LU2(B . "0x249A1") ; <CJK>
       (?$(LU3(B . "0x24B60") ; <CJK>
       (?$(LU4(B . "0x24B66") ; <CJK>
       (?$(LU5(B . "0x24B61") ; <CJK>
       (?$(LU6(B . "0x24B4E") ; <CJK>
       (?$(LU7(B . "0x24B5D") ; <CJK>
       (?$(LU8(B . "0x24B63") ; <CJK>
       (?$(LU9(B . "0x24BE6") ; <CJK>
       (?$(LU:(B . "0x24BEF") ; <CJK>
       (?$(LU;(B . "0x24BEC") ; <CJK>
       (?$(LU<(B . "0x24C98") ; <CJK>
       (?$(LU=(B . "0x24CA7") ; <CJK>
       (?$(LU>(B . "0x24C94") ; <CJK>
       (?$(LU?(B . "0x24C95") ; <CJK>
       (?$(LU@(B . "0x24C91") ; <CJK>
       (?$(LUA(B . "0x24C9D") ; <CJK>
       (?$(LUB(B . "0x24C99") ; <CJK>
       (?$(LUC(B . "0x24C9B") ; <CJK>
       (?$(LUD(B . "0x24C9C") ; <CJK>
       (?$(LUE(B . "0x24D1D") ; <CJK>
       (?$(LUF(B . "0x24D1C") ; <CJK>
       (?$(LUG(B . "0x24DD0") ; <CJK>
       (?$(LUH(B . "0x24DE0") ; <CJK>
       (?$(LUI(B . "0x24DCB") ; <CJK>
       (?$(LUJ(B . "0x24DDB") ; <CJK>
       (?$(LUK(B . "0x24DDA") ; <CJK>
       (?$(LUL(B . "0x24DC2") ; <CJK>
       (?$(LUM(B . "0x24DD3") ; <CJK>
       (?$(LUN(B . "0x24DE5") ; <CJK>
       (?$(LUO(B . "0x24F7D") ; <CJK>
       (?$(LUP(B . "0x24F7B") ; <CJK>
       (?$(LUQ(B . "0x24FFF") ; <CJK>
       (?$(LUR(B . "0x3FF2") ; <CJK>
       (?$(LUS(B . "0x24FF9") ; <CJK>
       (?$(LUT(B . "0x25077") ; <CJK>
       (?$(LUU(B . "0x2507C") ; <CJK>
       (?$(LUV(B . "0x25078") ; <CJK>
       (?$(LUW(B . "0x2507B") ; <CJK>
       (?$(LUX(B . "0x2507A") ; <CJK>
       (?$(LUY(B . "0x251D2") ; <CJK>
       (?$(LUZ(B . "0x251CB") ; <CJK>
       (?$(LU[(B . "0x251C9") ; <CJK>
       (?$(LU\(B . "0x251CE") ; <CJK>
       (?$(LU](B . "0x251E4") ; <CJK>
       (?$(LU^(B . "0x251CA") ; <CJK>
       (?$(LU_(B . "0x251D0") ; <CJK>
       (?$(LU`(B . "0x22FA5") ; <CJK>
       (?$(LUa(B . "0x4049") ; <CJK>
       (?$(LUb(B . "0x251D9") ; <CJK>
       (?$(LUc(B . "0x251EE") ; <CJK>
       (?$(LUd(B . "0x251DD") ; <CJK>
       (?$(LUe(B . "0x25200") ; <CJK>
       (?$(LUf(B . "0x251E1") ; <CJK>
       (?$(LUg(B . "0x253DE") ; <CJK>
       (?$(LUh(B . "0x253E2") ; <CJK>
       (?$(LUi(B . "0x253DA") ; <CJK>
       (?$(LUj(B . "0x254CE") ; <CJK>
       (?$(LUk(B . "0x2F94F") ; <CJK>
       (?$(LUl(B . "0x254CF") ; <CJK>
       (?$(LUm(B . "0x254DA") ; <CJK>
       (?$(LUn(B . "0x254D1") ; <CJK>
       (?$(LUo(B . "0x254D4") ; <CJK>
       (?$(LUp(B . "0x254ED") ; <CJK>
       (?$(LUq(B . "0x254CB") ; <CJK>
       (?$(LUr(B . "0x254D5") ; <CJK>
       (?$(LUs(B . "0x254F1") ; <CJK>
       (?$(LUt(B . "0x2569C") ; <CJK>
       (?$(LUu(B . "0x25688") ; <CJK>
       (?$(LUv(B . "0x25741") ; <CJK>
       (?$(LUw(B . "0x257D0") ; <CJK>
       (?$(LUx(B . "0x257F7") ; <CJK>
       (?$(LUy(B . "0x257CF") ; <CJK>
       (?$(LUz(B . "0x257D1") ; <CJK>
       (?$(LU{(B . "0x257DB") ; <CJK>
       (?$(LU|(B . "0x257DE") ; <CJK>
       (?$(LU}(B . "0x257F8") ; <CJK>
       (?$(LU~(B . "0x257DC") ; <CJK>
       (?$(LV!(B . "0x257D9") ; <CJK>
       (?$(LV"(B . "0x259A0") ; <CJK>
       (?$(LV#(B . "0x259B2") ; <CJK>
       (?$(LV$(B . "0x259A1") ; <CJK>
       (?$(LV%(B . "0x259AA") ; <CJK>
       (?$(LV&(B . "0x259A9") ; <CJK>
       (?$(LV'(B . "0x41A9") ; <CJK>
       (?$(LV((B . "0x259A6") ; <CJK>
       (?$(LV)(B . "0x2599C") ; <CJK>
       (?$(LV*(B . "0x259B5") ; <CJK>
       (?$(LV+(B . "0x259A7") ; <CJK>
       (?$(LV,(B . "0x25A8E") ; <CJK>
       (?$(LV-(B . "0x25A90") ; <CJK>
       (?$(LV.(B . "0x25A91") ; <CJK>
       (?$(LV/(B . "0x25B85") ; <CJK>
       (?$(LV0(B . "0x25B5B") ; <CJK>
       (?$(LV1(B . "0x25B70") ; <CJK>
       (?$(LV2(B . "0x25B64") ; <CJK>
       (?$(LV3(B . "0x25B67") ; <CJK>
       (?$(LV4(B . "0x25B63") ; <CJK>
       (?$(LV5(B . "0x25B77") ; <CJK>
       (?$(LV6(B . "0x25B68") ; <CJK>
       (?$(LV7(B . "0x25B65") ; <CJK>
       (?$(LV8(B . "0x25B6A") ; <CJK>
       (?$(LV9(B . "0x25B78") ; <CJK>
       (?$(LV:(B . "0x25B66") ; <CJK>
       (?$(LV;(B . "0x25E88") ; <CJK>
       (?$(LV<(B . "0x25E9E") ; <CJK>
       (?$(LV=(B . "0x25E74") ; <CJK>
       (?$(LV>(B . "0x25E7A") ; <CJK>
       (?$(LV?(B . "0x25E79") ; <CJK>
       (?$(LV@(B . "0x25E8B") ; <CJK>
       (?$(LVA(B . "0x25E7F") ; <CJK>
       (?$(LVB(B . "0x26013") ; <CJK>
       (?$(LVC(B . "0x2601E") ; <CJK>
       (?$(LVD(B . "0x26017") ; <CJK>
       (?$(LVE(B . "0x2601A") ; <CJK>
       (?$(LVF(B . "0x26022") ; <CJK>
       (?$(LVG(B . "0x26043") ; <CJK>
       (?$(LVH(B . "0x26019") ; <CJK>
       (?$(LVI(B . "0x2601F") ; <CJK>
       (?$(LVJ(B . "0x26027") ; <CJK>
       (?$(LVK(B . "0x26012") ; <CJK>
       (?$(LVL(B . "0x26024") ; <CJK>
       (?$(LVM(B . "0x26025") ; <CJK>
       (?$(LVN(B . "0x2035E") ; <CJK>
       (?$(LVO(B . "0x26235") ; <CJK>
       (?$(LVP(B . "0x26234") ; <CJK>
       (?$(LVQ(B . "0x262D1") ; <CJK>
       (?$(LVR(B . "0x262C4") ; <CJK>
       (?$(LVS(B . "0x262CA") ; <CJK>
       (?$(LVT(B . "0x262C6") ; <CJK>
       (?$(LVU(B . "0x262CB") ; <CJK>
       (?$(LVV(B . "0x262CD") ; <CJK>
       (?$(LVW(B . "0x262E2") ; <CJK>
       (?$(LVX(B . "0x26389") ; <CJK>
       (?$(LVY(B . "0x2638B") ; <CJK>
       (?$(LVZ(B . "0x26386") ; <CJK>
       (?$(LV[(B . "0x26388") ; <CJK>
       (?$(LV\(B . "0x2638D") ; <CJK>
       (?$(LV](B . "0x2643B") ; <CJK>
       (?$(LV^(B . "0x2643C") ; <CJK>
       (?$(LV_(B . "0x2643D") ; <CJK>
       (?$(LV`(B . "0x264F5") ; <CJK>
       (?$(LVa(B . "0x26579") ; <CJK>
       (?$(LVb(B . "0x26575") ; <CJK>
       (?$(LVc(B . "0x26582") ; <CJK>
       (?$(LVd(B . "0x2657F") ; <CJK>
       (?$(LVe(B . "0x26585") ; <CJK>
       (?$(LVf(B . "0x26576") ; <CJK>
       (?$(LVg(B . "0x2657C") ; <CJK>
       (?$(LVh(B . "0x2657E") ; <CJK>
       (?$(LVi(B . "0x2657B") ; <CJK>
       (?$(LVj(B . "0x26580") ; <CJK>
       (?$(LVk(B . "0x2657A") ; <CJK>
       (?$(LVl(B . "0x22548") ; <CJK>
       (?$(LVm(B . "0x43CB") ; <CJK>
       (?$(LVn(B . "0x2661D") ; <CJK>
       (?$(LVo(B . "0x266F6") ; <CJK>
       (?$(LVp(B . "0x266F7") ; <CJK>
       (?$(LVq(B . "0x266F9") ; <CJK>
       (?$(LVr(B . "0x26763") ; <CJK>
       (?$(LVs(B . "0x2676C") ; <CJK>
       (?$(LVt(B . "0x2676E") ; <CJK>
       (?$(LVu(B . "0x26714") ; <CJK>
       (?$(LVv(B . "0x440D") ; <CJK>
       (?$(LVw(B . "0x26767") ; <CJK>
       (?$(LVx(B . "0x2676F") ; <CJK>
       (?$(LVy(B . "0x26769") ; <CJK>
       (?$(LVz(B . "0x26776") ; <CJK>
       (?$(LV{(B . "0x26795") ; <CJK>
       (?$(LV|(B . "0x26771") ; <CJK>
       (?$(LV}(B . "0x26761") ; <CJK>
       (?$(LV~(B . "0x26778") ; <CJK>
       (?$(LW!(B . "0x2676B") ; <CJK>
       (?$(LW"(B . "0x26785") ; <CJK>
       (?$(LW#(B . "0x26784") ; <CJK>
       (?$(LW$(B . "0x26914") ; <CJK>
       (?$(LW%(B . "0x26976") ; <CJK>
       (?$(LW&(B . "0x259B6") ; <CJK>
       (?$(LW'(B . "0x26975") ; <CJK>
       (?$(LW((B . "0x26974") ; <CJK>
       (?$(LW)(B . "0x269E2") ; <CJK>
       (?$(LW*(B . "0x26A3F") ; <CJK>
       (?$(LW+(B . "0x26A44") ; <CJK>
       (?$(LW,(B . "0x26A3D") ; <CJK>
       (?$(LW-(B . "0x26A47") ; <CJK>
       (?$(LW.(B . "0x26A48") ; <CJK>
       (?$(LW/(B . "0x26ADB") ; <CJK>
       (?$(LW0(B . "0x26ADC") ; <CJK>
       (?$(LW1(B . "0x26ADD") ; <CJK>
       (?$(LW2(B . "0x26BE5") ; <CJK>
       (?$(LW3(B . "0x26BE6") ; <CJK>
       (?$(LW4(B . "0x26CC2") ; <CJK>
       (?$(LW5(B . "0x26D2E") ; <CJK>
       (?$(LW6(B . "0x26D1D") ; <CJK>
       (?$(LW7(B . "0x26CF8") ; <CJK>
       (?$(LW8(B . "0x26CF0") ; <CJK>
       (?$(LW9(B . "0x26CF6") ; <CJK>
       (?$(LW:(B . "0x26CC5") ; <CJK>
       (?$(LW;(B . "0x26CC6") ; <CJK>
       (?$(LW<(B . "0x26CFC") ; <CJK>
       (?$(LW=(B . "0x26D52") ; <CJK>
       (?$(LW>(B . "0x26D2F") ; <CJK>
       (?$(LW?(B . "0x26D10") ; <CJK>
       (?$(LW@(B . "0x26CF3") ; <CJK>
       (?$(LWA(B . "0x26CD2") ; <CJK>
       (?$(LWB(B . "0x26CEA") ; <CJK>
       (?$(LWC(B . "0x26CDC") ; <CJK>
       (?$(LWD(B . "0x26D1B") ; <CJK>
       (?$(LWE(B . "0x26CFB") ; <CJK>
       (?$(LWF(B . "0x26CC3") ; <CJK>
       (?$(LWG(B . "0x26D16") ; <CJK>
       (?$(LWH(B . "0x26D07") ; <CJK>
       (?$(LWI(B . "0x26CC9") ; <CJK>
       (?$(LWJ(B . "0x26CD8") ; <CJK>
       (?$(LWK(B . "0x26D30") ; <CJK>
       (?$(LWL(B . "0x26D13") ; <CJK>
       (?$(LWM(B . "0x26D31") ; <CJK>
       (?$(LWN(B . "0x26CFA") ; <CJK>
       (?$(LWO(B . "0x26CF2") ; <CJK>
       (?$(LWP(B . "0x26DE3") ; <CJK>
       (?$(LWQ(B . "0x26CD5") ; <CJK>
       (?$(LWR(B . "0x26D01") ; <CJK>
       (?$(LWS(B . "0x26CF1") ; <CJK>
       (?$(LWT(B . "0x26D1C") ; <CJK>
       (?$(LWU(B . "0x26CD6") ; <CJK>
       (?$(LWV(B . "0x26D08") ; <CJK>
       (?$(LWW(B . "0x26D0B") ; <CJK>
       (?$(LWX(B . "0x26D17") ; <CJK>
       (?$(LWY(B . "0x26D20") ; <CJK>
       (?$(LWZ(B . "0x26CCA") ; <CJK>
       (?$(LW[(B . "0x26D32") ; <CJK>
       (?$(LW\(B . "0x26D05") ; <CJK>
       (?$(LW](B . "0x26CE4") ; <CJK>
       (?$(LW^(B . "0x26CCE") ; <CJK>
       (?$(LW_(B . "0x26D33") ; <CJK>
       (?$(LW`(B . "0x26D02") ; <CJK>
       (?$(LWa(B . "0x26D19") ; <CJK>
       (?$(LWb(B . "0x26D1E") ; <CJK>
       (?$(LWc(B . "0x26CD3") ; <CJK>
       (?$(LWd(B . "0x26CF7") ; <CJK>
       (?$(LWe(B . "0x26CE8") ; <CJK>
       (?$(LWf(B . "0x26D1F") ; <CJK>
       (?$(LWg(B . "0x26CF4") ; <CJK>
       (?$(LWh(B . "0x26DD8") ; <CJK>
       (?$(LWi(B . "0x271BF") ; <CJK>
       (?$(LWj(B . "0x271BE") ; <CJK>
       (?$(LWk(B . "0x271BD") ; <CJK>
       (?$(LWl(B . "0x272DC") ; <CJK>
       (?$(LWm(B . "0x272DD") ; <CJK>
       (?$(LWn(B . "0x272AB") ; <CJK>
       (?$(LWo(B . "0x272C9") ; <CJK>
       (?$(LWp(B . "0x272C8") ; <CJK>
       (?$(LWq(B . "0x272DF") ; <CJK>
       (?$(LWr(B . "0x272D9") ; <CJK>
       (?$(LWs(B . "0x272DB") ; <CJK>
       (?$(LWt(B . "0x272CC") ; <CJK>
       (?$(LWu(B . "0x272E0") ; <CJK>
       (?$(LWv(B . "0x272EF") ; <CJK>
       (?$(LWw(B . "0x272F3") ; <CJK>
       (?$(LWx(B . "0x272AE") ; <CJK>
       (?$(LWy(B . "0x27301") ; <CJK>
       (?$(LWz(B . "0x275B7") ; <CJK>
       (?$(LW{(B . "0x275B9") ; <CJK>
       (?$(LW|(B . "0x275B6") ; <CJK>
       (?$(LW}(B . "0x275B8") ; <CJK>
       (?$(LW~(B . "0x275F6") ; <CJK>
       (?$(LX!(B . "0x275F3") ; <CJK>
       (?$(LX"(B . "0x275F5") ; <CJK>
       (?$(LX#(B . "0x275F2") ; <CJK>
       (?$(LX$(B . "0x27691") ; <CJK>
       (?$(LX%(B . "0x2769D") ; <CJK>
       (?$(LX&(B . "0x2769B") ; <CJK>
       (?$(LX'(B . "0x27692") ; <CJK>
       (?$(LX((B . "0x2768D") ; <CJK>
       (?$(LX)(B . "0x2769E") ; <CJK>
       (?$(LX*(B . "0x2768C") ; <CJK>
       (?$(LX+(B . "0x4631") ; <CJK>
       (?$(LX,(B . "0x2F9C7") ; <CJK>
       (?$(LX-(B . "0x27695") ; <CJK>
       (?$(LX.(B . "0x2F9C6") ; <CJK>
       (?$(LX/(B . "0x2768A") ; <CJK>
       (?$(LX0(B . "0x2768E") ; <CJK>
       (?$(LX1(B . "0x2769C") ; <CJK>
       (?$(LX2(B . "0x277EF") ; <CJK>
       (?$(LX3(B . "0x2782D") ; <CJK>
       (?$(LX4(B . "0x27852") ; <CJK>
       (?$(LX5(B . "0x27835") ; <CJK>
       (?$(LX6(B . "0x27828") ; <CJK>
       (?$(LX7(B . "0x2782E") ; <CJK>
       (?$(LX8(B . "0x278E5") ; <CJK>
       (?$(LX9(B . "0x279EA") ; <CJK>
       (?$(LX:(B . "0x279F1") ; <CJK>
       (?$(LX;(B . "0x279EB") ; <CJK>
       (?$(LX<(B . "0x279D8") ; <CJK>
       (?$(LX=(B . "0x279D0") ; <CJK>
       (?$(LX>(B . "0x279F3") ; <CJK>
       (?$(LX?(B . "0x279DB") ; <CJK>
       (?$(LX@(B . "0x279CE") ; <CJK>
       (?$(LXA(B . "0x46D5") ; <CJK>
       (?$(LXB(B . "0x279DA") ; <CJK>
       (?$(LXC(B . "0x279D7") ; <CJK>
       (?$(LXD(B . "0x279E1") ; <CJK>
       (?$(LXE(B . "0x279F2") ; <CJK>
       (?$(LXF(B . "0x279C8") ; <CJK>
       (?$(LXG(B . "0x279D9") ; <CJK>
       (?$(LXH(B . "0x279DE") ; <CJK>
       (?$(LXI(B . "0x279D1") ; <CJK>
       (?$(LXJ(B . "0x279E7") ; <CJK>
       (?$(LXK(B . "0x279CF") ; <CJK>
       (?$(LXL(B . "0x27BB7") ; <CJK>
       (?$(LXM(B . "0x27C47") ; <CJK>
       (?$(LXN(B . "0x27C42") ; <CJK>
       (?$(LXO(B . "0x27C43") ; <CJK>
       (?$(LXP(B . "0x2F9D3") ; <CJK>
       (?$(LXQ(B . "0x27CC3") ; <CJK>
       (?$(LXR(B . "0x27CC1") ; <CJK>
       (?$(LXS(B . "0x27CC7") ; <CJK>
       (?$(LXT(B . "0x27D64") ; <CJK>
       (?$(LXU(B . "0x27D6A") ; <CJK>
       (?$(LXV(B . "0x27D66") ; <CJK>
       (?$(LXW(B . "0x27D50") ; <CJK>
       (?$(LXX(B . "0x27D6E") ; <CJK>
       (?$(LXY(B . "0x27D65") ; <CJK>
       (?$(LXZ(B . "0x238EC") ; <CJK>
       (?$(LX[(B . "0x27D7F") ; <CJK>
       (?$(LX\(B . "0x2F9D5") ; <CJK>
       (?$(LX](B . "0x27D9A") ; <CJK>
       (?$(LX^(B . "0x27D69") ; <CJK>
       (?$(LX_(B . "0x27D72") ; <CJK>
       (?$(LX`(B . "0x27D6F") ; <CJK>
       (?$(LXa(B . "0x27D7D") ; <CJK>
       (?$(LXb(B . "0x27D70") ; <CJK>
       (?$(LXc(B . "0x27E60") ; <CJK>
       (?$(LXd(B . "0x27EC2") ; <CJK>
       (?$(LXe(B . "0x27EE7") ; <CJK>
       (?$(LXf(B . "0x27ED1") ; <CJK>
       (?$(LXg(B . "0x27EEB") ; <CJK>
       (?$(LXh(B . "0x27ED4") ; <CJK>
       (?$(LXi(B . "0x27EDC") ; <CJK>
       (?$(LXj(B . "0x27EDB") ; <CJK>
       (?$(LXk(B . "0x28037") ; <CJK>
       (?$(LXl(B . "0x28025") ; <CJK>
       (?$(LXm(B . "0x2801F") ; <CJK>
       (?$(LXn(B . "0x2801E") ; <CJK>
       (?$(LXo(B . "0x28021") ; <CJK>
       (?$(LXp(B . "0x2801B") ; <CJK>
       (?$(LXq(B . "0x28017") ; <CJK>
       (?$(LXr(B . "0x28022") ; <CJK>
       (?$(LXs(B . "0x2802A") ; <CJK>
       (?$(LXt(B . "0x2801A") ; <CJK>
       (?$(LXu(B . "0x2802D") ; <CJK>
       (?$(LXv(B . "0x28023") ; <CJK>
       (?$(LXw(B . "0x28026") ; <CJK>
       (?$(LXx(B . "0x28036") ; <CJK>
       (?$(LXy(B . "0x27FFF") ; <CJK>
       (?$(LXz(B . "0x2823A") ; <CJK>
       (?$(LX{(B . "0x28240") ; <CJK>
       (?$(LX|(B . "0x28242") ; <CJK>
       (?$(LX}(B . "0x28238") ; <CJK>
       (?$(LX~(B . "0x2823B") ; <CJK>
       (?$(LY!(B . "0x2823C") ; <CJK>
       (?$(LY"(B . "0x28243") ; <CJK>
       (?$(LY#(B . "0x282E8") ; <CJK>
       (?$(LY$(B . "0x4856") ; <CJK>
       (?$(LY%(B . "0x282F9") ; <CJK>
       (?$(LY&(B . "0x282EB") ; <CJK>
       (?$(LY'(B . "0x282F1") ; <CJK>
       (?$(LY((B . "0x282E9") ; <CJK>
       (?$(LY)(B . "0x282EC") ; <CJK>
       (?$(LY*(B . "0x28415") ; <CJK>
       (?$(LY+(B . "0x28447") ; <CJK>
       (?$(LY,(B . "0x28446") ; <CJK>
       (?$(LY-(B . "0x28445") ; <CJK>
       (?$(LY.(B . "0x28524") ; <CJK>
       (?$(LY/(B . "0x28556") ; <CJK>
       (?$(LY0(B . "0x28521") ; <CJK>
       (?$(LY1(B . "0x28527") ; <CJK>
       (?$(LY2(B . "0x2854D") ; <CJK>
       (?$(LY3(B . "0x28531") ; <CJK>
       (?$(LY4(B . "0x2851E") ; <CJK>
       (?$(LY5(B . "0x2852C") ; <CJK>
       (?$(LY6(B . "0x2854F") ; <CJK>
       (?$(LY7(B . "0x2852B") ; <CJK>
       (?$(LY8(B . "0x28553") ; <CJK>
       (?$(LY9(B . "0x28551") ; <CJK>
       (?$(LY:(B . "0x28554") ; <CJK>
       (?$(LY;(B . "0x28529") ; <CJK>
       (?$(LY<(B . "0x28550") ; <CJK>
       (?$(LY=(B . "0x2851F") ; <CJK>
       (?$(LY>(B . "0x28532") ; <CJK>
       (?$(LY?(B . "0x2852A") ; <CJK>
       (?$(LY@(B . "0x2851D") ; <CJK>
       (?$(LYA(B . "0x28528") ; <CJK>
       (?$(LYB(B . "0x2852E") ; <CJK>
       (?$(LYC(B . "0x2852D") ; <CJK>
       (?$(LYD(B . "0x286BC") ; <CJK>
       (?$(LYE(B . "0x286BB") ; <CJK>
       (?$(LYF(B . "0x286BD") ; <CJK>
       (?$(LYG(B . "0x2F9E4") ; <CJK>
       (?$(LYH(B . "0x28747") ; <CJK>
       (?$(LYI(B . "0x28741") ; <CJK>
       (?$(LYJ(B . "0x2F9E5") ; <CJK>
       (?$(LYK(B . "0x28749") ; <CJK>
       (?$(LYL(B . "0x48F4") ; <CJK>
       (?$(LYM(B . "0x2882E") ; <CJK>
       (?$(LYN(B . "0x28827") ; <CJK>
       (?$(LYO(B . "0x2896A") ; <CJK>
       (?$(LYP(B . "0x2897B") ; <CJK>
       (?$(LYQ(B . "0x28973") ; <CJK>
       (?$(LYR(B . "0x28975") ; <CJK>
       (?$(LYS(B . "0x28969") ; <CJK>
       (?$(LYT(B . "0x28979") ; <CJK>
       (?$(LYU(B . "0x28972") ; <CJK>
       (?$(LYV(B . "0x28C76") ; <CJK>
       (?$(LYW(B . "0x28C77") ; <CJK>
       (?$(LYX(B . "0x28C74") ; <CJK>
       (?$(LYY(B . "0x28C73") ; <CJK>
       (?$(LYZ(B . "0x28D02") ; <CJK>
       (?$(LY[(B . "0x28CFE") ; <CJK>
       (?$(LY\(B . "0x28D01") ; <CJK>
       (?$(LY](B . "0x28CF9") ; <CJK>
       (?$(LY^(B . "0x28CF4") ; <CJK>
       (?$(LY_(B . "0x28ED3") ; <CJK>
       (?$(LY`(B . "0x28ED5") ; <CJK>
       (?$(LYa(B . "0x28ED8") ; <CJK>
       (?$(LYb(B . "0x28EC3") ; <CJK>
       (?$(LYc(B . "0x28ECA") ; <CJK>
       (?$(LYd(B . "0x28ED0") ; <CJK>
       (?$(LYe(B . "0x28ECB") ; <CJK>
       (?$(LYf(B . "0x28ECE") ; <CJK>
       (?$(LYg(B . "0x28EC5") ; <CJK>
       (?$(LYh(B . "0x28EE6") ; <CJK>
       (?$(LYi(B . "0x28EC4") ; <CJK>
       (?$(LYj(B . "0x28EC0") ; <CJK>
       (?$(LYk(B . "0x28ED4") ; <CJK>
       (?$(LYl(B . "0x28EE8") ; <CJK>
       (?$(LYm(B . "0x28F76") ; <CJK>
       (?$(LYn(B . "0x28FA2") ; <CJK>
       (?$(LYo(B . "0x28FAE") ; <CJK>
       (?$(LYp(B . "0x28FA8") ; <CJK>
       (?$(LYq(B . "0x28FA3") ; <CJK>
       (?$(LYr(B . "0x28FA7") ; <CJK>
       (?$(LYs(B . "0x28F96") ; <CJK>
       (?$(LYt(B . "0x28FA9") ; <CJK>
       (?$(LYu(B . "0x28FA5") ; <CJK>
       (?$(LYv(B . "0x28FAF") ; <CJK>
       (?$(LYw(B . "0x28FA4") ; <CJK>
       (?$(LYx(B . "0x28FAB") ; <CJK>
       (?$(LYy(B . "0x28FAA") ; <CJK>
       (?$(LYz(B . "0x28FA6") ; <CJK>
       (?$(LY{(B . "0x28FA0") ; <CJK>
       (?$(LY|(B . "0x29098") ; <CJK>
       (?$(LY}(B . "0x291DB") ; <CJK>
       (?$(LY~(B . "0x291F6") ; <CJK>
       (?$(LZ!(B . "0x291F5") ; <CJK>
       (?$(LZ"(B . "0x2920C") ; <CJK>
       (?$(LZ#(B . "0x2920A") ; <CJK>
       (?$(LZ$(B . "0x9775") ; <CJK>
       (?$(LZ%(B . "0x29268") ; <CJK>
       (?$(LZ&(B . "0x29263") ; <CJK>
       (?$(LZ'(B . "0x29266") ; <CJK>
       (?$(LZ((B . "0x4A58") ; <CJK>
       (?$(LZ)(B . "0x29264") ; <CJK>
       (?$(LZ*(B . "0x2926A") ; <CJK>
       (?$(LZ+(B . "0x29269") ; <CJK>
       (?$(LZ,(B . "0x29395") ; <CJK>
       (?$(LZ-(B . "0x29402") ; <CJK>
       (?$(LZ.(B . "0x2946A") ; <CJK>
       (?$(LZ/(B . "0x2945E") ; <CJK>
       (?$(LZ0(B . "0x29468") ; <CJK>
       (?$(LZ1(B . "0x29469") ; <CJK>
       (?$(LZ2(B . "0x29465") ; <CJK>
       (?$(LZ3(B . "0x2F9FE") ; <CJK>
       (?$(LZ4(B . "0x295A7") ; <CJK>
       (?$(LZ5(B . "0x295AE") ; <CJK>
       (?$(LZ6(B . "0x295A8") ; <CJK>
       (?$(LZ7(B . "0x295B3") ; <CJK>
       (?$(LZ8(B . "0x2969C") ; <CJK>
       (?$(LZ9(B . "0x296A9") ; <CJK>
       (?$(LZ:(B . "0x296B6") ; <CJK>
       (?$(LZ;(B . "0x296B3") ; <CJK>
       (?$(LZ<(B . "0x296B2") ; <CJK>
       (?$(LZ=(B . "0x2FA03") ; <CJK>
       (?$(LZ>(B . "0x296B8") ; <CJK>
       (?$(LZ?(B . "0x296C0") ; <CJK>
       (?$(LZ@(B . "0x296BF") ; <CJK>
       (?$(LZA(B . "0x296BA") ; <CJK>
       (?$(LZB(B . "0x296A8") ; <CJK>
       (?$(LZC(B . "0x2983C") ; <CJK>
       (?$(LZD(B . "0x29872") ; <CJK>
       (?$(LZE(B . "0x29871") ; <CJK>
       (?$(LZF(B . "0x29875") ; <CJK>
       (?$(LZG(B . "0x29873") ; <CJK>
       (?$(LZH(B . "0x29A17") ; <CJK>
       (?$(LZI(B . "0x29A15") ; <CJK>
       (?$(LZJ(B . "0x29A16") ; <CJK>
       (?$(LZK(B . "0x29A1B") ; <CJK>
       (?$(LZL(B . "0x29AFA") ; <CJK>
       (?$(LZM(B . "0x29AF9") ; <CJK>
       (?$(LZN(B . "0x29C2C") ; <CJK>
       (?$(LZO(B . "0x29C85") ; <CJK>
       (?$(LZP(B . "0x29C82") ; <CJK>
       (?$(LZQ(B . "0x29C7F") ; <CJK>
       (?$(LZR(B . "0x29C7D") ; <CJK>
       (?$(LZS(B . "0x29C88") ; <CJK>
       (?$(LZT(B . "0x242F3") ; <CJK>
       (?$(LZU(B . "0x29D4E") ; <CJK>
       (?$(LZV(B . "0x29D50") ; <CJK>
       (?$(LZW(B . "0x29F93") ; <CJK>
       (?$(LZX(B . "0x29F97") ; <CJK>
       (?$(LZY(B . "0x29F98") ; <CJK>
       (?$(LZZ(B . "0x29F9B") ; <CJK>
       (?$(LZ[(B . "0x29F9C") ; <CJK>
       (?$(LZ\(B . "0x29F96") ; <CJK>
       (?$(LZ](B . "0x2A28B") ; <CJK>
       (?$(LZ^(B . "0x2A2FD") ; <CJK>
       (?$(LZ_(B . "0x2A2FC") ; <CJK>
       (?$(LZ`(B . "0x2FA17") ; <CJK>
       (?$(LZa(B . "0x2398B") ; <CJK>
       (?$(LZb(B . "0x20108") ; <CJK>
       (?$(LZc(B . "0x20107") ; <CJK>
       (?$(LZd(B . "0x20373") ; <CJK>
       (?$(LZe(B . "0x203A2") ; <CJK>
       (?$(LZf(B . "0x203AF") ; <CJK>
       (?$(LZg(B . "0x20382") ; <CJK>
       (?$(LZh(B . "0x2037B") ; <CJK>
       (?$(LZi(B . "0x20374") ; <CJK>
       (?$(LZj(B . "0x203B0") ; <CJK>
       (?$(LZk(B . "0x20376") ; <CJK>
       (?$(LZl(B . "0x203B9") ; <CJK>
       (?$(LZm(B . "0x2039E") ; <CJK>
       (?$(LZn(B . "0x203B1") ; <CJK>
       (?$(LZo(B . "0x203A1") ; <CJK>
       (?$(LZp(B . "0x203B2") ; <CJK>
       (?$(LZq(B . "0x2036E") ; <CJK>
       (?$(LZr(B . "0x2F80B") ; <CJK>
       (?$(LZs(B . "0x3487") ; <CJK>
       (?$(LZt(B . "0x20378") ; <CJK>
       (?$(LZu(B . "0x2037A") ; <CJK>
       (?$(LZv(B . "0x20383") ; <CJK>
       (?$(LZw(B . "0x2039A") ; <CJK>
       (?$(LZx(B . "0x204F8") ; <CJK>
       (?$(LZy(B . "0x20531") ; <CJK>
       (?$(LZz(B . "0x20569") ; <CJK>
       (?$(LZ{(B . "0x20568") ; <CJK>
       (?$(LZ|(B . "0x2059C") ; <CJK>
       (?$(LZ}(B . "0x20604") ; <CJK>
       (?$(LZ~(B . "0x20699") ; <CJK>
       (?$(L[!(B . "0x207C7") ; <CJK>
       (?$(L["(B . "0x207C6") ; <CJK>
       (?$(L[#(B . "0x207DC") ; <CJK>
       (?$(L[$(B . "0x207C4") ; <CJK>
       (?$(L[%(B . "0x207D8") ; <CJK>
       (?$(L[&(B . "0x207D4") ; <CJK>
       (?$(L['(B . "0x207DF") ; <CJK>
       (?$(L[((B . "0x207D1") ; <CJK>
       (?$(L[)(B . "0x207D0") ; <CJK>
       (?$(L[*(B . "0x207D6") ; <CJK>
       (?$(L[+(B . "0x207CF") ; <CJK>
       (?$(L[,(B . "0x208AD") ; <CJK>
       (?$(L[-(B . "0x208AF") ; <CJK>
       (?$(L[.(B . "0x208A7") ; <CJK>
       (?$(L[/(B . "0x208FD") ; <CJK>
       (?$(L[0(B . "0x2095B") ; <CJK>
       (?$(L[1(B . "0x2095A") ; <CJK>
       (?$(L[2(B . "0x20A07") ; <CJK>
       (?$(L[3(B . "0x20A9D") ; <CJK>
       (?$(L[4(B . "0x20A9B") ; <CJK>
       (?$(L[5(B . "0x20AAB") ; <CJK>
       (?$(L[6(B . "0x20AA4") ; <CJK>
       (?$(L[7(B . "0x20A9C") ; <CJK>
       (?$(L[8(B . "0x20A9E") ; <CJK>
       (?$(L[9(B . "0x20AA5") ; <CJK>
       (?$(L[:(B . "0x20AAA") ; <CJK>
       (?$(L[;(B . "0x20AA6") ; <CJK>
       (?$(L[<(B . "0x20B0E") ; <CJK>
       (?$(L[=(B . "0x20B7E") ; <CJK>
       (?$(L[>(B . "0x20B7C") ; <CJK>
       (?$(L[?(B . "0x20EEE") ; <CJK>
       (?$(L[@(B . "0x20ED5") ; <CJK>
       (?$(L[A(B . "0x20EE9") ; <CJK>
       (?$(L[B(B . "0x20E42") ; <CJK>
       (?$(L[C(B . "0x20EE2") ; <CJK>
       (?$(L[D(B . "0x20F23") ; <CJK>
       (?$(L[E(B . "0x20ED9") ; <CJK>
       (?$(L[F(B . "0x20ED4") ; <CJK>
       (?$(L[G(B . "0x20EE3") ; <CJK>
       (?$(L[H(B . "0x20F15") ; <CJK>
       (?$(L[I(B . "0x20EEF") ; <CJK>
       (?$(L[J(B . "0x20EF0") ; <CJK>
       (?$(L[K(B . "0x20ED6") ; <CJK>
       (?$(L[L(B . "0x20EDD") ; <CJK>
       (?$(L[M(B . "0x20EF6") ; <CJK>
       (?$(L[N(B . "0x20F1C") ; <CJK>
       (?$(L[O(B . "0x20ED8") ; <CJK>
       (?$(L[P(B . "0x20EDB") ; <CJK>
       (?$(L[Q(B . "0x20EDA") ; <CJK>
       (?$(L[R(B . "0x20EED") ; <CJK>
       (?$(L[S(B . "0x21411") ; <CJK>
       (?$(L[T(B . "0x21215") ; <CJK>
       (?$(L[U(B . "0x21218") ; <CJK>
       (?$(L[V(B . "0x2121A") ; <CJK>
       (?$(L[W(B . "0x2121F") ; <CJK>
       (?$(L[X(B . "0x21216") ; <CJK>
       (?$(L[Y(B . "0x2F84D") ; <CJK>
       (?$(L[Z(B . "0x21219") ; <CJK>
       (?$(L[[(B . "0x2F84B") ; <CJK>
       (?$(L[\(B . "0x213F0") ; <CJK>
       (?$(L[](B . "0x21409") ; <CJK>
       (?$(L[^(B . "0x2141B") ; <CJK>
       (?$(L[_(B . "0x27BE7") ; <CJK>
       (?$(L[`(B . "0x213F6") ; <CJK>
       (?$(L[a(B . "0x213F4") ; <CJK>
       (?$(L[b(B . "0x213B5") ; <CJK>
       (?$(L[c(B . "0x21410") ; <CJK>
       (?$(L[d(B . "0x213F2") ; <CJK>
       (?$(L[e(B . "0x21415") ; <CJK>
       (?$(L[f(B . "0x213F3") ; <CJK>
       (?$(L[g(B . "0x213F8") ; <CJK>
       (?$(L[h(B . "0x21539") ; <CJK>
       (?$(L[i(B . "0x2153B") ; <CJK>
       (?$(L[j(B . "0x21536") ; <CJK>
       (?$(L[k(B . "0x2140E") ; <CJK>
       (?$(L[l(B . "0x21572") ; <CJK>
       (?$(L[m(B . "0x21574") ; <CJK>
       (?$(L[n(B . "0x215B9") ; <CJK>
       (?$(L[o(B . "0x215B7") ; <CJK>
       (?$(L[p(B . "0x215B8") ; <CJK>
       (?$(L[q(B . "0x21672") ; <CJK>
       (?$(L[r(B . "0x2166B") ; <CJK>
       (?$(L[s(B . "0x2181D") ; <CJK>
       (?$(L[t(B . "0x21837") ; <CJK>
       (?$(L[u(B . "0x21822") ; <CJK>
       (?$(L[v(B . "0x21843") ; <CJK>
       (?$(L[w(B . "0x2184D") ; <CJK>
       (?$(L[x(B . "0x21838") ; <CJK>
       (?$(L[y(B . "0x2185B") ; <CJK>
       (?$(L[z(B . "0x21879") ; <CJK>
       (?$(L[{(B . "0x2181B") ; <CJK>
       (?$(L[|(B . "0x217F3") ; <CJK>
       (?$(L[}(B . "0x21991") ; <CJK>
       (?$(L[~(B . "0x21A7B") ; <CJK>
       (?$(L\!(B . "0x21A94") ; <CJK>
       (?$(L\"(B . "0x2F86F") ; <CJK>
       (?$(L\#(B . "0x21A96") ; <CJK>
       (?$(L\$(B . "0x21A7F") ; <CJK>
       (?$(L\%(B . "0x21A8F") ; <CJK>
       (?$(L\&(B . "0x21A84") ; <CJK>
       (?$(L\'(B . "0x21A7C") ; <CJK>
       (?$(L\((B . "0x21A8E") ; <CJK>
       (?$(L\)(B . "0x21A90") ; <CJK>
       (?$(L\*(B . "0x21A98") ; <CJK>
       (?$(L\+(B . "0x21A83") ; <CJK>
       (?$(L\,(B . "0x21A80") ; <CJK>
       (?$(L\-(B . "0x21A93") ; <CJK>
       (?$(L\.(B . "0x21A82") ; <CJK>
       (?$(L\/(B . "0x5900") ; <CJK>
       (?$(L\0(B . "0x21B3D") ; <CJK>
       (?$(L\1(B . "0x21B41") ; <CJK>
       (?$(L\2(B . "0x21BA1") ; <CJK>
       (?$(L\3(B . "0x21B9F") ; <CJK>
       (?$(L\4(B . "0x21C0A") ; <CJK>
       (?$(L\5(B . "0x21C0D") ; <CJK>
       (?$(L\6(B . "0x21CC8") ; <CJK>
       (?$(L\7(B . "0x21CC9") ; <CJK>
       (?$(L\8(B . "0x21CC7") ; <CJK>
       (?$(L\9(B . "0x21CCD") ; <CJK>
       (?$(L\:(B . "0x21D25") ; <CJK>
       (?$(L\;(B . "0x21EB1") ; <CJK>
       (?$(L\<(B . "0x21EDC") ; <CJK>
       (?$(L\=(B . "0x2F880") ; <CJK>
       (?$(L\>(B . "0x21EE5") ; <CJK>
       (?$(L\?(B . "0x21EF4") ; <CJK>
       (?$(L\@(B . "0x21EBF") ; <CJK>
       (?$(L\A(B . "0x21EDB") ; <CJK>
       (?$(L\B(B . "0x21EEA") ; <CJK>
       (?$(L\C(B . "0x21EF2") ; <CJK>
       (?$(L\D(B . "0x37FA") ; <CJK>
       (?$(L\E(B . "0x21EF1") ; <CJK>
       (?$(L\F(B . "0x21EED") ; <CJK>
       (?$(L\G(B . "0x21EE6") ; <CJK>
       (?$(L\H(B . "0x22002") ; <CJK>
       (?$(L\I(B . "0x2F882") ; <CJK>
       (?$(L\J(B . "0x22125") ; <CJK>
       (?$(L\K(B . "0x22118") ; <CJK>
       (?$(L\L(B . "0x2211F") ; <CJK>
       (?$(L\M(B . "0x22120") ; <CJK>
       (?$(L\N(B . "0x221CF") ; <CJK>
       (?$(L\O(B . "0x2229D") ; <CJK>
       (?$(L\P(B . "0x22299") ; <CJK>
       (?$(L\Q(B . "0x222A8") ; <CJK>
       (?$(L\R(B . "0x22368") ; <CJK>
       (?$(L\S(B . "0x22366") ; <CJK>
       (?$(L\T(B . "0x22367") ; <CJK>
       (?$(L\U(B . "0x22391") ; <CJK>
       (?$(L\V(B . "0x22413") ; <CJK>
       (?$(L\W(B . "0x22415") ; <CJK>
       (?$(L\X(B . "0x2241D") ; <CJK>
       (?$(L\Y(B . "0x22416") ; <CJK>
       (?$(L\Z(B . "0x22419") ; <CJK>
       (?$(L\[(B . "0x2246B") ; <CJK>
       (?$(L\\(B . "0x22468") ; <CJK>
       (?$(L\](B . "0x2246A") ; <CJK>
       (?$(L\^(B . "0x2246D") ; <CJK>
       (?$(L\_(B . "0x22469") ; <CJK>
       (?$(L\`(B . "0x224AA") ; <CJK>
       (?$(L\a(B . "0x22557") ; <CJK>
       (?$(L\b(B . "0x22552") ; <CJK>
       (?$(L\c(B . "0x22550") ; <CJK>
       (?$(L\d(B . "0x2255F") ; <CJK>
       (?$(L\e(B . "0x22567") ; <CJK>
       (?$(L\f(B . "0x2254F") ; <CJK>
       (?$(L\g(B . "0x38F2") ; <CJK>
       (?$(L\h(B . "0x2255B") ; <CJK>
       (?$(L\i(B . "0x2255C") ; <CJK>
       (?$(L\j(B . "0x2255D") ; <CJK>
       (?$(L\k(B . "0x2281F") ; <CJK>
       (?$(L\l(B . "0x2279D") ; <CJK>
       (?$(L\m(B . "0x227B1") ; <CJK>
       (?$(L\n(B . "0x227B0") ; <CJK>
       (?$(L\o(B . "0x22794") ; <CJK>
       (?$(L\p(B . "0x227C3") ; <CJK>
       (?$(L\q(B . "0x227AF") ; <CJK>
       (?$(L\r(B . "0x227A8") ; <CJK>
       (?$(L\s(B . "0x227DC") ; <CJK>
       (?$(L\t(B . "0x22798") ; <CJK>
       (?$(L\u(B . "0x227C4") ; <CJK>
       (?$(L\v(B . "0x227A4") ; <CJK>
       (?$(L\w(B . "0x227AB") ; <CJK>
       (?$(L\x(B . "0x227AA") ; <CJK>
       (?$(L\y(B . "0x227A5") ; <CJK>
       (?$(L\z(B . "0x22821") ; <CJK>
       (?$(L\{(B . "0x227EB") ; <CJK>
       (?$(L\|(B . "0x227E6") ; <CJK>
       (?$(L\}(B . "0x227F7") ; <CJK>
       (?$(L\~(B . "0x227F8") ; <CJK>
       (?$(L]!(B . "0x227FC") ; <CJK>
       (?$(L]"(B . "0x227FA") ; <CJK>
       (?$(L]#(B . "0x227E0") ; <CJK>
       (?$(L]$(B . "0x2F8AA") ; <CJK>
       (?$(L]%(B . "0x227F6") ; <CJK>
       (?$(L]&(B . "0x2F8A9") ; <CJK>
       (?$(L]'(B . "0x227E1") ; <CJK>
       (?$(L]((B . "0x229EC") ; <CJK>
       (?$(L])(B . "0x229E2") ; <CJK>
       (?$(L]*(B . "0x229E4") ; <CJK>
       (?$(L]+(B . "0x229F9") ; <CJK>
       (?$(L],(B . "0x22C6F") ; <CJK>
       (?$(L]-(B . "0x23A4C") ; <CJK>
       (?$(L].(B . "0x22CBB") ; <CJK>
       (?$(L]/(B . "0x22CE1") ; <CJK>
       (?$(L]0(B . "0x22D00") ; <CJK>
       (?$(L]1(B . "0x22CD8") ; <CJK>
       (?$(L]2(B . "0x3A2F") ; <CJK>
       (?$(L]3(B . "0x22CD6") ; <CJK>
       (?$(L]4(B . "0x22CE2") ; <CJK>
       (?$(L]5(B . "0x22CC3") ; <CJK>
       (?$(L]6(B . "0x22CB3") ; <CJK>
       (?$(L]7(B . "0x22CD2") ; <CJK>
       (?$(L]8(B . "0x2F8C1") ; <CJK>
       (?$(L]9(B . "0x22CCE") ; <CJK>
       (?$(L]:(B . "0x22CD0") ; <CJK>
       (?$(L];(B . "0x22CD5") ; <CJK>
       (?$(L]<(B . "0x22CB9") ; <CJK>
       (?$(L]=(B . "0x22CBA") ; <CJK>
       (?$(L]>(B . "0x22CCF") ; <CJK>
       (?$(L]?(B . "0x22CBD") ; <CJK>
       (?$(L]@(B . "0x22EDB") ; <CJK>
       (?$(L]A(B . "0x22FAA") ; <CJK>
       (?$(L]B(B . "0x22FAD") ; <CJK>
       (?$(L]C(B . "0x22FB8") ; <CJK>
       (?$(L]D(B . "0x22FB6") ; <CJK>
       (?$(L]E(B . "0x22FB5") ; <CJK>
       (?$(L]F(B . "0x22FAF") ; <CJK>
       (?$(L]G(B . "0x22FB4") ; <CJK>
       (?$(L]H(B . "0x22FB7") ; <CJK>
       (?$(L]I(B . "0x22FA8") ; <CJK>
       (?$(L]J(B . "0x22FB9") ; <CJK>
       (?$(L]K(B . "0x22FBE") ; <CJK>
       (?$(L]L(B . "0x23082") ; <CJK>
       (?$(L]M(B . "0x230BC") ; <CJK>
       (?$(L]N(B . "0x230B8") ; <CJK>
       (?$(L]O(B . "0x230B6") ; <CJK>
       (?$(L]P(B . "0x230B9") ; <CJK>
       (?$(L]Q(B . "0x3AC1") ; <CJK>
       (?$(L]R(B . "0x23110") ; <CJK>
       (?$(L]S(B . "0x23227") ; <CJK>
       (?$(L]T(B . "0x23269") ; <CJK>
       (?$(L]U(B . "0x23270") ; <CJK>
       (?$(L]V(B . "0x23256") ; <CJK>
       (?$(L]W(B . "0x2326B") ; <CJK>
       (?$(L]X(B . "0x2327A") ; <CJK>
       (?$(L]Y(B . "0x2326C") ; <CJK>
       (?$(L]Z(B . "0x2326D") ; <CJK>
       (?$(L][(B . "0x2F8D5") ; <CJK>
       (?$(L]\(B . "0x267C1") ; <CJK>
       (?$(L]](B . "0x2338D") ; <CJK>
       (?$(L]^(B . "0x23390") ; <CJK>
       (?$(L]_(B . "0x235B6") ; <CJK>
       (?$(L]`(B . "0x23610") ; <CJK>
       (?$(L]a(B . "0x23612") ; <CJK>
       (?$(L]b(B . "0x235BA") ; <CJK>
       (?$(L]c(B . "0x235BD") ; <CJK>
       (?$(L]d(B . "0x23605") ; <CJK>
       (?$(L]e(B . "0x235C2") ; <CJK>
       (?$(L]f(B . "0x23607") ; <CJK>
       (?$(L]g(B . "0x235F5") ; <CJK>
       (?$(L]h(B . "0x2F8E9") ; <CJK>
       (?$(L]i(B . "0x235AF") ; <CJK>
       (?$(L]j(B . "0x235F4") ; <CJK>
       (?$(L]k(B . "0x235F7") ; <CJK>
       (?$(L]l(B . "0x235F8") ; <CJK>
       (?$(L]m(B . "0x23611") ; <CJK>
       (?$(L]n(B . "0x238F6") ; <CJK>
       (?$(L]o(B . "0x238F5") ; <CJK>
       (?$(L]p(B . "0x238FB") ; <CJK>
       (?$(L]q(B . "0x23901") ; <CJK>
       (?$(L]r(B . "0x23900") ; <CJK>
       (?$(L]s(B . "0x23902") ; <CJK>
       (?$(L]t(B . "0x238FE") ; <CJK>
       (?$(L]u(B . "0x238FA") ; <CJK>
       (?$(L]v(B . "0x238FD") ; <CJK>
       (?$(L]w(B . "0x3C40") ; <CJK>
       (?$(L]x(B . "0x23A37") ; <CJK>
       (?$(L]y(B . "0x23A49") ; <CJK>
       (?$(L]z(B . "0x23A4B") ; <CJK>
       (?$(L]{(B . "0x23A46") ; <CJK>
       (?$(L]|(B . "0x23A47") ; <CJK>
       (?$(L]}(B . "0x23AB3") ; <CJK>
       (?$(L]~(B . "0x23AB2") ; <CJK>
       (?$(L^!(B . "0x23AB0") ; <CJK>
       (?$(L^"(B . "0x23AB7") ; <CJK>
       (?$(L^#(B . "0x23B11") ; <CJK>
       (?$(L^$(B . "0x23BCC") ; <CJK>
       (?$(L^%(B . "0x23BDF") ; <CJK>
       (?$(L^&(B . "0x23BD3") ; <CJK>
       (?$(L^'(B . "0x23BD5") ; <CJK>
       (?$(L^((B . "0x23BDB") ; <CJK>
       (?$(L^)(B . "0x23BC5") ; <CJK>
       (?$(L^*(B . "0x23BC8") ; <CJK>
       (?$(L^+(B . "0x23BC9") ; <CJK>
       (?$(L^,(B . "0x23BE2") ; <CJK>
       (?$(L^-(B . "0x23BCA") ; <CJK>
       (?$(L^.(B . "0x23BD1") ; <CJK>
       (?$(L^/(B . "0x23BD2") ; <CJK>
       (?$(L^0(B . "0x23BDD") ; <CJK>
       (?$(L^1(B . "0x23E6C") ; <CJK>
       (?$(L^2(B . "0x23E73") ; <CJK>
       (?$(L^3(B . "0x23F21") ; <CJK>
       (?$(L^4(B . "0x23EF0") ; <CJK>
       (?$(L^5(B . "0x23F1F") ; <CJK>
       (?$(L^6(B . "0x23F3B") ; <CJK>
       (?$(L^7(B . "0x23F22") ; <CJK>
       (?$(L^8(B . "0x23F23") ; <CJK>
       (?$(L^9(B . "0x23EE8") ; <CJK>
       (?$(L^:(B . "0x23EDD") ; <CJK>
       (?$(L^;(B . "0x3D3F") ; <CJK>
       (?$(L^<(B . "0x23F1B") ; <CJK>
       (?$(L^=(B . "0x23EED") ; <CJK>
       (?$(L^>(B . "0x2F90E") ; <CJK>
       (?$(L^?(B . "0x23EF2") ; <CJK>
       (?$(L^@(B . "0x3D46") ; <CJK>
       (?$(L^A(B . "0x23EDC") ; <CJK>
       (?$(L^B(B . "0x23EE9") ; <CJK>
       (?$(L^C(B . "0x23F1D") ; <CJK>
       (?$(L^D(B . "0x23EDA") ; <CJK>
       (?$(L^E(B . "0x23EE6") ; <CJK>
       (?$(L^F(B . "0x24313") ; <CJK>
       (?$(L^G(B . "0x24315") ; <CJK>
       (?$(L^H(B . "0x24316") ; <CJK>
       (?$(L^I(B . "0x2433C") ; <CJK>
       (?$(L^J(B . "0x2430B") ; <CJK>
       (?$(L^K(B . "0x2431C") ; <CJK>
       (?$(L^L(B . "0x2433A") ; <CJK>
       (?$(L^M(B . "0x2433D") ; <CJK>
       (?$(L^N(B . "0x2439A") ; <CJK>
       (?$(L^O(B . "0x2431D") ; <CJK>
       (?$(L^P(B . "0x24309") ; <CJK>
       (?$(L^Q(B . "0x24308") ; <CJK>
       (?$(L^R(B . "0x2433B") ; <CJK>
       (?$(L^S(B . "0x24522") ; <CJK>
       (?$(L^T(B . "0x24526") ; <CJK>
       (?$(L^U(B . "0x24525") ; <CJK>
       (?$(L^V(B . "0x24524") ; <CJK>
       (?$(L^W(B . "0x2039B") ; <CJK>
       (?$(L^X(B . "0x2458F") ; <CJK>
       (?$(L^Y(B . "0x24590") ; <CJK>
       (?$(L^Z(B . "0x245E6") ; <CJK>
       (?$(L^[(B . "0x245E3") ; <CJK>
       (?$(L^\(B . "0x245E5") ; <CJK>
       (?$(L^](B . "0x24611") ; <CJK>
       (?$(L^^(B . "0x2F925") ; <CJK>
       (?$(L^_(B . "0x246AE") ; <CJK>
       (?$(L^`(B . "0x246BE") ; <CJK>
       (?$(L^a(B . "0x246B4") ; <CJK>
       (?$(L^b(B . "0x246B3") ; <CJK>
       (?$(L^c(B . "0x246AF") ; <CJK>
       (?$(L^d(B . "0x24691") ; <CJK>
       (?$(L^e(B . "0x246C2") ; <CJK>
       (?$(L^f(B . "0x246B6") ; <CJK>
       (?$(L^g(B . "0x246B2") ; <CJK>
       (?$(L^h(B . "0x24857") ; <CJK>
       (?$(L^i(B . "0x2483B") ; <CJK>
       (?$(L^j(B . "0x24858") ; <CJK>
       (?$(L^k(B . "0x24851") ; <CJK>
       (?$(L^l(B . "0x24841") ; <CJK>
       (?$(L^m(B . "0x24839") ; <CJK>
       (?$(L^n(B . "0x3E8F") ; <CJK>
       (?$(L^o(B . "0x24859") ; <CJK>
       (?$(L^p(B . "0x24845") ; <CJK>
       (?$(L^q(B . "0x24861") ; <CJK>
       (?$(L^r(B . "0x248E8") ; <CJK>
       (?$(L^s(B . "0x249FA") ; <CJK>
       (?$(L^t(B . "0x249EA") ; <CJK>
       (?$(L^u(B . "0x249EF") ; <CJK>
       (?$(L^v(B . "0x249F2") ; <CJK>
       (?$(L^w(B . "0x249F0") ; <CJK>
       (?$(L^x(B . "0x24B08") ; <CJK>
       (?$(L^y(B . "0x24B70") ; <CJK>
       (?$(L^z(B . "0x24B6A") ; <CJK>
       (?$(L^{(B . "0x24B73") ; <CJK>
       (?$(L^|(B . "0x24B68") ; <CJK>
       (?$(L^}(B . "0x24BC8") ; <CJK>
       (?$(L^~(B . "0x24BF2") ; <CJK>
       (?$(L_!(B . "0x20B7B") ; <CJK>
       (?$(L_"(B . "0x24CAE") ; <CJK>
       (?$(L_#(B . "0x24CAB") ; <CJK>
       (?$(L_$(B . "0x24CB5") ; <CJK>
       (?$(L_%(B . "0x24CAF") ; <CJK>
       (?$(L_&(B . "0x24CB2") ; <CJK>
       (?$(L_'(B . "0x24CB6") ; <CJK>
       (?$(L_((B . "0x24CB0") ; <CJK>
       (?$(L_)(B . "0x24D1E") ; <CJK>
       (?$(L_*(B . "0x24E03") ; <CJK>
       (?$(L_+(B . "0x24E06") ; <CJK>
       (?$(L_,(B . "0x24E1F") ; <CJK>
       (?$(L_-(B . "0x3FAC") ; <CJK>
       (?$(L_.(B . "0x24E0F") ; <CJK>
       (?$(L_/(B . "0x24E02") ; <CJK>
       (?$(L_0(B . "0x24E19") ; <CJK>
       (?$(L_1(B . "0x24E18") ; <CJK>
       (?$(L_2(B . "0x24E22") ; <CJK>
       (?$(L_3(B . "0x24E15") ; <CJK>
       (?$(L_4(B . "0x24E07") ; <CJK>
       (?$(L_5(B . "0x24E0D") ; <CJK>
       (?$(L_6(B . "0x24E24") ; <CJK>
       (?$(L_7(B . "0x24E0C") ; <CJK>
       (?$(L_8(B . "0x24E1E") ; <CJK>
       (?$(L_9(B . "0x24F89") ; <CJK>
       (?$(L_:(B . "0x24F8A") ; <CJK>
       (?$(L_;(B . "0x2500A") ; <CJK>
       (?$(L_<(B . "0x2500B") ; <CJK>
       (?$(L_=(B . "0x25007") ; <CJK>
       (?$(L_>(B . "0x25004") ; <CJK>
       (?$(L_?(B . "0x25009") ; <CJK>
       (?$(L_@(B . "0x25084") ; <CJK>
       (?$(L_A(B . "0x25083") ; <CJK>
       (?$(L_B(B . "0x25218") ; <CJK>
       (?$(L_C(B . "0x25214") ; <CJK>
       (?$(L_D(B . "0x25205") ; <CJK>
       (?$(L_E(B . "0x25216") ; <CJK>
       (?$(L_F(B . "0x2520E") ; <CJK>
       (?$(L_G(B . "0x25211") ; <CJK>
       (?$(L_H(B . "0x25208") ; <CJK>
       (?$(L_I(B . "0x2520B") ; <CJK>
       (?$(L_J(B . "0x25215") ; <CJK>
       (?$(L_K(B . "0x25085") ; <CJK>
       (?$(L_L(B . "0x25237") ; <CJK>
       (?$(L_M(B . "0x2522A") ; <CJK>
       (?$(L_N(B . "0x2520D") ; <CJK>
       (?$(L_O(B . "0x2520F") ; <CJK>
       (?$(L_P(B . "0x2537E") ; <CJK>
       (?$(L_Q(B . "0x25376") ; <CJK>
       (?$(L_R(B . "0x25377") ; <CJK>
       (?$(L_S(B . "0x253EC") ; <CJK>
       (?$(L_T(B . "0x254FC") ; <CJK>
       (?$(L_U(B . "0x25508") ; <CJK>
       (?$(L_V(B . "0x254FF") ; <CJK>
       (?$(L_W(B . "0x25503") ; <CJK>
       (?$(L_X(B . "0x25510") ; <CJK>
       (?$(L_Y(B . "0x25505") ; <CJK>
       (?$(L_Z(B . "0x25506") ; <CJK>
       (?$(L_[(B . "0x254FA") ; <CJK>
       (?$(L_\(B . "0x256C7") ; <CJK>
       (?$(L_](B . "0x256C0") ; <CJK>
       (?$(L_^(B . "0x256C3") ; <CJK>
       (?$(L__(B . "0x256A7") ; <CJK>
       (?$(L_`(B . "0x256A8") ; <CJK>
       (?$(L_a(B . "0x256AB") ; <CJK>
       (?$(L_b(B . "0x256C1") ; <CJK>
       (?$(L_c(B . "0x256AA") ; <CJK>
       (?$(L_d(B . "0x256C8") ; <CJK>
       (?$(L_e(B . "0x25743") ; <CJK>
       (?$(L_f(B . "0x25802") ; <CJK>
       (?$(L_g(B . "0x2580E") ; <CJK>
       (?$(L_h(B . "0x25801") ; <CJK>
       (?$(L_i(B . "0x257FE") ; <CJK>
       (?$(L_j(B . "0x25803") ; <CJK>
       (?$(L_k(B . "0x4168") ; <CJK>
       (?$(L_l(B . "0x25822") ; <CJK>
       (?$(L_m(B . "0x25821") ; <CJK>
       (?$(L_n(B . "0x25807") ; <CJK>
       (?$(L_o(B . "0x25808") ; <CJK>
       (?$(L_p(B . "0x2580C") ; <CJK>
       (?$(L_q(B . "0x259CA") ; <CJK>
       (?$(L_r(B . "0x259BC") ; <CJK>
       (?$(L_s(B . "0x259BE") ; <CJK>
       (?$(L_t(B . "0x259BD") ; <CJK>
       (?$(L_u(B . "0x2F95C") ; <CJK>
       (?$(L_v(B . "0x259BB") ; <CJK>
       (?$(L_w(B . "0x259B9") ; <CJK>
       (?$(L_x(B . "0x41AB") ; <CJK>
       (?$(L_y(B . "0x259C5") ; <CJK>
       (?$(L_z(B . "0x25A99") ; <CJK>
       (?$(L_{(B . "0x25B6B") ; <CJK>
       (?$(L_|(B . "0x25B93") ; <CJK>
       (?$(L_}(B . "0x25B94") ; <CJK>
       (?$(L_~(B . "0x25BA9") ; <CJK>
       (?$(L`!(B . "0x25BA0") ; <CJK>
       (?$(L`"(B . "0x25BA6") ; <CJK>
       (?$(L`#(B . "0x2F961") ; <CJK>
       (?$(L`$(B . "0x25BAB") ; <CJK>
       (?$(L`%(B . "0x25B9E") ; <CJK>
       (?$(L`&(B . "0x25B9B") ; <CJK>
       (?$(L`'(B . "0x25B91") ; <CJK>
       (?$(L`((B . "0x25B99") ; <CJK>
       (?$(L`)(B . "0x25EB6") ; <CJK>
       (?$(L`*(B . "0x25EB8") ; <CJK>
       (?$(L`+(B . "0x25E9A") ; <CJK>
       (?$(L`,(B . "0x4291") ; <CJK>
       (?$(L`-(B . "0x25E98") ; <CJK>
       (?$(L`.(B . "0x25E9B") ; <CJK>
       (?$(L`/(B . "0x25EB3") ; <CJK>
       (?$(L`0(B . "0x25EA2") ; <CJK>
       (?$(L`1(B . "0x222AA") ; <CJK>
       (?$(L`2(B . "0x25EA0") ; <CJK>
       (?$(L`3(B . "0x25E9F") ; <CJK>
       (?$(L`4(B . "0x2605B") ; <CJK>
       (?$(L`5(B . "0x26070") ; <CJK>
       (?$(L`6(B . "0x26054") ; <CJK>
       (?$(L`7(B . "0x26071") ; <CJK>
       (?$(L`8(B . "0x26065") ; <CJK>
       (?$(L`9(B . "0x26051") ; <CJK>
       (?$(L`:(B . "0x2609D") ; <CJK>
       (?$(L`;(B . "0x26061") ; <CJK>
       (?$(L`<(B . "0x2605A") ; <CJK>
       (?$(L`=(B . "0x26074") ; <CJK>
       (?$(L`>(B . "0x2604C") ; <CJK>
       (?$(L`?(B . "0x2604B") ; <CJK>
       (?$(L`@(B . "0x2605E") ; <CJK>
       (?$(L`A(B . "0x26058") ; <CJK>
       (?$(L`B(B . "0x26053") ; <CJK>
       (?$(L`C(B . "0x26052") ; <CJK>
       (?$(L`D(B . "0x2623B") ; <CJK>
       (?$(L`E(B . "0x26239") ; <CJK>
       (?$(L`F(B . "0x262D6") ; <CJK>
       (?$(L`G(B . "0x262E7") ; <CJK>
       (?$(L`H(B . "0x262D7") ; <CJK>
       (?$(L`I(B . "0x262D8") ; <CJK>
       (?$(L`J(B . "0x262D9") ; <CJK>
       (?$(L`K(B . "0x262DA") ; <CJK>
       (?$(L`L(B . "0x262DB") ; <CJK>
       (?$(L`M(B . "0x262DC") ; <CJK>
       (?$(L`N(B . "0x262E0") ; <CJK>
       (?$(L`O(B . "0x262E4") ; <CJK>
       (?$(L`P(B . "0x262DD") ; <CJK>
       (?$(L`Q(B . "0x262F5") ; <CJK>
       (?$(L`R(B . "0x262F1") ; <CJK>
       (?$(L`S(B . "0x26398") ; <CJK>
       (?$(L`T(B . "0x2639D") ; <CJK>
       (?$(L`U(B . "0x26399") ; <CJK>
       (?$(L`V(B . "0x26450") ; <CJK>
       (?$(L`W(B . "0x26449") ; <CJK>
       (?$(L`X(B . "0x7FE4") ; <CJK>
       (?$(L`Y(B . "0x26462") ; <CJK>
       (?$(L`Z(B . "0x264D7") ; <CJK>
       (?$(L`[(B . "0x26501") ; <CJK>
       (?$(L`\(B . "0x264F7") ; <CJK>
       (?$(L`](B . "0x2F97D") ; <CJK>
       (?$(L`^(B . "0x2658C") ; <CJK>
       (?$(L`_(B . "0x2659C") ; <CJK>
       (?$(L``(B . "0x8088") ; <CJK>
       (?$(L`a(B . "0x2661F") ; <CJK>
       (?$(L`b(B . "0x2661E") ; <CJK>
       (?$(L`c(B . "0x2673D") ; <CJK>
       (?$(L`d(B . "0x2673F") ; <CJK>
       (?$(L`e(B . "0x26711") ; <CJK>
       (?$(L`f(B . "0x26759") ; <CJK>
       (?$(L`g(B . "0x2673E") ; <CJK>
       (?$(L`h(B . "0x26758") ; <CJK>
       (?$(L`i(B . "0x26800") ; <CJK>
       (?$(L`j(B . "0x2679E") ; <CJK>
       (?$(L`k(B . "0x267B6") ; <CJK>
       (?$(L`l(B . "0x267AA") ; <CJK>
       (?$(L`m(B . "0x267AF") ; <CJK>
       (?$(L`n(B . "0x267AC") ; <CJK>
       (?$(L`o(B . "0x4430") ; <CJK>
       (?$(L`p(B . "0x267C0") ; <CJK>
       (?$(L`q(B . "0x267A9") ; <CJK>
       (?$(L`r(B . "0x20B10") ; <CJK>
       (?$(L`s(B . "0x268EE") ; <CJK>
       (?$(L`t(B . "0x26977") ; <CJK>
       (?$(L`u(B . "0x26979") ; <CJK>
       (?$(L`v(B . "0x2697A") ; <CJK>
       (?$(L`w(B . "0x2697D") ; <CJK>
       (?$(L`x(B . "0x2697F") ; <CJK>
       (?$(L`y(B . "0x26983") ; <CJK>
       (?$(L`z(B . "0x26978") ; <CJK>
       (?$(L`{(B . "0x2697E") ; <CJK>
       (?$(L`|(B . "0x269E4") ; <CJK>
       (?$(L`}(B . "0x269E6") ; <CJK>
       (?$(L`~(B . "0x269E5") ; <CJK>
       (?$(La!(B . "0x445D") ; <CJK>
       (?$(La"(B . "0x26A4E") ; <CJK>
       (?$(La#(B . "0x26A59") ; <CJK>
       (?$(La$(B . "0x4475") ; <CJK>
       (?$(La%(B . "0x2F98E") ; <CJK>
       (?$(La&(B . "0x26A4F") ; <CJK>
       (?$(La'(B . "0x26A4A") ; <CJK>
       (?$(La((B . "0x26AE3") ; <CJK>
       (?$(La)(B . "0x26ADE") ; <CJK>
       (?$(La*(B . "0x26AE2") ; <CJK>
       (?$(La+(B . "0x26C74") ; <CJK>
       (?$(La,(B . "0x26CAC") ; <CJK>
       (?$(La-(B . "0x26C61") ; <CJK>
       (?$(La.(B . "0x26C62") ; <CJK>
       (?$(La/(B . "0x26C76") ; <CJK>
       (?$(La0(B . "0x26C7A") ; <CJK>
       (?$(La1(B . "0x26C79") ; <CJK>
       (?$(La2(B . "0x26C60") ; <CJK>
       (?$(La3(B . "0x26D64") ; <CJK>
       (?$(La4(B . "0x26E81") ; <CJK>
       (?$(La5(B . "0x26DDF") ; <CJK>
       (?$(La6(B . "0x26D84") ; <CJK>
       (?$(La7(B . "0x26D8A") ; <CJK>
       (?$(La8(B . "0x26D92") ; <CJK>
       (?$(La9(B . "0x26D79") ; <CJK>
       (?$(La:(B . "0x26DDE") ; <CJK>
       (?$(La;(B . "0x26D98") ; <CJK>
       (?$(La<(B . "0x26D6C") ; <CJK>
       (?$(La=(B . "0x26DE1") ; <CJK>
       (?$(La>(B . "0x2F9A5") ; <CJK>
       (?$(La?(B . "0x26D7C") ; <CJK>
       (?$(La@(B . "0x26D72") ; <CJK>
       (?$(LaA(B . "0x26D81") ; <CJK>
       (?$(LaB(B . "0x26DE0") ; <CJK>
       (?$(LaC(B . "0x26D65") ; <CJK>
       (?$(LaD(B . "0x44FF") ; <CJK>
       (?$(LaE(B . "0x26D6A") ; <CJK>
       (?$(LaF(B . "0x26D97") ; <CJK>
       (?$(LaG(B . "0x26DAA") ; <CJK>
       (?$(LaH(B . "0x26DD3") ; <CJK>
       (?$(LaI(B . "0x26DAB") ; <CJK>
       (?$(LaJ(B . "0x26D6E") ; <CJK>
       (?$(LaK(B . "0x26DAC") ; <CJK>
       (?$(LaL(B . "0x26D76") ; <CJK>
       (?$(LaM(B . "0x26D7B") ; <CJK>
       (?$(LaN(B . "0x26DAD") ; <CJK>
       (?$(LaO(B . "0x2F9A6") ; <CJK>
       (?$(LaP(B . "0x26D94") ; <CJK>
       (?$(LaQ(B . "0x26DD7") ; <CJK>
       (?$(LaR(B . "0x26D70") ; <CJK>
       (?$(LaS(B . "0x26DD5") ; <CJK>
       (?$(LaT(B . "0x26DF1") ; <CJK>
       (?$(LaU(B . "0x26D7A") ; <CJK>
       (?$(LaV(B . "0x26D68") ; <CJK>
       (?$(LaW(B . "0x26D96") ; <CJK>
       (?$(LaX(B . "0x450B") ; <CJK>
       (?$(LaY(B . "0x26D73") ; <CJK>
       (?$(LaZ(B . "0x26DAE") ; <CJK>
       (?$(La[(B . "0x26DDD") ; <CJK>
       (?$(La\(B . "0x26DDA") ; <CJK>
       (?$(La](B . "0x26DAF") ; <CJK>
       (?$(La^(B . "0x26DB0") ; <CJK>
       (?$(La_(B . "0x26DDB") ; <CJK>
       (?$(La`(B . "0x26D62") ; <CJK>
       (?$(Laa(B . "0x26DF8") ; <CJK>
       (?$(Lab(B . "0x271C2") ; <CJK>
       (?$(Lac(B . "0x271C7") ; <CJK>
       (?$(Lad(B . "0x271C8") ; <CJK>
       (?$(Lae(B . "0x271C5") ; <CJK>
       (?$(Laf(B . "0x271C3") ; <CJK>
       (?$(Lag(B . "0x271C6") ; <CJK>
       (?$(Lah(B . "0x272DE") ; <CJK>
       (?$(Lai(B . "0x45C8") ; <CJK>
       (?$(Laj(B . "0x27311") ; <CJK>
       (?$(Lak(B . "0x27315") ; <CJK>
       (?$(Lal(B . "0x27328") ; <CJK>
       (?$(Lam(B . "0x27321") ; <CJK>
       (?$(Lan(B . "0x2732D") ; <CJK>
       (?$(Lao(B . "0x27351") ; <CJK>
       (?$(Lap(B . "0x2732B") ; <CJK>
       (?$(Laq(B . "0x27316") ; <CJK>
       (?$(Lar(B . "0x27324") ; <CJK>
       (?$(Las(B . "0x27335") ; <CJK>
       (?$(Lat(B . "0x2731F") ; <CJK>
       (?$(Lau(B . "0x27312") ; <CJK>
       (?$(Lav(B . "0x27310") ; <CJK>
       (?$(Law(B . "0x27380") ; <CJK>
       (?$(Lax(B . "0x2733B") ; <CJK>
       (?$(Lay(B . "0x27329") ; <CJK>
       (?$(Laz(B . "0x2732A") ; <CJK>
       (?$(La{(B . "0x2731B") ; <CJK>
       (?$(La|(B . "0x27318") ; <CJK>
       (?$(La}(B . "0x27320") ; <CJK>
       (?$(La~(B . "0x2733F") ; <CJK>
       (?$(Lb!(B . "0x2731C") ; <CJK>
       (?$(Lb"(B . "0x27326") ; <CJK>
       (?$(Lb#(B . "0x2730B") ; <CJK>
       (?$(Lb$(B . "0x275BE") ; <CJK>
       (?$(Lb%(B . "0x275C4") ; <CJK>
       (?$(Lb&(B . "0x275BD") ; <CJK>
       (?$(Lb'(B . "0x275FA") ; <CJK>
       (?$(Lb((B . "0x275FB") ; <CJK>
       (?$(Lb)(B . "0x276B1") ; <CJK>
       (?$(Lb*(B . "0x276B2") ; <CJK>
       (?$(Lb+(B . "0x276B0") ; <CJK>
       (?$(Lb,(B . "0x276B9") ; <CJK>
       (?$(Lb-(B . "0x276A6") ; <CJK>
       (?$(Lb.(B . "0x276BD") ; <CJK>
       (?$(Lb/(B . "0x276B6") ; <CJK>
       (?$(Lb0(B . "0x276B8") ; <CJK>
       (?$(Lb1(B . "0x276B4") ; <CJK>
       (?$(Lb2(B . "0x276B3") ; <CJK>
       (?$(Lb3(B . "0x276A7") ; <CJK>
       (?$(Lb4(B . "0x276AE") ; <CJK>
       (?$(Lb5(B . "0x276BC") ; <CJK>
       (?$(Lb6(B . "0x277F2") ; <CJK>
       (?$(Lb7(B . "0x277F3") ; <CJK>
       (?$(Lb8(B . "0x277F4") ; <CJK>
       (?$(Lb9(B . "0x2783B") ; <CJK>
       (?$(Lb:(B . "0x27840") ; <CJK>
       (?$(Lb;(B . "0x27846") ; <CJK>
       (?$(Lb<(B . "0x278F0") ; <CJK>
       (?$(Lb=(B . "0x278EE") ; <CJK>
       (?$(Lb>(B . "0x278E8") ; <CJK>
       (?$(Lb?(B . "0x278F1") ; <CJK>
       (?$(Lb@(B . "0x278EB") ; <CJK>
       (?$(LbA(B . "0x278EF") ; <CJK>
       (?$(LbB(B . "0x279FC") ; <CJK>
       (?$(LbC(B . "0x27A20") ; <CJK>
       (?$(LbD(B . "0x27A09") ; <CJK>
       (?$(LbE(B . "0x27A06") ; <CJK>
       (?$(LbF(B . "0x27A03") ; <CJK>
       (?$(LbG(B . "0x2F9CF") ; <CJK>
       (?$(LbH(B . "0x27A19") ; <CJK>
       (?$(LbI(B . "0x27A24") ; <CJK>
       (?$(LbJ(B . "0x27A1B") ; <CJK>
       (?$(LbK(B . "0x27A1D") ; <CJK>
       (?$(LbL(B . "0x279FD") ; <CJK>
       (?$(LbM(B . "0x27A1E") ; <CJK>
       (?$(LbN(B . "0x279F4") ; <CJK>
       (?$(LbO(B . "0x27A01") ; <CJK>
       (?$(LbP(B . "0x27A08") ; <CJK>
       (?$(LbQ(B . "0x27A05") ; <CJK>
       (?$(LbR(B . "0x27A23") ; <CJK>
       (?$(LbS(B . "0x279FF") ; <CJK>
       (?$(LbT(B . "0x27BEA") ; <CJK>
       (?$(LbU(B . "0x27C4D") ; <CJK>
       (?$(LbV(B . "0x27C4E") ; <CJK>
       (?$(LbW(B . "0x27C56") ; <CJK>
       (?$(LbX(B . "0x27C57") ; <CJK>
       (?$(LbY(B . "0x27C51") ; <CJK>
       (?$(LbZ(B . "0x27C55") ; <CJK>
       (?$(Lb[(B . "0x27C54") ; <CJK>
       (?$(Lb\(B . "0x27CCB") ; <CJK>
       (?$(Lb](B . "0x27CD4") ; <CJK>
       (?$(Lb^(B . "0x27CD1") ; <CJK>
       (?$(Lb_(B . "0x27CCF") ; <CJK>
       (?$(Lb`(B . "0x27CD2") ; <CJK>
       (?$(Lba(B . "0x27CCA") ; <CJK>
       (?$(Lbb(B . "0x27CD6") ; <CJK>
       (?$(Lbc(B . "0x27D8B") ; <CJK>
       (?$(Lbd(B . "0x27D88") ; <CJK>
       (?$(Lbe(B . "0x27D85") ; <CJK>
       (?$(Lbf(B . "0x27D89") ; <CJK>
       (?$(Lbg(B . "0x21A9B") ; <CJK>
       (?$(Lbh(B . "0x27DBB") ; <CJK>
       (?$(Lbi(B . "0x27D8C") ; <CJK>
       (?$(Lbj(B . "0x4774") ; <CJK>
       (?$(Lbk(B . "0x27D99") ; <CJK>
       (?$(Lbl(B . "0x27D8A") ; <CJK>
       (?$(Lbm(B . "0x27EEC") ; <CJK>
       (?$(Lbn(B . "0x27EEF") ; <CJK>
       (?$(Lbo(B . "0x27EF9") ; <CJK>
       (?$(Lbp(B . "0x27F09") ; <CJK>
       (?$(Lbq(B . "0x27EF8") ; <CJK>
       (?$(Lbr(B . "0x27EF3") ; <CJK>
       (?$(Lbs(B . "0x27F00") ; <CJK>
       (?$(Lbt(B . "0x27F1D") ; <CJK>
       (?$(Lbu(B . "0x47AC") ; <CJK>
       (?$(Lbv(B . "0x27EFD") ; <CJK>
       (?$(Lbw(B . "0x28048") ; <CJK>
       (?$(Lbx(B . "0x2805C") ; <CJK>
       (?$(Lby(B . "0x28055") ; <CJK>
       (?$(Lbz(B . "0x2805E") ; <CJK>
       (?$(Lb{(B . "0x28049") ; <CJK>
       (?$(Lb|(B . "0x28063") ; <CJK>
       (?$(Lb}(B . "0x28060") ; <CJK>
       (?$(Lb~(B . "0x28053") ; <CJK>
       (?$(Lc!(B . "0x28062") ; <CJK>
       (?$(Lc"(B . "0x28040") ; <CJK>
       (?$(Lc#(B . "0x28249") ; <CJK>
       (?$(Lc$(B . "0x2824A") ; <CJK>
       (?$(Lc%(B . "0x2824C") ; <CJK>
       (?$(Lc&(B . "0x2824D") ; <CJK>
       (?$(Lc'(B . "0x2830A") ; <CJK>
       (?$(Lc((B . "0x28306") ; <CJK>
       (?$(Lc)(B . "0x2832F") ; <CJK>
       (?$(Lc*(B . "0x28321") ; <CJK>
       (?$(Lc+(B . "0x28307") ; <CJK>
       (?$(Lc,(B . "0x28309") ; <CJK>
       (?$(Lc-(B . "0x28302") ; <CJK>
       (?$(Lc.(B . "0x28316") ; <CJK>
       (?$(Lc/(B . "0x28303") ; <CJK>
       (?$(Lc0(B . "0x2830B") ; <CJK>
       (?$(Lc1(B . "0x2830F") ; <CJK>
       (?$(Lc2(B . "0x28560") ; <CJK>
       (?$(Lc3(B . "0x28568") ; <CJK>
       (?$(Lc4(B . "0x2855E") ; <CJK>
       (?$(Lc5(B . "0x2855D") ; <CJK>
       (?$(Lc6(B . "0x28563") ; <CJK>
       (?$(Lc7(B . "0x2855F") ; <CJK>
       (?$(Lc8(B . "0x28564") ; <CJK>
       (?$(Lc9(B . "0x28578") ; <CJK>
       (?$(Lc:(B . "0x28561") ; <CJK>
       (?$(Lc;(B . "0x28569") ; <CJK>
       (?$(Lc<(B . "0x28565") ; <CJK>
       (?$(Lc=(B . "0x286DA") ; <CJK>
       (?$(Lc>(B . "0x286E6") ; <CJK>
       (?$(Lc?(B . "0x286DB") ; <CJK>
       (?$(Lc@(B . "0x286DC") ; <CJK>
       (?$(LcA(B . "0x28739") ; <CJK>
       (?$(LcB(B . "0x28757") ; <CJK>
       (?$(LcC(B . "0x28755") ; <CJK>
       (?$(LcD(B . "0x28765") ; <CJK>
       (?$(LcE(B . "0x28761") ; <CJK>
       (?$(LcF(B . "0x28754") ; <CJK>
       (?$(LcG(B . "0x28845") ; <CJK>
       (?$(LcH(B . "0x28841") ; <CJK>
       (?$(LcI(B . "0x2883E") ; <CJK>
       (?$(LcJ(B . "0x28837") ; <CJK>
       (?$(LcK(B . "0x28912") ; <CJK>
       (?$(LcL(B . "0x28913") ; <CJK>
       (?$(LcM(B . "0x2892C") ; <CJK>
       (?$(LcN(B . "0x28996") ; <CJK>
       (?$(LcO(B . "0x2F9E9") ; <CJK>
       (?$(LcP(B . "0x2899C") ; <CJK>
       (?$(LcQ(B . "0x2899D") ; <CJK>
       (?$(LcR(B . "0x28985") ; <CJK>
       (?$(LcS(B . "0x2F9E8") ; <CJK>
       (?$(LcT(B . "0x2899F") ; <CJK>
       (?$(LcU(B . "0x289A3") ; <CJK>
       (?$(LcV(B . "0x28C82") ; <CJK>
       (?$(LcW(B . "0x28C83") ; <CJK>
       (?$(LcX(B . "0x2F9EE") ; <CJK>
       (?$(LcY(B . "0x28D1D") ; <CJK>
       (?$(LcZ(B . "0x28D14") ; <CJK>
       (?$(Lc[(B . "0x28D1F") ; <CJK>
       (?$(Lc\(B . "0x28D20") ; <CJK>
       (?$(Lc](B . "0x28E47") ; <CJK>
       (?$(Lc^(B . "0x28E80") ; <CJK>
       (?$(Lc_(B . "0x28EC9") ; <CJK>
       (?$(Lc`(B . "0x28EF9") ; <CJK>
       (?$(Lca(B . "0x28F06") ; <CJK>
       (?$(Lcb(B . "0x28EF0") ; <CJK>
       (?$(Lcc(B . "0x28EF8") ; <CJK>
       (?$(Lcd(B . "0x28EEF") ; <CJK>
       (?$(Lce(B . "0x28EFD") ; <CJK>
       (?$(Lcf(B . "0x28EF1") ; <CJK>
       (?$(Lcg(B . "0x28EFE") ; <CJK>
       (?$(Lch(B . "0x28FB8") ; <CJK>
       (?$(Lci(B . "0x28FC0") ; <CJK>
       (?$(Lcj(B . "0x28FC3") ; <CJK>
       (?$(Lck(B . "0x28FB5") ; <CJK>
       (?$(Lcl(B . "0x28FB6") ; <CJK>
       (?$(Lcm(B . "0x28FC9") ; <CJK>
       (?$(Lcn(B . "0x2F9F3") ; <CJK>
       (?$(Lco(B . "0x28FBD") ; <CJK>
       (?$(Lcp(B . "0x28FBA") ; <CJK>
       (?$(Lcq(B . "0x28FBF") ; <CJK>
       (?$(Lcr(B . "0x28FB3") ; <CJK>
       (?$(Lcs(B . "0x28FC6") ; <CJK>
       (?$(Lct(B . "0x28FB2") ; <CJK>
       (?$(Lcu(B . "0x28FBC") ; <CJK>
       (?$(Lcv(B . "0x28FB7") ; <CJK>
       (?$(Lcw(B . "0x28FB9") ; <CJK>
       (?$(Lcx(B . "0x28FC8") ; <CJK>
       (?$(Lcy(B . "0x290B5") ; <CJK>
       (?$(Lcz(B . "0x290B3") ; <CJK>
       (?$(Lc{(B . "0x4A16") ; <CJK>
       (?$(Lc|(B . "0x290AC") ; <CJK>
       (?$(Lc}(B . "0x290A9") ; <CJK>
       (?$(Lc~(B . "0x290AD") ; <CJK>
       (?$(Ld!(B . "0x29211") ; <CJK>
       (?$(Ld"(B . "0x2920D") ; <CJK>
       (?$(Ld#(B . "0x29216") ; <CJK>
       (?$(Ld$(B . "0x29289") ; <CJK>
       (?$(Ld%(B . "0x2927C") ; <CJK>
       (?$(Ld&(B . "0x2928B") ; <CJK>
       (?$(Ld'(B . "0x2927B") ; <CJK>
       (?$(Ld((B . "0x29288") ; <CJK>
       (?$(Ld)(B . "0x29284") ; <CJK>
       (?$(Ld*(B . "0x2939D") ; <CJK>
       (?$(Ld+(B . "0x29398") ; <CJK>
       (?$(Ld,(B . "0x29488") ; <CJK>
       (?$(Ld-(B . "0x29486") ; <CJK>
       (?$(Ld.(B . "0x29482") ; <CJK>
       (?$(Ld/(B . "0x2948B") ; <CJK>
       (?$(Ld0(B . "0x2F9FF") ; <CJK>
       (?$(Ld1(B . "0x29471") ; <CJK>
       (?$(Ld2(B . "0x29472") ; <CJK>
       (?$(Ld3(B . "0x29481") ; <CJK>
       (?$(Ld4(B . "0x2948C") ; <CJK>
       (?$(Ld5(B . "0x29480") ; <CJK>
       (?$(Ld6(B . "0x29489") ; <CJK>
       (?$(Ld7(B . "0x295BB") ; <CJK>
       (?$(Ld8(B . "0x295C1") ; <CJK>
       (?$(Ld9(B . "0x295BE") ; <CJK>
       (?$(Ld:(B . "0x2FA01") ; <CJK>
       (?$(Ld;(B . "0x295BD") ; <CJK>
       (?$(Ld<(B . "0x296C1") ; <CJK>
       (?$(Ld=(B . "0x296B4") ; <CJK>
       (?$(Ld>(B . "0x296B7") ; <CJK>
       (?$(Ld?(B . "0x296C8") ; <CJK>
       (?$(Ld@(B . "0x4B3B") ; <CJK>
       (?$(LdA(B . "0x296D3") ; <CJK>
       (?$(LdB(B . "0x296D0") ; <CJK>
       (?$(LdC(B . "0x296B0") ; <CJK>
       (?$(LdD(B . "0x296CA") ; <CJK>
       (?$(LdE(B . "0x296CD") ; <CJK>
       (?$(LdF(B . "0x29815") ; <CJK>
       (?$(LdG(B . "0x29819") ; <CJK>
       (?$(LdH(B . "0x29817") ; <CJK>
       (?$(LdI(B . "0x2983F") ; <CJK>
       (?$(LdJ(B . "0x29840") ; <CJK>
       (?$(LdK(B . "0x29844") ; <CJK>
       (?$(LdL(B . "0x2987C") ; <CJK>
       (?$(LdM(B . "0x29878") ; <CJK>
       (?$(LdN(B . "0x29879") ; <CJK>
       (?$(LdO(B . "0x29888") ; <CJK>
       (?$(LdP(B . "0x2FA06") ; <CJK>
       (?$(LdQ(B . "0x29889") ; <CJK>
       (?$(LdR(B . "0x2987D") ; <CJK>
       (?$(LdS(B . "0x29A23") ; <CJK>
       (?$(LdT(B . "0x29A24") ; <CJK>
       (?$(LdU(B . "0x29A26") ; <CJK>
       (?$(LdV(B . "0x29A22") ; <CJK>
       (?$(LdW(B . "0x29A27") ; <CJK>
       (?$(LdX(B . "0x29A1F") ; <CJK>
       (?$(LdY(B . "0x29AC9") ; <CJK>
       (?$(LdZ(B . "0x29AC3") ; <CJK>
       (?$(Ld[(B . "0x29B0A") ; <CJK>
       (?$(Ld\(B . "0x29B0B") ; <CJK>
       (?$(Ld](B . "0x29B04") ; <CJK>
       (?$(Ld^(B . "0x4BEF") ; <CJK>
       (?$(Ld_(B . "0x29B03") ; <CJK>
       (?$(Ld`(B . "0x29B01") ; <CJK>
       (?$(Lda(B . "0x29B09") ; <CJK>
       (?$(Ldb(B . "0x29C0F") ; <CJK>
       (?$(Ldc(B . "0x29C2E") ; <CJK>
       (?$(Ldd(B . "0x29C2D") ; <CJK>
       (?$(Lde(B . "0x29C91") ; <CJK>
       (?$(Ldf(B . "0x29C99") ; <CJK>
       (?$(Ldg(B . "0x29C9E") ; <CJK>
       (?$(Ldh(B . "0x29C90") ; <CJK>
       (?$(Ldi(B . "0x29C94") ; <CJK>
       (?$(Ldj(B . "0x29C9D") ; <CJK>
       (?$(Ldk(B . "0x29C98") ; <CJK>
       (?$(Ldl(B . "0x29C9B") ; <CJK>
       (?$(Ldm(B . "0x29C9C") ; <CJK>
       (?$(Ldn(B . "0x29C9A") ; <CJK>
       (?$(Ldo(B . "0x29D54") ; <CJK>
       (?$(Ldp(B . "0x29F9D") ; <CJK>
       (?$(Ldq(B . "0x29F9F") ; <CJK>
       (?$(Ldr(B . "0x29FA3") ; <CJK>
       (?$(Lds(B . "0x29FA4") ; <CJK>
       (?$(Ldt(B . "0x29FA5") ; <CJK>
       (?$(Ldu(B . "0x2A302") ; <CJK>
       (?$(Ldv(B . "0x2A417") ; <CJK>
       (?$(Ldw(B . "0x2A41B") ; <CJK>
       (?$(Ldx(B . "0x2A419") ; <CJK>
       (?$(Ldy(B . "0x2A4D1") ; <CJK>
       (?$(Ldz(B . "0x21537") ; <CJK>
       ))))

(provide 'u-cns-6)

;;; u-cns-6.el ends here
