;; Quail package `chinese-ctlaub' -*- coding:iso-2022-7bit; -*-
;;   Generated by the command `miscdic-convert'
;;   Date: Wed Feb 15 10:28:36 2012
;;   Source dictionary file: CTLau-b5.html
;;   Copyright notice of the source file
;;------------------------------------------------------
;; "CTLau-b5.html" is available at:
;;
;;   http://umunhum.stanford.edu/~lee/chicomp/CTLau-b5.html
;;
;; It contains the following copyright notice:
;;
;; # Copyright (C) 1988-2001  Fung Fung Lee (lee@umunhum.stanford.edu)
;; # 
;; # This program is free software; you can redistribute it and/or
;; # modify it under the terms of the GNU General Public License
;; # as published by the Free Software Foundation; either version 2
;; # of the License, or any later version.
;; # 
;; # This program is distributed in the hope that it will be useful,
;; # but WITHOUT ANY WARRANTY; without even the implied warranty of
;; # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; # GNU General Public License for more details.
;; # 
;; # You should have received a copy of the GNU General Public License
;; # along with this program; if not, write to the Free Software Foundation,
;; # Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;------------------------------------------------------

;;; Code:

(require 'quail)
(quail-define-package "chinese-ctlaub" "Chinese-BIG5" "$(0N,Gn(B" t
"$(0KH)tTT&,!(N,Tg>A*#Gn5x!((B

 $(0N,Tg>A*#GnM$0D5x'J7{(B
 Sidney Lau's Cantonese transcription scheme as described in his book
 \"Elementary Cantonese\", The Government Printer, Hong Kong, 1972.
 This file was prepared by Fung Fung Lee ($(0,XFS76(B).
 Originally converted from CTCPS3.tit
 Last modified: June 2, 1993.

 Some infrequent characters are accessed by typing \\, followed by
 the Cantonese romanization of the respective radical ($(0?f5}(B)."
  '(("" . quail-delete-last-char)
   ("." . quail-next-translation)
   (">" . quail-next-translation)
   ("," . quail-prev-translation)
   ("<" . quail-prev-translation))
  nil nil nil nil)

(quail-define-rules
("a" "$(01`;@R*+U&:;=-jB+$(1[5(B")
("aai" "$(06n7e$(1Ar$(02:6aIRRF(B")
("aan" "$(07o62(B")
("aang" "$(0\.(B")
("aap" "$(0U:(B")
("aat" "$(0UM/f(B")
("aau" "$(0/p(B")
("ak" "$(0AJ,F'._!(B")
("am" "$(0F=TE]S(B")
("ang" "$(0]N(B")
("au" "$(0OD^0OHJ,$(1KB(B")
("ba" "$(0,E'<1A(=+D9>4QI_^_]>PH0jH<$(1A21m(B")
("baai" "$(0BCXH<v39$(1Ec.=(B")
("baak" "$(0(v*L+%-w/05e&4(B")
("baan" "$(0TW8_AYId030k,M-c9o(B")
("baang" "$(0ViYG(B")
("baat" "$(0&-7g(B")
("baau" "$(0'~5H52IhU6ZG$(1kM(B")
("bai" "$(0J]?q$(1MR$(0PSUo<rJc:e(B")
("bak" "$(0("(B")
("bam" "$(04*)&(B")
("ban" "$(0M4>H<3$(1<@$(0V$$(1\t$(0.e2CGcR4UQXXY-$(1[3n8(B")
("bang" "$(0;~(B")
("bat" "$(0&c>,C./aDCJ6A%IC(B")
("be" "$(0;F(B")
("bei" "$(0?8A,@-'SM|$(1(4$(0CQGW.9RX/?$(1+K$(0,+G=W"Wb9:0G3w&26?]z'S+n(B")
("beng" "$(03dMo8k(B")
("bik" "$(0I0KyRJZy(B")
("bin" "$(0;6381n^I[1D;'-TV]4\*Yk,z$(11Z(B")
("bing" "$(0-e+/)D'`1'45:T(B")
("bit" "$(0+2^+$(1PC$(0ZR(SIL(B")
("biu" "$(01QO:?*;i^L[=(B")
("bo" "$(06\1r?f(M@_HQ,dO3Pp7[ZZ/I@`[k6lZ;$(1D[V5(B")
("boh" "$(04EC[O'0M.\QS$(13u(B")
("bok" "$(0MrF2@<IIL.>sLT0]:eI[Sl(B")
("bong" "$(0-[UZ=<K'GrO|YU(B")
("booi" "$(05.01QE-KQb8[BO(B")
("boon" "$(0(%(\9p8eF1*s>R5K265)(B")
("boot" "$(11@$(07S>jO!20B9+y(B")
("buk" "$(0&4X^:`Iy(B")
("bung" "$(04K(B")
("cha" "$(03h7:&G$(12V$(09~F0,&HZRl@L(B")
("chaai" "$(0=wQ=8):AR5?k(B")
("chaak" "$(0BBC-'v/qHqA4(B")
("chaam" "$(0;7^gJnJo[qJ}_/^k,_$(1p((B")
("chaan" "$(0[7>)U(B%V5$(1E{(B")
("chaang" "$(0N}Rw(B")
("chaap" "$(0AG(B")
("chaat" "$(0JWUiZL..$(14"\L(B")
("chaau" "$(0,>DZ<&+Q0e$(12+(B")
("chai" "$(0=_M}Au.g4h$(1Ae$(0C]$(1\M(B")
("cham" "$(0@s,k1lJU,i^lO[$(1oh(B")
("chan" "$(0?tJ9D@]sT68qD-2@$(1aB(B")
("chang" "$(0NRAe(B")
("chap" "$(0P=TS(B")
("chat" "$(0&%KK3q(B")
("chau" "$(04r/eI<ZP]0Ga\%LA$(1L.$(0Wk9iB2(@0WWuEMR3$(1Y5(B")
("che" "$(0-P'c,K$(1)I$(0;^-Z<|(B")
("chek" "$(0':(B")
("cheng" "$(0Py(B")
("cheuk" "$(0XCL9-D&E.88&-$$(1-u$(0)s(B")
("cheung" "$(0V<H\C(1\@\>A/z=yH$K$;A67K4ENW0F6CE/R;e(B")
("chi" "$(0G?*BD%./*:*~.oA"*;T[3Y9RR0S6>1:$KwMd[0Ev>'Q23>;3*$Ij7F-yY,({33NW$(1.8$(0@>EI$(1)O$(02G.t9-:+Q>(B")
("chik" "$(0<R-L(Y$(1I7$(0(:<z(B")
("chim" "$(0Z\OQJ>IwRp$(1U6(B")
("chin" "$(0&FTe^CX]2*=R\}\P^%\t&FQO($*k(B")
("ching" "$(0OKL#<FC$Py+HZ4?_94VH1f=SA^$(1=-$(03DLo(B")
("chip" "$(0.f(B")
("chit" "$(0'#JuJfKS$(1$Q$(0?DYM(B")
("chiu" "$(0AhD?OSVR7LVK711q5a-:3P:^(B")
("cho" "$(09xRhVbO;=+>PQV<^S*\HRBV6J4$(1&W+H^X^^(B")
("choh" "$(0Q`7d1PQ]YfFHXpO{F+Td9q(B")
("choi" "$(0GJ<4&`:CC{,Z<iCmP[WT8(ES(B")
("chong" "$(0,,@7Y/6ALjS~FpOqY`N^AU@0(B")
("chue" "$(0?)Z<NZ[)UDUpGx3[D2*p$(1n.(B")
("chuen" "$(0,[)uE/)AAH&V4s@D*l$(1q@$(0Xu&Q$(1_s$(03y>2803GB@:%$(1$K$(0?nMV(B")
("chuet" "$(0O&/h$(15X$(0L=5D;I$(1Om$(0.I(B")
("chui" "$(0.>+MDlTr:g$(1D9$(00fANWsJz<!E29aLJWX;_Q77C$(13y(B")
("chuk" "$(01s^d$(1C#$(0,W?[L`8g$(1!)$(0^3(B")
("chun" "$(03O$(1CV$(0]&98A(*1-W(B")
("chung" "$(05n's<8,t*fZ1VzP^+Z(!X;Y{:0EW$(1H>(B")
("chut" "$(0'yX6(B")
("da" "$(0(U(B")
("daai" "$(0&L<('QUc+E(B")
("daam" "$(0;B9YRkW%B)=N$(1OX8H(B")
("daan" "$(0+!@M&f$(1U$Pa$(0(ZNrPxN_?1$(1HB$(0Mg(B")
("daap" "$(0C1Q<F/Om$(1'P(B")
("daat" "$(0I/Rb$(1A|7x$(0^#(B")
("dai" "$(0ME>JX"/6DM+&/k2u,/(c$(18:(B")
("dak" "$(0Na<68X(B")
("dang" "$(0C,[+S:BuJ"QR$(1B|jA(B")
("dat" "$(0'z4t(B")
("dau" "$(0-I:o,@;(:d?YBr1,$(1A7$(0:(\#(B")
("de" "$(08W$(1B%(B")
("dei" "$(0)c(B")
("dek" "$(0>I(B")
("deng" "$(0-2:\$(1$p(B")
("deuh" "$(0*9(B")
("deuk" "$(0Ba;<(B")
("dik" "$(00|KA5bO.-*KXJGJ([6(B")
("dim" "$(0X5$(15N$(0/4(B")
("din" "$(0IZ.)GST{J=-0@eS)F\[M]^IO^c(B")
("ding" "$(0Ip.z5V&$(0@"T`L$&q$(1(K$(05m(B")
("dip" "$(0KxPcT=]i@JG'(B")
("dit" "$(0DF5d99DK(B")
("diu" "$(0)STt<aP~GU(36I&0?m)$$(1O!$(0D1(B")
("do" "$(0&/I-.02z?h;ZGHQ/,\WlB/+kF86077RSP*<JBzJ3$(1"X(B")
("doh" "$(0)j$(1)Y$(0I$*9H~.3A3ND(B")
("doi" "$(0'o3"?</*X8(B")
("dok" "$(0]:TM(B")
("dong" "$(0VFG6Ra\^Us]9(B")
("duen" "$(0B|Wv3uXKL'PA(B")
("duet" "$(0JE(B")
("dui" "$(0JX;U+,Dj(B")
("duk" "$(0SBGG3vZJ]uZISb_C(B")
("dun" "$(0AVIbNERAD_I9(B")
("dung" "$(0;00*U^NV'wH;Ao$(1%?$(0356F4#.Q$(1+O(B")
("fa" "$(01E'((B")
("faai" "$(0,9E\Gg@/$(1VO(B")
("faan" "$(00\Vn'1=258&<(hZjZO)~BmY)O>\!?pFw1T?JE"T&(B")
("faat" "$(0Bv0OB^(B")
("fai" "$(0AMU\D7+S11NY0QQBF>(B")
("fan" "$(0):'"RNV_1F$(19y$(0+K0B9NNBBP,y9@/DNsH/0!;g$(1Kh$(0:<$(1H{$(0Y4$(1aA(B")
("fat" "$(0*t/B/[3x(RLIC4)2'gM_$(18](B")
("fau" "$(0+B;V8G=k1^6J*P(B")
("fe" "$(0;>(B")
("fei" "$(05{1gCSCh126OQ%$(16X$(0)oAZ$(1M{$(0LKTz(B")
("foh" "$(04p?M'W).P{$(1A,$(0Pj(B")
("fok" "$(0Tx^9(B")
("fong" "$(0),0T'J/t+^1>19/S-`+l??9A9sE~7pEl3.WK,20(-;$(1A*$(09n(B")
("foo" "$(0'4.L+x'Y@oM;>K:_PP;,O/JN,B1u-.O(6&/uCM/5LP5ZQ,@,'j5Y5W1b;b.M'h1N;J5<7=T23`$(1%S$(01@$(1-?$(0Q~R!(B")
("fooi" "$(07PM,*I31=)2YMvHa@X(B")
("foon" "$(0]dNOB"(B")
("foot" "$(0Wz(B")
("fuk" "$(0A'0%K~TR@z)4C}Y<H);1YwPd(B")
("fung" "$(05zVjYC2mFSHI76QaKn=r?bE&TC.aMz6)$(13{(B")
("ga" "$(03_:vN$'|EaRIJ0J.$(1+($(07'HsP&Q|$(1d"$(0?7(B")
("gaai" "$(0HY&vDk4MCz-p,<1G4RM'/$4V$(17i$(0:~+}$(1:T(B")
("gaak" "$(05u8,9cIS:p$(1Av$(0LSY\U2(B")
("gaam" "$(0B6Kr]~UT$(1pZ(B")
("gaan" "$(0)nDgX|W*Z`3^^|^|ABRiOXT:(B")
("gaang" "$(09V(B")
("gaap" "$(0(s+i>yU!ID50$(1U4(B")
("gaau" "$(0<uI%))F-PO5h^:MP4BMnC8C)$(1%4$(0>4CrI"(B")
("gai" "$(05U\,YgW5$(13Y(B")
("gam" "$(01[&uEw(m3eAWP;TkG\R@(B")
("gan" "$(01UL<Hz7~&[C3'IE0Y@$(1Hb4?)A$(0*c(B")
("gang" "$(0=7,V/3ZgU)9ZGm6g(B")
("gap" "$(0X2Cw3+(B")
("gat" "$(00z)P8"$(1%9(B")
("gau" "$(0-7Y.&';]5J0q2R-,5w&=-&A$<t.V0{$(1JI\D(B")
("gei" "$(0@~:5S#;X3N4z,AL)*[:k["6z&X$(1!j$(0;m,5+s$(1.-$(0N>,^OkIo(B")
("geng" "$(0[5U"(B")
("geuk" "$(0H'(B")
("geung" "$(0N#2[ZQ1.$(1^<(B")
("gik" "$(0AlS0FLUe1h$(1D$$(0A=(B")
("gim" "$(0N-Uu6BN'(B")
("gin" "$(0:{-E)62{;S17Wo<[H"(B")
("ging" "$(07B@!9uGo-lJ;A`21J!>z^R\AF:Bq\$$(1)3OT$(04e(B")
("gip" "$(0+7(B")
("git" "$(0C9ON@.8+(B")
("giu" "$(0^'(6NLVMZe(B")
("go" "$(0:nP%+LS_8tLR9QSgYZP+GIM+(B")
("goh" "$(0K;686Y(B")
("goi" "$(0H[,R(B")
("gok" "$(0\=)WUkM^-F0t(B")
("gon" "$(0Em=34u-<M9C#:r(B")
("gong" "$(0*AB,/&6MTf5!->L?<%K,WJ5s*,$(1YR(B")
("goo" "$(0(-0J.W15.w3KDL$(1?h$(0.E*v.kIq^H]BDwI@U8Tn(B")
("goon" "$(0L(2&_).{\u?LAiU)^eK!6#>v_J(B")
("got" "$(0@5H7Pn(B")
("guen" "$(07aZ&6w6'>8.;Gp.-@;8D(B")
("gui" "$(0.'Rd(<W)\k/#8}(IQ@Tb4665JJX)$(1X|(B")
("guk" "$(0+~Ci-HX&$(1hoUB(B")
("gung" "$(0'}&W&})B7I^n,S^4-s:F7)&_Qn3B:D:-(B")
("gwa" "$(0(k<c$(13p$(0JQ.:.N(B")
("gwaai" "$(0-f/g/J(B")
("gwaan" "$(0[CJl(B")
("gwaang" "$(0?d(B")
("gwaat" "$(0.13E(B")
("gwai" "$(0XP.xKh)e$(17^$(0XWU@M\5^:qHf8!I!D9<O$(1kXjg3s$(0J%$(1O]$(04X(B")
("gwan" "$(0+J5]+bK?AxD^:V?6Gi(B")
("gwang" "$(0]3(B")
("gwat" "$(0:m<]GeMt(B")
("gwing" "$(047(B")
("gwoh" "$(0I50+'BLzApX($(1[6(B")
("gwok" "$(0?g;PJa(B")
("gwong" "$(0N])=(B")
("ha" "$(06p&72EPeX%F?EoI2G.$(1Nn(B")
("haai" "$(0T>U12gACQm=8ZtR]Wf(B")
("haak" "$(02kUJ(B")
("haam" "$(0MW2<=a.+@BU,(B")
("haan" "$(05pDfNI(B")
("haang" "$(1!R$(0+_*h(B")
("haap" "$(15Y$(0728ZEG.H(B")
("haau" "$(07hJ~7y*T+TML3C8S(J6b+v2^(B")
("hai" "$(0-8&|6s$(1LCp-(B")
("hak" "$(0.,M7E*@?+-$(16D(B")
("ham" "$(0R[+WDW$(1W$$(0Rc@[;/+c4i@u?yU$(B")
("han" "$(03!>04A30RKU_(B")
("hang" "$(0/2*h6X*mT0321:;?,Y[A(B")
("hap" "$(01o)Z>6G^4&+;Qq(B")
("hat" "$(07z&@OvW].4(B")
("hau" "$(0&H3&3&69@V1mB\25:S^y(B")
("hei" "$(086:E6h,)@F,vN5B#:@RC=:K[N2\w?y=sUbIvNH[rS<VSSs(B")
("hek" "$(0)[(B")
("heuh" "$(0I^(B")
("heung" "$(0)X]A-k5~7rDUMq(B")
("him" "$(0TsWI'O(B")
("hin" "$(0=u[y^PMC],:G<m<mRU5Q4jHK^C(B")
("hing" "$(0S|M==H6PNc't\UVu(B")
("hip" "$(0K:/G.77Y9^(B")
("hit" "$(0FY(B")
("hiu" "$(0OOIuS!Xv\gRo$(1Oc$(0^((B")
("ho" "$(0HA8J)pULUFM1=F9XEO$(1\O$(00#Bx]C^&(B")
("hoh" "$(0*u?$(,0I.B$(1?D$(0D8.Y$(18X(B")
("hoi" "$(07&De8B89)+U.@4@6EA$(1d)Ub(B")
("hok" "$(0RQ]OB'(B")
("hon" "$(0@nKH4a*?'{$(1(v$(0X'-9St7f,U7O=q-vZC$(1AR$(0X9(B")
("hong" "$(0<+9m*h0')LC/>;JjV]+?CKD{2t$(1Hf(B")
("hot" "$(0B?@C(B")
("huen" "$(0@@;O'^[aCAH1(B")
("huet" "$(0*g(B")
("hui" "$(0Cq?C(+N8N@$(1GP$(08#F}$(18<(B")
("huk" "$(0MN6_(B")
("hung" "$(04(4yDu1)7G2D8R5NX13|,g'7<V)>9b)KK]?i6((B")
("ja" "$(1L7$(02HB5K(.T'f49D*)^)^?2(B")
("jaai" "$(0X:E-JT(B")
("jaak" "$(0?K)xLLRfS,XEJs9;YBJ2$(18[(B")
("jaam" "$(09=O2<~JZ^FB7$(1Rk(B")
("jaan" "$(0_5GAArL6\-N~WS(B")
("jaang" "$(0<hGK={0i(B")
("jaap" "$(0>eYdDv]rIQ8|$(1%`$(0Ml(B")
("jaat" "$(0>U(_1R$(1.9(B")
("jaau" "$(0,GN4-=^vGv,O'X(B")
("jai" "$(0.2V%Ug>CR9McKJ'k^!A?(B")
("jak" "$(02-;"&w(B")
("jam" "$(00)8A3,F;:]$(1g+$(0R)(B")
("jan" "$(0YY8z7Z4GQi:c)b$(1Ax$(0M5(B")
("jang" "$(0NA$(1g>$(0IsNpAe[%$(1Ob$(0;|TiL/(B")
("jap" "$(0(e;[(B")
("jat" "$(08jEb$(1%<$(0Q3>E(B")
("jau" "$(03{:Y=%@t*b)}-MAP?:.S$(1_P$(0/-.JOt.}2XAFI:$(1Hx$(0;M@U4x2%(B")
("je" "$(0?V106..mWM$(1[0$(0PRQLE@K5^/(B")
("jek" "$(0(89f0g6e(B")
("jeng" "$(0&k=hQQ-b(B")
("jeuk" "$(0:[Cb?{V;[f[Z$(1RU(B")
("jeung" "$(0<0D0;sPZA@1\OIO?Od)MYRR}IzO6?~JeK=KN,]&8<)Q.'nCOSKMb63<H[?W8(B")
("ji" "$(0&N*]C<)t1"Ab,6&g2]=jHr0Z'P(89M*^)zEH*zIf&Z1?0/'F+VLs139\+`3A?R*0Nx55GuG`>/9|29BF+w4wT?1v1M.q1%4k92To$(1,v$(0>f$(1>m$(0]U(B")
("jik" "$(0VeY*X~1!\'+<SYHy;nY31#&K*C7;AyB&6-KE$(1(F$(0Z#$(1_6$(0*-(B")
("jim" "$(0){KM\F9!XnHj$(18%$(00K*}\D(B")
("jin" "$(07/X]L*Fu;+Y7Q9Q-P-U*$(1SD$(0P!B(V"W^R^$(1&qS%(B")
("jing" "$(0Nb(`T|D&3JRmGCA_L5I]5X;!Lf/=/F@|8lK}$(1H:(B")
("jip" "$(0<Z\e2I(B")
("jit" "$(0Gh,LJq<[GD8C6Z$(1_6(B")
("jiu" "$(0T'AzBQE7/^0LM8Fz(/$(1I+$(0D($(1I$$(0Ah(B")
("jo" "$(0*/>[?`:y9/QNVa\2Am:*-1-#9793(B")
("joh" "$(0+e+81a(K*w7?1~$(1.@(B")
("joi" "$(0)d)C2;-%7%I&Fa$(1(5(B")
("jok" "$(0+#_E3U3k(B")
("jong" "$(00nY/]/]qH6O8>~HS+jNz+hLW(B")
("jue" "$(0'e*o0DCbPzQ)8.8bCv*8HeBU/Y?,]|VlQx-~:#$(1)i$(0MT$(1\;(B")
("juen" "$(0E/;rYL[($(1mS$(0_>@rTXSU\fYq(B")
("juet" "$(0C;$(15X$(0L=;I$(1Om(B")
("jui" "$(0@3QU,*.F0p8o0ULN?0<yD)N6GwA{Tj:RYDNC\`$(1H]$(0UV(B")
("juk" "$(0-N=!\~1x\>VWC7DJ?]*MV7_4^^Sa917_S-J'.r];[8$(18Y$(01+(B")
("jun" "$(0DQKqFn3~7nXa733`C+V,X,S{Rt]<$(1,a(B")
("jung" "$(0&dL">9Vl.yVk>]Ie?EM"4\/A\MH()5YzAjYHL8E5Wt>p$(126$(0L4(B")
("jut" "$(0.6(B")
("ka" "$(0('.C$(1##(B")
("kaai" "$(0FI(B")
("kaat" "$(1)?(B")
("kaau" "$(0QkQ\(B")
("kai" "$(02WP(<w:=Fr(B")
("kam" "$(12}$(0ZwBeRjG^R<$(1#U(B")
("kan" "$(0E<1D(B")
("kap" "$(0'0+OC@,x9J$(11g(B")
("kat" "$(02>(B")
("kau" "$(0*+HRK-,fFeWU*_H,;k>!$(1)!$(0(1EdIn$(1(i$(0Df(B")
("ke" "$(0YxSL5=*y(B")
("kei" "$(0Aw.(Ag4lK");G7R6.b0?;y1&,$B_GZ$(1Hh$(0[]]L(B")
("kek" "$(0N*(B")
("keuk" "$(024RE(B")
("keung" "$(0<1$(1gUF6(B")
("kim" "$(0U>IA(B")
("kin" "$(0:&(B")
("king" "$(0E1[TUd@#ZN$(1kC(B")
("kit" "$(0Qo$(1PZ$(0ALL&Zs&OPIZ)(B")
("kiu" "$(0[/R~@SI{O*Y(Ut(B")
("koh" "$(1H;(B")
("koi" "$(0FNLeD\BGA6P"&bOx(B")
("kok" "$(0O}:W=[K/UN(B")
("kong" "$(0,?XD-+[}&n0c)-$(1A8$(0Z:(B")
("koo" "$(1L](B")
("kooi" "$(0N.V9ZcHtN&OVW'$(1bj(B")
("koot" "$(03EWPCH(B")
("kuen" "$(0]cHn$(1q~$(07U(B")
("kuet" "$(0?A,o,C9O$(1'q$(0@=J$[!$(1Oh$(0&P(B")
("kui" "$(0;5/nQ}/]DB66YK]EB3+)^iJ[$(19;$(0Xm(B")
("kuk" "$(0*3(B")
("kung" "$(0P,1*(B")
("kwa" "$(0)lLx2T$(1*Z$(0H{9h$(1%;(B")
("kwaang" "$(07|(B")
("kwai" "$(0?>4UW6>5S^H2F%\n$(1:6BY$(0DN(B")
("kwan" "$(0+[QJC'Cf.^/{7]HPG{Tm/2)>D}(B")
("kwik" "$(0Ma$(1Si(B")
("kwong" "$(0[}Z:(B")
("la" "$(1^N$(0@I;;2+(B")
("laai" "$(0/WTK(B")
("laam" "$(0Y1XQ\1;c\&^`]+_:V)\<(B")
("laan" "$(0]#\r[pW|[u$(1pR$(0Z6\v$(1qD(B")
("laang" "$(0+1(B")
("laap" "$(0Zi.X]((B")
("laat" "$(0M?[2$(1L&(B")
("lai" "$(0-t[^=vR.Xq9tN0UE\c_H$(1kE(B")
("lak" "$(0;-*Z$(1!3(B")
("lam" "$(0N)B`00TwW(=U(B")
("lap" "$(0)"'x>O>G(B")
("lat" "$(0(p(B")
("lau" "$(0KFO=8i3}Fo8`K2>>YsN,Oo3l;`JwVX5q$(1Ab$(0J/$(1jp$(0[@$(1d-^T$(0]I(B")
("le" "$(02K(B")
("lei" "$(0,X+4>"Oh1z$(1)<$(0=@_&M2YcK@HTZ"?")QNSN)6^1}@T7!Qc(B")
("lek" "$(0(>(B")
("leng" "$(1UZh6(B")
("leuk" "$(0>*<U(B")
("leung" "$(0OC.&DY6,X}=JGl-AQC1jPuZo(B")
("lik" "$(0&1S&ZD$(1eA(B")
("lim" "$(0]6En/,UnW&U~(B")
("lin" "$(0?ZNnFyP8PUKO[9XG(B")
("ling" "$(0C`Mk(7^rI\$(1<V$(0FR/s4F\bIJ+'>b6G?sUW'p$(1%p$(0>h(B")
("lip" "$(0Xe$(1/>(B")
("lit" "$(0)EC|8U.*(B")
("liu" "$(0JR&(O$>gIxVDS=T\$(1JOj?$(0Jb7jN3$(13F(B")
("lo" "$(0H|]@SN*SN|@9-'-r2a$(1QG$(0\6_.Z3[xRe@&H@R(Hw$(1W{$(0_8N1X<$(1P.$(0Z?$(1Ne$(0^{VC$(1jImu$(0_B(B")
("loh" "$(0Zd2F^GW>^K_@_'L{OM[>(B")
("loi" "$(0-uCc<;*V(B")
("lok" "$(0O@H0MUHpI=8T4)U0C?ZHO@(B")
("long" "$(0=}FF8YA!5i7x8<AcPa(B")
("luen" "$(0V{]_^8]]_3E+^7$(1mL(B")
("luet" "$(0)J(B")
("lui" "$(01tHT[K>\=bO~IY]7W-UCX?Rg+IQ^7lJYVgNeX[]HZh;L/T@;(B")
("luk" "$(0Th@'&{?u[_GTG[NvB*L;(B")
("lun" "$(0-|+=<fQG6@=eLDQ"VNQP^Y+>[.^\(B")
("lung" "$(0[sU?]o[b]mVVDoZ/Z9[D,.[z(B")
("lut" "$(08%3$8%=|*X(B")
("m" "$(06](B")
("ma" "$(0@)Ee:lP#KgT-PGJ)ED(B")
("maai" "$(0Q16mD:We(B")
("maan" "$(0G]Jk=&[O_(PX;8KQR7^.(B")
("maang" "$(00~Tc=x.vLpL\(B")
("maau" "$(0-(TJ59(zIP()M3(B")
("mai" "$(0Ow$(1_q$(0:MWG*N2B(B")
("mak" "$(0@(9dR/U=5r]G$(1I6(B")
("man" "$(0'GLM(b;C/Z<xNoM]0A:'9C+N9D)H0_Dx(B")
("mang" "$(0CeGB(B")
("mat" "$(00mLn;p])''$(1!"$(0WO(B")
("mau" "$(03]D<YAT<*J8f5?$(1%G(B")
("me" "$(02J(B")
("mei" "$(05"(],#4`Wm@q@g[HV^Es.AW3$(1;C$(02}6y$(1FK$(07i^"$(1^J$(0X3(B")
("mi" "$(02B(B")
("mik" "$(0?=(B")
("min" "$(05t+.LB;)2/6}P<A|8{(B")
("ming" "$(0)Y/}.U(xT,MxMS6D:!I>(B")
("mit" "$(0PYFgVY(B")
("miu" "$(0+oAA5BKsY24qBAN[Wn$(1:V$(0YP0,$(1=.$(09<(B")
("mo" "$(00>BS(a;.NyO</i.lJ<O1E:Ng'T2$@{,(M%T)'RL[1y(T[G$(1)POo$(0NK[Y(B")
("moh" "$(0M{M{Jv\4STNw]JURR-(B")
("mok" "$(0>|6NPMKDJOJ^R7(B")
("mong" "$(09r,4&B-B*%>{L>=-)m1-(B")
("mooi" "$(0080v==QjQjFx@i,e3R.iR%(B")
("moon" "$(0KI611]SQA-$(1[7j^$(0YF(B")
("moot" "$(0(^,u/\0N5@0@(B")
("muk" "$(0'N(yGE0lS[5E,p$(1HC(B")
("mung" "$(0LaXOJCZ7XM$(1id$(0*x(B")
("na" "$(07W-\6c6v7c(B")
("naai" "$(0*=&&(E(B")
("naam" "$(023-/@K@v$(1F?(B")
("naan" "$(0[E(B")
("naap" "$(0+RD]9L?B(B")
("naau" "$(0O"R$$(16T$(0.O\N(B")
("nai" "$(00H(B")
("nam" "$(1TG(B")
("nang" "$(09e(B")
("nau" "$(0,DD[9H*6+m$(1\\$(0Sw$(1Ri(B")
("ne" "$(0.R(B")
("nei" "$(0+$(HMp4".jSy<AU[=$$(1aqH?(B")
("neung" "$(06u(B")
("ng" "$(0&mM)=6+A+G7\'*)1='7M$(1!m$(0EJHD\_(B")
("nga" "$(0(l1B'\:.HMDt?@$(1!v#!(B")
("ngaai" "$(0*e;{=V'$<_(B")
("ngaak" "$(0Ym(B")
("ngaam" "$(0VE^6(B")
("ngaan" "$(0DsYn>:(B")
("ngaang" "$(0B~(B")
("ngaau" "$(0=i27'Z18(B")
("ngai" "$(0)OGOTy6>\j:tY|ZqZkOGHb]Z$(1fQ$(05#(B")
("ngak" "$(0+F(B")
("ngam" "$(0<.[[(B")
("ngan" "$(0DzMQ]V(B")
("ngat" "$(0-V)|&C$(1!I(B")
("ngau" "$(0']IH'&Zm:|PK(B")
("ngit" "$(1aL(B")
("ngo" "$(0E.<sO_SuVx(B")
("ngoh" "$(0,=1;HG75Z'1{?F6~Qt6d$(1U>(B")
("ngoi" "$(0+E(AZUM[(B")
("ngok" "$(0DS/+$(1ZR$(0WyYpO@(B")
("ngon" "$(0/'(B")
("ngong" "$(0/|(B")
("ngung" "$(0Xh(B")
("ni" "$(0.R(B")
("nik" "$(0\";4Fk(B")
("nim" "$(0/C/c(B")
("nin" "$(0*"(B")
("ning" "$(0XRV=JP0[V#*rUG$(1i`(B")
("nip" "$(0<n7^Y+_6YX8N$(1q}(B")
("niu" "$(0@%,"HU(B")
("no" "$(0+9H+A7(D3(/;(B")
("noh" "$(0U`\($(1kO:U(B")
("noi" "$(0.c&z5%Qu$(1+8(B")
("nok" "$(0T@(B")
("nong" "$(0][]h$(1p~(B")
("nuen" "$(0JIFA(B")
("nui" "$(0&M$(1:$(B")
("nuk" "$(12s(B")
("nung" "$(0W$S+I*N%RD(B")
("o" "$(05;3c@HRH;dDI$(1E3(B")
("oi" "$(0Ey28Os\3$(1V_$(0^s(B")
("ok" "$(0A+R?;TA2(B")
("on" "$(0)y7{Ql883;$(12.$(0MX(B")
("ong" "$(0Ms8x(B")
("ou" "$(0S/ZxE`R\E](B")
("pa" "$(0/K(W9W5\0hBd0-(B")
("paai" "$(0<kBW4'6;(B")
("paak" "$(03jR&>Q;:///j4H(B")
("paan" "$(0,IZ84c(B")
("paang" "$(0OTAt=oA&A}GVSz[\(B")
("paau" "$(04:+6:B/b.KDE0[(B")
("pai" "$(0,H(B")
("pan" "$(0ZEN;U#?O(B")
("pang" "$(0RV0&(B")
("pat" "$(0')(u(B")
("pei" "$(0\@(wMI$(1,O$(0/_Bc8mBs,!.D'b)9;f0.IN(B")
("pek" "$(0N+(B")
("pik" "$(0I)]?N"Xi(B")
("pin" "$(0I6P>P2;$'[[RPh(B")
("ping" "$(03<(N/d\7X+8~G})%.ZCZ>&D$2o$(1)($(02\7"U/(B")
("pit" "$(0JrSS$(1!_(B")
("piu" "$(0>BPQ\RKGSHE9$(1I2$(0JK$(16A(B")
("po" "$(0Z{A\/m>i$(1S0$(0?'H:Lc6i8@?;22Fh$(1j:(B")
("poh" "$(09$;hMj(5$(1]e$(0DG(B")
("pok" "$(0N{*7N:$(1jE(B")
("pong" "$(07kLQ:,@+WHZ2$(1YQ$(0FcT+(B")
("pooi" "$(06$:Z;\LyQ*?r-z,m$(1%s$(0CW<95+$(1UX(B")
("poon" "$(0OuOY+3/X4ZP$(B")
("poot" "$(0OLIB(B")
("puk" "$(0Iy(B")
("pung" "$(0P]VZ<\GQ(B")
("sa" "$(1+V$(0>u4f,h9B5&',$(1!FAy$(0HNZ!(B")
("saai" "$(0^;<7ZM9l(B")
("saam" "$(0&6&65R$(1:#(B")
("saan" "$(0&UAXSd;^4D+5*D3aOU5o.n56DD(B")
("saang" "$(04](n(B")
("saap" "$(0+d(#9"Tu(B")
("saat" "$(0O%Y0=E2'G"[>(B")
("saau" "$(0T~=07XC"6T$(1FL(B")
("sai" "$(0>Y*jE='aM(?\RGSe$(17X$(0@hBY4$$(1>n(B")
("sak" "$(0ES(B")
("sam" "$(0'A4J,jNP$(19p$(0,8=fX@KW&pAq,%(B")
("san" "$(090F<-O=((t*\-R9%.G*{6{>ZCNE}W+QX-Q(B")
("sang" "$(0(nBj4=(B")
("sap" "$(0&3V/3FV+(B")
("sat" "$(0(CJSPg2jG/PN(B")
("sau" "$(0\OY$'D&sE{*.6<5})w;H.@JA<gOpZKKLF3S}J+>a-56S?#$(1B#$(04@$(1d+S1(B")
("se" "$(0NQ1$7--i1=?Q$(14'$(0M6?+.<XY$(1#'$(0]R(B")
("sei" "$(0(?*<(B")
("sek" "$(0(|K{Tg(B")
("seng" "$(0H%Vy(B")
("seuk" "$(02)^M(B")
("seung" "$(0YeX$4_&9;9Ex<'J*UB;9E3Q+/!LwA#_,P.WCB8<<JH[hOF$(1Qs(B")
("si" "$(0G~-h3S(L7m-q(}H^(93)&J7<D!G)3M2p2nQzEE'l-o'UH]A[O#N<-4(4C>2rN\$(1_\$(0Ep$(1H8`$$(0?H;37E(B")
("sik" "$(0*d<I06*#7KIi\LQK5|LtZ|3=/xA]Tg<?K^EgI'$(1E=Nk$(0LqO]W@(B")
("sim" "$(0:aY9$(1-7$(0:fNJ$(1Wn$(0VT(B")
("sin" "$(0)@P@K\R_SxCD7TY!MZ'qX-H*Gz]k$(1%O$(06*$(1$J$(01(\Q(B")
("sing" "$(02SVy@:A1/M'+/V**6!HcG|>7Zb@83TB]T_.p)#$(1Np$(0H%(8(B")
("sip" "$(0\m\l8F(B")
("sit" "$(0^>*`FK0R7.W2Wq(B")
("siu" "$(0&R9?N=QZ'8)?8>S9Mi1V>VT(B}Qg7*LOXw(B")
("so" "$(0\89EO0F4\X<bEhXIDXETF`D,EPS\D}55.2(B")
("soh" "$(0/UPV8$>.E4Lk=;6[KfYV$(1Az$(0EC6t$(1F7(B")
("soi" "$(0H&\Z(B")
("sok" "$(09F7vJ1$(1B&(B")
("song" "$(08'EB@G=t$(1gu(B")
("sue" "$(07u83TTIrO9,JCUW1AaE)Rz*)Q(<-F`(B")
("suen" "$(0L,MMP17#>tLdF5+P2h="TZ$(1R,(B")
("suet" "$(0M*?|(B")
("sui" "$(0D}'VC%X#Mf2NG:L3=lG0J?Gs^UGPFZVUI.Tq9.:/2vQ!KvC=LFCXYO<25*(B")
("suk" "$(0.?CI\i=W]v;jO^HFVdC6$(1H|$(0;o)i;%J:P_(B")
("sun" "$(01k-UQT6f=K9GC2VJD|CVHgIl84*F::MBPw:"3%(B")
("sung" "$(0Y{;wV|Nk:K+{=YEj$(1>b$(0(8(B")
("sut" "$(037?55_Jt*(W7(B")
("ta" "$(0'm(G)q$(1H6(B")
("taai" "$(0'5Ji$(1:<$(0D=8;'5,q$(1#;A/(B")
("taam" "$(0Pv?NG9OPZ~<YC~(B")
("taan" "$(0J-]b^b]fRLUr.]?9Kz48$(1&*#x(B")
("taap" "$(0EZEXWZ+aMF(B")
("tai" "$(0^VAIYo$(1>A$(0@]H.P7=/QYTL@AAfUK8=2(;uT86|(B")
("tan" "$(0+@(B")
("tang" "$(0\W\|OZ(B")
("tau" "$(0U%;#,N?a(B")
("tek" "$(0Q;(B")
("teng" "$(0_#H-(B")
("tik" "$(06L<L$(1-y#wU5(B")
("tim" "$(0<D=Q>(34LZ$(1+I$(0RWYv(B")
("tin" "$(0'3Ff*|EY(qCP(B")
("ting" "$(0,-:u]p$(16p$(01i7>7`$(1Mr$(0@f$(1U;$(0HCQh(B")
("tip" "$(0D3/.(B")
("tit" "$(0]8(B")
("tiu" "$(0=?P~3H>=H}-{$(17aNj$(0>F$(1kJ(B")
("to" "$(0?x;D<l;t?e)T&I6qJ8.#-?W[ZVV(FqGtCl8-:Q=d:77AEV?&(2[IXb$(1:'(B")
("toh" "$(0>q/oU71_IkQwR|+u@O*q0F(B")
("toi" "$(051(;3tME5F/r(B")
("tok" "$(0*-/`$(1@[(B")
("tong" "$(0EU6UB>F.;YAkPLSh6:QA=OQ6S>]YOa$(1R}$(0W9Wi(B")
("tuen" "$(0J7+\';W#(B")
("tuet" "$(0>l(B")
("tui" "$(0LU<eU&HHT1:N(B")
("tuk" "$(0-6(B")
("tun" "$(04b(B")
("tung" "$(0?X)RBo>T8pWN8*$(1H4$(0VGMR,0C*=4$(1/9$(0C0$(1Ah$(0It$(1!J$(09`$(1bn(B")
("uk" "$(02qB4(B")
("wa" "$(02?N7BlC_Hd>+CsL$2`$(1jC(B")
("waai" "$(0Z.Z5=g3r(B")
("waak" "$(0/QBlA*J#(B")
("waan" "$(0_%WdV@<>2i'=]`Ia7b$(1dp$(00s&F(B")
("waang" "$(0Rx(B")
("waat" "$(0G+Fm3:(B")
("wai" "$(0F[44T]TB*n@Y;ELEXsT;K3Nd(&A.2e5vI18/<NV1H3Ck.h:zP9PT4L5,@EB<;qNjPl:}@N(B")
("wan" "$(0DyI+[JFl'%MwBE=\OnZX&h9U$(1H0$(0IT&y\9WjF@$(1ZL$(01I$(1K0$(0K<(B")
("wang" "$(0+|(Q(B")
("wat" "$(0/"64(B")
("wik" "$(0;R(B")
("wing" "$(0(d(VK+SZD#0EUYSZ(B")
("woh" "$(0.PWr(~L!PfB=L%6=@kGf(B")
("wok" "$(0V>$(1n:(B")
("wong" "$(0A)/<E(VOPiXx4W;*A9F~,n'_04/w(B")
("woo" "$(08V*EB:0r5/G-@dH4PbP6A.]-&lKU'CEKYW-C$(1!{=vK;$(0<T$(11M(B")
("wooi" "$(0)`FEE?3#Cu(B")
("woon" "$(00sAQPB7}@QKpG!BHQ'GRBwCJ2QAO)(6K(B")
("woot" "$(04%(B")
("ya" "$(0&?(B")
("yai" "$(0*43@(B")
("yam" "$(05x)7E$B$Hv'2+tPW?v+X=c$(1:LC|LS$(0[F(B")
("yan" "$(00=&*7J,7'@)N)_$(1ic$(0&o&D4{$(1$%$(09y852f;lX!(FH?Kj53'r8:$(1Ni$(0:)(B")
("yap" "$(0&,0CAK-XLb(B")
("yat" "$(0&"'K@cDPF_++-}Y[(B")
("yau" "$(0'd1X*5(r'9&55lAD3\)32xUA<@NhDTIEBZ0SI,-]'/(.*xI?M-(O.!$(1%h$(02IG(Ob$(1Ng$(0?3R'X7Z+(B")
("ye" "$(0.`EzFM5(G&?j+0:x(B")
("yeuk" "$(0]1$(1ZQ$(04}'L7@5MKl5>Zo_-$(1aC(B")
("yeung" "$(0U9O5(B[o3z^o[g[c^j3s96FOAS-mKm*QDm87)8$(17C$(0QsKC3']l7DMh(B")
("yi" "$(0YQ6/K`.$&)'i>DEu*UGy/y>-\?Kk.|Pt/L&Y*WUj$(1N`$(0-n)/*iU')kN!9]-"2_XAAn-3H!R:$(1%:$(0]aR=2=2LKTL@$(1Wm$(0K#$(1NdlNe/(B")
("yik" "$(0M~,PVw:L<XCL=M,3V}4P)*RZ8v\B>cZa2|2V^SLr/y(B")
("yim" "$(0[e0d'u3ZEcJ&SA^T$(1[U$(0=Z^}Tp.d<`^m$(1.*$(0]X(B")
("yin" "$(0/9>#-GS;BT4gFvS@Q0>r=IC!6V2~7(T9=pZ-/8K>@^2#$(1qx$(0B;+qJM9_L+^1(B")
("ying" "$(05CN`,12OM&R8&tU])F-Y\qUP^z^BOfT.V3K_Zr1S\E4Y3Q]wRP[dZ@_F(B")
("yip" "$(0H5FG5y[j(B")
("yit" "$(0O`N9TA9j(B")
("yiu" "$(0Y"H#5S\/XFWg+pKeF7@ZMDWL2c9k'6)]$(1BkW"$(0NM(B")
("yoh" "$(0@P6W(B")
("yue" "$(0LY/v1eM$/v)r&i_"9}\;R1US-g*>+(2!I8@$A:BDKVDn6xUV4n)v*R)UI3@R74<:Xk].@pHVI`THE'-S=P0}FUH?EtWa4o$(1A`$(0TDUI+rG8$(1NoLUR_$(01<$(125$(04v?}^2(B")
("yuen" "$(0U<M@6`+z6Q&x0Y$(1Cc$(0?U-aIF&;$(16n$(0<B.~;a[m(iSm8y=]6C:1W`EQERG*FdP?5G[L3-:b$(1(U$(04<IKMy(B")
("yuet" "$(0'M)!GnD>&#7RQf$(1VL-bH=(B")
("yui" "$(0T!Q_1HHO(B")
("yuk" "$(0(j-@*Y:JT3,w*2_I=DKc8IF]$(1nV$(0Ic3V$(1H9(B")
("yun" "$(0DdOW(B")
("yung" "$(0B1<,$(1gO$(0(o2.T/7+*'9vL]KZFbC:&~EL9SR`E,V~$(1o;$(0IUTNHB<=1p$(1:W$(0:UK)--(B")
("\\a" "$(0!"!$!)!#!(!2!d!e!f!g!R!S!>!?!Z![!J!K"1!;(B $(0#P#Q#R#S#T#U#V#W#X#O!*"i!l"c"h$O!m!n#:"0"8#9(B")
("\\beng" "$(1b9$(0Xj0yS&4T8n8s8u$(11'$(08r>3$(1>8>;]d>5E1$(0G<$(1E4$(0G>$(1E7]cR:L)R9L'R;X\$(0OrOl$(1XXX_mdX]]a$(0]j$(1X[$(0\z$(1b8(B")
("\\booi" "$(0D6$(1@Q@O$(0D5$(1cb$(0HuHx$(1lBTWN=TY$(0WW(B")
("\\che" "$(0:H?T$(1oW@f@nn6@e$(0I($(1H#H"$(0M<QIQDQHTU$(1cs(B")
("\\chi" "$(1,K>J$(0IW(B")
("\\chung" "$(1c8fq$(05P$(1-J$(05O$(12]2_2e$(0\:$(12k$(0?-?.?/]%$(19*9)$(0?4$(1fl90@#G/$(0Y8Ct$(1Z8$(0CxCy$(1is?v@&$(0HJHE$(1G3$(0HL$(1G8G5M_MdMcMk$(0W?$(1Mt$(0LvLuLm$(1itT'T#$(0Pk$(1Sk$(0W=$(1SlT%Z+_5$(0W:L/$(1Z-Z4_(Z*$(0W<$(1c/_+_-c5_<_7c,c.$(0Y;$(1iwiv$(0Zu$(1ful2$(0]'^h$(1pN(B")
("\\faat" "$(13M$(0ImMuR#$(1U~$(0U3U4$(1[|dh$(0^w$(1oe(B")
("\\foh" "$(0F|$(1DU$(0S7$(1+o$(043$(1+rX9$(08Q$(16u6y$(0S?$(1=`=c$(0F{G$$(1D\Q|Qp$(0V:$(1X;$(0V2$(1b*ki$(0_G(B")
("\\fong" "$(1/R/T/S$(0=#$(1<E(B")
("\\fung" "$(1O7$(0[N$(1ld(B")
("\\gaak" "$(1[b$(0_7$(1dK$(0Yi(B")
("\\gam" "$(0IMDbD`IC$(1gPj<j8j7[1U<U:U/[.[,[-_~_|$(0Ww$(1gW$(0[:[;$(1Nq$(0_?$(1U@$(0[B$(1`,g[`*(B")
("\\gan" "$(0@}$(1&Q&P$(0/1$(1\gIy$(0J_,2$(1;X$(0J`J\NX(B")
("\\gau" "$(1!e"c$(0Xd$(1$d$f$(00o$(1($,#XMDr0g$(08]$(10l0jXL0f0k7'$(0=z]g$(17+7/7&i>$(0B[$(1=w$(0Kd$(1Ks$(0Oe$(1R%XJ]Rkl(B")
("\\gin" "$(1@8$(0WF$(1N.n$$(0T7$(1_H$(0Y=$(1g#(B")
("\\gok" "$(0<}$(19K$(0Y>$(1@;GKGFN2g%(B")
("\\gwa" "$(10~$(0>%(B")
("\\gwai" "$(1V%$(0^xY}$(1`v$(0Y~]K(B")
("\\gwoh" "$(1J@$(0<SF*F)$(1B}J?(B")
("\\hau" "$(13vI0VI(B")
("\\him" "$(0XV$(16==!C~$(0S%(B")
("\\jau" "$(1--$(05[$(1@TGlGfq`3C3D3EA&A%H5$(0_=$(1qbN]$(0MO$(1N^U'[&[(['_rd!gN$(0[4$(1c~j4$(0\K]5(B")
("\\juk" "$(0TQ$(1Zo$(0WY$(1Zp$(0TO_*W\[*['$(1gB$(0[-\I_<$(1n/n2qapS$(0\G$(1GzNJ$(0YE$(1cq3*9^9[$(0?S$(1_j@an1$(0DA$(1@]$(0DH$(1Gq$(0[,YJ$(1Gvn0$(0]2$(1NANETj$(0Q:]y$(1TbT_$(0]x$(1Zk(B")
("\\jukfa" "$(1ErEuL[^*Ra$(0L0$(1Rc$(0L-$(1mkLa$(0Xz$(1LX$(0P0X{P3P5$(1Y&Y)Y($(0Sf$(1Y-$(0V[$(1^(pH^/bS$(0Xy$(1bV$(0Z[]nZ^$(11c$(0Gk$(11h7{1f7p8!$(0>L>N$(17z7r7u7vq-$(0>M$(1>k^0>l>h$(0Gj(B")
("\\kwat" "$(0_1[<$(1ODm,$(0Yy$(1dfh0$(0_0$(1pd$(0^W(B")
("\\lai" "$(11N(B")
("\\ma" "$(1Ut$(0Qy$(1jn$(0Q{$(1UxnOd\d_dclljr$(0[Q$(1lmjq$(0]F$(1lknM$(0_9$(1r$(B")
("\\mo" "$(05$$(1=,$(0F^$(1QBD($(0S'$(1eiWsmW(B")
("\\moon" "$(1:+$(0W}DiDc$(1ABl[$(0Qe$(1UQr5UP[T[W[X[Z[R`?$(0W{Y_Ya$(1jT(B")
("\\muk" "$(1$C$(0,b$(1$DK#i%$(00;$(1';$(007$(1<X$(0OA=A0:Uw$(1+&i#$(03b3m$(1i&$(03n$(1+-$(03g$(1+/$(03p=>$(1+D$(03i3o$(1e`*}]%/_/`<W$(0S$$(1/k$(0FP$(1/lJv$(0=9$(1/n$(0Rv82Uv$(1o2/^6%6#6&$(0=1$(16)$(0\sA~$(1<m$(0Z=$(1Q)$(0As$(1]#Ce<o$(0O7$(1C[$(0Av$(1<^CUCY$(0FJ$(1CZ$(0FV_$FQ$(1CfCg$(0K6[tZ>$(1Jik`(B")
("\\nga" "$(0SI$(11"E(]_]]b7(B")
("\\ngaan" "$(1(:,E$(04^4d$(1,C1:1;197N7T7V$(0><GFXo$(1EE$(0GMGNGLKu$(1RF$(0Kt$(1L1$(0OySRSPVI$(1]g$(0Xl$(1,o2!$(09P$(1@GF3fJ$(0Sr^f$(1^P(B")
("\\ngau" "$(1+~$(0*K4>$(17"7%$(0BX$(1=rDk$(0Ka(B")
("\\niu" "$(1h_r(\5\:$(0^[$(1a*npa-a/$(0_K$(1d}r@$(0Z($(1e(p"d|h\$(0[X$(1k-k6k<$(0]P$(1m$nioso{o|ov(B")
("\\nooi" "$(1:y4Y$(0)^$(14U4T$(0Ef@j$(1:|I[$(0Ei$(1B?I^V]$(0JL$(1ITV\Vc(B")
("\\pao" "$(0Ho$(1Gbc__c(B")
("\\saan" "$(1"8#`#b$(079$(1&@&G&C$(0/)$(1&E$(0/%$(1Vl$(02s$(1P4*!5!$(0<$$(15"5)$(0<#$(14x$(0;x;z@w$(1;L;I$(0Ek$(1Io;ABVIjP-$(0NTWR$(1\f(B")
("\\sam" "$(1!\$(0*&[nNu$(1#{J<#}#~$(0F#F$,;$(1#y$(0,:$(1&^$(0/H$(1&]$(0/P/E$(1&i$(0/N/O$(1&bW*$(0Jm$(1\r$(0F($(1*M;e$(07S7N$(1J0/*/+/($(07Q$(1/-$(0A/<G$(15C5A$(0<K<M<P<CF"$(1PO$(0A0A5A;A8$(1BoBn$(0JpNqNtNmRY(B")
("\\sam" "$(1RP/!/"/#/$$(07E$(1J,$(0F'F&Nf$(1W#$(0UaXB$(1r+(B")
("\\sau" "$(0<d$(1JG&}&y$(0/l3?$(1Pb*a/=/;5R<%$(0<q$(15V$(0Jy$(15^$(0<j$(15M$(0<o$(15_JQ<'<$$(0O-$(1<.;z$(0ARAE$(1<+a_C5C=C?C&K(C2CAJPhz$(0J|$(1PX$(0XJ$(1ad$(0O+$(1k\W1W/\x$(0Ul$(1eSo.q!$(07V$(15K;y$(09gUf(B")
("\\sek" "$(0VQ$(1(=L8,T>U,N$(03L9'9#[~$(1kq$(09)9&$(11>1=1F$(0>@$(1>O>L]q7]7_7\$(0SWGX$(1EMELXqET$(0K|$(1L5L=RPRT$(0SV$(1]u]v$(0VP$(1bFiMf2f/(B")
("\\si" "$(04~4|$(1,mkv$(09I$(11y8,$(0>^>_Sq>W>X$(1?#$(0CC$(1F!F)E~$(0L:$(1LwLu$(0PCLH$(1LzLn$(0L7LGPD$(1Rq$(0PFPE$(1b`RuRvRwYDRr$(0SpSo$(1Y<$(0Sn$(1^=$(0SiSj\+VpVrVhVfVm$(1kx$(0Y#Y%2[$(1i[f@fBq1(B")
("\\sik" "$(0]D^Q$(1nG`\$(0E#$(1dZ$(0E!$(1AT$(0E%IgMq$(1Uk$(0+(U+Yt$(1g~g|$(0[P$(1jf(B")
("\\teng" "$(0TYWc$(1(o(r$(05c$(1-W$(05fYN5`?^5g$(1349h$(0^J$(19i$(0?W?c$(19l$(0DR$(1@s@uH)$(0I7$(1H'$(0QMMAMH(B")
("\\tin" "$(1$n$(04N4O$(1,>1%>4E,(B")
("\\to" "$(0.[$(1%veE$(0._$(1%|&"%u%y%}4E)U)VB-4>$(02U2P$(1.O$(0E^@a$(1B,.P.U464;$(0;W$(14<4O494847:f:e$(0@b$(1B5IDI?$(0N?]T$(1#LVZ$(0RM)h)fX>$(1")$(0)gZ0+g(B")
("\\wai" "$(0)a$(1"'40$(0+]$(1%r$(02M6j$(14/$(0;Q$(1VR(B")
("\\woh" "$(0X4$(1mh,\1U$(095$(11Q$(0@x$(1>^>\$(0GdGb$(1R\$(0P)Xr(B")
("\\wong" "$(1"e$(0SD$(1Dy(-$(00u$(1,+$(04C4I$(1,,0o0n$(0=~$(10t0r$(08dG2$(1R-$(0G4BhBbBi$(1>$>">#$(0Bg$(1>'$(0G1G5$(1D|$(0G3VAKiOiSC\yOj$(1R0R,$(0OgSGVBV?$(1]V$(0Xf^=$(1i?(B")
("\\woo" "$(1&r*U$(0A>(B")
("\\yan" "$(1!4$(0,T$(1"Ymo)&$(0:w$(1OU"YAh(B")
("\\yat" "$(1"O"N$:$(0Rr0<$(1',$(00"/~$(1's$(03X$(1*w*x*m$(0O49T$(1/W$(0Rq7t$(15m$(0AdFB$(1CG$(0UqK&$(1W?ah$(0XL\p(B")
("\\yi" "$(1-P2w$(0:3$(12z$(0:2$(19:$(0Zv$(1@2@1@6_@G=f~cGN"$(0L~$(1N'$(0L}$(1N%N*$(0T5$(1T3$(0PqWDPsT4WB$(1_Ciyq<(B")
("\\yider" "$(1"v(z({$(01c:h$(1-d3JAG$(0?zDq?w$(1AF$(0Dp$(1H\`C"r"tcx"qH1%)(u(w$(01YT^)g$(1(x3<-]-^[$-_@v$(0]{:X$(13A3@3?9t9m$(0DV$(1@xNU$(0MK$(1NRT~$(0Wh$(1j1lJ(B")
("\\yin" "$(0:6:8:9$(1cK@=$(0D'D.D+$(1@FGNGTGO$(0H_$(1GU$(0HiHhQ#M/M.$(1N7T?TC$(0P|Q&P}Q$TFTG$(1ZV$(0Y?_;$(1_Nn'$(0[$(B")
("\\yoo" "$(1V'ok\)\*$(0X0$(1`w$(0X/$(1`yqM$(0X.$(1h?dtr?$(0^,$(1n]l{na$(0Z%[V$(1h7hEh:$(0[U$(1h<h=$(0[W$(1h>jz$(0_A\[$(1j}k'l|$(0]M$(1l}n^$(0^-$(1nZ$(0^Z^X$(1ogpg(B")
("\\yuk" "$(1YU$(0?I$(1FI8Q8P8J$(0,"CRCT$(1F<M/B.BA$(0LV$(1S)^W^U$(0)I$(1$y'4$(01416$(1(Q$(0\0$(1,}-#-+-)*|$(054$(18M$(09[9g7w(B")
)
